<?php
/**
 * File validation exception before saving the record.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Exceptions;

/**
 * Class validation exception before saving the record.
 */
class SaveRecordHandlers extends AppException
{
	/** @var array Params data */
	private $params = [];

	/**
	 * Set params data.
	 *
	 * @param array $data
	 *
	 * @return void
	 */
	public function setParams(array $data): void
	{
		$this->params = $data;
	}

	/**
	 * Get params data.
	 *
	 * @return array
	 */
	public function getParams(): array
	{
		return $this->params;
	}
}
