<?php

/**
 * Comarch payment synchronization map file.
 *
 * The file is part of the paid functionality. Using the file is allowed only after purchasing a subscription.
 * File modification allowed only with the consent of the system producer.
 *
 * @package Integration
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Integrations\Comarch\Xl\Maps;

/**
 * Comarch payment synchronization map class.
 */
class Payment extends \App\Integrations\Comarch\Map
{
	/** {@inheritdoc} */
	const API_NAME_ID = 'idPlatnosci';
	/** {@inheritdoc} */
	protected $moduleName = 'PaymentsIn';
	/** {@inheritdoc} */
	protected $fieldMap = [
		'paymentsname' => [
			'name' => 'operacja', 'fn' => 'convertOperation'
		],
		'paymentstitle' => 'tresc',
		'paymentsvalue' => 'kwota',
		'bank_account' => 'kodBanku',
		'currency_id' => [
			'name' => 'waluta', 'fn' => 'convertCurrency'
		],
		'relatedid' => [
			'name' => 'idKontrahenta',
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Accounts',
		],
		'finvoiceid' => [
			'name' => 'id',
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Invoices',
		],
	];
	/** {@inheritdoc} */
	protected $defaultDataYf = [
		'fieldMap' => [
			'paymentsin_status' => 'PLL_PAID'
		],
	];
	/** @var array Operation cache. */
	protected $operationCache;

	/**
	 * Convert operation in YF/API.
	 *
	 * @param mixed $value
	 * @param array $field
	 * @param bool  $fromApi
	 *
	 * @return string
	 */
	protected function convertOperation($value, array $field, bool $fromApi)
	{
		if (!$fromApi) {
			return '';
		}
		if (null === $this->operationCache) {
			foreach ($this->synchronizer->getFromApi('Dictionary/CashBankOperation') as $row) {
				$this->operationCache[$row['kod']] = $row['nazwa'];
			}
		}
		return $this->operationCache[$value] ?? '';
	}
}
