<?php
/**
 * Interface for advanced operations on report data
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Decorator;

use App\Report\Model\Query;

/** ReportDataDecorator interface */
interface ReportDataDecorator
{
	/** Adjust report data */
	public function decorate(array $data, Query $query): array;
}
