<?php
/**
 * Standard YetiForce field object
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model\Field;

use App\Report\Enums\FieldType;
use App\Report\Model\Field;
use Vtiger_Field_Model;

/** YetiForceField class */
final class YetiForceField implements Field
{
	public function __construct(
		private readonly Vtiger_Field_Model $field,
	) {
	}

	/** {@inheritDoc} */
	public function getType(): ?FieldType
	{
		return FieldType::tryFrom($this->field->getFieldDataType());
	}

	/** {@inheritDoc} */
	public function getNativeModel(): object
	{
		return $this->field;
	}
}
