<?php
/**
 * Report Join model
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model;

use App\Report\Enums\JoinType;

/** Join class */
final class Join
{
	public function __construct(
		private int $id,
		private Query $query,
		private string $module,
		private JoinType $type,
	) {
	}

	/** Get join id */
	public function getId(): int
	{
		return $this->id;
	}

	/** Get related Query */
	public function getQuery(): Query
	{
		return $this->query;
	}

	/** Get joined module name */
	public function getModule(): string
	{
		return $this->module;
	}

	/** Get join type (eg. LEFT JOIN, INNER JOIN) */
	public function getType(): JoinType
	{
		return $this->type;
	}
}
