<?php

namespace App\TextParser;

/**
 * Table currency summary class.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Arkadiusz Sołek <a.solek@yetiforce.com>
 */
class TableCurrencySummary extends Base
{
	/** @var string Class name */
	public $name = 'LBL_TABLE_CURRENCY_SUMMARY';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/**
	 * Process.
	 *
	 * @return string
	 */
	public function process()
	{
		if (!$this->textParser->recordModel || !$this->textParser->recordModel->getModule()->isInventory()) {
			return '';
		}

		$html = '';
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->moduleName);
		$fields = $inventory->getFieldsByBlocks();
		$currencySummary = $inventory->getField('currency')?->getCurrencyConversationSummary($this->textParser->recordModel) ?? [];
		$baseCurrency = \Vtiger_Util_Helper::getBaseCurrency();

		if (
			!empty($fields[0])
			&& !empty($currencySummary['groups'])
			&& $inventory->isField('tax')
			&& $inventory->isField('taxmode')
			&& $inventory->isField('currency')
		) {
			$html .= '<table class="table-currency-summary" style="border-collapse:collapse;width:100%;border:1px solid #ddd;">
							<thead>
								<tr>
									<th colspan="2" style="padding:0px 4px;text-align:center;">
										<strong>' . \App\Language::translate('LBL_CURRENCIES_SUMMARY', $this->textParser->moduleName) . '</strong>
									</th>
								</tr>
							</thead>
							<tbody>';
			foreach ($currencySummary['groups'] as $key => $value) {
				$html .= '<tr>
								<td class="name" style="padding:0px 4px;">' . $key . '</td>
								<td class="value" style="text-align:right;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($value, true, $baseCurrency['currency_symbol']) . ' </td>
							</tr>';
			}
			$html .= '<tr class="summary">
							<th class="name" style="padding:0px 4px;font-weight:bold;text-align: left">' . \App\Language::translate('LBL_AMOUNT', $this->textParser->moduleName) . '</th>
							<th class="value" style="text-align:right;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($currencySummary['total'], true, $baseCurrency['currency_symbol']) . ' </th>
						</tr>
					</tbody>
				</table>';
		}

		return $html;
	}
}
