<?php

/**
 * Configuration file.
 * This file is auto-generated.
 *
 * @package Config
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

namespace Config\Modules;

/**
 * Configuration file: Config\Modules\OpenStreetMap.
 */
class OpenStreetMap
{
	/**
	 * Number of entries to be updated in one run of cron
	 *
	 * @var int
	 */
	public static $cronMaxUpdatedAddresses = 1000;

	/**
	 * Allow modules.
	 *
	 * @var string[]
	 */
	public static $mapModules = ['Accounts', 'Contacts', 'Competition', 'Vendors', 'Partners', 'Leads', 'Locations'];

	/**
	 * List of fields from which to show information in the map pin
	 *
	 * @var array
	 */
	public static $mapPinFields = [
		'Accounts' => ['accountname', 'email1', 'phone'],
		'Leads' => ['company', 'firstname', 'lastname', 'email'],
		'Partners' => ['subject', 'email'],
		'Competition' => ['subject', 'email'],
		'Vendors' => ['vendorname', 'email', 'website'],
		'Contacts' => ['firstname', 'lastname', 'email', 'phone'],
		'Locations' => ['subject', 'email'],
	];
}
