<?php
/**
 * Cron task to update coordinates.
 *
 * @package Cron
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Tomasz Kur <t.kur@yetiforce.com>
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

use App\Config;
use App\CronHandler;
use App\Db;
use App\Db\Query;
use App\Map\Coordinates;
use vtlib\Cron;

/**
 * OSSSoldServices_Renewal_Cron class.
 */
class OpenStreetMap_UpdaterCoordinates_Cron extends CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$coordinatesConnector = Coordinates::getActiveInstance();
		if (null === $coordinatesConnector) {
			$this->addTaskLog("Nothing to process: no active coordinates driver");
			return;
		}

		$db = Db::getInstance();
		$lastUpdatedCrmId = (new Query())->select(['crmid'])->from('u_#__openstreetmap_address_updater')->scalar();
		if (false !== $lastUpdatedCrmId) {
			$dataReader = (new Query())->select(['crmid', 'setype', 'deleted'])
				->from('vtiger_crmentity')
				->where(['setype' => Config::module('OpenStreetMap', 'mapModules', [])])
				->andWhere(['>', 'crmid', $lastUpdatedCrmId])
				->limit(Config::module('OpenStreetMap', 'cronMaxUpdatedAddresses'))
				->createCommand()->query();
			$moduleModel = OpenStreetMap_Module_Model::getInstance('OpenStreetMap');
			while ($row = $dataReader->read()) {
				if ($moduleModel->isAllowModules($row['setype']) && 0 == $row['deleted']) {
					$recordModel = Vtiger_Record_Model::getInstanceById($row['crmid']);
					foreach (Coordinates::TYPE_ADDRESS as $typeAddress) {
						$addressInfo = Coordinates::getAddressParams($recordModel, $typeAddress);
						$coordinate = $coordinatesConnector->getCoordinates($addressInfo);
						if (null === $coordinate) {
							break;
						}
						if (empty($coordinate)) {
							continue;
						}
						Coordinates::saveCoordinates($recordModel->getId(), $typeAddress, $coordinate, false);
					}
				}
				$lastUpdatedCrmId = $row['crmid'];
				if ($this->checkTimeout()) {
					break;
				}
			}
			$dataReader->close();
			$lastRecordId = $db->getUniqueID('vtiger_crmentity', 'crmid', false);
			if ($dataReader->count() || $lastRecordId === $lastUpdatedCrmId) {
				$db->createCommand()->update('u_#__openstreetmap_address_updater', ['crmid' => $lastUpdatedCrmId])->execute();
				$this->cronTask->updateStatus(Cron::$STATUS_DISABLED);
				$this->cronTask->set('lockStatus', true);
			} else {
				$db->createCommand()->update('u_#__openstreetmap_address_updater', ['crmid' => $lastUpdatedCrmId])->execute();
			}
		}
	}
}
