<?php
/**
 * Class to edit view.
 *
 * @package   View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Request;
use App\User;

/**
 * Class ReportTemplate_Edit_View.
 */
class ReportTemplate_Edit_View extends Vtiger_Edit_View
{
	public function preProcess(Request $request, $display = true): void
	{
		parent::preProcess($request, $display);

		if (true === $request->getBoolean('isDuplicate')) {
			$this->record->set('assigned_user_id', User::getCurrentUserId());
		}
	}

	/** {@inheritdoc} */
	public function getFooterScripts(Request $request)
	{
		return array_merge(
			parent::getFooterScripts($request),
			$this->checkAndConvertJsScripts([
				"modules.{$request->getModule()}.resources.ConditionBuilder"
			])
		);
	}
}
