<?php
/**
 * Mailbox action file.
 *
 * @package Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Request;

class Users_Mailbox_Action extends \App\Controller\Action
{
	/** {@inheritdoc} */
	public function checkPermission(Request $request)
	{
		$recordId = $request->getInteger('record');
		if (\App\User::getCurrentUserRealId() !== $recordId) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$mailboxModel = $this->getModelFromRequest($request);
		$mailboxModel->save();

		$response = new Vtiger_Response();
		$response->setEmitType(Vtiger_Response::$EMIT_JSON);
		$response->setResult(['success' => true, 'url' => $mailboxModel->getRedirectUrl()]);
		$response->emit();
	}

	public function getModelFromRequest(Request $request): Users_Mailbox_Model
	{
		$recordId = $request->getInteger('record');
		$mailboxModel = new Users_Mailbox_Model($recordId);
		$mailboxModel->getFieldsForEdit();

		foreach ($mailboxModel->getFieldsForEdit() as $fieldName => $fieldModel) {
			if ($request->has($fieldName)) {
				$value = $request->isEmpty($fieldName) ? '' : $request->getByType($fieldName, $fieldModel->get('purifyType'));
				$fieldUiTypeModel = $fieldModel->getUITypeModel();
				$fieldUiTypeModel->validate($value, true);

				$value = $fieldUiTypeModel->getDBValue($value);
				$mailboxModel->set($fieldName, $value);
			}
		}

		return $mailboxModel;
	}
}
