<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 * *********************************************************************************** */

class Vtiger_CurrencyList_UIType extends Vtiger_Picklist_UIType
{
	/** {@inheritdoc} */
	public function validate($value, $isUserFormat = false)
	{
		if (empty($value) || isset($this->validate[$value])) {
			return;
		}
		if (!is_numeric($value)) {
			throw new \App\Exceptions\Security('ERR_ILLEGAL_FIELD_VALUE||' . $this->getFieldModel()->getFieldName() . '||' . $this->getFieldModel()->getModuleName() . '||' . $value, 406);
		}
		$maximumLength = $this->getFieldModel()->get('maximumlength');
		if ($maximumLength) {
			$rangeValues = explode(',', $maximumLength);
			if (($rangeValues[1] ?? $rangeValues[0]) < $value || (isset($rangeValues[1]) ? $rangeValues[0] : 0) > $value) {
				throw new \App\Exceptions\Security('ERR_VALUE_IS_TOO_LONG||' . $this->getFieldModel()->getFieldName() . '||' . $this->getFieldModel()->getModuleName() . '||' . $value, 406);
			}
		}

		$this->validate[$value] = true;
	}

	/** {@inheritdoc} */
	public function getDisplayValue($value, $record = false, $recordModel = false, $rawText = false, $length = false)
	{
		return $value ? \App\Purifier::encodeHtml($this->getPicklistValues()[$value] ?? $value) : '';
	}

	/** {@inheritdoc} */
	public function getPicklistValues()
	{
		$currencies = array_column(\App\Fields\Currency::getAll(true), 'currency_name', 'id');
		asort($currencies);
		return $currencies;
	}

	/**
	 * Get currencies full data.
	 *
	 * @return array
	 */
	public function getCurrencies(): array
	{
		$currencies = array_map(fn ($currency) => array_merge($currency, \vtlib\Functions::getConversionRateInfo($currency['id'])), \App\Fields\Currency::getAll(true));
		uasort($currencies, fn ($a, $b) => strnatcmp($a['currency_name'], $b['currency_name']));

		return $currencies;
	}

	public function getCurrenyListReferenceFieldName()
	{
		return 'currency_name';
	}

	/**
	 * Function defines empty picklist element availability.
	 *
	 * @return bool
	 */
	public function isEmptyPicklistOptionAllowed()
	{
		return false;
	}

	/** {@inheritdoc} */
	public function getAllowedColumnTypes()
	{
		return ['integer', 'smallint'];
	}

	/** {@inheritdoc} */
	public function getDefaultOperator()
	{
		return 'e';
	}

	/** {@inheritdoc} */
	public function getQueryOperators()
	{
		return ['e', 'n', 'y', 'ny', 'ef', 'nf'];
	}

	/** {@inheritdoc} */
	public function getTemplateName()
	{
		return 'Edit/Field/CurrencyList.tpl';
	}
}
