'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 *  Class representing an extended calendar.
 * @extends Calendar_Calendar_Js
 */function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _callSuper(t,o,e){return o=_getPrototypeOf(o),_possibleConstructorReturn(t,_isNativeReflectConstruct()?Reflect.construct(o,e||[],_getPrototypeOf(t).constructor):o.apply(t,e))}function _possibleConstructorReturn(self,call){if(call&&("object"===_typeof(call)||"function"==typeof call))return call;if(void 0!==call)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(self)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));}catch(t){}return (_isNativeReflectConstruct=function(){return !!t})()}function _get(){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get.bind():function(target,property,receiver){var base=_superPropBase(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(3>arguments.length?target:receiver):desc.value}},_get.apply(this,arguments)}function _superPropBase(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&(object=_getPrototypeOf(object),null!==object););return object}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),Object.defineProperty(subClass,"prototype",{writable:!1}),superClass&&_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}window.Calendar_Calendar_Js=/*#__PURE__*/function(_Vtiger_Calendar_Js){function Calendar_Calendar_Js(){return _classCallCheck(this,Calendar_Calendar_Js),_callSuper(this,Calendar_Calendar_Js,arguments)}return _inherits(Calendar_Calendar_Js,_Vtiger_Calendar_Js),_createClass(Calendar_Calendar_Js,[{key:"setCalendarModuleOptions",value:/**
	 * Set calendar module options.
	 * @returns {{allDaySlot: boolean, dayClick: object, selectable: boolean}}
	 */function setCalendarModuleOptions(){var _this=this,self=this;return {allDaySlot:app.getMainParams("allDaySlot"),dateClick:function dateClick(args){1==_this.eventCreate&&_this.showCalendarCreateView().done(function(form){!1===_this.getSidebarView().find(".tab-pane.active").hasClass("js-right-panel-event")&&_this.getSidebarView().find(".js-right-panel-event-link").trigger("click"),_this.dayCallbackCreateModal(form,args);});},selectable:!1,eventClick:function eventClick(info){info.jsEvent.preventDefault();var element=$(info.el),link=element.attr("href");link||(link=element.find("a").attr("href")),element.hasClass("js-quick-detail-modal")?(element.data("url",link.replace("view=","xview=")+"&view=QuickDetailModal"),app.registerModal(element)):!self.readonly&&self.eventEdit?self.showSidebarEvent(link):window.location.assign(link.replace("view=","xview=")+"&view=Detail");}}}/**
	 * Show sidebar event
	 * @param {*} params
	 * @returns {Promise}
	 */},{key:"showSidebarEvent",value:function showSidebarEvent(params){var _this2=this,self=this,aDeferred=$.Deferred(),progressInstance=$.progressIndicator({blockInfo:{enabled:!0}});return "number"==typeof params&&(params={module:this.module,view:"EventForm",record:params}),AppConnector.request(params).done(function(data){progressInstance.progressIndicator({mode:"hide"}),self.openRightPanel(),_this2.updateSidebar(data);var sidebar=self.getSidebarView();sidebar.find("form").length?self.registerEditForm(sidebar):(app.showNewScrollbar(sidebar.find(".js-calendar__form__wrapper"),{suppressScrollX:!0}),sidebar.find(".js-activity-state .js-summary-close-edit").on("click",function(){self.showCalendarCreateView();}),sidebar.find(".js-activity-state .editRecord").on("click",function(){self.showSidebarEvent($(this).data("id"));})),aDeferred.resolve(sidebar.find(".js-qc-form"));}).fail(function(error){progressInstance.progressIndicator({mode:"hide"}),app.errorLog(error);}),aDeferred.promise()}/**
	 * Open sidebar right panel
	 */},{key:"openRightPanel",value:function openRightPanel(){this.getSidebarView().hasClass("hideSiteBar")&&this.getSidebarView().find(".js-toggle-site-bar-right-button").trigger("click");}/**
	 * Update sidebar
	 * @param {html} data
	 */},{key:"updateSidebar",value:function updateSidebar(data){this.getSidebarView().find(".js-qc-form").html(data),this.showRightPanelForm();}/**
	 * Show sidebar right panel form
	 */},{key:"showRightPanelForm",value:function showRightPanelForm(){var calendarRightPanel=this.getSidebarView();calendarRightPanel.find(".js-right-panel-event").hasClass("active")||calendarRightPanel.find(".js-right-panel-event-link").trigger("click"),app.showNewScrollbar(calendarRightPanel.find(".js-calendar__form__wrapper"),{suppressScrollX:!0});}/**
	 * Register events to EditView
	 * @param {jQuery} sideBar
	 */},{key:"registerEditForm",value:function registerEditForm(sideBar){var _this3=this,editViewInstance=Vtiger_Edit_Js.getInstanceByModuleName(sideBar.find("[name=\"module\"]").val()),rightFormCreate=sideBar.find("form.js-form");editViewInstance.setForm(rightFormCreate),editViewInstance.registerBasicEvents(rightFormCreate),rightFormCreate.validationEngine(app.validationEngineOptions),App.Fields.Picklist.showSelect2ElementView(sideBar.find("select")),sideBar.find(".js-summary-close-edit").on("click",function(){_this3.showCalendarCreateView();}),App.Components.QuickCreate.registerPostLoadEvents(rightFormCreate,{callbackFunction:this.registerAfterSubmitForm(this)}),new App.Fields.Text.Editor(sideBar.find(".js-editor"),{height:"5em",toolbar:"Min"});}/**
	 * Register actions to do after save record
	 * @param {object} self
	 * @param {object} data
	 * @returns {function}
	 */},{key:"registerAfterSubmitForm",value:function registerAfterSubmitForm(self){return function returnFunction(data){data.success&&(self.reloadCalendarData(),self.refreshDatesRowView(),self.getSidebarView().find(".js-qc-form").html(""),self.showCalendarCreateView(),window.popoverCache={});}}/**
	 * Show create view
	 * @returns {Promise}
	 */},{key:"showCalendarCreateView",value:function showCalendarCreateView(){var _this4=this,aDeferred=$.Deferred();if(1==this.eventCreate){var sideBar=this.getSidebarView(),qcForm=sideBar.find(".js-qc-form");if(0<qcForm.find("form").length&&0===qcForm.find("input[name=record]").length)aDeferred.resolve(qcForm);else {var progressInstance=$.progressIndicator({blockInfo:{enabled:!0}});this.showSidebarEvent({module:this.module,view:"EventForm"}).done(function(){progressInstance.progressIndicator({mode:"hide"}),_this4.registerAutofillTime(),aDeferred.resolve(qcForm);}).fail(function(error){progressInstance.progressIndicator({mode:"hide"}),app.errorLog(error);});}}else aDeferred.reject();return aDeferred.promise()}/**
	 * Auto select date in create view in extended calendar
	 */},{key:"registerAutofillTime",value:function registerAutofillTime(){app.getMainParams("autofillTime")&&this.container.find(".js-autofill").prop("checked","checked").trigger("change");}/**
	 * Register cache settings
	 */},{key:"registerCacheSettings",value:function registerCacheSettings(){var self=this;$(".siteBarRight .filterField").each(function(){var name=$(this).attr("id"),value=app.moduleCacheGet(name),element=$("#"+name);0<element.length&&null!=value&&"checkbox"==element.attr("type")&&element.prop("checked",value);}),this.getCalendarView().find(".fc-toolbar .fc-button").on("click",function(e){var element=$(e.currentTarget);element.hasClass("fc-"+self.fullCalendar.view.type+"-button")?app.moduleCacheSet("defaultView",self.fullCalendar.view.type):(element.hasClass("fc-prev-button")||element.hasClass("fc-next-button")||element.hasClass("fc-today-button"))&&(app.moduleCacheSet("start",App.Fields.Date.dateToUserFormat(self.fullCalendar.view.activeStart)),app.moduleCacheSet("end",App.Fields.Date.dateToUserFormat(self.fullCalendar.view.activeEnd)));});var keys=app.moduleCacheKeys();if(0<keys.length){var alert=$("#moduleCacheAlert");alert.find(".cacheClear").on("click",function(){app.moduleCacheClear(),alert.addClass("d-none"),location.reload();});}}/**
	 * Register site bar events
	 */},{key:"registerSiteBarEvents",value:function registerSiteBarEvents(){var calendarRightPanel=$(".js-calendar-right-panel");calendarRightPanel.find(".js-show-sitebar").on("click",function(){calendarRightPanel.hasClass("hideSiteBar")&&calendarRightPanel.find(".js-toggle-site-bar-right-button").trigger("click");});}/**
	 * Register popover buttons' click
	 */},{key:"registerPopoverButtonsClickEvent",value:function registerPopoverButtonsClickEvent(){$(document).on("click",".js-calendar-popover__button",this.showCalendarPopoverLinkInSidebar.bind(this));}/**
	 *  Show popover link in sidebar
	 * @param {jQuery.Event} e click event
	 * @returns {boolean}
	 */},{key:"showCalendarPopoverLinkInSidebar",value:function showCalendarPopoverLinkInSidebar(e){var href=e.currentTarget.href,hrefObject=app.convertUrlToObject(href);if("Calendar"!==hrefObject.module||"Edit"!==hrefObject.view&&"Detail"!==hrefObject.view)return !0;e.preventDefault();var sidebarView="Edit"===hrefObject.view?"EventForm":"ActivityState";href=href.replace(hrefObject.view,sidebarView),this.showSidebarEvent(href);}/**
	 * Register events
	 */},{key:"registerEvents",value:function registerEvents(){_get(_getPrototypeOf(Calendar_Calendar_Js.prototype),"registerEvents",this).call(this),this.registerSiteBarEvents(),this.registerPopoverButtonsClickEvent(),ElementQueries.listen(),this.showCalendarCreateView();}}],[{key:"goToRecordsList",value:/**
	 * Go to records list
	 * @param {string} link
	 */function goToRecordsList(link){var self=app.pageController,status=app.getMainParams("activityStateLabels",!0),options=self.getDefaultParams();link+=options.cvid?"&viewname="+options.cvid:"&viewname=All";var searchParams="[\"activitystatus\",\"e\",\""+status[app.getMainParams("showType")].join()+"\"]";searchParams+=",[\"date_start\",\"bw\",\""+options.start+" 00:00:00,"+options.end+" 23:59:59\"]",options.user&&(searchParams+=",[\"assigned_user_id\",\"e\",\""+options.user.selectedIds.join("##")+"\"]"),link+="&search_params=[["+encodeURIComponent(searchParams)+"]]",window.location.href=link;}}])}(Vtiger_Calendar_Js);
//# sourceMappingURL=CalendarView.min.js.map
