'use strict';

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 ************************************************************************************/"use strict";if("undefined"==typeof ImportJs){/*
	 * Namespaced javascript class for Import
	 */var ImportJs={toogleMergeConfiguration:function toogleMergeConfiguration(){var mergeChecked=jQuery("#auto_merge").is(":checked"),duplicateMergeConfiguration=jQuery("#duplicates_merge_configuration");mergeChecked?duplicateMergeConfiguration.show():duplicateMergeConfiguration.hide();},checkFileType:function checkFileType(){var filePath=jQuery("#import_file").val();if(""!=filePath){var fileExtension=filePath.split(".").pop();jQuery(".js-type").val(fileExtension),ImportJs.handleFileTypeChange();}},handleFileTypeChange:function handleFileTypeChange(){var fileType=jQuery(".js-type").val(),delimiterContainer=jQuery(".js-delimiter-container"),hasHeaderContainer=jQuery(".js-has-header-container"),xmlTpl=jQuery(".js-xml-tpl"),extension=jQuery(".js-zip-extension");"xml"===fileType?(delimiterContainer.addClass("d-none"),hasHeaderContainer.addClass("d-none"),xmlTpl.removeClass("d-none"),extension.addClass("d-none")):"zip"===fileType?(delimiterContainer.addClass("d-none"),hasHeaderContainer.addClass("d-none"),extension.removeClass("d-none")):(delimiterContainer.removeClass("d-none"),hasHeaderContainer.removeClass("d-none"),extension.addClass("d-none"),xmlTpl.addClass("d-none"));},uploadAndParse:function uploadAndParse(){return !!ImportJs.validateFilePath()&&!!ImportJs.validateMergeCriteria()},registerImportClickEvent:function registerImportClickEvent(){$("#importButton").removeAttr("disabled").on("click",function(){return ImportJs.sanitizeAndSubmit()});},validateFilePath:function validateFilePath(){var importFile=jQuery("#import_file"),filePath=importFile.val();if(""==jQuery.trim(filePath)){var errorMessage=app.vtranslate("JS_IMPORT_FILE_CAN_NOT_BE_EMPTY");return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),importFile.focus(),!1}return !!ImportJs.uploadFilter("import_file","csv|vcf|xml|zip|ics|ical")&&!!ImportJs.uploadFileSize("import_file")},uploadFilter:function uploadFilter(elementId,allowedExtensions){var obj=jQuery("#"+elementId);if(obj){var filePath=obj.val(),fileParts=filePath.toLowerCase().split("."),fileType=fileParts[fileParts.length-1],validExtensions=allowedExtensions.toLowerCase().split("|");if(0>validExtensions.indexOf(fileType)){var errorMessage=app.vtranslate("JS_SELECT_FILE_EXTENSION")+"\n"+validExtensions;return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),obj.focus(),!1}}return !0},uploadFileSize:function uploadFileSize(elementId){var element=jQuery("#"+elementId),importMaxUploadSize=element.closest("td").data("importUploadSize"),importMaxUploadSizeInMb=element.closest("td").data("importUploadSizeMb"),uploadedFileSize=element.get(0).files[0].size;if(uploadedFileSize>importMaxUploadSize){var errorMessage=app.vtranslate("JS_UPLOADED_FILE_SIZE_EXCEEDS")+" "+importMaxUploadSizeInMb+" MB."+app.vtranslate("JS_PLEASE_SPLIT_FILE_AND_IMPORT_AGAIN");return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),!1}return !0},validateMergeCriteria:function validateMergeCriteria(){var mergeChecked=jQuery("#auto_merge").is(":checked");if(mergeChecked){var selectedOptions=jQuery("#selected_merge_fields option");if(0==selectedOptions.length){var errorMessage=app.vtranslate("JS_PLEASE_SELECT_ONE_FIELD_FOR_MERGE");return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),!1}}return ImportJs.convertOptionsToJSONArray("#selected_merge_fields","#merge_fields"),!0},convertOptionsToJSONArray:function convertOptionsToJSONArray(objName,targetObjName){var obj=jQuery(objName),arr=[];if("undefined"!=typeof obj&&""!=obj[0])for(var i=0;i<obj[0].length;++i)obj[0].options[i].selected&&arr.push(obj[0].options[i].value);if("undefined"!==targetObjName){var targetObj=$(targetObjName);"undefined"!=typeof targetObj&&targetObj.val(JSON.stringify(arr));}return arr},copySelectedOptions:function copySelectedOptions(source,destination){var srcObj=jQuery(source),destObj=jQuery(destination);if("undefined"!=typeof srcObj&&"undefined"!=typeof destObj){for(var i=0;i<srcObj[0].length;i++)if(!0==srcObj[0].options[i].selected){for(var rowFound=!1,existingObj=null,j=0;j<destObj[0].length;j++)if(destObj[0].options[j].value==srcObj[0].options[i].value){rowFound=!0,existingObj=destObj[0].options[j];break}if(!0!=rowFound){var opt=$("<option selected>");opt.attr("value",srcObj[0].options[i].value),opt.text(srcObj[0].options[i].text),jQuery(destObj[0]).append(opt),srcObj[0].options[i].selected=!1;}else null!=existingObj&&(existingObj.selected=!0);}srcObj.trigger("change"),destObj.trigger("change");}},removeSelectedOptions:function removeSelectedOptions(objName){var obj=jQuery(objName);if(obj.length)for(var i=obj[0].options.length-1;0<=i;i--)!0==obj[0].options[i].selected&&(obj[0].options[i]=null);},sanitizeAndSubmit:function sanitizeAndSubmit(){return !!ImportJs.sanitizeFieldMapping()&&!!ImportJs.validateCustomMap()},sanitizeFieldMapping:function sanitizeFieldMapping(){for(var errorMessage,fieldsList=jQuery(".fieldIdentifier"),mappedFields={},inventoryMappedFields={},params={},mappedDefaultValues={},i=0;i<fieldsList.length;++i){var fieldElement=jQuery(fieldsList.get(i)),rowId=jQuery("[name=row_counter]",fieldElement).get(0).value,selectElement=jQuery("select",fieldElement),selectedFieldElement=selectElement.find("option:selected"),selectedFieldName=selectedFieldElement.val(),selectedFieldDefaultValueElement=jQuery("#"+selectedFieldName+"_defaultvalue",fieldElement),defaultValue="";if(defaultValue="checkbox"==selectedFieldDefaultValueElement.attr("type")?selectedFieldDefaultValueElement.is(":checked"):selectedFieldDefaultValueElement.val(),""!=selectedFieldName){var stopImmediately;if(selectElement.hasClass("inventory")?(stopImmediately=ImportJs.checkIfMappedFieldExist(selectedFieldName,inventoryMappedFields,selectedFieldElement),inventoryMappedFields[selectedFieldName]=rowId-1):(stopImmediately=ImportJs.checkIfMappedFieldExist(selectedFieldName,mappedFields,selectedFieldElement),mappedFields[selectedFieldName]=rowId-1),stopImmediately)return !1;""!=defaultValue&&(mappedDefaultValues[selectedFieldName]=defaultValue);}}var mandatoryFields=JSON.parse(jQuery("#mandatory_fields").val()),missingMandatoryFields=[];for(var mandatoryFieldName in mandatoryFields)if(mandatoryFieldName in mappedFields)continue;else missingMandatoryFields.push("\""+mandatoryFields[mandatoryFieldName]+"\"");return 0<missingMandatoryFields.length?(errorMessage=app.vtranslate("JS_MAP_MANDATORY_FIELDS")+missingMandatoryFields.join(","),params={text:errorMessage,type:"error"},Vtiger_Helper_Js.showMessage(params),!1):(jQuery("#field_mapping").val(JSON.stringify(mappedFields)),jQuery("#inventory_field_mapping").val(JSON.stringify(inventoryMappedFields)),jQuery("#default_values").val(JSON.stringify(mappedDefaultValues)),!0)},checkIfMappedFieldExist:function checkIfMappedFieldExist(selectedFieldName,mappedFields,selectedFieldElement){if(selectedFieldName in mappedFields){var errorMessage=app.vtranslate("JS_FIELD_MAPPED_MORE_THAN_ONCE")+" "+selectedFieldElement.data("label");return Vtiger_Helper_Js.showMessage({text:errorMessage,type:"error"}),!0}return !1},validateCustomMap:function validateCustomMap(){var errorMessage,params={},saveMap=jQuery("#save_map").is(":checked");if(saveMap){var mapName=jQuery("#save_map_as").val();if(""==jQuery.trim(mapName))return errorMessage=app.vtranslate("JS_MAP_NAME_CAN_NOT_BE_EMPTY"),params={text:errorMessage,type:"error"},Vtiger_Helper_Js.showMessage(params),!1;for(var mapOption,mapOptions=jQuery("#saved_maps option"),i=0;i<mapOptions.length;++i)if(mapOption=jQuery(mapOptions.get(i)),mapOption.html()==mapName)return errorMessage=app.vtranslate("JS_MAP_NAME_ALREADY_EXISTS"),params={text:errorMessage,type:"error"},Vtiger_Helper_Js.showMessage(params),!1}return !0},loadSavedMap:function loadSavedMap(){var selectedMapElement=jQuery("#saved_maps option:selected"),mapId=selectedMapElement.attr("id"),fieldsList=jQuery(".fieldIdentifier"),deleteMapContainer=jQuery("#delete_map_container");if(fieldsList.each(function(i,element){var fieldElement=jQuery(element);jQuery("[name=mapped_fields]",fieldElement).val("");}),-1==mapId)return void deleteMapContainer.hide();deleteMapContainer.show();var mappingString=selectedMapElement.val();if(""!=mappingString){for(var mappingPairs=mappingString.split("&"),mapping={},i=0;i<mappingPairs.length;++i){var mappingPair=mappingPairs[i].split("="),header=mappingPair[0];header=header.replace(/\/eq\//g,"="),header=header.replace(/\/amp\//g,"&"),mapping["'"+header+"'"]=mappingPair[1];}fieldsList.each(function(i,element){var fieldElement=jQuery(element),mappedFields=jQuery("[name=mapped_fields]",fieldElement),rowId=jQuery("[name=row_counter]",fieldElement).get(0).value,headerNameElement=jQuery("[name=header_name]",fieldElement).get(0),headerName=jQuery(headerNameElement).html();"'"+headerName+"'"in mapping?mappedFields.val(mapping["'"+headerName+"'"]):rowId in mapping&&mappedFields.val($rowId),mappedFields.trigger("change"),ImportJs.loadDefaultValueWidget(fieldElement.attr("id"));});}},deleteMap:function deleteMap(module){app.showConfirmModal({text:app.vtranslate("LBL_DELETE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var selectedMapElement=jQuery("#saved_maps option:selected"),mapId=selectedMapElement.attr("id"),status=jQuery("#status");status.show(),AppConnector.request({module:module,view:"Import",mode:"deleteMap",mapid:mapId}).done(function(data){var mapContainer=$("#savedMapsContainer").html(data);status.hide(),App.Fields.Picklist.showSelect2ElementView(mapContainer.find("select")),App.Fields.Picklist.changeSelectElementView(jQuery("#saved_maps"));}).fail(function(error){console.error(error);});}});},loadDefaultValueWidget:function loadDefaultValueWidget(rowIdentifierId){var affectedRow=jQuery("#"+rowIdentifierId);if("undefined"!=typeof affectedRow&&null!=affectedRow){var selectedFieldElement=jQuery("[name=mapped_fields]",affectedRow).get(0),selectedFieldName=jQuery(selectedFieldElement).val(),defaultValueContainer=jQuery(jQuery("[name=default_value_container]",affectedRow).get(0)),allDefaultValuesContainer=jQuery("#defaultValuesElementsContainer");if(0<defaultValueContainer.children.length){var copyOfDefaultValueWidget=jQuery(":first",defaultValueContainer).detach();copyOfDefaultValueWidget.appendTo(allDefaultValuesContainer);}var selectedFieldDefValueContainer=jQuery("#"+selectedFieldName+"_defaultvalue_container",allDefaultValuesContainer),defaultValueWidget=selectedFieldDefValueContainer.detach();defaultValueWidget.appendTo(defaultValueContainer);}},loadDefaultValueWidgetForMappedFields:function loadDefaultValueWidgetForMappedFields(){var fieldsList=jQuery(".fieldIdentifier");fieldsList.each(function(i,element){var fieldElement=jQuery(element),mappedFieldName=jQuery("[name=mapped_fields]",fieldElement).val();""!=mappedFieldName&&ImportJs.loadDefaultValueWidget(fieldElement.attr("id"));});},submitAction:function submitAction(){var form=jQuery("[name=\"importAdvanced\"]");form.on("submit",function(){$.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),position:"html",blockInfo:{enabled:!0}});});},openListInModal:function openListInModal(){$(".js-open-list-in-modal").on("click",function(){var element=$(this),moduleName=element.data("module-name"),type="",forUser=element.data("for-user"),forModule=element.data("for-module");""!==$(this).attr("data-type")&&(type="&type="+element.data("type")),app.showModalWindow(null,"index.php?module="+moduleName+"&view=List&mode=getImportDetails"+type+"&start=1&foruser="+forUser+"&forModule="+forModule,function(data){var container=data.find(".listViewEntriesDiv"),containerH=container.height(),containerOffsetTop=container.offset().top,footerH=$(".js-footer").height(),windowH=$(window).height();Quasar.plugins.Platform.is.desktop&&(containerH+containerOffsetTop+footerH>windowH&&container.height(windowH-(containerOffsetTop+footerH)),app.showNewScrollbarTopBottomRight(container));});});}};jQuery(document).ready(function(){ImportJs.toogleMergeConfiguration(),ImportJs.openListInModal(),ImportJs.submitAction(),ImportJs.loadDefaultValueWidgetForMappedFields(),ImportJs.registerImportClickEvent(),App.Fields.Date.register(jQuery(".contentsDiv"));});}
//# sourceMappingURL=Import.min.js.map
