'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";window.MailIntegration_Iframe={mailId:0,container:{},iframe:{},iframeWindow:{},moduleSelect:{},addRecordBtn:{},loaderParams:{blockInfo:{enabled:!0},message:!1},/**
	 * AppConnector wrapper
	 *
	 * @param   {object}  request
	 *
	 * @return  {object}           AppConnector object with done method
	 */connector:function connector(request){var _this=this;return AppConnector.request(request).fail(function(){_this.hideIframeLoader(),_this.showResponseMessage(!1);})},/**
	 * Show response message
	 *
	 * @param   {boolean}  success
	 * @param   {string}  message
	 */showResponseMessage:function showResponseMessage(success){var message=1<arguments.length&&arguments[1]!==void 0?arguments[1]:"";success?this.mailItem.notificationMessages.replaceAsync("information",{type:"informationalMessage",message:message,icon:"iconid",persistent:!1}):this.mailItem.notificationMessages.replaceAsync("error",{type:"errorMessage",message:app.vtranslate("JS_ERROR")+" "+message});},/**
	 * Register list item events
	 */registerListItemEvents:function registerListItemEvents(){this.container.on("click",".js-list-item-click",this.onClickListItem.bind(this)),$(document).on("click",".popover a",this.onClickLink.bind(this)),this.container.on("click",".js-add-related-record",this.onClickQuickCreateBtn.bind(this)),this.container.on("click",".js-remove-record",this.onClickDeleteRelation.bind(this));},/**
	 * On ListItem click actions
	 *
	 * @param   {[type]}  event  [event description]
	 *
	 * @return  {[type]}         [return description]
	 */onClickListItem:function onClickListItem(event){var currentTarget=$(event.currentTarget);this.toggleActiveListItems(currentTarget),this.onClickLink(event,currentTarget.find(".js-record-link").attr("href"));},/**
	 * On link click
	 *
	 * @param   {object}  event  click event object
	 * @param   {string}  url
	 */onClickLink:function onClickLink(event,url){event.preventDefault(),url||(url=$(event.currentTarget).attr("href")),this.changeIframeSource(url);},/**
	 * On delete relation click
	 *
	 * @param   {object}  event  click event
	 */onClickDeleteRelation:function onClickDeleteRelation(event){var _this2=this;event.stopPropagation();var currentTarget=$(event.currentTarget),recordData=currentTarget.closest(".js-list-item-click").data();this.connector({module:"MailIntegration",action:"Mail",mode:"deleteRelation",mailId:this.mailId,record:recordData.id,recordModule:recordData.module}).done(function(response){_this2.showResponseMessage(response.success,app.vtranslate("JS_REMOVED_RELATION_SUCCESSFULLY")),_this2.reloadView(response.success);});},/**
	 * On quick create btn click
	 *
	 * @param   {object}  event  click event
	 */onClickQuickCreateBtn:function onClickQuickCreateBtn(event){var _this3=this;event.stopPropagation();var currentTarget=$(event.currentTarget),recordData=currentTarget.closest(".js-list-item-click").data(),newRecordData={sourceModule:recordData.module,sourceRecord:recordData.id};this.showQuickCreateForm(event.currentTarget.dataset.module,{data:newRecordData,callbackFunction:function callbackFunction(){_this3.iframeWindow.location.reload();}});},/**
	 * Fill new record data in quick create form
	 *
	 * @param   {string}  moduleName  [moduleName description]
	 *
	 * @return  {object}              call asyncGetMailBody which returns Promise
	 */fillNewRecordData:function fillNewRecordData(moduleName){var _this4=this,data={email:this.mailItem.from.emailAddress,email1:this.mailItem.from.emailAddress,relationOperation:!0,relatedRecords:$.map(this.container.find(".js-list-item-click"),function(record){return {module:record.dataset.module,id:record.dataset.id}})},fillNameFields=function(first){var nameData=_this4.mailItem.from.displayName.split(" "),firstName=nameData.shift(),lastName=nameData.join(" ");return first?firstName:lastName},autoCompleteMap=JSON.parse(this.container.find(".js-mailAutoCompleteFields").val());if(autoCompleteMap&&autoCompleteMap[moduleName]){var map=autoCompleteMap[moduleName];for(var name in map)if(map.hasOwnProperty(name)&&map[name])switch(map[name]){case"fromNameFirstPart":data[name]=fillNameFields(!0);break;case"fromNameSecondPart":data[name]=fillNameFields(!1);break;case"fromName":data[name]=this.mailItem.from.displayName;break;case"subject":data[name]=this.mailItem.subject;break;case"email":data[name]=this.mailItem.from.emailAddress;}}return this.mailDetails={},new Promise(function(resolve){_this4.asyncGetMailBody().then(function(){data.description=_this4.mailDetails.mailBody,resolve(data);});})},/**
	 * Toggle active list items
	 *
	 * @param   {object}  targetListItem  jQuery
	 */toggleActiveListItems:function toggleActiveListItems(targetListItem){targetListItem.siblings().removeClass("active"),targetListItem.addClass("active");},/**
	 * Change iframe source
	 *
	 * @param   {string}  url
	 */changeIframeSource:function changeIframeSource(url){this.iframe.attr("src",url),this.showIframeLoader();},/**
	 * Add relation
	 *
	 * @param   {number}  recordId
	 * @param   {string}  moduleName
	 */addRelation:function addRelation(recordId,moduleName){var _this5=this;this.connector({module:"MailIntegration",action:"Mail",mode:"addRelation",mailId:this.mailId,record:recordId,recordModule:moduleName}).done(function(response){_this5.showResponseMessage(response.success,app.vtranslate("JS_ADDED_RELATION_SUCCESSFULLY")),_this5.reloadView(response.success);});},/**
	 * Show quick create form
	 *
	 * @param   {string}  moduleName
	 * @param   {object}  quickCreateParams
	 */showQuickCreateForm:function showQuickCreateForm(moduleName){var quickCreateParams=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{};quickCreateParams=Object.assign({noCache:!0,data:{}},quickCreateParams),this.fillNewRecordData(moduleName).then(function(data){quickCreateParams.data=Object.assign(data,quickCreateParams.data),App.Components.QuickCreate.createRecord(moduleName,quickCreateParams);});},/**
	 * Register iframe events
	 */registerIframeEvents:function registerIframeEvents(){var _this6=this,link=this.container.find(".js-list-item-click").first();this.initIframeLoader(),link.length?(link.addClass("active"),this.iframe.attr("src",link.find(".js-record-link").attr("href")),this.iframe.on("load",function(){_this6.hideIframeLoader();})):this.hideIframeLoader();},/**
	 * Register import click
	 */registerImportClick:function registerImportClick(){var _this7=this;this.container.on("click",".js-import-mail",function(){_this7.showIframeLoader(),_this7.getMailDetails().then(function(){_this7.connector(Object.assign({module:"MailIntegration",action:"Import"},_this7.mailDetails,window.PanelParams)).done(function(response){_this7.hideIframeLoader(),_this7.showResponseMessage(response.success,app.vtranslate("JS_IMPORT")),_this7.reloadView(response.success);});});});},/**
	 * Get mail details
	 *
	 * @return  {object}  Promise
	 */getMailDetails:function getMailDetails(){var mailItem=this.mailItem;if(0<mailItem.attachments.length)for(var attachment,outputString="",i=0;i<mailItem.attachments.length;i++)attachment=mailItem.attachments[i],outputString+="<BR>"+i+". Name: ",outputString+=attachment.name,outputString+="<BR>ID: "+attachment.id,outputString+="<BR>contentType: "+attachment.contentType,outputString+="<BR>size: "+attachment.size,outputString+="<BR>attachmentType: "+attachment.attachmentType,outputString+="<BR>isInline: "+attachment.isInline;return this.mailDetails={mailFrom:this.parseEmailAddressDetails(mailItem.from),mailSender:mailItem.sender.emailAddress,mailTo:this.parseEmailAddressDetails(mailItem.to),mailCc:this.parseEmailAddressDetails(mailItem.cc),mailMessageId:mailItem.internetMessageId,mailSubject:mailItem.subject,mailNormalizedSubject:mailItem.normalizedSubject,mailDateTimeCreated:mailItem.dateTimeCreated.toISOString()},this.asyncGetMailBody()},/**
	 * Get mail body async function
	 *
	 * @param   {function}  callback
	 *
	 * @return  {object}            Promise
	 */asyncGetMailBody:function asyncGetMailBody(){var _this8=this;return Promise.all([new Promise(function(resolve,reject){_this8.mailItem.body.getAsync(Office.CoercionType.Html,function(body){"succeeded"===body.status?(_this8.mailDetails.mailBody=body.value,resolve(body)):reject(body);});}),new Promise(function(resolve,reject){_this8.mailItem.getAllInternetHeadersAsync(function(body){"succeeded"===body.status?(_this8.mailDetails.mailHeaders=body.value,resolve(body)):reject(body);});})])},/**
	 * Parse email address details
	 *
	 * @param   {object}  data
	 *
	 * @return  {string}        e-mail address
	 */parseEmailAddressDetails:function parseEmailAddressDetails(data){var fn=function(row){return row.emailAddress};if($.isArray(data)){var rows=[];return $.each(data,function(index,value){rows[index]=fn(value);}),rows}return fn(data)},/**
	 * Set iframe height
	 */setIframeHeight:function setIframeHeight(){this.iframe.height($(window).height()-this.iframe.offset().top);},/**
	 * Show iframe loader
	 */showIframeLoader:function showIframeLoader(){this.iframeLoader.progressIndicator(this.loaderParams);},/**
	 * Hide iframe loader
	 */hideIframeLoader:function hideIframeLoader(){this.iframeLoader.progressIndicator({mode:"hide"});},/**
	 * Init iframe loader
	 */initIframeLoader:function initIframeLoader(){this.iframeLoader=$.progressIndicator(this.loaderParams);},/**
	 * Register modules select
	 */registerModulesSelect:function registerModulesSelect(){var _this9=this;this.moduleSelect=App.Fields.Picklist.showSelect2ElementView(this.container.find(".js-modules")),this.moduleSelect.on("change",this.registerModulesSelectChange.bind(this)),this.container.find(".js-select-record").on("click",function(){var params={module:_this9.moduleSelect[0].value,src_module:"OSSMailView"};_this9.container.find(".js-list-item-click").each(function(){var data=$(this).data();("link"==data.field||"process"==data.field)&&(params[data.field]=data.id);}),app.showRecordsList(params,function(_modal,instance){instance.setSelectEvent(function(responseData){_this9.addRelation(responseData.id,params.module);});});});},/**
	 * Register modules select change
	 */registerModulesSelectChange:function registerModulesSelectChange(){this.moduleSelect.select2("data")[0].element.dataset.addRecord?this.addRecordBtn.removeClass("d-none"):this.addRecordBtn.addClass("d-none");},/**
	 * Register add record
	 */registerAddRecord:function registerAddRecord(){var _this10=this;this.addRecordBtn.on("click",function(){var moduleName=_this10.moduleSelect[0].value;_this10.showQuickCreateForm(moduleName,{callbackFunction:function callbackFunction(_ref){var result=_ref.result;_this10.addRelation(result._recordId,moduleName);}});});},/**
	 * Reload view
	 */reloadView:function reloadView(condition){condition&&window.location.reload();},/**
	 * Register events
	 */registerEvents:function registerEvents(){this.container=$("#page"),this.iframe=$("#js-iframe"),this.iframeWindow=this.iframe[0].contentWindow,this.addRecordBtn=this.container.find(".js-add-record"),this.mailId=this.container.find(".js-iframe-container").data("mailId"),this.mailItem=Office.context.mailbox.item,this.iframe.length&&(this.registerListItemEvents(),this.registerIframeEvents(),this.setIframeHeight(),this.mailId?(this.registerModulesSelect(),this.registerAddRecord()):this.registerImportClick());}},window.App.Components.Scrollbar.active=!1,function(){window.MailIntegration_Iframe.registerEvents();}($);
//# sourceMappingURL=Iframe.min.js.map
