'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_CurrencyUpdate_Index_Js",{},{/*
		 * Shows or hides block informing about supported currencies by presently chosen bank
		 */registerInfoButton:function registerInfoButton(container){container.find("#supportedCurrencies").on("click",function(){jQuery("#infoBlock").toggleClass("d-none");});},/*
		 * Shows or hides block informing about unsupported currencies by presently chosen bank
		 */registerAlertButton:function registerAlertButton(container){container.find("#unsupportedCurrencies").on("click",function(){container.find("#alertBlock").toggleClass("d-none");});},/*
		 * Event fired on bank picklist change.
		 * Daves the chosen bank as active in database.
		 * Updates information about supported and unsupported currencies for currently chosen bank,
		 */registerBankChange:function registerBankChange(container){var thisInstance=this;container.find("#bank").on("change",function(){var bankName=container.find("#bank option:selected").data("name");container.find("#alertSpan").html(""),container.find("#infoSpan").html("");var infoProgress=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={},bankId=jQuery("#bank option:selected").val();params.data={parent:app.getParentModuleName(),module:app.getModuleName(),name:bankName,id:bankId},params.dataType="json",params.data.action="SaveActiveBank",AppConnector.request(params).done(function(data){var response=data.result;response.success?(app.showNotify({text:response.message,type:"success"}),params.data.action="GetBankCurrencies",thisInstance.supportedCurrencies(container,params),thisInstance.unsupportedCurrencies(container,params)):app.showNotify({text:response.message,hide:!1,type:"error"}),infoProgress.progressIndicator({mode:"hide"});});});},/**
		 * Supported currencies.
		 * @param {jQuery} container
		 * @param {object} params
		 */supportedCurrencies:function supportedCurrencies(container,params){params.data.mode="supported",AppConnector.request(params).done(function(data){var name,response=data.result,html="";for(name in response)html+="<p><strong>"+name+"</strong> - "+response[name]+"</p>";container.find("#infoSpan").html(html);});},/**
		 * Unsupported currencies.
		 * @param {jQuery} container
		 * @param {object} params
		 */unsupportedCurrencies:function unsupportedCurrencies(container,params){params.data.mode="unsupported",AppConnector.request(params).done(function(data){var response=data.result;jQuery.isEmptyObject(response)?(!container.find("#unsupportedCurrencies").hasClass("d-none")&&container.find("#unsupportedCurrencies").addClass("d-none"),!container.find("#alertBlock").hasClass("d-none")&&container.find("#alertBlock").addClass("d-none")):container.find("#unsupportedCurrencies").removeClass("d-none");var name,html="";for(name in response)html+="<p><strong>"+name+"</strong> - "+response[name]+"</p>";container.find("#alertSpan").html(html);});},/**
		 * Register events
		 */registerEvents:function registerEvents(){var container=jQuery("#currencyUpdateContainer");App.Fields.Date.register("#datepicker",!1,{}),this.registerInfoButton(container),this.registerAlertButton(container),this.registerBankChange(container);}});
//# sourceMappingURL=Index.min.js.map
