'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_Inventory_Index_Js",{},{//Stored history of Name and duplicate check result
duplicateCheckCache:{},/**
		 * This function will show the model for Add/Edit
		 */edit:function edit(url,currentTrElement){var aDeferred=jQuery.Deferred(),thisInstance=this,progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return AppConnector.request(url).done(function(data){var callBackFunction=function(container){thisInstance.duplicateCheckCache={};var form=container.find("#formInventory"),params=app.validationEngineOptions;params.onValidationComplete=function(formData,valid){if(valid)return thisInstance.saveDetails(formData,currentTrElement),valid},form.validationEngine(params),form.on("submit",function(e){e.preventDefault();});};progressIndicatorElement.progressIndicator({mode:"hide"}),app.showModalWindow(data,function(modalContainer){"function"==typeof callBackFunction&&callBackFunction(modalContainer);},{});}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()},/*
		 * Function to Save the Details
		 */saveDetails:function saveDetails(form,currentTrElement){var thisInstance=this,params=form.serializeFormData(),saveButton=form.find("[type=\"submit\"]");saveButton.prop("disabled",!0),"undefined"==typeof params&&(params={}),thisInstance.validateName(params).done(function(response){if("undefined"==typeof response)return saveButton.prop("disabled",!1),!1;var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="SaveAjax",params.view=app.getViewName(),AppConnector.request(params).done(function(data){//show notification after details saved
progressIndicatorElement.progressIndicator({mode:"hide"}),app.hideModalWindow(),"string"==typeof data&&(data=JSON.parse(data)),data.result.value=App.Fields.Double.formatToDisplay(data.result.value),"true"==form.find(".addView").val()?thisInstance.addDetails(data.result):thisInstance.updateDetails(data.result,currentTrElement),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_SAVE_CHANGES")});});}).fail(function(){return saveButton.prop("disabled",!1),!1});},/*
		 * Function to add the Details in the list after saving
		 */addDetails:function addDetails(details){var container=jQuery("#inventory"),currency=jQuery("#currency"),symbol="%",table=$(".inventoryTable",container);0<currency.length&&(currency=JSON.parse(currency.val()),symbol=currency.currency_symbol),1===details.default&&table.find(".default").prop("checked",!1);var trElement=$("<tr data-id=\"".concat(details.id,"\">\n\t\t\t\t\t<td class=\"textAlignCenter ").concat(details.row_type,"\"><label class=\"name\">").concat(details.name,"</label></td>\n\t\t\t\t\t<td class=\"textAlignCenter ").concat(details.row_type,"\"><span class=\"value\">").concat(details.value," ").concat(symbol,"</span></td>\n\t\t\t\t\t<td class=\"textAlignCenter ").concat(details.row_type,"\">\n\t\t\t\t\t<div class=\"float-right  w-50 d-flex justify-content-between mr-2\">\n\t\t\t\t\t\t<input class=\"status js-update-field mt-2\" checked type=\"checkbox\" data-field-name=\"status\">\n\t\t\t\t\t\t<div class=\"actions\">\n\t\t\t\t\t\t\t<button class=\"btn btn-outline-primary btn-sm editInventory u-cursor-pointer\" data-url=\"").concat(details._editurl,"\">\n\t\t\t\t\t\t\t<span title=\"Edycja\" class=\"yfi yfi-full-editing-view alignBottom\"></span>\n\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t\t<button class=\"removeInventory u-cursor-pointer btn btn-outline-primary btn-sm\" data-url=\"").concat(details._editurl,"\">\n\t\t\t\t\t\t\t<span title=\"Usu\u0144\" class=\"fas fa-trash-alt alignBottom\"></span>\n\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t</td>\n\t\t\t\t\t</tr>"));table.append(trElement);},/*
		 * Function to update the details in the list after edit
		 */updateDetails:function updateDetails(data,currentTrElement){var currency=jQuery("#currency"),symbol="%";if(0<currency.length&&(currency=JSON.parse(currency.val()),symbol=currency.currency_symbol),currentTrElement.find(".name").text(data.name),currentTrElement.find(".value").text(data.value+" "+symbol),0===data.status?currentTrElement.find(".status").prop("checked",!0):currentTrElement.find(".status").prop("checked",!1),1===data["default"]){var table=$(".inventoryTable");table.find(".default").prop("checked",!1),currentTrElement.find(".default").prop("checked",!0);}else currentTrElement.find(".default").prop("checked",!1);},/*
		 * Function to validate the Name to avoid duplicates
		 */validateName:function validateName(data){var thisInstance=this,aDeferred=jQuery.Deferred(),name=data.name,form=jQuery("#formInventory"),nameElement=form.find("[name=\"name\"]");if(!(name in thisInstance.duplicateCheckCache))thisInstance.checkDuplicateName(data).done(function(data){thisInstance.duplicateCheckCache[name]=data.success,data.success&&(thisInstance.duplicateCheckCache.message=data.message,nameElement.validationEngine("showPrompt",data.message,"error","bottomLeft",!0),aDeferred.reject(data)),aDeferred.resolve(data);}).fail(function(data){aDeferred.reject(data);});else if(!0==thisInstance.duplicateCheckCache[name]){var result=thisInstance.duplicateCheckCache.message;nameElement.validationEngine("showPrompt",result,"error","bottomLeft",!0),aDeferred.reject();}else aDeferred.resolve();return aDeferred.promise()},/*
		 * Function to check Duplication of inventory Name
		 */checkDuplicateName:function checkDuplicateName(details){var aDeferred=jQuery.Deferred(),name=details.name,id=details.id,moduleName=app.getModuleName(),params={module:moduleName,parent:app.getParentModuleName(),action:"SaveAjax",mode:"checkDuplicateName",name:name,id:id,view:app.getViewName()};return AppConnector.request(params).done(function(data){"string"==typeof data&&(data=JSON.parse(data)),aDeferred.resolve(data.result);}).fail(function(error,err){aDeferred.reject(error,err);}),aDeferred.promise()},/*
		 * Function to update status as enabled or disabled
		 */updateCheckbox:function updateCheckbox(currentTarget){var aDeferred=jQuery.Deferred(),currentTrElement=currentTarget.closest("tr"),id=currentTrElement.data("id"),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),updatedCheckbox=currentTarget.data("field-name"),params={module:app.getModuleName(),parent:app.getParentModuleName(),action:"SaveAjax",id:id,view:app.getViewName()};if("status"===updatedCheckbox)params.status=currentTarget.is(":checked")?0:1;else if("default"===updatedCheckbox){params.default=currentTarget.is(":checked")?1:0;var table=$(".inventoryTable");1===params.default&&table.find(".default").not(currentTarget).prop("checked",!1);}return AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject(error);}),aDeferred.promise()},removeInventory:function removeInventory(inventoryElement){app.showConfirmModal({text:app.vtranslate("JS_DELETE_INVENTORY_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var params={};params.view=app.getViewName(),params.id=inventoryElement.data("id"),app.saveAjax("deleteInventory",params).done(function(data){Settings_Vtiger_Index_Js.showMessage({type:"success",text:data.result.message}),inventoryElement.remove();});}});},/*
		 * Function to register all actions in the List
		 */registerActions:function registerActions(){var thisInstance=this,container=jQuery("#inventory");//register click event for Add New Inventory button
//register event for edit icon
//register event for edit icon
//register event for checkbox to change the Status
container.find(".addInventory").on("click",function(e){var addInventoryButton=jQuery(e.currentTarget),createUrl=addInventoryButton.data("url");thisInstance.edit(createUrl);}),container.on("click",".editInventory",function(e){var editButton=jQuery(e.currentTarget),currentTrElement=editButton.closest("tr");thisInstance.edit(editButton.data("url"),currentTrElement);}),container.on("click",".removeInventory",function(e){var removeInventoryButton=jQuery(e.currentTarget),currentTrElement=removeInventoryButton.closest("tr");thisInstance.removeInventory(currentTrElement);}),container.on("click","[type=\"checkbox\"]",function(e){var currentTarget=jQuery(e.currentTarget);thisInstance.updateCheckbox(currentTarget).done(function(){var params={};params.text=app.vtranslate("JS_SAVE_CHANGES"),Settings_Vtiger_Index_Js.showMessage(params);});});},registerEvents:function registerEvents(){this.registerActions();}});
//# sourceMappingURL=Index.min.js.map
