'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";Settings_Vtiger_Edit_Js("Settings_PDF_Edit_Js",{instance:{}},{currentInstance:!1,editContainer:!1,init:function init(){this.initiate();},/**
		 * Function to get the container which holds all the workflow elements
		 * @return jQuery object
		 */getContainer:function getContainer(){return this.editContainer},/**
		 * Function to set the reports container
		 * @params : element - which represents the workflow container
		 * @return : current instance
		 */setContainer:function setContainer(element){return this.editContainer=element,this},/*
		 * Function to return the instance based on the step of the Workflow
		 */getInstance:function getInstance(step){if(step in Settings_PDF_Edit_Js.instance)return Settings_PDF_Edit_Js.instance[step];return Settings_PDF_Edit_Js.instance[step]=new window["Settings_PDF_Edit"+step+"_Js"],Settings_PDF_Edit_Js.instance[step]},/*
		 * Function to get the value of the step
		 * returns 1 or 2 or 3
		 */getStepValue:function getStepValue(){var container=this.currentInstance.getContainer();return jQuery(".step",container).val()},/*
		 * Function to initiate the step 1 instance
		 */initiate:function initiate(container){"undefined"==typeof container&&(container=jQuery(".pdfTemplateContents")),container.is(".pdfTemplateContents")?this.setContainer(container):this.setContainer(jQuery(".pdfTemplateContents",container)),this.initiateStep("1"),this.currentInstance.registerEvents();},/*
		 * Function to initiate all the operations for a step
		 * @params step value
		 */initiateStep:function initiateStep(stepVal){this.activateHeader("step"+stepVal),this.currentInstance=this.getInstance(stepVal);},/*
		 * Function to activate the header based on the class
		 * @params class name
		 */activateHeader:function activateHeader(step){var headersContainer=jQuery(".crumbs ");headersContainer.find(".active").removeClass("active"),jQuery("#"+step,headersContainer).addClass("active");},/*
		 * Function to register the click event for next button
		 */registerFormSubmitEvent:function registerFormSubmitEvent(form){var thisInstance=this;jQuery.isFunction(thisInstance.currentInstance.submit)&&form.on("submit",function(e){var form=jQuery(e.currentTarget),specialValidation=!0;jQuery.isFunction(thisInstance.currentInstance.isFormValidate)&&(specialValidation=thisInstance.currentInstance.isFormValidate()),form.validationEngine("validate")&&specialValidation&&thisInstance.currentInstance.submit().done(function(data){thisInstance.getContainer().prepend(data);var stepVal=thisInstance.getStepValue(),nextStepVal=parseInt(stepVal)+1;thisInstance.initiateStep(nextStepVal),thisInstance.currentInstance.initialize();var container=thisInstance.currentInstance.getContainer();thisInstance.registerFormSubmitEvent(container),thisInstance.currentInstance.registerEvents(),thisInstance.registerEditors(container);}),e.preventDefault();});},back:function back(){var step=this.getStepValue(),prevStep=parseInt(step)-1;this.currentInstance.initialize();var container=this.currentInstance.getContainer(),pdfRecordElement=jQuery("[name=\"record\"]",container),pdfId=pdfRecordElement.val();container.remove(),this.initiateStep(prevStep);var currentContainer=this.currentInstance.getContainer();currentContainer.show(),jQuery("[name=\"record\"]",currentContainer).val(pdfId);},registerCancelStepClickEvent:function registerCancelStepClickEvent(form){jQuery("button.cancelLink",form).on("click",function(){window.history.back();});},/*
		 * Function to register the click event for back step
		 */registerBackStepClickEvent:function registerBackStepClickEvent(){var thisInstance=this,container=this.getContainer();container.on("click",".backStep",function(){thisInstance.back();});},registerMetatagsClickEvent:function registerMetatagsClickEvent(form){var metaTagsStatus=form.find("#metatags_status");metaTagsStatus.is(":checked")?form.find(".metatags").removeClass("d-none"):form.find(".metatags").addClass("d-none"),metaTagsStatus.on("change",function(){var status=$(this).is(":checked");status?($("#set_subject",form).val($("#secondary_name",form).val()),$("#set_title",form).val($("#primary_name",form).val()),$(".metatags",form).removeClass("d-none")):$(".metatags",form).addClass("d-none");});},/**
		 * Register wysiwyg editors
		 * @param {jQuery} container
		 * @param {array} fonts
		 */registerEditors:function registerEditors(container){var fonts=1<arguments.length&&arguments[1]!==void 0?arguments[1]:["DejaVu Sans"];container.find(".js-editor").each(function(){var editor=$(this);"undefined"!=typeof CONFIG.fonts&&1===fonts.length&&(fonts=CONFIG.fonts.map(function(font){return font}),fonts.unshift("DejaVu Sans")),App.Fields.Text.Editor.register(editor,{entities_latin:!1,toolbar:"PDF",font_defaultLabel:"DejaVu Sans",fontSize_defaultLabel:"10px",font_names:fonts.join(";"),contentsCss:CONFIG.siteUrl+"layouts/resources/fonts/fonts.css",height:"body_content"===editor.attr("id")?"800px":"80px",stylesSet:[{name:"Komorka 14",element:"td",attributes:{style:"font-size:14px"}}],allowedContent:{$1:{elements:CKEDITOR.dtd,attributes:!0,classes:!0,styles:{display:!0,color:!0,"background-color":!0,"background-image":!0,"font-size":!0,"font-weight":!0,"font-family":!0,"text-align":!0,"text-transform":!0,width:!0,height:!0,border:!0,"border-collapse":!0,"cell-spacing":!0,"vertical-align":!0,"margin-top":!0,"margin-bottom":!0,"margin-left":!0,"margin-right":!0,"padding-top":!0,"padding-bottom":!0,"padding-left":!0,"padding-right":!0,margin:!0,padding:!0,"border-color":!0,"border-width":!0,"border-style":!0,"border-top-color":!0,"border-top-width":!0,"border-top-style":!0,"border-right-color":!0,"border-right-width":!0,"border-right-style":!0,"border-bottom-color":!0,"border-bottom-width":!0,"border-bottom-style":!0,"border-left-color":!0,"border-left-width":!0,"border-left-style":!0,"line-height":!0}}}});});},/**
		 * Register wysiwyg editors with fonts
		 * @param form
		 */registerEditorsWithFonts:function registerEditorsWithFonts(form){var _this=this;$.ajax({url:CONFIG.siteUrl+"layouts/resources/fonts/fonts.json",method:"GET",dataType:"json"}).done(function(response){if(0===response.length)return _this.registerEditors(form);var fonts=response.map(function(font){return font.family}).filter(function(val,index,self){return self.indexOf(val)===index});CONFIG.fonts=fonts,_this.registerEditors(form,fonts);}).fail(function(){_this.registerEditors(form),app.errorLog("Could not load fonts.");});},/**
		 * Register events
		 */registerEvents:function registerEvents(){var form=this.currentInstance.getContainer();this.registerFormSubmitEvent(form),this.registerBackStepClickEvent(),this.registerCancelStepClickEvent(form),this.registerMetatagsClickEvent(form),this.registerEditorsWithFonts(form);}});
//# sourceMappingURL=Edit.min.js.map
