'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 * Class Settings_YetiForce_Shop_Js.
 * @type {window.Settings_YetiForce_Shop_Js}
 */function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}window.Settings_YetiForce_Shop_Js=/*#__PURE__*/function(){/**
	 * Constructor.
	 */function Settings_YetiForce_Shop_Js(){var modalUrl=0<arguments.length&&arguments[0]!==void 0?arguments[0]:"index.php?module=YetiForce&parent=Settings";_classCallCheck(this,Settings_YetiForce_Shop_Js),this.container=$(".js-products-container"),this.modalUrl=modalUrl;}/**
	 * Register events.
	 */return _createClass(Settings_YetiForce_Shop_Js,[{key:"registerEvents",value:function registerEvents(){this.registerProductModalClick(),this.registerBuyModalClick(),this.registerShopSearch(),this.registerCategories(),this.registerSwitch(),this.registerRefresh();}/**
	 * Register events.
	 */},{key:"registerShopSearch",value:function registerShopSearch(){var _this=this,searchField=this.container.find(".js-shop-search");searchField=searchField.length?searchField:$(".js-shop-search"),searchField.on("keyup",function(e){var value=$(e.currentTarget).val().toLowerCase();_this.container.find(".js-product .js-text-search").filter(function(){var item=$(this).closest(".js-product");-1<$(this).text().toLowerCase().indexOf(value)?item.removeClass("d-none"):item.addClass("d-none");});}).on("click",function(e){e.stopPropagation();});}/**
	 * Register product modal click.
	 *
	 */},{key:"registerProductModalClick",value:function registerProductModalClick(){var _this2=this;this.container.find(".js-product").on("click",function(e){var target=$(e.target);if(!(target.hasClass("js-product-switch")||target.closest(".js-stop-parent-trigger").length)){var progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0}}),currentTarget=$(e.currentTarget);_this2.showProductModal(currentTarget.data("product"),currentTarget.data("productId")),progressIndicatorElement.progressIndicator({mode:"hide"});}});}/**
	 * Register switch
	 */},{key:"registerSwitch",value:function registerSwitch(){this.container.find(".js-product-switch").on("change",function(e){var currentTarget=$(e.currentTarget),isChecked=currentTarget.is(":checked"),confirm=currentTarget.data("confirm");confirm&&app.showConfirmModal({title:confirm,confirmedCallback:function confirmedCallback(){var url=isChecked?currentTarget.data("url-on"):currentTarget.data("url-off");url&&($.progressIndicator({blockInfo:{enabled:!0}}),AppConnector.request(url).done(function(){window.location.reload();}));},rejectedCallback:function rejectedCallback(){currentTarget.prop("checked",!isChecked);}});});}/**
	 * Show product modal action.
	 *
	 * @param   {string}  productName
	 */},{key:"showProductModal",value:function showProductModal(productName){var _this3=this,productId=1<arguments.length&&arguments[1]!==void 0?arguments[1]:"";app.showModalWindow(null,"".concat(this.modalUrl,"&view=ProductModal&product=").concat(productName,"&productId=").concat(productId),function(modalContainer){modalContainer.find(".js-modal__save").on("click",function(){app.hideModalWindow(),_this3.showBuyModal(productName,productId);});});}/**
	 * Register buy modal click.
	 *
	 */},{key:"registerBuyModalClick",value:function registerBuyModalClick(){var _this4=this;this.container.find(".js-buy-modal").on("click",function(e){var progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0}});e.stopPropagation();var currentTarget=$(e.currentTarget);_this4.showBuyModal(currentTarget.data("product"),currentTarget.data("productId")),progressIndicatorElement.progressIndicator({mode:"hide"});});}/**
	 * Show buy modal action.
	 *
	 * @param   {string}  productName
	 * @param   {string}  productId
	 */},{key:"showBuyModal",value:function showBuyModal(productName,productId){app.showModalWindow(null,"".concat(this.modalUrl,"&view=BuyModal&product=").concat(productName).concat(productId?"&productId="+productId:""),this.registerBuyModalEvents.bind(this));}},{key:"registerBuyModalEvents",value:function registerBuyModalEvents(modalContainer){var _this5=this,buyForm=modalContainer.find(".js-buy-form"),companyForm=modalContainer.find(".js-update-company-form");modalContainer.find(".js-modal__save").on("click",function(){_this5.registerBuyModalForms(companyForm,buyForm);}),companyForm.validationEngine(app.validationEngineOptions),companyForm.find("[data-inputmask]").inputmask(),buyForm.length&&(buyForm.validationEngine(app.validationEngineOptions),buyForm.find("[data-inputmask]").inputmask()),modalContainer.find(".js-price-by-size").on("change",function(e){var dataset=e.currentTarget.selectedOptions[0].dataset;for(var d in dataset)modalContainer.find(".js-buy-text[data-key=\"".concat(d,"\"]")).text(dataset[d]),modalContainer.find(".js-buy-value[name=\"".concat(d,"\"]")).val(dataset[d]);});}},{key:"registerBuyModalForms",value:function registerBuyModalForms(companyForm,buyForm){if(!0===companyForm.validationEngine("validate")){var formData=companyForm.serializeFormData(),progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request(formData).done(function(data){var response=data.result;if(data.success&&response&&response.success&&response.orderId){var customField=buyForm.find("input[name=\"custom\"]");customField.val("".concat(customField.val(),"|").concat(response.orderId)),buyForm.submit(),app.hideModalWindow();}else app.showNotify({text:(null===response||void 0===response?void 0:response.message)||app.vtranslate("JS_ERROR"),type:data.result.type,hide:!0,delay:8e3,textTrusted:!1});progressIndicatorElement.progressIndicator({mode:"hide"});});}else app.formAlignmentAfterValidation(companyForm);}/**
	 * Register categories.
	 *
	 */},{key:"registerCategories",value:function registerCategories(){var _this6=this;this.container.find(".js-select-category").on("click",function(e){_this6.changeCategory($(e.currentTarget).data("tab"));}),this.changeCategory(this.container.find(".js-select-category.active").data("tab"));}/**
	 * Register categories.
	 *
	 */},{key:"changeCategory",value:function changeCategory(category){this.container.find(".js-nav-premium .js-product").each(function(){var product=$(this);"All"===category?product.removeClass("d-none"):product.data("category")===category?product.removeClass("d-none"):product.addClass("d-none");});}/** Check registration status */},{key:"registerRefresh",value:function registerRefresh(){this.container.find(".js-refresh-status").on("click",function(){var progressIndicator=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request({parent:"Settings",module:"Companies",action:"CheckStatus"}).done(function(data){progressIndicator.progressIndicator({mode:"hide"}),data.success&&data.result&&(data.result.message&&app.showNotify({text:data.result.message,type:data.result.type,hide:!0,delay:8e3,textTrusted:!1}),data.result.success&&window.location.reload());});});}}])}();
//# sourceMappingURL=Shop.min.js.map
