/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/
'use strict';

Users_Detail_Js(
	'Users_PreferenceDetail_Js',
	{},
	{
		/**
		 * register Events for my preference
		 */
		registerEvents: function () {
			this._super();
			Users_Edit_Js.registerChangeEventForCurrencySeparator();
			let container = this.getContentHolder();
			App.Fields.Tree.register(container);
			App.Fields.MultiEmail.register(container);
			App.Fields.Password.register(container);
			this.registerRunTest();
			this.refisterSaveMailbox();
		},

		refisterSaveMailbox: function () {
			let container = this.getContentHolder().find('#mailbox');
			let form = container.closest('form');
			form.on('submit', (e) => {
				e.preventDefault();
				if (form.validationEngine('validate')) {
					let progress = $.progressIndicator({
						message: app.vtranslate('JS_SAVE_LOADER_INFO'),
						blockInfo: { enabled: true }
					});
					let formData = form.serializeFormData();
					app
						.saveAjax('', [], formData)
						.done(function (data) {
							progress.progressIndicator({ mode: 'hide' });
							if (data.success && data.result) {
								app.showNotify({ text: app.vtranslate('JS_SAVE_NOTIFY_SUCCESS'), type: 'success' });
								if (data.result.url) {
									$.progressIndicator({ blockInfo: { enabled: true } });
									window.location.href = data.result.url;
								}
							} else {
								app.showNotify({
									text: app.vtranslate('JS_ERROR'),
									type: 'error'
								});
							}
						})
						.fail((_textStatus, errorThrown) => {
							app.showNotify({
								textTrusted: false,
								title: app.vtranslate('JS_ERROR'),
								text: errorThrown,
								type: 'error'
							});
							progress.progressIndicator({ mode: 'hide' });
						});
				}
			});
		},

		registerRunTest: function () {
			let container = this.getContentHolder();
			container.find('.js-mailbox-run').on('click', (e) => {
				let form = $(e.currentTarget).closest('form');
				container.find('.js-toggle-panel').find('.js-block-content').removeClass('d-none');
				if (form.validationEngine('validate')) {
					let progressLoader = $.progressIndicator({
						position: 'html',
						blockInfo: { enabled: true }
					});
					let formData = form.serializeFormData();
					formData['action'] = 'RunTest';
					app
						.saveAjax(null, [], formData)
						.done(function (data) {
							let response = data.result;
							if (data.success && response && response.result) {
								let message = response.message;
								app.showNotify({
									text: message ?? app.vtranslate('JS_SAVE_SUCCESS'),
									type: response.type ?? 'success'
								});
							} else {
								let message = response.message ? response.message : app.vtranslate('JS_ERROR');
								app.showNotify({ textTrusted: false, text: message, type: response.type ?? 'error' });
							}
						})
						.fail(function () {
							app.showNotify({ textTrusted: false, text: app.vtranslate('JS_ERROR'), type: 'error' });
						})
						.always(() => {
							progressLoader.progressIndicator({ mode: 'hide' });
						});
				}
			});
		}
	}
);
