'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 * Class representing a standard calendar.
 * @extends Calendar_Js
 */function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _callSuper(t,o,e){return o=_getPrototypeOf(o),_possibleConstructorReturn(t,_isNativeReflectConstruct()?Reflect.construct(o,e||[],_getPrototypeOf(t).constructor):o.apply(t,e))}function _possibleConstructorReturn(self,call){if(call&&("object"===_typeof(call)||"function"==typeof call))return call;if(void 0!==call)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(self)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));}catch(t){}return (_isNativeReflectConstruct=function(){return !!t})()}function _get(){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get.bind():function(target,property,receiver){var base=_superPropBase(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(3>arguments.length?target:receiver):desc.value}},_get.apply(this,arguments)}function _superPropBase(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&(object=_getPrototypeOf(object),null!==object););return object}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),Object.defineProperty(subClass,"prototype",{writable:!1}),superClass&&_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}window.Vtiger_Calendar_Js=/*#__PURE__*/function(_Calendar_Js){function Vtiger_Calendar_Js(){return _classCallCheck(this,Vtiger_Calendar_Js),_callSuper(this,Vtiger_Calendar_Js,arguments)}return _inherits(Vtiger_Calendar_Js,_Calendar_Js),_createClass(Vtiger_Calendar_Js,[{key:"setCalendarModuleOptions",value:/**
	 * Set calendar module options.
	 * @returns {{allDaySlot: boolean, dayClick: object, selectable: boolean}}
	 */function setCalendarModuleOptions(){var _this=this,self=this;return {allDaySlot:app.getMainParams("allDaySlot"),dateClick:function dateClick(args){_this.eventCreate&&self.registerDayClickEvent(args);},selectable:!1,eventClick:function eventClick(info){info.jsEvent.preventDefault();var element=$(info.el),link=element.attr("href");link||(link=element.find("a").attr("href")),link&&-1!==$.inArray("js-show-modal",info.event.classNames)&&app.showModalWindow(null,link.replace("view=","xview=")+"&view=QuickDetailModal");}}}/**
	 * Set calendar module's options.
	 * @returns {object}
	 */},{key:"setCalendarAdvancedOptions",value:function setCalendarAdvancedOptions(){var self=this;return Object.assign(_get(_getPrototypeOf(Vtiger_Calendar_Js.prototype),"setCalendarAdvancedOptions",this).call(this),{headerToolbar:{left:"dayGridMonth,".concat(app.getMainParams("weekView"),",").concat(app.getMainParams("dayView"),",listWeek,today"),center:"prevYear,prev,title,next,nextYear",right:""},select:function select(info){self.selectDays(info);},datesSet:function datesSet(dateInfo){app.event.trigger("Calendar.DatesSet",dateInfo,this),"year"!==self.fullCalendar.view&&self.loadCalendarData();}})}/**
	 * Function invokes by fullCalendar, sets selected days in form
	 * @param {object} info
	 */},{key:"selectDays",value:function selectDays(info){return !!this.container.find(".js-right-panel-event-link").length&&void(this.container.find(".js-right-panel-event-link").tab("show"),_get(_getPrototypeOf(Vtiger_Calendar_Js.prototype),"selectDays",this).call(this,info))}/**
	 * Load calendar data
	 */},{key:"loadCalendarData",value:function loadCalendarData(){var self=this,progressInstance=$.progressIndicator({blockInfo:{enabled:!0}}),options=this.getDefaultParams();self.fullCalendar.removeAllEvents(),self.clearFilterButton(options.user),options.historyUrl="index.php?module=".concat(options.module,"&view=Calendar&history=true"),options.historyUrl+="&viewType=".concat(this.fullCalendar.view.type,"&start=").concat(options.start,"&end=").concat(options.end),options.historyUrl+="&time=".concat(options.time,"&user=").concat(JSON.stringify(options.user)),options.historyUrl+="&extraSources=".concat(JSON.stringify(options.extraSources)),options.historyUrl+="&hiddenDays=".concat(this.fullCalendar.getOption("hiddenDays")),options.cvid&&(options.historyUrl+="&cvid=".concat(options.cvid));var connectorMethod=window.AppConnector.request;this.browserHistory&&window.calendarLoaded&&(connectorMethod=window.AppConnector.requestPjax),this.browserHistoryConfig&&Object.keys(this.browserHistoryConfig).length&&!window.calendarLoaded&&(options=Object.assign(options,{start:this.browserHistoryConfig.start,end:this.browserHistoryConfig.end,user:this.browserHistoryConfig.user,time:this.browserHistoryConfig.time,cvid:this.browserHistoryConfig.cvid}),connectorMethod=window.AppConnector.request,app.setMainParams("showType",this.browserHistoryConfig.time),app.setMainParams("usersId",this.browserHistoryConfig.user)),connectorMethod(options).done(function(events){self.fullCalendar.removeAllEvents(),self.fullCalendar.addEventSource(events.result),progressInstance.progressIndicator({mode:"hide"});}),window.calendarLoaded=!0;}/**
	 * Reload calendar data after changing search parameters
	 */},{key:"reloadCalendarData",value:function reloadCalendarData(){_get(_getPrototypeOf(Vtiger_Calendar_Js.prototype),"reloadCalendarData",this).call(this),this.updateCountTaskCalendar();}/**
	 * Show/hide clear filter button
	 */},{key:"clearFilterButton",value:function clearFilterButton(user){var currentUser=parseInt(app.getMainParams("userId")),time=app.getMainParams("showType"),statement=JSON.stringify(user.selectedIds)===JSON.stringify(["".concat(currentUser)])&&void 0===this.getCurrentCvId()&&"current"===time;$(".js-calendar__clear-filters").toggleClass("d-none",statement);}/**
	 * Default params
	 * @returns {{module: *, action: string, mode: string, start: *, end: *, user: *, emptyFilters: boolean}}
	 */},{key:"getDefaultParams",value:function getDefaultParams(){var options=_get(_getPrototypeOf(Vtiger_Calendar_Js.prototype),"getDefaultParams",this).call(this),user=this.getSelectedUsersCalendar();0===user.length&&(user=app.getMainParams("usersId")),void 0===user&&(user=[app.getMainParams("userId")]),"timeGridDay"===this.fullCalendar.view&&(this.fullCalendar.view.activeEnd=this.fullCalendar.view.activeEnd.add(1,"day"));var time=this.getSidebarView().find(".js-switch--showType input:checked").data("val");return options.time=void 0===options.time?app.getMainParams("showType"):time,options.history=!0,options.user=user,options}/**
	 * Get selected users
	 * @returns {{ selectedIds: array, excludedIds: array }}
	 */},{key:"getSelectedUsersCalendar",value:function getSelectedUsersCalendar(){var sidebar=this.getSidebarView(),selectedUsers=sidebar.find(".js-input-user-owner-id:checked"),notSelectedUsers=sidebar.find(".js-input-user-owner-id:not(:checked)"),selectedUsersAjax=sidebar.find(".js-input-user-owner-id-ajax"),selectedRolesAjax=sidebar.find(".js-input-role-owner-id-ajax"),checkboxSelectAll=sidebar.find(".js-select-all"),selectedIds=[],excludedIds=[],ifSelectAllIsChecked=0<checkboxSelectAll.length&&checkboxSelectAll.is(":checked");return ifSelectAllIsChecked?selectedIds.push("all"):0<selectedUsers.length&&selectedUsers.each(function(){selectedIds.push($(this).val());}),0<selectedUsersAjax.length&&(selectedIds=selectedUsersAjax.val().concat(selectedRolesAjax.val())),ifSelectAllIsChecked&&notSelectedUsers&&notSelectedUsers.each(function(){excludedIds.push($(this).val());}),0===selectedIds.length&&CONFIG.userId&&selectedIds.push(CONFIG.userId),{selectedIds:selectedIds,excludedIds:excludedIds}}/**
	 * Register day click event.
	 * @param {object} info
	 */},{key:"registerDayClickEvent",value:function registerDayClickEvent(info){var self=this,userFormat=App.Fields.Date.dateToUserFormat(info.date);return CONFIG.isQuickCreateSupported?void self.getCalendarCreateView().done(function(data){App.Components.QuickCreate.showModal(data,{callbackFunction:function callbackFunction(){self.reloadCalendarData();},callbackBeforeRegister:function callbackBeforeRegister(modal){modal.find(".js-selected-date").val(App.Fields.Date.dateToDbFormat(info.date));},callbackPostShown:function callbackPostShown(modal){self.dayCallbackCreateModal(modal,info);}});}):void app.openUrl("index.php?module="+(this.module?this.module:CONFIG.module)+"&view=Edit&date_start="+userFormat+"&due_date="+userFormat)}/**
	 * Callback after shown create modal
	 * @param {jQuery} modal
	 * @param {object} info
	 */},{key:"dayCallbackCreateModal",value:function dayCallbackCreateModal(modal,info){var endTimeString,dateFormat=modal.find("[name=\"date_start\"]").data("dateFormat"),timeFormat=modal.find("[name=\"time_start\"]").data("format"),defaultTimeFormat="hh:mm A",userFormat=App.Fields.Date.dateToUserFormat(info.date,dateFormat);24==timeFormat&&(defaultTimeFormat="HH:mm");var startTimeString=moment(info.date).format(defaultTimeFormat);if("dayGridMonth"==this.fullCalendar.view.type){var now=new Date;startTimeString=moment(now).format(defaultTimeFormat),endTimeString=moment(now).add(15,"minutes").format(defaultTimeFormat);}else endTimeString=moment(info.date).add(30,"minutes").format(defaultTimeFormat);modal.find("[name=\"date_start\"]").val(userFormat),modal.find("[name=\"due_date\"]").val(userFormat),modal.find("[name=\"time_start\"]").val(startTimeString),modal.find("[name=\"time_end\"]").val(endTimeString);}/**
	 * Register switch events
	 */},{key:"registerSwitchEvents",value:function registerSwitchEvents(){var isWorkDays,switchShowTypeVal,_this2=this,switchContainer=$(".js-calendar__tab--filters"),switchShowType=switchContainer.find(".js-switch--showType"),showTypeState=switchShowType.find(".js-switch--label-on.active").length?"current":"history",switchSwitchingDays=switchContainer.find(".js-switch--switchingDays"),switchingDaysState=switchSwitchingDays.find(".js-switch--label-on.active").length?"workDays":"all",historyParams=app.getMainParams("historyParams",!0);""===historyParams?(isWorkDays="workDays"===app.getMainParams("switchingDays")&&"all"!==app.moduleCacheGet("defaultSwitchingDays"),switchShowTypeVal="current"===app.getMainParams("showType")&&"history"!==app.moduleCacheGet("defaultShowType"),!switchShowTypeVal&&switchShowType.find(".js-switch--label-off").button("toggle")):(void 0!==historyParams.time&&app.setMainParams("showType",historyParams.time),app.setMainParams("switchingDays",""===historyParams.hiddenDays?"all":"workDays")),switchShowType.on("change","input",function(e){var currentTarget=$(e.currentTarget);"undefined"==typeof currentTarget.data("on-text")?"undefined"!=typeof currentTarget.data("off-text")&&(app.setMainParams("showType","history"),app.moduleCacheSet("defaultShowType","history")):(app.setMainParams("showType","current"),app.moduleCacheSet("defaultShowType","current")),_this2.reloadCalendarData();}),app.getMainParams("showType")!==showTypeState&&$("label.active",switchShowType).find("input").filter(":first").trigger("change"),switchSwitchingDays.length&&("undefined"!=typeof isWorkDays&&!isWorkDays&&switchSwitchingDays.find(".js-switch--label-off").button("toggle"),switchSwitchingDays.on("change","input",function(e){var currentTarget=$(e.currentTarget),hiddenDays=[];"undefined"==typeof currentTarget.data("on-text")?"undefined"!=typeof currentTarget.data("off-text")&&(app.setMainParams("switchingDays","all"),app.moduleCacheSet("defaultSwitchingDays","all")):(app.setMainParams("switchingDays","workDays"),app.moduleCacheSet("defaultSwitchingDays","workDays"),hiddenDays=app.getMainParams("hiddenDays",!0)),_this2.fullCalendar.setOption("hiddenDays",hiddenDays),_this2.fullCalendar.setOption("height",_this2.setCalendarHeight());}),app.getMainParams("switchingDays")!==switchingDaysState&&$("label.active",switchSwitchingDays).find("input").filter(":first").trigger("change"));}/**
	 * Function toggles next year/month and general arrows on view render
	 */},{key:"registerViewRenderEvents",value:function registerViewRenderEvents(){var _this3=this,toolbar=this.calendarView.find(".fc-toolbar.fc-header-toolbar");this.showChangeDateButtons(toolbar),this.appendSubDateRow(toolbar),this.refreshDatesRowView(),this.addHeaderButtons(),this.showTodayButtonCheckbox(toolbar),app.event.on("Calendar.DatesSet",function(){_this3.showChangeDateButtons(toolbar),_this3.refreshDatesRowView(),_this3.showTodayButtonCheckbox(toolbar);});}/**
	 * Function shows change date buttons in calendar's header for specific view
	 * @param {jQuery} toolbar
	 */},{key:"showChangeDateButtons",value:function showChangeDateButtons(toolbar){var view=this.fullCalendar.view,buttonText=this.calendarOptions.buttonText,nextPrevButtons=toolbar.find(".fc-prev-button, .fc-next-button"),yearButtons=toolbar.find(".fc-prevYear-button, .fc-nextYear-button");if(yearButtons.first().html("<span class=\"fas fa-xs fa-minus mr-1\"></span>".concat(buttonText.year)),yearButtons.last().html("".concat(buttonText.year,"<span class=\"fas fa-xs fa-plus ml-1\"></span>")),"year"!==view.type&&Calendar_Js.viewsNamesLabels[view.type]){var viewType=Calendar_Js.viewsNamesLabels[view.type];nextPrevButtons.first().html("<span class=\"fas fa-xs fa-minus mr-1\"></span>".concat(buttonText[viewType])),nextPrevButtons.last().html("".concat(buttonText[viewType],"<span class=\"fas fa-xs fa-plus ml-1\"></span>"));}"year"===view.type?(nextPrevButtons.hide(),yearButtons.show()):"dayGridMonth"===view.type?(nextPrevButtons.show(),yearButtons.show()):"list"===view.type?(nextPrevButtons.hide(),yearButtons.hide()):(nextPrevButtons.show(),yearButtons.hide());}/**
	 * Appends sub date row to calendar header and register its scroll
	 * @param {jQuery} toolbar
	 */},{key:"appendSubDateRow",value:function appendSubDateRow(toolbar){this.calendarView.find(".js-dates-row").length||(this.subDateRow=$("<div class=\"js-scroll js-dates-row u-overflow-auto-xl-down order-4 flex-grow-1 position-relative my-1 w-100\" data-js=\"perfectScrollbar | container\">\n\t\t\t\t\t\t<div class=\"d-flex flex-nowrap w-100\">\n\t\t\t\t\t\t\t<div class=\"js-sub-date-list w-100 sub-date-list row no-gutters flex-nowrap nav nav-tabs\" data-js=\"data-type\"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>"),toolbar.append(this.subDateRow),$(window).width()>app.breakpoints.lg&&app.showNewScrollbar(toolbar));}/**
	 * Refresh date bar with counts
	 */},{key:"refreshDatesRowView",value:function refreshDatesRowView(){var self=this;switch(this.fullCalendar.view.type){case"year":self.generateYearList();break;case"dayGridMonth":self.generateMonthList();break;case"dayGridWeek":case"timeGridWeek":case"listWeek":self.generateWeekList();break;case"dayGridWeek":case"timeGridDay":case"dayGridDay":self.generateDaysList();break;default:this.container.find(".js-dates-row .js-sub-date-list").html("");}self.updateCountTaskCalendar(),self.registerDatesChange();}/**
	 * Generate days bar list
	 */},{key:"generateDaysList",value:function generateDaysList(){for(var datesView=this.container.find(".js-dates-row"),activeDays=moment(this.fullCalendar.view.currentStart).format("DDD"),nextDays=moment(this.fullCalendar.view.currentStart).add(7,"days"),prevDays=moment(this.fullCalendar.view.currentStart).subtract(5,"days"),daysToShow=nextDays.diff(prevDays,"days"),html="",day=0;day<daysToShow;++day){if("workDays"===app.getMainParams("switchingDays")&&"all"!==app.moduleCacheGet("defaultSwitchingDays")&&-1!==$.inArray(prevDays.day(),app.getMainParams("hiddenDays",!0))){prevDays=moment(prevDays).add(1,"days"),daysToShow++;continue}var date=prevDays.format("YYYY-MM-DD"),dateUser=App.Fields.Date.dateToUserFormat(date),active="";prevDays.format("DDD")===activeDays&&(active="active"),html+="<div data-date=\"".concat(date,"\" data-dates=\"").concat(date,"|").concat(date,"\" data-type=\"days\"\n\t\t\t\tclass=\"js-sub-record sub-record nav-item px-0\" data-js=\"click\">\n\t\t\t\t<div class=\"sub-record-content nav-link js-popover-tooltip ").concat(active,"\"\n\t\t\t\t\ttitle=\"").concat(App.Fields.Date.fullDaysTranslated[prevDays.format("d")]," ").concat(dateUser,"\" data-js=\"class: active\">\n\t\t\t\t<div class=\"sub-date-name\">").concat(app.vtranslate("JS_DAY_SHORT")," ").concat(prevDays.format("DD"),"\n\t\t\t\t<div class=\"js-count-events count badge  ml-1\" data-js=\"html\">0</div>\n\t\t\t\t</div></div></div>"),prevDays=moment(prevDays).add(1,"days");}datesView.find(".js-sub-date-list").html(html);}/**
	 * Generate weeks bar list
	 */},{key:"generateWeekList",value:function generateWeekList(){for(var datesView=this.container.find(".js-dates-row"),activeWeek=moment(this.fullCalendar.view.currentStart).format("WW"),nextWeeks=moment(this.fullCalendar.view.currentStart).add(6,"weeks"),prevWeeks=moment(this.fullCalendar.view.currentStart).subtract(5,"weeks"),html="";prevWeeks.format("YYYY-MM-DD")<=nextWeeks.format("YYYY-MM-DD");){var date=prevWeeks.format("YYYY-MM-DD"),dateEnd=moment(prevWeeks).add(6,"day").format("YYYY-MM-DD"),dateUser=App.Fields.Date.dateToUserFormat(date),dateEndUser=App.Fields.Date.dateToUserFormat(dateEnd),active="";prevWeeks.format("WW")===activeWeek&&(active="active"),html+="<div data-date=\"".concat(date,"\" data-dates=\"").concat(date,"|").concat(dateEnd,"\"\n\t\t\t\tclass=\"js-sub-record sub-record nav-item px-0\" data-type=\"weeks\" data-js=\"click\">\n\t\t\t\t<div class=\"sub-record-content nav-link js-popover-tooltip ").concat(active,"\" title=\"").concat(dateUser," > ").concat(dateEndUser,"\" data-js=\"class: active\">\n\t\t\t\t<div class=\"sub-date-name\">").concat(app.vtranslate("JS_WEEK_SHORT")," ").concat(prevWeeks.format("WW"),"\n\t\t\t\t<div class=\"js-count-events count badge  ml-1\" data-js=\"html\">0</div>\n\t\t\t\t</div></div></div>"),prevWeeks.add(1,"weeks");}datesView.find(".js-sub-date-list").html(html);}/**
	 * Generate month bar list
	 */},{key:"generateMonthList",value:function generateMonthList(){for(var datesView=this.container.find(".js-dates-row"),activeMonth=this.fullCalendar.view.currentStart.getMonth(),activeYear=this.fullCalendar.view.currentStart.getFullYear(),html="",month=0;12>month;++month){var m=8>=month?"0"+(month+1):month+1,lastDay=App.Fields.Date.getLastMonthDay(activeYear,m),date=activeYear+"-"+m+"-01",dateEnd=activeYear+"-"+m+"-"+lastDay,dateUser=App.Fields.Date.dateToUserFormat(date),dateEndUser=App.Fields.Date.dateToUserFormat(dateEnd),active="";month===activeMonth&&(active="active"),html+="<div data-date=\"".concat(date,"\" data-dates=\"").concat(date,"|").concat(dateEnd,"\"\n\t\t\t\tclass=\"js-sub-record sub-record nav-item px-0\" data-type=\"months\" data-js=\"click\">\n\t\t\t\t<div class=\"sub-record-content nav-link js-popover-tooltip ").concat(active,"\" title=\"").concat(dateUser," > ").concat(dateEndUser,"\" data-js=\"class: active\">\n\t\t\t\t<div class=\"sub-date-name\">").concat(App.Fields.Date.monthsTranslated[month],"\n\t\t\t\t<div class=\"js-count-events count badge  ml-1\" data-js=\"html\">0</div>\n\t\t\t\t</div></div></div>");}datesView.find(".js-sub-date-list").html(html);}/**
	 * Generate year bar list
	 */},{key:"generateYearList",value:function generateYearList(){for(var datesView=this.container.find(".js-dates-row"),activeYear=this.fullCalendar.view.currentStart.getFullYear(),prevYear=activeYear-1,html="";prevYear<=activeYear+1;){var date=prevYear+"-01-01",dateEnd=prevYear+"-12-31",active="";prevYear===activeYear&&(active="active"),html+="<div data-date=\"".concat(date,"\" data-dates=\"").concat(date,"|").concat(dateEnd,"\"\n\t\t\t\tclass=\"js-sub-record sub-record col-4 nav-item\" data-type=\"years\" data-js=\"click\">\n\t\t\t\t<div class=\"sub-record-content nav-link ").concat(active,"\" data-js=\"class: active\">\n\t\t\t\t<div class=\"sub-date-name\">").concat(prevYear,"<div class=\"js-count-events count badge  ml-1\" data-js=\"html\">0</div></div>\n\t\t\t\t</div></div>"),++prevYear;}datesView.find(".js-sub-date-list").html(html);}/**
	 * Counting the number of events in the bar for the current view
	 */},{key:"updateCountTaskCalendar",value:function updateCountTaskCalendar(){var datesView=this.container.find(".js-dates-row"),subDatesElements=datesView.find(".js-sub-record"),options=this.getDefaultParams(),dateArray={};delete options.start,delete options.end,subDatesElements.each(function(key){dateArray[key]=$(this).data("dates").split("|");}),options.mode="getCountEventsGroup",options.dates=dateArray,AppConnector.request(options).done(function(events){subDatesElements.each(function(key){$(this).find(".js-count-events").removeClass("hide").html(events.result[key]);});});}/**
	 * Registration of the date change in the counting the number of events bar
	 */},{key:"registerDatesChange",value:function registerDatesChange(){var _this4=this;this.container.find(".js-dates-row .js-sub-record").on("click",function(e){var currentTarget=$(e.currentTarget);currentTarget.addClass("active"),_this4.fullCalendar.gotoDate(currentTarget.data("date"));});}/**
	 * Add header buttons
	 */},{key:"addHeaderButtons",value:function addHeaderButtons(){if(!this.calendarView.find(".js-calendar__view-btn").length){var buttonsContainer=this.calendarView.prev(".js-calendar__header-buttons"),viewBtn=buttonsContainer.find(".js-calendar__view-btn").clone(),filters=buttonsContainer.find(".js-calendar__filter-container").clone(),toolbar=this.calendarView.find(".fc-toolbar-chunk");toolbar.first().addClass("fc-left"),toolbar.eq(1).addClass("fc-center"),this.calendarView.find(".fc-left .fc-button-group").prepend(viewBtn),this.calendarView.find(".fc-center").after(filters),this.registerClearFilterButton(),this.registerFilterTabChange();}}/**
	 * Register clear filter button
	 */},{key:"registerClearFilterButton",value:function registerClearFilterButton(){var _this5=this,sidebar=this.getSidebarView(),clearBtn=this.calendarView.find(".js-calendar__clear-filters");app.showPopoverElementView(clearBtn),clearBtn.on("click",function(){$(".js-calendar__extended-filter-tab a").removeClass("active"),app.moduleCacheSet("CurrentCvId",null),app.setMainParams("showType","current"),app.moduleCacheSet("defaultShowType","current"),sidebar.find("input:checkbox").prop("checked",!1),sidebar.find("option:selected").prop("selected",!1).trigger("change.select2"),sidebar.find(".js-sidebar-filter-container").each(function(_,e){var element=$(e),cacheName=element.data("cache");element.data("name")&&cacheName&&app.moduleCacheSet(cacheName,"");});var calendarSwitch=sidebar.find(".js-switch--showType [class*=\"js-switch--label\"]"),actualUserCheckbox=sidebar.find(".js-input-user-owner-id[value="+app.getMainParams("userId")+"]");calendarSwitch.last().removeClass("active"),calendarSwitch.first().addClass("active"),$("input[data-val=\"current\"]",calendarSwitch).prop("checked",!0),actualUserCheckbox.length?actualUserCheckbox.prop("checked",!0):app.setMainParams("usersId",void 0),_this5.reloadCalendarData();});}/**
	 * Register filter tab change
	 */},{key:"registerFilterTabChange",value:function registerFilterTabChange(){var _this6=this;this.calendarView.find(".js-calendar__extended-filter-tab").on("shown.bs.tab",function(){_this6.reloadCalendarData(),app.moduleCacheSet("CurrentCvId",_this6.getCurrentCvId());});}/**
	 * Function appends and shows today button's checkbox
	 * @param {jQuery} toolbar
	 */},{key:"showTodayButtonCheckbox",value:function showTodayButtonCheckbox(toolbar){var todayButton=toolbar.find(".fc-today-button"),todyButtonIcon=todayButton.attr("disabled")?"fa-calendar-check":"fa-calendar",popoverContent=todayButton.attr("title");todayButton.html("<div class=\"js-popover-tooltip\"><span class=\"far fa-lg ".concat(todyButtonIcon,"\"></span></div>")),app.showPopoverElementView(todayButton.find(".js-popover-tooltip"),{title:popoverContent});}/**
	 * Registration of the event being added to favorite users
	 */},{key:"registerPinUser",value:function registerPinUser(){var self=this;this.getSidebarView().find(".js-pin-user").on("click",function(){var element=$(this);AppConnector.request({module:self.module,action:"Calendar",mode:"pinOrUnpinUser",element_id:element.data("elementid")}).done(function(data){"unpin"===data.result?element.find(".js-pin-icon").removeClass("fas").addClass("far"):"pin"===data.result?element.find(".js-pin-icon").removeClass("far").addClass("fas"):app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"});});});}/**
	 * Register cache settings
	 */},{key:"registerCacheSettings",value:function registerCacheSettings(){}/**
	 * Register events
	 */},{key:"registerEvents",value:function registerEvents(){_get(_getPrototypeOf(Vtiger_Calendar_Js.prototype),"registerEvents",this).call(this),this.registerCacheSettings(),this.registerSwitchEvents(),this.registerPinUser(),ElementQueries.listen();}}])}(Calendar_Js);
//# sourceMappingURL=CalendarView.min.js.map
