'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _createForOfIteratorHelper(o,allowArrayLike){var it="undefined"!=typeof Symbol&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&"number"==typeof o.length){it&&(o=it);var i=0,F=function(){};return {s:F,n:function n(){return i>=o.length?{done:!0}:{done:!1,value:o[i++]}},e:function e(_e){throw _e},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var err,normalCompletion=!0,didErr=!1;return {s:function s(){it=it.call(o);},n:function n(){var step=it.next();return normalCompletion=step.done,step},e:function e(_e2){didErr=!0,err=_e2;},f:function f(){try{normalCompletion||null==it.return||it.return();}finally{if(didErr)throw err}}}}function _unsupportedIterableToArray(o,minLen){if(o){if("string"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return "Object"===n&&o.constructor&&(n=o.constructor.name),"Map"===n||"Set"===n?Array.from(o):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(o,minLen):void 0}}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}YetiForce_Widget_Js("YetiForce_Chart_Widget_Js",{},{plotContainer:null,chartInstance:null,chartData:[],filterIds:[],customOption:{},/**
		 * Get plot container
		 * @param {Boolean} useCache
		 * @returns {HTMLElement}
		 */getChartContainer:function(){var useCache=!!(0<arguments.length&&void 0!==arguments[0])&&arguments[0];return this.plotContainer&&useCache||(this.plotContainer=this.getContainer().find(".js-chart-container").get(0)),this.plotContainer},/**
		 * Get chart instance
		 * @returns
		 */getChartInstance:function(){return !this.chartInstance&&this.getChartContainer()&&(this.chartInstance=echarts.getInstanceByDom(this.getChartContainer())||echarts.init(this.getChartContainer())),this.chartInstance},/**
		 * Destroy chart instance
		 */destroyChartInstance:function destroyChartInstance(){var chart=this.chartInstance||echarts.getInstanceByDom(this.getChartContainer()||"");chart&&(chart.isDisposed()?chart.dispose():null,this.chartInstance=null,this.plotContainer=null);},/**
		 * Register rezise event
		 */registerResize:function(){var _this=this,container=this.getChartContainer();if(!container)return !1;var chart=this.getChartInstance();new ResizeObserver(function(e){_this.loadScrollbar();var boundingRect=e[0].target.getBoundingClientRect();chart.resize({width:boundingRect.width,height:boundingRect.height});}).observe(container.parentNode);},/**
		 * Placeholder for individual chart type options
		 * If you want to customize default options this is the right place - override this method in your class
		 *
		 * @returns {object} chart options
		 */getBasicOptions:function(){return {}},/**
		 * Get data from JSON encoded input value
		 *
		 * @return {object} data for chart
		 */generateData:function(){return this.getWidgetData(!0)},/**
		 * Load and display chart into the view
		 *
		 * @return {*} chartInstance
		 */loadChart:function(){if("undefined"==typeof this.getChartContainer())return !1;var data=this.generateData();data=this.mergeAll([data,this.customOption,this.getBasicOptions()]),this.destroyChartInstance(),this.loadScrollbar();// to resize
var chart=this.getChartInstance();return chart.setOption(data),chart},/**
		 * Merge data
		 * @param {Object} target
		 * @param {Object} source
		 * @param {Object} overwrite
		 * @returns {Object}
		 */merge:function(target,source,overwrite){if(!this.isObject(source)||!this.isObject(target))return overwrite?this.clone(source):target;for(var key in source)if(source.hasOwnProperty(key)&&"__proto__"!==key){var targetProp=target[key],sourceProp=source[key];this.isObject(sourceProp)&&this.isObject(targetProp)&&!this.isArray(sourceProp)&&!this.isArray(targetProp)?this.merge(targetProp,sourceProp,overwrite):overwrite||!(key in target)?target[key]=this.clone(source[key]):this.isArray(sourceProp)&&this.isArray(targetProp)&&(target[key]=this.mergeAll([targetProp,sourceProp]));}return target},mergeAll:function(targetAndSources,overwrite){for(var result=targetAndSources[0],i=1,len=targetAndSources.length;i<len;i++)result=this.merge(result,targetAndSources[i],overwrite);return result},isObject:function(value){var type=_typeof(value);return "function"===type||!!value&&"object"===type},isArray:function(value){return Array.isArray?Array.isArray(value):"[object Array]"===objToString.call(value)},clone:function(source){if(null==source||"object"!==_typeof(source))return source;var result=source,typeStr=Object.prototype.toString.call(source);if("[object Array]"===typeStr){result=[];for(var i=0,len=source.length;i<len;i++)result[i]=this.clone(source[i]);}else for(var key in result={},source)source.hasOwnProperty(key)&&"__proto__"!==key&&(result[key]=this.clone(source[key]));return result},clear:function(){this.destroyChartInstance(),this._super();},postLoadWidget:function(){this.isEmptyData()||this.loadChart(),this._super(),this.registerRecordsCount(),this.registerSectionClick();},postRefreshWidget:function(){this.isEmptyData()||this.loadChart(),this._super(),this.registerResize(),this.registerSectionClick();},getChartImage:function getChartImage(){var base64Image=this.chartInstance.getDataURL({backgroundColor:"#fff"}),image=new Image;return image.src=base64Image,image},registerHeaderButtons:function(){var _this2=this,container=this.getContainer(),header=container.find(".dashboardWidgetHeader"),downloadWidget=header.find(".downloadWidget"),printWidget=header.find(".printWidget");printWidget.on("click",function(){var imgEl=_this2.getChartImage();_this2.printImage(imgEl,header.find(".dashboardTitle").text(),600,400);}),downloadWidget.on("click",function(){var imgEl=$(_this2.getChartImage()),a=$("<a>").attr("href",imgEl.attr("src")).attr("download",header.find(".js-widget__header__title").text()+".png").appendTo(container);a[0].click(),a.remove();}),this._super();},/**
		 * Register click event for chart element
		 */registerSectionClick:function(){var _this3=this,chart=this.getChartInstance();chart&&chart.on("click",function(e){var links=_this3.getWidgetData().links||null;if(links&&_this3.isObject(links)&&0<Object.keys(links).length){var link=links[e.seriesIndex][e.dataIndex]||"";link&&(window.location.href=link);}else for(var key in e.data)"link"==key&&e.data[key]?window.location.href=e.data[key]:_this3.isObject(e.data[key])&&e.data[key].link&&(window.location.href=e.data[key].link);});},/**
		 * Get chart type
		 * We don't wan't to override loadChart method (good practice)
		 * so we can extend some chart type and change its type only to show data in different manner.
		 * Get type is used to set up Chartjs chart type.
		 *
		 * @param {object} chartData
		 * @returns {string}
		 */getType:function(){return "bar"},/**
		 * Get sub type of a chart.
		 * For example 'bar' is main type and barDivided is a subset of bar with little different options.
		 * By default we are using standard type.
		 * GetSubType is used to get properties - it does not set up Chartjs chart type per se (getType is used for this purpose)
		 *
		 * @param {object}  chartData
		 * @returns {string}
		 */getSubType:function(){return this.getType()},isMultiFilter:function isMultiFilter(){return "undefined"!=typeof this.filterIds&&1<this.filterIds.length},/**
		 * Formatowanie numeru do formatu użytkownika
		 * @param {int|float} number
		 * @returns {int|float}
		 */formatNumber:function formatNumber(number){return Number.isInteger(number)?App.Fields.Integer.formatToDisplay(number):App.Fields.Double.formatToDisplay(number)}}),YetiForce_Chart_Widget_Js("YetiForce_Bar_Widget_Js",{},{/** @inheritdoc */getBasicOptions:function(){var _this4=this;return {legend:{type:"scroll"},xAxis:{type:"category",axisLabel:{interval:0,hideOverlap:!0}},yAxis:{type:"value",axisLabel:{formatter:function formatter(value){return "number"==typeof value?_this4.formatNumber(value):value}}},grid:{left:"3%",right:"4%",bottom:"3%",top:"15%",containLabel:!0},tooltip:{valueFormatter:function valueFormatter(value){return "number"==typeof value?_this4.formatNumber(value):value},appendToBody:!0},label:{show:!0,position:"top",formatter:function formatter(data){var value;return "number"==typeof data.value?value=data.value:data.encode&&"number"==typeof data.value[data.encode.y[0]]?value=data.value[data.encode.y[0]]:"number"==typeof data.value[data.seriesName]&&(value=data.value[data.seriesName]),void 0===value?data.value:_this4.formatNumber(value)}},labelLayout:{hideOverlap:!0},series:[{type:"bar"}]}},getType:function(){return "bar"}}),YetiForce_Bar_Widget_Js("YetiForce_BarStacked_Widget_Js",{},{/** @inheritdoc */getBasicOptions:function(){var options=this._super();return options.label={show:!0,position:"inside"},options.series=[{type:"bar",stack:"total"}],options},getSubType:function getSubType(){return "barStacked"}}),YetiForce_Bar_Widget_Js("YetiForce_Horizontal_Widget_Js",{},{/** @inheritdoc */getBasicOptions:function(){var _this5=this,options=this._super();return options.xAxis.type="value",options.yAxis.type="category",options.grid.top="10%",options.label.position="inside",options.label.formatter=function(data){var value;return "number"==typeof data.value?value=data.value:data.encode&&"number"==typeof data.value[data.encode.x[0]]?value=data.value[data.encode.x[0]]:"number"==typeof data.value[data.seriesName]&&(value=data.value[data.seriesName]),void 0===value?data.value:_this5.formatNumber(value)},options},getType:function getType(){return "bar"}}),YetiForce_Horizontal_Widget_Js("YetiForce_HorizontalStacked_Widget_Js",{},{getType:function getType(){return "horizontalBar"},getSubType:function getSubType(){return "horizontalBarStacked"}}),YetiForce_Chart_Widget_Js("YetiForce_Funnel_Widget_Js",{},{/** @inheritdoc */getBasicOptions:function(){var _this6=this;return {legend:{type:"scroll"},tooltip:{trigger:"item",valueFormatter:function valueFormatter(value){return "number"==typeof value?_this6.formatNumber(value):value},appendToBody:!0},series:[{type:"funnel",left:"5%",top:30,bottom:5,width:"90%",label:{show:!0,position:"inside",formatter:function formatter(data){var value;return "number"==typeof data.value?value=data.value:data.encode&&"number"==typeof data.value[data.encode.value[0]]?value=data.value[data.encode.value[0]]:"number"==typeof data.value[data.seriesName]&&(value=data.value[data.seriesName]),data.name+(void 0===value?"":": "+_this6.formatNumber(value))}},emphasis:{label:{fontSize:17}}}]}},getType:function(){return "funnel"}}),YetiForce_Chart_Widget_Js("YetiForce_Pie_Widget_Js",{},{/** @inheritdoc */generateData:function(){var dataChart=this.getWidgetData(!0),groupKey="|x|",convert=dataChart.dataset&&dataChart.dataset.dimensions&&dataChart.dataset.source&&dataChart.dataset.source[groupKey];if(!convert)return dataChart;dataChart=_objectSpread({},this.getWidgetData());var _step,dimensions=dataChart.dataset.dimensions||[],newSeries=[],step=100/(dimensions.length-(5<dimensions.length?0:1)),keyIterator=0,dataGroups=dataChart.dataset.source[groupKey],maxLenght=dataGroups.length,_iterator=_createForOfIteratorHelper(dimensions);try{for(_iterator.s();!(_step=_iterator.n()).done;){var dim=_step.value;if(dim!==groupKey){for(var value,series={name:dim,type:"pie",label:{show:!1},radius:[step*keyIterator+"%",step*keyIterator+step-step/10+"%"],top:"20",itemStyle:{borderRadius:2,borderColor:"#fff",borderWidth:2}},newData=[],data=dataChart.dataset.source[dim],i=0;i<maxLenght;i++)value=void 0===data[i]?null:data[i],newData.push({value:value,name:dataGroups[i]});series.data=newData,newSeries.push(series),keyIterator++;}}}catch(err){_iterator.e(err);}finally{_iterator.f();}return delete dataChart.dataset,dataChart=this.mergeAll([{series:newSeries},dataChart]),dataChart},/** @inheritdoc */getBasicOptions:function(){var _this7=this;return {legend:{type:"scroll"},tooltip:{trigger:"item",valueFormatter:function valueFormatter(value){return "number"==typeof value?_this7.formatNumber(value):value},appendToBody:!0},series:[{type:"pie"}]}},getType:function(){return "pie"}}),YetiForce_Pie_Widget_Js("YetiForce_Donut_Widget_Js",{},{getBasicOptions:function(){var options=this._super();return options.series=[{type:"pie",radius:["40%","70%"]}],options}}),YetiForce_Pie_Widget_Js("YetiForce_PieDivided_Widget_Js",{},{getSubType:function getSubType(){return "pieDivided"}}),YetiForce_Chart_Widget_Js("YetiForce_Line_Widget_Js",{},{getBasicOptions:function(){var _this8=this;return {legend:{type:"scroll"},xAxis:{type:"category"},yAxis:{type:"value",axisLabel:{formatter:function formatter(value){return "number"==typeof value?_this8.formatNumber(value):value}}},grid:{left:"3%",right:"4%",bottom:"3%",top:"15%",containLabel:!0},tooltip:{valueFormatter:function valueFormatter(value){return "number"==typeof value?_this8.formatNumber(value):value}},label:{show:!0,position:"top",formatter:function formatter(data){var value;return "number"==typeof data.value?value=data.value:data.encode&&"number"==typeof data.value[data.encode.y[0]]?value=data.value[data.encode.y[0]]:"number"==typeof data.value[data.seriesName]&&(value=data.value[data.seriesName]),void 0===value?data.value:_this8.formatNumber(value)}},labelLayout:{hideOverlap:!0},series:[{type:"line"}]}},getType:function(){return "line"}}),YetiForce_Line_Widget_Js("YetiForce_LinePlain_Widget_Js",{},{/** @inheritdoc */generateData:function(){var dataChart=this.getWidgetData(!0);if(1<Object.keys(dataChart.series).length){dataChart=_objectSpread({},this.getWidgetData());var defaultSeries=this.getBasicOptions().series;for(var i in dataChart.series)dataChart.series[i]=this.mergeAll([dataChart.series[i],defaultSeries[0]]);}return dataChart},getBasicOptions:function(){var options=this._super();return options.series=[{type:"line",smooth:!0}],options},getSubType:function(){return "linePlain"}}),YetiForce_Line_Widget_Js("YetiForce_LineStacked_Widget_Js",{},{getType:function getType(){return "line"},getSubType:function getSubType(){return "lineStacked"}}),YetiForce_Donut_Widget_Js("YetiForce_Axis_Widget_Js",{},{}),YetiForce_Chart_Widget_Js("YetiForce_BarDivided_Widget_Js",{},{getType:function(){return "bar"},getSubType:function(){return "barDivided"}}),YetiForce_LineStacked_Widget_Js("YetiForce_LinePlainStacked_Widget_Js",{},{getSubType:function getSubType(){return "linePlainStacked"}}),YetiForce_Chart_Widget_Js("YetiForce_ChartFilter_Widget_Js",{},{init:function init(container){container=$(container),this.setContainer(container);var chartClassName=container.find("[name=\"typeChart\"]").val(),stacked=!!Number(container.find("[name=\"stacked\"]").val());stacked&&(chartClassName+="Stacked");var instance=YetiForce_Chart_Widget_Js.getInstance(container,chartClassName);if(instance){var filterIdsStr=instance.getContainer().find("[name=\"filterIds\"]").val();filterIdsStr&&(instance.filterIds=JSON.parse(filterIdsStr));}this.registerCache(container);}});
//# sourceMappingURL=Chart.min.js.map
