'use strict';

function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}(function($){var csscls=PhpDebugBar.utils.makecsscls("phpdebugbar-widgets-"),htmlize=PhpDebugBar.Widgets.htmlize=function(text){return text.replace(/\n/g,"<br>").replace(/\s/g,"&nbsp;")},renderValue=PhpDebugBar.Widgets.renderValue=function(value,prettify){return "string"==typeof value?value:prettify?htmlize(JSON.stringify(value,void 0,2)):JSON.stringify(value)},highlight=PhpDebugBar.Widgets.highlight=function(code,lang){return "string"==typeof code?"undefined"==typeof hljs?htmlize(code):lang?hljs.highlight(lang,code).value:hljs.highlightAuto(code).value:("object"===("undefined"==typeof hljs?"undefined":_typeof(hljs))&&code.each(function(i,e){hljs.highlightBlock(e);}),code)},createCodeBlock=PhpDebugBar.Widgets.createCodeBlock=function(code,lang,firstLineNumber,highlightedLine){var pre=$("<pre />").addClass(csscls("code-block")),codeElement=$("<code />").text(code+"\n").appendTo(pre);// Add a newline to prevent <code> element from vertically collapsing too far if the last
// code line was empty: that creates problems with the horizontal scrollbar being
// incorrectly positioned - most noticeable when line numbers are shown.
// Add a span with a special class if we are supposed to highlight a line.  highlight.js will
// still correctly format code even with existing markup in it.
// Show line numbers in a list
if($.isNumeric(highlightedLine)&&($.isNumeric(firstLineNumber)&&(highlightedLine=highlightedLine-firstLineNumber+1),codeElement.html(function(index,html){var currentLine=1;return html.replace(/^.*$/gm,function(line){return currentLine++==highlightedLine?"<span class=\""+csscls("highlighted-line")+"\">"+line+"</span>":line})})),lang&&pre.addClass("language-"+lang),highlight(pre),$.isNumeric(firstLineNumber)){var lineCount=code.split("\n").length,$lineNumbers=$("<ul />").prependTo(pre);pre.children().addClass(csscls("numbered-code"));for(var i=firstLineNumber;i<firstLineNumber+lineCount;i++)$("<li />").text(i).appendTo($lineNumbers);}return pre},ListWidget=PhpDebugBar.Widgets.ListWidget=PhpDebugBar.Widget.extend({tagName:"ul",className:csscls("list"),initialize:function initialize(options){options.itemRenderer||(options.itemRenderer=this.itemRenderer),this.set(options);},render:function render(){this.bindAttr(["itemRenderer","data"],function(){if(this.$el.empty(),!!this.has("data"))for(var li,data=this.get("data"),i=0;i<data.length;i++)li=$("<li />").addClass(csscls("list-item")).appendTo(this.$el),this.get("itemRenderer")(li,data[i]);});},/**
		 * Renders the content of a <li> element
		 *
		 * @param {jQuery} li The <li> element as a jQuery Object
		 * @param {Object} value An item from the data array
		 */itemRenderer:function itemRenderer(li,value){li.html(renderValue(value));}}),KVListWidget=PhpDebugBar.Widgets.KVListWidget=ListWidget.extend({tagName:"dl",className:csscls("kvlist"),render:function render(){this.bindAttr(["itemRenderer","data"],function(){if(this.$el.empty(),!!this.has("data")){var self=this;$.each(this.get("data"),function(key,value){var dt=$("<dt />").addClass(csscls("key")).appendTo(self.$el),dd=$("<dd />").addClass(csscls("value")).appendTo(self.$el);self.get("itemRenderer")(dt,dd,key,value);});}});},/**
		 * Renders the content of the <dt> and <dd> elements
		 *
		 * @param {jQuery} dt The <dt> element as a jQuery Object
		 * @param {jQuery} dd The <dd> element as a jQuery Object
		 * @param {String} key Property name
		 * @param {Object} value Property value
		 */itemRenderer:function itemRenderer(dt,dd,key,value){dt.text(key),dd.html(htmlize(value));}}),VariableListWidget=PhpDebugBar.Widgets.VariableListWidget=KVListWidget.extend({className:csscls("kvlist varlist"),itemRenderer:function itemRenderer(dt,dd,key,value){$("<span />").attr("title",key).text(key).appendTo(dt);var v=value;v&&100<v.length&&(v=v.substr(0,100)+"...");var prettyVal=null;dd.text(v).click(function(){dd.hasClass(csscls("pretty"))?dd.text(v).removeClass(csscls("pretty")):(prettyVal=prettyVal||createCodeBlock(value),dd.addClass(csscls("pretty")).empty().append(prettyVal));});}}),HtmlVariableListWidget=PhpDebugBar.Widgets.HtmlVariableListWidget=KVListWidget.extend({className:csscls("kvlist htmlvarlist"),itemRenderer:function itemRenderer(dt,dd,key,value){$("<span />").attr("title",key).text(key).appendTo(dt),dd.html(value);}}),IFrameWidget=PhpDebugBar.Widgets.IFrameWidget=PhpDebugBar.Widget.extend({tagName:"iframe",className:csscls("iframe"),render:function render(){this.$el.attr({seamless:"seamless",border:"0",width:"100%",height:"100%"}),this.bindAttr("data",function(url){this.$el.attr("src",url);});}}),MessagesWidget=PhpDebugBar.Widgets.MessagesWidget=PhpDebugBar.Widget.extend({className:csscls("messages"),render:function render(){var self=this;this.$list=new ListWidget({itemRenderer:function itemRenderer(li,value){if(value.message_html)var val=$("<span />").addClass(csscls("value")).html(value.message_html).appendTo(li);else {var m=value.message;100<m.length&&(m=m.substr(0,100)+"...");var val=$("<span />").addClass(csscls("value")).text(m).appendTo(li);if(!value.is_string||100<value.message.length){var prettyVal=value.message;value.is_string||(prettyVal=null),li.css("cursor","pointer").click(function(){val.hasClass(csscls("pretty"))?val.text(m).removeClass(csscls("pretty")):(prettyVal=prettyVal||createCodeBlock(value.message,"php"),val.addClass(csscls("pretty")).empty().append(prettyVal));});}}value.collector&&$("<span />").addClass(csscls("collector")).text(value.collector).prependTo(li),value.label&&(val.addClass(csscls(value.label)),$("<span />").addClass(csscls("label")).text(value.label).prependTo(li));}}),this.$list.$el.appendTo(this.$el),this.$toolbar=$("<div><i class=\"phpdebugbar-fa phpdebugbar-fa-search\"></i></div>").addClass(csscls("toolbar")).appendTo(this.$el),$("<input type=\"text\" />").on("change",function(){self.set("search",this.value);}).appendTo(this.$toolbar),this.bindAttr("data",function(data){this.set({exclude:[],search:""}),this.$toolbar.find(csscls(".filter")).remove();for(var filters=[],self=this,i=0;i<data.length;i++)data[i].label&&!(-1<$.inArray(data[i].label,filters))&&(filters.push(data[i].label),$("<a />").addClass(csscls("filter")).text(data[i].label).attr("rel",data[i].label).on("click",function(){self.onFilterClick(this);}).appendTo(this.$toolbar));}),this.bindAttr(["exclude","search"],function(){var data=this.get("data"),exclude=this.get("exclude"),search=this.get("search"),caseless=!1,fdata=[];search&&search===search.toLowerCase()&&(caseless=!0);for(var message,i=0;i<data.length;i++)message=caseless?data[i].message.toLowerCase():data[i].message,data[i].label&&-1!==$.inArray(data[i].label,exclude)||search&&!(-1<message.indexOf(search))||fdata.push(data[i]);this.$list.set("data",fdata);});},onFilterClick:function onFilterClick(el){$(el).toggleClass(csscls("excluded"));var excludedLabels=[];this.$toolbar.find(csscls(".filter")+csscls(".excluded")).each(function(){excludedLabels.push(this.rel);}),this.set("exclude",excludedLabels);}}),TimelineWidget=PhpDebugBar.Widgets.TimelineWidget=PhpDebugBar.Widget.extend({tagName:"ul",className:csscls("timeline"),render:function render(){this.bindAttr("data",function(data){// ported from php DataFormatter
var formatDuration=function(seconds){return .001>seconds?(1e6*seconds).toFixed()+"\u03BCs":1>seconds?(1e3*seconds).toFixed(2)+"ms":seconds.toFixed(2)+"s"};if(this.$el.empty(),data.measures){for(var measure,aggregate={},i=0;i<data.measures.length;i++){measure=data.measures[i],aggregate[measure.label]||(aggregate[measure.label]={count:0,duration:0}),aggregate[measure.label].count+=1,aggregate[measure.label].duration+=measure.duration;var m=$("<div />").addClass(csscls("measure")),li=$("<li />"),left=(100*measure.relative_start/data.duration).toFixed(2),width=Math.min((100*measure.duration/data.duration).toFixed(2),100-left);if(m.append($("<span />").addClass(csscls("value")).css({left:left+"%",width:width+"%"})),m.append($("<span />").addClass(csscls("label")).text(measure.label+" ("+measure.duration_str+")")),measure.collector&&$("<span />").addClass(csscls("collector")).text(measure.collector).appendTo(m),m.appendTo(li),this.$el.append(li),measure.params&&!$.isEmptyObject(measure.params)){var table=$("<table><tr><th colspan=\"2\">Params</th></tr></table>").addClass(csscls("params")).appendTo(li);for(var key in measure.params)"function"!=typeof measure.params[key]&&table.append("<tr><td class=\""+csscls("name")+"\">"+key+"</td><td class=\""+csscls("value")+"\"><pre><code>"+measure.params[key]+"</code></pre></td></tr>");li.css("cursor","pointer").click(function(){var table=$(this).find("table");table.is(":visible")?table.hide():table.show();});}}// convert to array and sort by duration
aggregate=$.map(aggregate,function(data,label){return {label:label,data:data}}).sort(function(a,b){return b.data.duration-a.data.duration});// build table and add
var aggregateTable=$("<table style=\"display: table; border: 0; width: 99%\"></table>").addClass(csscls("params"));$.each(aggregate,function(i,aggregate){width=Math.min((100*aggregate.data.duration/data.duration).toFixed(2),100),aggregateTable.append("<tr><td class=\""+csscls("name")+"\">"+aggregate.data.count+" x "+aggregate.label+" ("+width+"%)</td><td class=\""+csscls("value")+"\"><div class=\""+csscls("measure")+"\"><span class=\""+csscls("value")+"\" style=\"width:"+width+"%\"></span><span class=\""+csscls("label")+"\">"+formatDuration(aggregate.data.duration)+"</span></div></td></tr>");}),this.$el.append("<li/>").find("li:last").append(aggregateTable);}});}}),ExceptionsWidget=PhpDebugBar.Widgets.ExceptionsWidget=PhpDebugBar.Widget.extend({className:csscls("exceptions"),render:function render(){this.$list=new ListWidget({itemRenderer:function itemRenderer(li,e){if($("<span />").addClass(csscls("message")).text(e.message).appendTo(li),e.file){var header=$("<span />").addClass(csscls("filename")).text(e.file+"#"+e.line);e.xdebug_link&&(e.xdebug_link.ajax?$("<a title=\""+e.xdebug_link.url+"\"></a>").on("click",function(){$.ajax(e.xdebug_link.url);}).addClass(csscls("editor-link")).appendTo(header):$("<a href=\""+e.xdebug_link.url+"\"></a>").addClass(csscls("editor-link")).appendTo(header)),header.appendTo(li);}if(e.type&&$("<span />").addClass(csscls("type")).text(e.type).appendTo(li),e.surrounding_lines){var pre=createCodeBlock(e.surrounding_lines.join(""),"php").addClass(csscls("file")).appendTo(li);li.click(function(){pre.is(":visible")?pre.hide():pre.show();});}e.stack_trace&&e.stack_trace.split("\n").forEach(function(trace){var $traceLine=$("<div />");$("<span />").addClass(csscls("filename")).text(trace).appendTo($traceLine),$traceLine.appendTo(li);});}}),this.$list.$el.appendTo(this.$el),this.bindAttr("data",function(data){this.$list.set("data",data),1==data.length&&this.$list.$el.children().first().find(csscls(".file")).show();});}}),DebugLogsWidget=PhpDebugBar.Widgets.DebugLogsWidget=PhpDebugBar.Widget.extend({className:csscls("messages"),render:function render(){var self=this;this.$list=new ListWidget({itemRenderer:function itemRenderer(li,value){var m=value.message,val=$("<span />").addClass(csscls("value")).text(m).appendTo(li),prettyVal=value.message;value.is_string||(prettyVal=null),li.css("cursor","pointer").click(function(){val.hasClass(csscls("pretty"))?val.text(m).removeClass(csscls("pretty")):(prettyVal=prettyVal||createCodeBlock(value.trace,"php"),val.addClass(csscls("pretty")).append(prettyVal));}),value.label&&(val.addClass(csscls(value.label)),$("<span />").addClass(csscls("label")).text(value.label).appendTo(li)),value.collector&&$("<span />").addClass(csscls("collector")).text(value.collector).appendTo(li);}}),this.$list.$el.appendTo(this.$el),this.$toolbar=$("<div><i class=\"phpdebugbar-fa phpdebugbar-fa-search\"></i></div>").addClass(csscls("toolbar")).appendTo(this.$el),$("<input type=\"text\" />").on("change",function(){self.set("search",this.value);}).css("border","solid 1px #000").appendTo(this.$toolbar),this.bindAttr("data",function(data){this.set({exclude:[],search:""}),this.$toolbar.find(csscls(".filter")).remove();for(var filters=[],self=this,i=0;i<data.length;i++)data[i].label&&!(-1<$.inArray(data[i].label,filters))&&(filters.push(data[i].label),$("<a />").addClass(csscls("filter")).text(data[i].label).attr("rel",data[i].label).on("click",function(){self.onFilterClick(this);}).appendTo(this.$toolbar));}),this.bindAttr(["exclude","search"],function(){var data=this.get("data"),exclude=this.get("exclude"),search=this.get("search"),caseless=!1,fdata=[];search&&search===search.toLowerCase()&&(caseless=!0);for(var message,i=0;i<data.length;i++)message=caseless?data[i].message.toLowerCase():data[i].message,data[i].label&&-1!==$.inArray(data[i].label,exclude)||search&&!(-1<message.indexOf(search))||fdata.push(data[i]);this.$list.set("data",fdata);});},onFilterClick:function onFilterClick(el){$(el).toggleClass(csscls("excluded"));var excludedLabels=[];this.$toolbar.find(csscls(".filter")+csscls(".excluded")).each(function(){excludedLabels.push(this.rel);}),this.set("exclude",excludedLabels);}});/**
	 * Replaces spaces with &nbsp; and line breaks with <br>
	 *
	 * @param {String} text
	 * @return {String}
	 */ /**
	 * Returns a string representation of value, using JSON.stringify
	 * if it's an object.
	 *
	 * @param {Object} value
	 * @param {Boolean} prettify Uses htmlize() if true
	 * @return {String}
	 */ /**
	 * Highlights a block of code
	 *
	 * @param  {String} code
	 * @param  {String} lang
	 * @return {String}
	 */ /**
	 * Creates a <pre> element with a block of code
	 *
	 * @param  {String} code
	 * @param  {String} lang
	 * @param  {Number} [firstLineNumber] If provided, shows line numbers beginning with the given value.
	 * @param  {Number} [highlightedLine] If provided, the given line number will be highlighted.
	 * @return {String}
	 */ // ------------------------------------------------------------------
// Generic widgets
// ------------------------------------------------------------------
/**
	 * Displays array element in a <ul> list
	 *
	 * Options:
	 *  - data
	 *  - itemRenderer: a function used to render list items (optional)
	 */ // ------------------------------------------------------------------
/**
	 * Displays object property/value paris in a <dl> list
	 *
	 * Options:
	 *  - data
	 *  - itemRenderer: a function used to render list items (optional)
	 */ // ------------------------------------------------------------------
/**
	 * An extension of KVListWidget where the data represents a list
	 * of variables
	 *
	 * Options:
	 *  - data
	 */ // ------------------------------------------------------------------
/**
	 * An extension of KVListWidget where the data represents a list
	 * of variables whose contents are HTML; this is useful for showing
	 * variable output from VarDumper's HtmlDumper.
	 *
	 * Options:
	 *  - data
	 */ // ------------------------------------------------------------------
/**
	 * Iframe widget
	 *
	 * Options:
	 *  - data
	 */ // ------------------------------------------------------------------
// Collector specific widgets
// ------------------------------------------------------------------
/**
	 * Widget for the MessagesCollector
	 *
	 * Uses ListWidget under the hood
	 *
	 * Options:
	 *  - data
	 */ // ------------------------------------------------------------------
/**
	 * Widget for the TimeDataCollector
	 *
	 * Options:
	 *  - data
	 */ // ------------------------------------------------------------------
/**
	 * Widget for the displaying exceptions
	 *
	 * Options:
	 *  - data
	 */})(PhpDebugBar.$);
//# sourceMappingURL=logs.min.js.map
