'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

/*
 * Inline Form Validation Engine 3.1.1 v3, jQuery plugin
 *
 * Copyright(c) 2010, Cedric Dugas
 * http://www.position-absolute.com
 *
 * 2.0 Rewrite by Olivier Refalo
 * http://www.crionics.com
 *
 * Form validation engine allowing custom regex rules to be added.
 * Licensed under the MIT License
 */(function($){var methods={/**
     * Kind of the constructor, called before any action
     * @param options
     */init:function init(options){var form=this;return form.data('jqv')&&null!=form.data('jqv')||(options=methods._saveOptions(form,options),$(document).on('click','.formError',function(){$(this).fadeOut(150,function(){$(this).closest('.formError').remove();});})),this},/**
     * Attachs jQuery.validationEngine to form.submit and field.blur events
     * Takes an optional params: a list of options
     * ie. jQuery("#formID1").validationEngine('attach', {promptPosition : "centerRight"});
     */attach:function attach(userOptions){var options,form=this;return options=userOptions?methods._saveOptions(form,userOptions):form.data('jqv'),options.validateAttribute=form.find('[data-validation-engine*=validate]').length?'data-validation-engine':'class',options.binded&&(form.on(options.validationEventTrigger,'['+options.validateAttribute+'*=validate]:not([type=checkbox]):not([type=radio]):not(.datepicker)',methods._onFieldEvent),form.on('click','['+options.validateAttribute+'*=validate][type=checkbox],['+options.validateAttribute+'*=validate][type=radio]',methods._onFieldEvent),form.on(options.validationEventTrigger,'['+options.validateAttribute+'*=validate][class*=datepicker]',{delay:300},methods._onFieldEvent)),options.autoPositionUpdate&&$(window).bind('resize',{noAnimation:!0,formElem:form},methods.updatePromptsPosition),form.on('click','a[data-validation-engine-skip], a[class*=\'validate-skip\'], button[data-validation-engine-skip], button[class*=\'validate-skip\'], input[data-validation-engine-skip], input[class*=\'validate-skip\']',methods._submitButtonClick),form.removeData('jqv_submitButton'),form.on('submit',methods._onSubmitEvent),this},/**
     * Unregisters any bindings that may point to jQuery.validaitonEngine
     */detach:function detach(){var form=this,options=form.data('jqv');// unbind fields
return form.off(options.validationEventTrigger,'['+options.validateAttribute+'*=validate]:not([type=checkbox]):not([type=radio]):not(.datepicker)',methods._onFieldEvent),form.off('click','['+options.validateAttribute+'*=validate][type=checkbox],['+options.validateAttribute+'*=validate][type=radio]',methods._onFieldEvent),form.off(options.validationEventTrigger,'['+options.validateAttribute+'*=validate][class*=datepicker]',methods._onFieldEvent),form.off('submit',methods._onSubmitEvent),form.removeData('jqv'),form.off('click','a[data-validation-engine-skip], a[class*=\'validate-skip\'], button[data-validation-engine-skip], button[class*=\'validate-skip\'], input[data-validation-engine-skip], input[class*=\'validate-skip\']',methods._submitButtonClick),form.removeData('jqv_submitButton'),options.autoPositionUpdate&&$(window).off('resize',methods.updatePromptsPosition),this},/**
     * Validates either a form or a list of fields, shows prompts accordingly.
     * Note: There is no ajax form validation with this method, only field ajax validation are evaluated
     *
     * @return true if the form validates, false if it fails
     */validate:function validate(userOptions){var options,element=$(this),valid=null;if(element.is('form')||element.hasClass('validationEngineContainer')){if(element.hasClass('validating'))// form is already validating.
// Should abort old validation and start new one. I don't know how to implement it.
return !1;element.addClass('validating'),options=userOptions?methods._saveOptions(element,userOptions):element.data('jqv');var valid=methods._validateFields(this);// If the form doesn't validate, clear the 'validating' class before the user has a chance to submit again
setTimeout(function(){element.removeClass('validating');},100),valid&&options.onSuccess?options.onSuccess():!valid&&options.onFailure&&options.onFailure();}else if(element.is('form')||element.hasClass('validationEngineContainer'))element.removeClass('validating');else {// field validation
var form=element.closest('form, .validationEngineContainer');options=form.data('jqv')?form.data('jqv'):$.validationEngine.defaults,valid=methods._validateField(element,options),valid&&options.onFieldSuccess?options.onFieldSuccess():options.onFieldFailure&&0<options.InvalidFields.length&&options.onFieldFailure();}return options.onValidationComplete?!!options.onValidationComplete(form,valid):valid},/**
     *  Redraw prompts position, useful when you change the DOM state when validating
     */updatePromptsPosition:function updatePromptsPosition(event){if(event&&this==window)var form=event.data.formElem,noAnimation=event.data.noAnimation;else var form=$(this.closest('form, .validationEngineContainer'));var options=form.data('jqv');// No option, take default one
return options||(options=methods._saveOptions(form,options)),form.find('['+options.validateAttribute+'*=validate]').not(':disabled').each(function(){var field=$(this);options.prettySelect&&field.is(':hidden')&&(field=form.find('#'+options.usePrefix+field.attr('id')+options.useSuffix));var prompt=methods._getPrompt(field),promptText=$(prompt).find('.formErrorContent').html();prompt&&methods._updatePrompt(field,$(prompt),promptText,void 0,!1,options,noAnimation);}),this},/**
     * Displays a prompt on a element.
     * Note that the element needs an id!
     *
     * @param {String} promptText html text to display type
     * @param {String} type the type of bubble: 'pass' (green), 'load' (black) anything else (red)
     * @param {String} possible values topLeft, topRight, bottomLeft, centerRight, bottomRight
     */showPrompt:function showPrompt(promptText,type,promptPosition,showArrow){var form=this.closest('form, .validationEngineContainer'),options=form.data('jqv');// No option, take default one
return options||(options=methods._saveOptions(this,options)),promptPosition&&(options.promptPosition=promptPosition),options.showArrow=!0==showArrow,methods._showPrompt(this,promptText,type,!1,options),this},/**
     * Closes form error prompts, CAN be invidual
     * Fixed issue (hide) hiding all error prompts?!
     * (https://github.com/posabsolute/jQuery-Validation-Engine/issues/966)
     */hide:function hide(){var form=$(this).closest('form, .validationEngineContainer'),field=$(this).attr('id'),options=form.data('jqv');options||(options=methods._saveOptions(form,options));var closingtag,fadeDuration=options&&options.fadeDuration?options.fadeDuration:.3;return closingtag=form.is('form')||form.hasClass('validationEngineContainer')?methods._getClassName(field)+'formError':'parentForm'+methods._getClassName(field),$('.'+closingtag).fadeTo(fadeDuration,0,function(){$('.'+closingtag).remove();}),this},/**
     * Closes all error prompts on the page
     */hideAll:function hideAll(){var form=this,options=form.data('jqv'),duration=options?options.fadeDuration:300;return $('.formError').fadeTo(duration,0,function(){$(this).closest('.formError').remove();}),this},/**
     * Typically called when user exists a field using tab or a mouse click, triggers a field
     * validation
     */_onFieldEvent:function _onFieldEvent(event){var field=$(this),form=field.closest('form, .validationEngineContainer'),options=form.data('jqv');// No option, take default one
options||(options=methods._saveOptions(form,options)),options.eventTrigger='field',!0==options.notEmpty?0<field.val().length&&window.setTimeout(function(){methods._validateField(field,options);},event.data?event.data.delay:0):window.setTimeout(function(){methods._validateField(field,options);},event.data?event.data.delay:0);},/**
     * Called when the form is submited, shows prompts accordingly
     *
     * @param {jqObject}
     *            form
     * @return false if form submission needs to be cancelled
     */_onSubmitEvent:function _onSubmitEvent(){var form=$(this),options=form.data('jqv');//check if it is trigger from skipped button
if(form.data('jqv_submitButton')){var submitButton=$('#'+form.data('jqv_submitButton'));if(submitButton&&0<submitButton.length&&(submitButton.hasClass('validate-skip')||'true'==submitButton.attr('data-validation-engine-skip')))return !0}options.eventTrigger='submit';// validate each field
// (- skip field ajax validation, not necessary IF we will perform an ajax form validation)
var r=methods._validateFields(form);return r&&options.ajaxFormValidation?(methods._validateFormWithAjax(form,options),!1):options.onValidationComplete?!!options.onValidationComplete(form,r):r},/**
     * Return true if the ajax field validations passed so far
     * @param {Object} options
     * @return true, is all ajax validation passed so far (remember ajax is async)
     */_checkAjaxStatus:function _checkAjaxStatus(options){var status=!0;return $.each(options.ajaxValidCache,function(key,value){if(!value)// break the each
return status=!1,!1}),status},/**
     * Return true if the ajax field is validated
     * @param {String} fieldid
     * @param {Object} options
     * @return true, if validation passed, false if false or doesn't exist
     */_checkAjaxFieldStatus:function _checkAjaxFieldStatus(fieldid,options){return !0==options.ajaxValidCache[fieldid]},/**
     * Validates form fields, shows prompts accordingly
     *
     * @param {jqObject}
     *            form
     * @param {skipAjaxFieldValidation}
     *            boolean - when set to true, ajax field validation is skipped, typically used when the submit button is clicked
     *
     * @return true if form is valid, false if not, undefined if ajax form validation is done
     */_validateFields:function _validateFields(form){var options=form.data('jqv');options.InvalidFields=[];// this variable is set to true if an error is found
var errorFound=!1;// Trigger hook, start validation
form.trigger('jqv.form.validating');// first, evaluate status of non ajax fields
var first_err=null;if(form.find('['+options.validateAttribute+'*=validate]').not(':disabled').each(function(){var field=$(this),names=[];if(0>$.inArray(field.attr('name'),names)){if(errorFound|=methods._validateField(field,options),errorFound&&null==first_err&&(field.is(':hidden')&&options.prettySelect?first_err=field=form.find('#'+options.usePrefix+methods._jqSelector(field.attr('id'))+options.useSuffix):(field.data('jqv-prompt-at')instanceof jQuery?field=field.data('jqv-prompt-at'):field.data('jqv-prompt-at')&&(field=$(field.data('jqv-prompt-at'))),first_err=field)),options.doNotShowAllErrosOnSubmit)return !1;//if option set, stop checking validation rules after one error is found
if(names.push(field.attr('name')),!0==options.showOneMessage&&errorFound)return !1}}),form.trigger('jqv.form.result',[errorFound]),errorFound){if(options.scroll){var destination=first_err.offset().top,fixleft=first_err.offset().left,positionType=options.promptPosition;//prompt positioning adjustment support. Usage: positionType:Xshift,Yshift (for ex.: bottomLeft:+20 or bottomLeft:-20,+10)
if('string'==typeof positionType&&-1!=positionType.indexOf(':')&&(positionType=positionType.substring(0,positionType.indexOf(':'))),'bottomRight'!=positionType&&'bottomLeft'!=positionType){var prompt_err=methods._getPrompt(first_err);prompt_err&&(destination=prompt_err.offset().top);}// Offset the amount the page scrolls by an amount in px to accomodate fixed elements at top of page
// get the position of the first error, there should be at least one, no need to check this
//var destination = form.find(".formError:not('.greenPopup'):first").offset().top;
if(options.scrollOffset&&(destination-=options.scrollOffset),options.isOverflown){var overflowDIV=$(options.overflownDIV);if(!overflowDIV.length)return !1;var scrollContainerScroll=overflowDIV.scrollTop(),scrollContainerPos=-parseInt(overflowDIV.offset().top);destination+=scrollContainerScroll+scrollContainerPos-5;var scrollContainer=$(options.overflownDIV).filter(':not(:animated)');scrollContainer.animate({scrollTop:destination},1100,function(){options.focusFirstField&&first_err.focus();});}else $('html, body').animate({scrollTop:destination},1100,function(){options.focusFirstField&&first_err.focus();}),$('html, body').animate({scrollLeft:fixleft},1100);}else options.focusFirstField&&first_err.focus();return !1}return !0},/**
     * This method is called to perform an ajax form validation.
     * During this process all the (field, value) pairs are sent to the server which returns a list of invalid fields or true
     *
     * @param {jqObject} form
     * @param {Map} options
     */_validateFormWithAjax:function _validateFormWithAjax(form,options){var data=form.serialize(),type=options.ajaxFormValidationMethod?options.ajaxFormValidationMethod:'GET',url=options.ajaxFormValidationURL?options.ajaxFormValidationURL:form.attr('action'),dataType=options.dataType?options.dataType:'json';$.ajax({type:type,url:url,cache:!1,dataType:dataType,data:data,form:form,methods:methods,options:options,beforeSend:function beforeSend(){return options.onBeforeAjaxFormValidation(form,options)},error:function error(data,transport){options.onFailure?options.onFailure(data,transport):methods._ajaxError(data,transport);},success:function success(json){if('json'==dataType&&!0!==json){for(var errorInForm=!1,i=0;i<json.length;i++){var value=json[i],errorFieldId=value[0],errorField=$($('#'+errorFieldId)[0]);// make sure we found the element
if(1==errorField.length){// promptText or selector
var msg=value[2];// if the field is valid
if(!0!=value[1]){if(errorInForm|=!0,options.allrules[msg]){var txt=options.allrules[msg].alertText;txt&&(msg=txt);}options.showPrompts&&methods._showPrompt(errorField,msg,'',!1,options,!0);}else if(''==msg||!msg)// if for some reason, status==true and error="", just close the prompt
methods._closePrompt(errorField);else {// the field is valid, but we are displaying a green prompt
if(options.allrules[msg]){var txt=options.allrules[msg].alertTextOk;txt&&(msg=txt);}options.showPrompts&&methods._showPrompt(errorField,msg,'pass',!1,options,!0);}}}// getting to this case doesn't necessary means that the form is invalid
// the server may return green or closing prompt actions
// this flag helps figuring it out
options.onAjaxFormComplete(!errorInForm,form,json,options);}else options.onAjaxFormComplete(!0,form,json,options);}});},/**
     * Validates field, shows prompts accordingly
     *
     * @param {jqObject}
     *            field
     * @param {Array[String]}
     *            field's validation rules
     * @param {Map}
     *            user options
     * @return false if field is valid (It is inversed for *fields*, it return false on validate and true on errors.)
     */_validateField:function _validateField(field,options,skipAjaxValidation){if(field.attr('id')||(field.attr('id','form-validation-field-'+$.validationEngine.fieldIdCounter),++$.validationEngine.fieldIdCounter),!options.validateNonVisibleFields&&(field.is(':hidden')&&!options.prettySelect||field.parent().is(':hidden'))||0<field.closest('.noValidate').length)return !1;if(field.hasClass(options.ignoreFieldsWithClass))return !1;if(!options.validateNonVisibleFields&&(field.is(':hidden')&&!options.prettySelect||field.parent().is(':hidden')))return !1;var rulesParsing=field.attr(options.validateAttribute),getRules=/validate\[(.*)\]/.exec(rulesParsing);if(!getRules)return !1;var str=getRules[1],rules=str.split(/\[|,|\]/),fieldName=field.attr('name'),promptText='',promptType='',required=!1,limitErrors=!1;// true if we ran the ajax validation, tells the logic to stop messing with prompts
options.isError=!1,options.showArrow=!0==options.showArrow,0<options.maxErrorsPerField&&(limitErrors=!0);// Fix for adding spaces in the rules
for(var form=$(field.closest('form, .validationEngineContainer')),i=0;i<rules.length;i++)rules[i]=rules[i].toString().replace(' ',''),''===rules[i]&&delete rules[i];for(var i=0,field_errors=0;i<rules.length;i++){// If we are limiting errors, and have hit the max, break
if(limitErrors&&field_errors>=options.maxErrorsPerField){// If we haven't hit a required yet, check to see if there is one in the validation rules for this
// field and that it's index is greater or equal to our current index
if(!required){var have_required=$.inArray('required',rules);required=-1!=have_required&&have_required>=i;}break}var errorMsg=void 0;switch(rules[i]){case'required':required=!0,errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._required);break;case'custom':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._custom);break;case'groupRequired':// Check is its the first of group, if not, reload validation with first field
// AND continue normal validation on present field
var classGroup='['+options.validateAttribute+'*='+rules[i+1]+']',firstOfGroup=form.find(classGroup).eq(0);firstOfGroup[0]!=field[0]&&(methods._validateField(firstOfGroup,options,skipAjaxValidation),options.showArrow=!0),errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._groupRequired),errorMsg&&(required=!0),options.showArrow=!1;break;case'ajax':errorMsg=methods._ajax(field,rules,i,options),errorMsg&&(promptType='load');break;case'minSize':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._minSize);break;case'maxSize':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._maxSize);break;case'min':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._min);break;case'max':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._max);break;case'past':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._past);break;case'future':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._future);break;case'dateRange':var classGroup='['+options.validateAttribute+'*='+rules[i+1]+']';options.firstOfGroup=form.find(classGroup).eq(0),options.secondOfGroup=form.find(classGroup).eq(1),(options.firstOfGroup[0].value||options.secondOfGroup[0].value)&&(errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._dateRange)),errorMsg&&(required=!0),options.showArrow=!1;break;case'dateTimeRange':var classGroup='['+options.validateAttribute+'*='+rules[i+1]+']';options.firstOfGroup=form.find(classGroup).eq(0),options.secondOfGroup=form.find(classGroup).eq(1),(options.firstOfGroup[0].value||options.secondOfGroup[0].value)&&(errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._dateTimeRange)),errorMsg&&(required=!0),options.showArrow=!1;break;case'maxCheckbox':field=$(form.find('input[name=\''+fieldName+'\']')),errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._maxCheckbox);break;case'minCheckbox':field=$(form.find('input[name=\''+fieldName+'\']')),errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._minCheckbox);break;case'equals':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._equals);break;case'funcCall':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._funcCall);break;case'creditCard':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._creditCard);break;case'condRequired':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._condRequired),void 0!==errorMsg&&(required=!0);break;case'funcCallRequired':errorMsg=methods._getErrorMessage(form,field,rules[i],rules,i,options,methods._funcCallRequired),void 0!==errorMsg&&(required=!0);break;}var end_validation=!1;// If we were passed back an message object, check what the status was to determine what to do
if('object'==('undefined'==typeof errorMsg?'undefined':_typeof(errorMsg)))switch(errorMsg.status){case'_break':end_validation=!0;break;// If we have an error message, set errorMsg to the error message
case'_error':errorMsg=errorMsg.message;break;// If we want to throw an error, but not show a prompt, return early with true
case'_error_no_prompt':return !0;}//funcCallRequired, first in rules, and has error, skip anything else
// If it has been specified that validation should end now, break
if(0==i&&0==str.indexOf('funcCallRequired')&&void 0!==errorMsg&&(''!=promptText&&(promptText+='<br/>'),promptText+=errorMsg,options.isError=!0,field_errors++,end_validation=!0),end_validation)break;// If we have a string, that means that we have an error, so add it to the error message.
'string'==typeof errorMsg&&(''!=promptText&&(promptText+='<br/>'),promptText+=errorMsg,options.isError=!0,field_errors++);}// If the rules required is not added, an empty field is not validated
//the 3rd condition is added so that even empty password fields should be equal
//otherwise if one is filled and another left empty, the "equal" condition would fail
//which does not make any sense
!required&&!field.val()&&1>field.val().length&&0>$.inArray('equals',rules)&&(options.isError=!1);// Hack for radio/checkbox group button, the validation go into the
// first radio/checkbox of the group
var fieldType=field.prop('type'),positionType=field.data('promptPosition')||options.promptPosition;if(('radio'==fieldType||'checkbox'==fieldType)&&1<form.find('input[name=\''+fieldName+'\']').length&&(field='inline'===positionType?$(form.find('input[name=\''+fieldName+'\'][type!=hidden]:last')):$(form.find('input[name=\''+fieldName+'\'][type!=hidden]:first')),options.showArrow=options.showArrowOnRadioAndCheckbox),field.is(':hidden')&&options.prettySelect&&!field.is('textarea')){var jqSelector=methods._jqSelector(field.attr('id'));field=form.find('#'+options.usePrefix+jqSelector),0>=field.length&&(field=form.find('#'+jqSelector+options.useSuffix));}options.isError&&options.showPrompts?methods._showPrompt(field,promptText,promptType,!1,options):methods._closePrompt(field),field.trigger('jqv.field.result',[field,options.isError,promptText]);/* Record error */var errindex=$.inArray(field[0],options.InvalidFields);return -1==errindex?options.isError&&options.InvalidFields.push(field[0]):!options.isError&&options.InvalidFields.splice(errindex,1),methods._handleStatusCssClasses(field,options),options.isError&&options.onFieldFailure&&options.onFieldFailure(field),!options.isError&&options.onFieldSuccess&&options.onFieldSuccess(field),options.isError},/**
     * Handling css classes of fields indicating result of validation
     *
     * @param {jqObject}
     *            field
     * @param {Array[String]}
     *            field's validation rules
     * @private
     */_handleStatusCssClasses:function _handleStatusCssClasses(field,options){options.addSuccessCssClassToField&&field.removeClass(options.addSuccessCssClassToField),options.addFailureCssClassToField&&field.removeClass(options.addFailureCssClassToField),options.addSuccessCssClassToField&&!options.isError&&field.addClass(options.addSuccessCssClassToField),options.addFailureCssClassToField&&options.isError&&field.addClass(options.addFailureCssClassToField);},/********************
     * _getErrorMessage
     *
     * @param form
     * @param field
     * @param rule
     * @param rules
     * @param i
     * @param options
     * @param originalValidationMethod
     * @return {*}
     * @private
     */_getErrorMessage:function _getErrorMessage(form,field,rule,rules,i,options,originalValidationMethod){// If we are using the custon validation type, build the index for the rule.
// Otherwise if we are doing a function call, make the call and return the object
// that is passed back.
var rule_index=jQuery.inArray(rule,rules);if('custom'===rule||'funcCall'===rule||'funcCallRequired'===rule){var custom_validation_type=rules[rule_index+1];rule=rule+'['+custom_validation_type+']',delete rules[rule_index];}// Change the rule to the composite rule, if it was different from the original
var errorMsg,alteredRule=rule,element_classes=field.attr('data-validation-engine')?field.attr('data-validation-engine'):field.attr('class'),element_classes_array=element_classes.split(' ');// Call the original validation method. If we are dealing with dates or checkboxes, also pass the form
// If the original validation method returned an error and we have a custom error message,
// return the custom message instead. Otherwise return the original error message.
if(errorMsg='future'==rule||'past'==rule||'maxCheckbox'==rule||'minCheckbox'==rule?originalValidationMethod(form,field,rules,i,options):originalValidationMethod(field,rules,i,options),null!=errorMsg){var custom_message=methods._getCustomErrorMessage($(field),element_classes_array,alteredRule,options);custom_message&&(errorMsg=custom_message);}return errorMsg},_getCustomErrorMessage:function _getCustomErrorMessage(field,classes,rule,options){var custom_message=!1,validityProp=/^custom\[.*\]$/.test(rule)?methods._validityProp.custom:methods._validityProp[rule];// If there is a validityProp for this rule, check to see if the field has an attribute for it
if(null!=validityProp&&(custom_message=field.attr('data-errormessage-'+validityProp),null!=custom_message))// If there was an error message for it, return the message
return custom_message;// If there is an inline custom error message, return it
if(custom_message=field.attr('data-errormessage'),null!=custom_message)return custom_message;var id='#'+field.attr('id');// If we have custom messages for the element's id, get the message for the rule from the id.
// Otherwise, if we have custom messages for the element's classes, use the first class message we find instead.
if('undefined'!=typeof options.custom_error_messages[id]&&'undefined'!=typeof options.custom_error_messages[id][rule])custom_message=options.custom_error_messages[id][rule].message;else if(0<classes.length)for(var element_class,i=0;i<classes.length&&0<classes.length;i++)if(element_class='.'+classes[i],'undefined'!=typeof options.custom_error_messages[element_class]&&'undefined'!=typeof options.custom_error_messages[element_class][rule]){custom_message=options.custom_error_messages[element_class][rule].message;break}return custom_message||'undefined'==typeof options.custom_error_messages[rule]||'undefined'==typeof options.custom_error_messages[rule].message||(custom_message=options.custom_error_messages[rule].message),custom_message},_validityProp:{required:'value-missing',custom:'custom-error',groupRequired:'value-missing',ajax:'custom-error',minSize:'range-underflow',maxSize:'range-overflow',min:'range-underflow',max:'range-overflow',past:'type-mismatch',future:'type-mismatch',dateRange:'type-mismatch',dateTimeRange:'type-mismatch',maxCheckbox:'range-overflow',minCheckbox:'range-underflow',equals:'pattern-mismatch',funcCall:'custom-error',funcCallRequired:'custom-error',creditCard:'pattern-mismatch',condRequired:'value-missing'},/**
     * Required validation
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @param {bool} condRequired flag when method is used for internal purpose in condRequired check
     * @return an error string if validation failed
     */_required:function _required(field,rules,i,options,condRequired){switch(field.prop('type')){case'radio':case'checkbox':// new validation style to only check dependent field
if(condRequired){if(!field.prop('checked'))return options.allrules[rules[i]].alertTextCheckboxMultiple;break}// old validation style
var form=field.closest('form, .validationEngineContainer'),name=field.attr('name');if(0==form.find('input[name=\''+name+'\']:checked').length)return 1==form.find('input[name=\''+name+'\']:visible').length?options.allrules[rules[i]].alertTextCheckboxe:options.allrules[rules[i]].alertTextCheckboxMultiple;break;case'text':case'password':case'textarea':case'file':case'select-one':case'select-multiple':default:var field_val=$.trim(field.val()),dv_placeholder=$.trim(field.attr('data-validation-placeholder'));if(!field_val||dv_placeholder&&field_val==dv_placeholder)return options.allrules[rules[i]].alertText;}},/**
     * Validate that 1 from the group field is required
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_groupRequired:function _groupRequired(field,rules,i,options){var classGroup='['+options.validateAttribute+'*='+rules[i+1]+']',isValid=!1;// Check all fields from the group
if(field.closest('form, .validationEngineContainer').find(classGroup).each(function(){if(!methods._required($(this),rules,i,options))return isValid=!0,!1}),!isValid)return options.allrules[rules[i]].alertText},/**
     * Validate rules
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_custom:function _custom(field,rules,i,options){var fn,customRule=rules[i+1],rule=options.allrules[customRule];if(!rule)return void alert('jqv:custom rule not found - '+customRule);if(rule.regex){var ex=rule.regex;if(!ex)return void alert('jqv:custom regex not found - '+customRule);var pattern=new RegExp(ex);if(!pattern.test(field.val()))return options.allrules[customRule].alertText}else if(rule.func){if(fn=rule.func,'function'!=typeof fn)return void alert('jqv:custom parameter \'function\' is no function - '+customRule);if(!fn(field,rules,i,options))return options.allrules[customRule].alertText}else return void alert('jqv:custom type not allowed '+customRule)},/**
     * Validate custom function outside of the engine scope
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_funcCall:function _funcCall(field,rules,i,options){var fn,functionName=rules[i+1];if(-1<functionName.indexOf('.')){for(var namespaces=functionName.split('.'),scope=window;namespaces.length;)scope=scope[namespaces.shift()];fn=scope;}else fn=window[functionName]||options.customFunctions[functionName];return 'function'==typeof fn?fn(field,rules,i,options):void 0},_funcCallRequired:function _funcCallRequired(field,rules,i,options){return methods._funcCall(field,rules,i,options)},/**
     * Field match
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_equals:function _equals(field,rules,i,options){var equalsField=rules[i+1];if(field.val()!=$('#'+equalsField).val())return options.allrules.equals.alertText},/**
     * Check the maximum size (in characters)
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_maxSize:function _maxSize(field,rules,i,options){var max=rules[i+1],len=field.val().length;if(len>max){var rule=options.allrules.maxSize;return rule.alertText+max+rule.alertText2}},/**
     * Check the minimum size (in characters)
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_minSize:function _minSize(field,rules,i,options){var min=rules[i+1],len=field.val().length;if(len<min){var rule=options.allrules.minSize;return rule.alertText+min+rule.alertText2}},/**
     * Check number minimum value
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_min:function _min(field,rules,i,options){var min=parseFloat(rules[i+1]),len=parseFloat(field.val());if(len<min){var rule=options.allrules.min;return rule.alertText2?rule.alertText+min+rule.alertText2:rule.alertText+min}},/**
     * Check number maximum value
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_max:function _max(field,rules,i,options){var max=parseFloat(rules[i+1]),len=parseFloat(field.val());if(len>max){var rule=options.allrules.max;return rule.alertText2?rule.alertText+max+rule.alertText2:rule.alertText+max;//orefalo: to review, also do the translations
}},/**
     * Checks date is in the past
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_past:function _past(form,field,rules,i,options){var pdate,p=rules[i+1],fieldAlt=$(form.find('*[name=\''+p.replace(/^#+/,'')+'\']'));if('now'==p.toLowerCase())pdate=new Date;else if(null!=fieldAlt.val()){if(fieldAlt.is(':disabled'))return;pdate=methods._parseDate(fieldAlt.val());}else pdate=methods._parseDate(p);var vdate=methods._parseDate(field.val());if(vdate>pdate){var rule=options.allrules.past;return rule.alertText2?rule.alertText+methods._dateToString(pdate)+rule.alertText2:rule.alertText+methods._dateToString(pdate)}},/**
     * Checks date is in the future
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_future:function _future(form,field,rules,i,options){var pdate,p=rules[i+1],fieldAlt=$(form.find('*[name=\''+p.replace(/^#+/,'')+'\']'));if('now'==p.toLowerCase())pdate=new Date;else if(null!=fieldAlt.val()){if(fieldAlt.is(':disabled'))return;pdate=methods._parseDate(fieldAlt.val());}else pdate=methods._parseDate(p);var vdate=methods._parseDate(field.val());if(vdate<pdate){var rule=options.allrules.future;return rule.alertText2?rule.alertText+methods._dateToString(pdate)+rule.alertText2:rule.alertText+methods._dateToString(pdate)}},/**
     * Checks if valid date
     *
     * @param {string} date string
     * @return a bool based on determination of valid date
     */_isDate:function _isDate(value){var dateRegEx=new RegExp(/^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/);return dateRegEx.test(value)},/**
     * Checks if valid date time
     *
     * @param {string} date string
     * @return a bool based on determination of valid date time
     */_isDateTime:function _isDateTime(value){var dateTimeRegEx=new RegExp(/^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/);return dateTimeRegEx.test(value)},//Checks if the start date is before the end date
//returns true if end is later than start
_dateCompare:function _dateCompare(start,end){return new Date(start.toString())<new Date(end.toString())},/**
     * Checks date range
     *
     * @param {jqObject} first field name
     * @param {jqObject} second field name
     * @return an error string if validation failed
     */_dateRange:function _dateRange(field,rules,i,options){//are not both populated
//are both dates but range is off
return !options.firstOfGroup[0].value&&options.secondOfGroup[0].value||options.firstOfGroup[0].value&&!options.secondOfGroup[0].value?options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2:methods._isDate(options.firstOfGroup[0].value)&&methods._isDate(options.secondOfGroup[0].value)?methods._dateCompare(options.firstOfGroup[0].value,options.secondOfGroup[0].value)?void 0:options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2:options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2;//are not both dates
},/**
     * Checks date time range
     *
     * @param {jqObject} first field name
     * @param {jqObject} second field name
     * @return an error string if validation failed
     */_dateTimeRange:function _dateTimeRange(field,rules,i,options){//are not both populated
//are both dates but range is off
return !options.firstOfGroup[0].value&&options.secondOfGroup[0].value||options.firstOfGroup[0].value&&!options.secondOfGroup[0].value?options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2:methods._isDateTime(options.firstOfGroup[0].value)&&methods._isDateTime(options.secondOfGroup[0].value)?methods._dateCompare(options.firstOfGroup[0].value,options.secondOfGroup[0].value)?void 0:options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2:options.allrules[rules[i]].alertText+options.allrules[rules[i]].alertText2;//are not both dates
},/**
     * Max number of checkbox selected
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_maxCheckbox:function _maxCheckbox(form,field,rules,i,options){var nbCheck=rules[i+1],groupname=field.attr('name'),groupSize=form.find('input[name=\''+groupname+'\']:checked').length;if(groupSize>nbCheck)return options.showArrow=!1,options.allrules.maxCheckbox.alertText2?options.allrules.maxCheckbox.alertText+' '+nbCheck+' '+options.allrules.maxCheckbox.alertText2:options.allrules.maxCheckbox.alertText},/**
     * Min number of checkbox selected
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_minCheckbox:function _minCheckbox(form,field,rules,i,options){var nbCheck=rules[i+1],groupname=field.attr('name'),groupSize=form.find('input[name=\''+groupname+'\']:checked').length;if(groupSize<nbCheck)return options.showArrow=!1,options.allrules.minCheckbox.alertText+' '+nbCheck+' '+options.allrules.minCheckbox.alertText2},/**
     * Checks that it is a valid credit card number according to the
     * Luhn checksum algorithm.
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return an error string if validation failed
     */_creditCard:function _creditCard(field,rules,i,options){//spaces and dashes may be valid characters, but must be stripped to calculate the checksum.
var valid=!1,cardNumber=field.val().replace(/ +/g,'').replace(/-+/g,''),numDigits=cardNumber.length;if(14<=numDigits&&16>=numDigits&&0<parseInt(cardNumber)){var digit,sum=0,i=numDigits-1,pos=1,luhn=new String;do digit=parseInt(cardNumber.charAt(i)),luhn+=0==pos++%2?2*digit:digit;while(0<=--i);for(i=0;i<luhn.length;i++)sum+=parseInt(luhn.charAt(i));valid=0==sum%10;}return valid?void 0:options.allrules.creditCard.alertText},/**
     * Ajax field validation
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     *            user options
     * @return nothing! the ajax validator handles the prompts itself
     */_ajax:function _ajax(field,rules,i,options){var errorSelector=rules[i+1],rule=options.allrules[errorSelector],extraData=rule.extraData,extraDataDynamic=rule.extraDataDynamic,data={fieldId:field.attr('id'),fieldValue:field.val()};if('object'===('undefined'==typeof extraData?'undefined':_typeof(extraData)))$.extend(data,extraData);else if('string'==typeof extraData)for(var values,tempData=extraData.split('&'),i=0;i<tempData.length;i++)values=tempData[i].split('='),values[0]&&values[0]&&(data[values[0]]=values[1]);if(extraDataDynamic)for(var id,domIds=String(extraDataDynamic).split(','),i=0;i<domIds.length;i++)if(id=domIds[i],$(id).length){var inputValue=field.closest('form, .validationEngineContainer').find(id).val(),keyValue=id.replace('#','')+'='+escape(inputValue);data[id.replace('#','')]=inputValue;}// If a field change event triggered this we want to clear the cache for this ID
// If there is an error or if the the field is already validated, do not re-execute AJAX
return ('field'==options.eventTrigger&&delete options.ajaxValidCache[field.attr('id')],!options.isError&&!methods._checkAjaxFieldStatus(field.attr('id'),options))?($.ajax({type:options.ajaxFormValidationMethod,url:rule.url,cache:!1,dataType:'json',data:data,field:field,rule:rule,methods:methods,options:options,beforeSend:function beforeSend(){},error:function error(data,transport){options.onFailure?options.onFailure(data,transport):methods._ajaxError(data,transport);},success:function success(json){// asynchronously called on success, data is the json answer from the server
var errorFieldId=json[0],errorField=$('#'+errorFieldId).eq(0);//var errorField = $($("#" + errorFieldId)[0]);
// make sure we found the element
if(1==errorField.length){var status=json[1],msg=json[2];// read the optional msg from the server
if(!status){// resolve the msg prompt
if(options.ajaxValidCache[errorFieldId]=!1,options.isError=!0,!msg)msg=rule.alertText;else if(options.allrules[msg]){var txt=options.allrules[msg].alertText;txt&&(msg=txt);}options.showPrompts&&methods._showPrompt(errorField,msg,'',!0,options);}else {// resolves the msg prompt
if(options.ajaxValidCache[errorFieldId]=!0,!msg)msg=rule.alertTextOk;else if(options.allrules[msg]){var txt=options.allrules[msg].alertTextOk;txt&&(msg=txt);}options.showPrompts&&(msg?methods._showPrompt(errorField,msg,'pass',!0,options):methods._closePrompt(errorField)),'submit'==options.eventTrigger&&field.closest('form').submit();}}errorField.trigger('jqv.field.result',[errorField,options.isError,msg]);}}),rule.alertTextLoad):void 0},/**
     * Common method to handle ajax errors
     *
     * @param {Object} data
     * @param {Object} transport
     */_ajaxError:function _ajaxError(data,transport){0==data.status&&null==transport?alert('The page is not served from a server! ajax call failed'):'undefined'!=typeof console&&console.log('Ajax error: '+data.status+' '+transport);},/**
     * date -> string
     *
     * @param {Object} date
     */_dateToString:function _dateToString(date){return date.getFullYear()+'-'+(date.getMonth()+1)+'-'+date.getDate()},/**
     * Parses an ISO date
     * @param {String} d
     */_parseDate:function _parseDate(d){var dateParts=d.split('-');return dateParts==d&&(dateParts=d.split('/')),dateParts==d?(dateParts=d.split('.'),new Date(dateParts[2],dateParts[1]-1,dateParts[0])):new Date(dateParts[0],dateParts[1]-1,dateParts[2])},/**
     * Builds or updates a prompt with the given information
     *
     * @param {jqObject} field
     * @param {String} promptText html text to display type
     * @param {String} type the type of bubble: 'pass' (green), 'load' (black) anything else (red)
     * @param {boolean} ajaxed - use to mark fields than being validated with ajax
     * @param {Map} options user options
     */_showPrompt:function _showPrompt(field,promptText,type,ajaxed,options,ajaxform){field.data('jqv-prompt-at')instanceof jQuery?field=field.data('jqv-prompt-at'):field.data('jqv-prompt-at')&&(field=$(field.data('jqv-prompt-at')));var prompt=methods._getPrompt(field);// The ajax submit errors are not see has an error in the form,
// When the form errors are returned, the engine see 2 bubbles, but those are ebing closed by the engine at the same time
// Because no error was found befor submitting
ajaxform&&(prompt=!1),$.trim(promptText)&&(prompt?methods._updatePrompt(field,prompt,promptText,type,ajaxed,options):methods._buildPrompt(field,promptText,type,ajaxed,options));},/**
     * Builds and shades a prompt for the given field.
     *
     * @param {jqObject} field
     * @param {String} promptText html text to display type
     * @param {String} type the type of bubble: 'pass' (green), 'load' (black) anything else (red)
     * @param {boolean} ajaxed - use to mark fields than being validated with ajax
     * @param {Map} options user options
     */_buildPrompt:function _buildPrompt(field,promptText,type,ajaxed,options){// create the prompt
var prompt=$('<div>');switch(prompt.addClass(methods._getClassName(field.attr('id'))+'formError'),prompt.addClass('parentForm'+methods._getClassName(field.closest('form, .validationEngineContainer').attr('id'))),prompt.addClass('formError'),type){case'pass':prompt.addClass('greenPopup');break;case'load':prompt.addClass('blackPopup');break;}ajaxed&&prompt.addClass('ajaxed');// create the prompt content
var promptContent=$('<div>').addClass('formErrorContent').html(promptText).appendTo(prompt),positionType=field.data('promptPosition')||options.promptPosition;// determine position type
// create the css arrow pointing at the field
// note that there is no triangle on max-checkbox and radio
if(options.showArrow){var arrow=$('<div>').addClass('formErrorArrow');//prompt positioning adjustment support. Usage: positionType:Xshift,Yshift (for ex.: bottomLeft:+20 or bottomLeft:-20,+10)
if('string'==typeof positionType){var pos=positionType.indexOf(':');-1!=pos&&(positionType=positionType.substring(0,pos));}'bottomLeft'===positionType||'bottomRight'===positionType?(prompt.find('.formErrorContent').before(arrow),arrow.addClass('formErrorArrowBottom').html('<div class="line1"><!-- --></div><div class="line2"><!-- --></div><div class="line3"><!-- --></div><div class="line4"><!-- --></div><div class="line5"><!-- --></div><div class="line6"><!-- --></div><div class="line7"><!-- --></div><div class="line8"><!-- --></div><div class="line9"><!-- --></div><div class="line10"><!-- --></div>')):'topLeft'===positionType||'topRight'===positionType?(arrow.html('<div class="line10"><!-- --></div><div class="line9"><!-- --></div><div class="line8"><!-- --></div><div class="line7"><!-- --></div><div class="line6"><!-- --></div><div class="line5"><!-- --></div><div class="line4"><!-- --></div><div class="line3"><!-- --></div><div class="line2"><!-- --></div><div class="line1"><!-- --></div>'),prompt.append(arrow)):void 0;}// Add custom prompt class
options.addPromptClass&&prompt.addClass(options.addPromptClass);// Add custom prompt class defined in element
var requiredOverride=field.attr('data-required-class');if(void 0!==requiredOverride)prompt.addClass(requiredOverride);else if(options.prettySelect&&$('#'+field.attr('id')).next().is('select')){var prettyOverrideClass=$('#'+field.attr('id').substr(options.usePrefix.length).substring(options.useSuffix.length)).attr('data-required-class');void 0!==prettyOverrideClass&&prompt.addClass(prettyOverrideClass);}prompt.css({opacity:0}),'inline'===positionType?(prompt.addClass('inline'),'undefined'!=typeof field.attr('data-prompt-target')&&0<$('#'+field.attr('data-prompt-target')).length?prompt.appendTo($('#'+field.attr('data-prompt-target'))):field.after(prompt)):field.before(prompt);var pos=methods._calculatePosition(field,prompt,options);// Support RTL layouts by @yasser_lotfy ( Yasser Lotfy )
return $('body').hasClass('rtl')?prompt.css({position:'inline'===positionType?'relative':'absolute',top:pos.callerTopPosition,left:'initial',right:pos.callerleftPosition,marginTop:pos.marginTopSize,opacity:0}).data('callerField',field):prompt.css({position:'inline'===positionType?'relative':'absolute',top:pos.callerTopPosition,left:pos.callerleftPosition,right:'initial',marginTop:pos.marginTopSize,opacity:0}).data('callerField',field),options.autoHidePrompt&&setTimeout(function(){prompt.animate({opacity:0},function(){prompt.closest('.formError').remove();});},options.autoHideDelay),prompt.animate({opacity:.87})},/**
     * Updates the prompt text field - the field for which the prompt
     * @param {jqObject} field
     * @param {String} promptText html text to display type
     * @param {String} type the type of bubble: 'pass' (green), 'load' (black) anything else (red)
     * @param {boolean} ajaxed - use to mark fields than being validated with ajax
     * @param {Map} options user options
     */_updatePrompt:function _updatePrompt(field,prompt,promptText,type,ajaxed,options,noAnimation){if(prompt){'undefined'!=typeof type&&('pass'==type?prompt.addClass('greenPopup'):prompt.removeClass('greenPopup'),'load'==type?prompt.addClass('blackPopup'):prompt.removeClass('blackPopup')),ajaxed?prompt.addClass('ajaxed'):prompt.removeClass('ajaxed'),prompt.find('.formErrorContent').html(promptText);var pos=methods._calculatePosition(field,prompt,options);// Support RTL layouts by @yasser_lotfy ( Yasser Lotfy )
if($('body').hasClass('rtl'))var css={top:pos.callerTopPosition,left:'initial',right:pos.callerleftPosition,marginTop:pos.marginTopSize,opacity:.87};else var css={top:pos.callerTopPosition,left:pos.callerleftPosition,right:'initial',marginTop:pos.marginTopSize,opacity:.87};prompt.css({opacity:0,display:'block'}),noAnimation?prompt.css(css):prompt.animate(css);}},/**
     * Closes the prompt associated with the given field
     *
     * @param {jqObject}
     *            field
     */_closePrompt:function _closePrompt(field){var prompt=methods._getPrompt(field);prompt&&prompt.fadeTo('fast',0,function(){prompt.closest('.formError').remove();});},closePrompt:function closePrompt(field){return methods._closePrompt(field)},/**
     * Returns the error prompt matching the field if any
     *
     * @param {jqObject}
     *            field
     * @return undefined or the error prompt (jqObject)
     */_getPrompt:function _getPrompt(field){var formId=$(field).closest('form, .validationEngineContainer').attr('id'),className=methods._getClassName(field.attr('id'))+'formError',match=$('.'+methods._escapeExpression(className)+'.parentForm'+methods._getClassName(formId))[0];if(match)return $(match)},/**
     * Returns the escapade classname
     *
     * @param {selector}
     *            className
     */_escapeExpression:function _escapeExpression(selector){return selector.replace(/([#;&,\.\+\*\~':"\!\^$\[\]\(\)=>\|])/g,'\\$1')},/**
     * returns true if we are in a RTLed document
     *
     * @param {jqObject} field
     */isRTL:function isRTL(field){var $document=$(document),$body=$('body'),rtl=field&&field.hasClass('rtl')||field&&'rtl'===(field.attr('dir')||'').toLowerCase()||$document.hasClass('rtl')||'rtl'===($document.attr('dir')||'').toLowerCase()||$body.hasClass('rtl')||'rtl'===($body.attr('dir')||'').toLowerCase();return Boolean(rtl)},/**
     * Calculates prompt position
     *
     * @param {jqObject}
     *            field
     * @param {jqObject}
     *            the prompt
     * @param {Map}
     *            options
     * @return positions
     */_calculatePosition:function _calculatePosition(field,promptElmt,options){var promptTopPosition,promptleftPosition,marginTopSize,fieldWidth=field.width(),fieldLeft=field.position().left,fieldTop=field.position().top,fieldHeight=field.height(),promptHeight=promptElmt.height();promptTopPosition=promptleftPosition=0,marginTopSize=-promptHeight;//prompt positioning adjustment support
//now you can adjust prompt position
//usage: positionType:Xshift,Yshift
//for example:
//   bottomLeft:+20 means bottomLeft position shifted by 20 pixels right horizontally
//   topRight:20, -15 means topRight position shifted by 20 pixels to right and 15 pixels to top
//You can use +pixels, - pixels. If no sign is provided than + is default.
var positionType=field.data('promptPosition')||options.promptPosition,shift1='',shift2='',shiftX=0,shiftY=0;switch('string'==typeof positionType&&-1!=positionType.indexOf(':')&&(shift1=positionType.substring(positionType.indexOf(':')+1),positionType=positionType.substring(0,positionType.indexOf(':')),-1!=shift1.indexOf(',')&&(shift2=shift1.substring(shift1.indexOf(',')+1),shift1=shift1.substring(0,shift1.indexOf(',')),shiftY=parseInt(shift2),isNaN(shiftY)&&(shiftY=0)),shiftX=parseInt(shift1),isNaN(shift1)&&(shift1=0)),positionType){default:case'topRight':promptleftPosition+=fieldLeft+fieldWidth-27,promptTopPosition+=fieldTop;break;case'topLeft':promptTopPosition+=fieldTop,promptleftPosition+=fieldLeft;break;case'centerRight':promptTopPosition=fieldTop+4,marginTopSize=0,promptleftPosition=fieldLeft+field.outerWidth(!0)+5;break;case'centerLeft':promptleftPosition=fieldLeft-(promptElmt.width()+2),promptTopPosition=fieldTop+4,marginTopSize=0;break;case'bottomLeft':promptTopPosition=fieldTop+field.height()+5,marginTopSize=0,promptleftPosition=fieldLeft;break;case'bottomRight':promptleftPosition=fieldLeft+fieldWidth-27,promptTopPosition=fieldTop+field.height()+5,marginTopSize=0;break;case'inline':promptleftPosition=0,promptTopPosition=0,marginTopSize=0;}//apply adjusments if any
return promptleftPosition+=shiftX,promptTopPosition+=shiftY,{callerTopPosition:promptTopPosition+'px',callerleftPosition:promptleftPosition+'px',marginTopSize:marginTopSize+'px'}},/**
     * Saves the user options and variables in the form.data
     *
     * @param {jqObject}
     *            form - the form where the user option should be saved
     * @param {Map}
     *            options - the user options
     * @return the user options (extended from the defaults)
     */_saveOptions:function _saveOptions(form,options){// is there a language localisation ?
if($.validationEngineLanguage)var allRules=$.validationEngineLanguage.allRules;else $.error('jQuery.validationEngine rules are not loaded, plz add localization files to the page');// --- Internals DO NOT TOUCH or OVERLOAD ---
// validation rules and i18
$.validationEngine.defaults.allrules=allRules;var userOptions=$.extend(!0,{},$.validationEngine.defaults,options);return form.data('jqv',userOptions),userOptions},/**
     * Removes forbidden characters from class name
     * @param {String} className
     */_getClassName:function _getClassName(className){if(className)return className.replace(/:/g,'_').replace(/\./g,'_')},/**
     * Escape special character for jQuery selector
     * http://totaldev.com/content/escaping-characters-get-valid-jquery-id
     * @param {String} selector
     */_jqSelector:function _jqSelector(str){return str.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,'\\$1')},/**
     * Conditionally required field
     *
     * @param {jqObject} field
     * @param {Array[String]} rules
     * @param {int} i rules index
     * @param {Map}
     * user options
     * @return an error string if validation failed
     */_condRequired:function _condRequired(field,rules,i,options){var idx,dependingField;for(idx=i+1;idx<rules.length;idx++)/* Use _required for determining wether dependingField has a value.
         * There is logic there for handling all field types, and default value; so we won't replicate that here
         * Indicate this special use by setting the last parameter to true so we only validate the dependingField on chackboxes and radio buttons (#462)
         */if(dependingField=jQuery('#'+rules[idx]).first(),dependingField.length&&null==methods._required(dependingField,['required'],0,options,!0))/* We now know any of the depending fields has a value,
           * so we can validate this field as per normal required code
           */return methods._required(field,['required'],0,options)},_submitButtonClick:function _submitButtonClick(){var button=$(this),form=button.closest('form, .validationEngineContainer');form.data('jqv_submitButton',button.attr('id'));}};/**
   * Plugin entry point.
   * You may pass an action as a parameter or a list of options.
   * if none, the init and attach methods are being called.
   * Remember: if you pass options, the attached method is NOT called automatically
   *
   * @param {String}
   *            method (optional) action
   */// LEAK GLOBAL OPTIONS
$.fn.validationEngine=function(method){var form=$(this);return form[0]?'string'==typeof method&&'_'!=method.charAt(0)&&methods[method]?('showPrompt'!=method&&'hide'!=method&&'hideAll'!=method&&methods.init.apply(form),methods[method].apply(form,Array.prototype.slice.call(arguments,1))):'object'!=('undefined'==typeof method?'undefined':_typeof(method))&&method?void $.error('Method '+method+' does not exist in jQuery.validationEngine'):(methods.init.apply(form,arguments),methods.attach.apply(form)):form;// stop here if the form does not exist
},$.validationEngine={fieldIdCounter:0,defaults:{// Name of the event triggering field validation
validationEventTrigger:'blur',// Automatically scroll viewport to the first error
scroll:!0,// Focus on the first input
focusFirstField:!0,// Show prompts, set to false to disable prompts
showPrompts:!0,// Should we attempt to validate non-visible input fields contained in the form? (Useful in cases of tabbed containers, e.g. jQuery-UI tabs)
validateNonVisibleFields:!1,// ignore the validation for fields with this specific class (Useful in cases of tabbed containers AND hidden fields we don't want to validate)
ignoreFieldsWithClass:'ignoreMe',// Opening box position, possible locations are: topLeft,
// topRight, bottomLeft, centerRight, bottomRight, inline
// inline gets inserted after the validated field or into an element specified in data-prompt-target
promptPosition:'topRight',bindMethod:'bind',// internal, automatically set to true when it parse a _ajax rule
inlineAjax:!1,// if set to true, the form data is sent asynchronously via ajax to the form.action url (get)
ajaxFormValidation:!1,// The url to send the submit ajax validation (default to action)
ajaxFormValidationURL:!1,// HTTP method used for ajax validation
ajaxFormValidationMethod:'get',// Ajax form validation callback method: boolean onComplete(form, status, errors, options)
// retuns false if the form.submit event needs to be canceled.
onAjaxFormComplete:$.noop,// called right before the ajax call, may return false to cancel
onBeforeAjaxFormValidation:$.noop,// Stops form from submitting and execute function assiciated with it
onValidationComplete:!1,// Used when you have a form fields too close and the errors messages are on top of other disturbing viewing messages
doNotShowAllErrosOnSubmit:!1,// Object where you store custom messages to override the default error messages
custom_error_messages:{},// true if you want to validate the input fields on blur event
binded:!0,// set to true if you want to validate the input fields on blur only if the field it's not empty
notEmpty:!1,// set to true, when the prompt arrow needs to be displayed
showArrow:!0,// set to false, determines if the prompt arrow should be displayed when validating
// checkboxes and radio buttons
showArrowOnRadioAndCheckbox:!1,// did one of the validation fail ? kept global to stop further ajax validations
isError:!1,// Limit how many displayed errors a field can have
maxErrorsPerField:!1,// Caches field validation status, typically only bad status are created.
// the array is used during ajax form validation to detect issues early and prevent an expensive submit
ajaxValidCache:{},// Auto update prompt position after window resize
autoPositionUpdate:!1,InvalidFields:[],onFieldSuccess:!1,onFieldFailure:!1,onSuccess:!1,onFailure:!1,validateAttribute:'class',addSuccessCssClassToField:'',addFailureCssClassToField:'',// Auto-hide prompt
autoHidePrompt:!1,// Delay before auto-hide
autoHideDelay:1e4,// Fade out duration while hiding the validations
fadeDuration:300,// Use Prettify select library
prettySelect:!1,// Add css class on prompt
addPromptClass:'',// Custom ID uses prefix
usePrefix:'',// Custom ID uses suffix
useSuffix:'',// Only show one message per error prompt
showOneMessage:!1}},$(function(){$.validationEngine.defaults.promptPosition=methods.isRTL()?'topLeft':'topRight';});})(jQuery);
//# sourceMappingURL=jquery.validationEngine.min.js.map
