Das umfassende Handbuch für Yii 2.0
===================================

Dieses Tutorial wurde unter den [Bedingungen der Yii-Dokumentation](https://www.yiiframework.com/doc/terms/) veröffentlicht.

Alle Rechte vorbehalten.

2014 (c) Yii Software LLC.


Einführung
----------

* [Über Yii](intro-yii.md)
* [Upgrade von Version 1.1](intro-upgrade-from-v1.md)


Einstieg
--------

* [Yii installieren](start-installation.md)
* [Running Applications](start-workflow.md)
* [Hallo sagen](start-hello.md)
* [Arbeiten mit Formularen](start-forms.md)
* [Arbeiten mit Datenbanken](start-databases.md)
* [Code generieren mit Gii](start-gii.md)
* [Ausblick](start-looking-ahead.md)


Application Struktur
--------------------

* [Überblick](structure-overview.md)
* [Entry Scripts](structure-entry-scripts.md)
* [Applications](structure-applications.md)
* [Application Komponenten](structure-application-components.md)
* [Controller](structure-controllers.md)
* [Model](structure-models.md)
* [View](structure-views.md)
* **TBD** [Filters](structure-filters.md)
* **TBD** [Widgets](structure-widgets.md)
* **TBD** [Modules](structure-modules.md)
* [Assets](structure-assets.md)
* **TBD** [Extensions](structure-extensions.md)


Anfragen bearbeiten
-------------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Routing](runtime-routing.md)
* **TBD** [Requests](runtime-requests.md)
* **TBD** [Responses](runtime-responses.md)
* **TBD** [Sessions and Cookies](runtime-sessions-cookies.md)
* [Parsen und Generieren von URLs](runtime-url-handling.md)
* [Fehlerbehandlung](runtime-handling-errors.md)
* [Logging](runtime-logging.md)


Kern-Konzepte
-------------

* [Komponenten](concept-components.md)
* [Eigenschaften](concept-properties.md)
* [Events (Ereignisse)](concept-events.md)
* [Behaviors](concept-behaviors.md)
* [Konfiguration](concept-configurations.md)
* [Aliase](concept-aliases.md)
* [Class Autoloading](concept-autoloading.md)
* [Service Locator](concept-service-locator.md)
* [Dependency Injection Container](concept-di-container.md)


Arbeiten mit Datenbanken
------------------------

* [Data Access Objects](db-dao.md) - Connecting to a database, basic queries, transactions and schema manipulation
* [Query Builder](db-query-builder.md) - Querying the database using a simple abstraction layer
* [Active Record](db-active-record.md) - The active record ORM, retrieving and manipulating records and defining relations
* [Migrations](db-migrations.md) - Version control your databases in a team development environment
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Eingabedaten verarbeiten
------------------------

* [Creating Forms](input-forms.md)
* [Validating Input](input-validation.md)
* **TBD** [Uploading Files](input-file-upload.md)
* **TBD** [Getting Data for Multiple Models](input-multiple-models.md)


Ausgabe von Daten
-----------------

* **TBD** [Data Formatting](output-formatting.md)
* **TBD** [Pagination](output-pagination.md)
* **TBD** [Sorting](output-sorting.md)
* [Data Providers](output-data-providers.md)
* [Data Widgets](output-data-widgets.md)
* [Theming](output-theming.md)


Sicherheit
----------

* [Authentication](security-authentication.md)
* [Authorization](security-authorization.md)
* [Working with Passwords](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Best Practices](security-best-practices.md)


Caching
-------

* [Overview](caching-overview.md)
* [Data Caching](caching-data.md)
* [Fragment Caching](caching-fragment.md)
* [Page Caching](caching-page.md)
* [HTTP Caching](caching-http.md)


RESTful Web Services
--------------------

* [Quick Start](rest-quick-start.md)
* [Resources](rest-resources.md)
* [Controllers](rest-controllers.md)
* [Routing](rest-routing.md)
* [Response Formatting](rest-response-formatting.md)
* [Authentication](rest-authentication.md)
* [Rate Limiting](rest-rate-limiting.md)
* [Versioning](rest-versioning.md)
* [Error Handling](rest-error-handling.md)


Development Tools
-----------------

* [Debug Toolbar and Debugger](tool-debugger.md)
* [Generating Code using Gii](tool-gii.md)
* **TBD** [Generating API Documentation](tool-api-doc.md)


Testing
-------

* [Overview](test-overview.md)
* **TBD** [Unit Tests](test-unit.md)
* **TBD** [Functional Tests](test-functional.md)
* **TBD** [Acceptance Tests](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Yii erweitern
-------------

* [Creating Extensions](extend-creating-extensions.md)
* [Customizing Core Code](extend-customizing-core.md)
* [Using 3rd-Party Libraries](extend-using-libs.md)
* **TBD** [Using Yii in 3rd-Party Systems](extend-embedding-in-others.md)
* **TBD** [Using Yii 1.1 and 2.0 Together](extend-using-v1-v2.md)
* [Using Composer](extend-using-composer.md)


Weitere Themen
--------------

* [Advanced Application Template](tutorial-advanced-app.md)
* [Building Application from Scratch](tutorial-start-from-scratch.md)
* [Console Commands](tutorial-console.md)
* [Core Validators](tutorial-core-validators.md)
* [Internationalization](tutorial-i18n.md)
* [Mailing](tutorial-mailing.md)
* [Performance Tuning](tutorial-performance-tuning.md)
* **TBD** [Shared Hosting Environment](tutorial-shared-hosting.md)
* [Template Engines](tutorial-template-engines.md)


Widgets
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Bootstrap Widgets](bootstrap-widgets.md)
* [Jquery UI Widgets](jui-widgets.md)


Helfer-Klassen
--------------

* [Overview](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

