Постраничное разделение данных
==========

В случае когда требуется отобразить слишком много данных на одной странице, эта страница зачастую 
разделяется на несколько частей, каждая из которых содержит и отображает только часть данных за один раз. 
Такие части называются страницами, а сам процесс называется постраничным разделением данных.
  
Если вы используете [провайдер данных](output-data-providers.md) с одним из [виджетов данных](output-data-widgets.md), 
то в этом случае будет автоматически использовано постраничное разделение данных. В противном случае вам требуется создать объект [[\yii\data\Pagination]],
заполнить его такими данными как [[\yii\data\Pagination::$totalCount|общее количество элементов]],
[[\yii\data\Pagination::$pageSize|количество элементов на одной странице]] и [[\yii\data\Pagination::$page|текущая страница]], затем применить
его к запросу и передать в [[\yii\widgets\LinkPager|элемент нумерации страниц]].


Первым делом в действии контроллера мы создаем объект постраничного разделения данных и заполняем его данными:

```php
function actionIndex()
{
    $query = Article::find()->where(['status' => 1]);
    $countQuery = clone $query;
    $pages = new Pagination(['totalCount' => $countQuery->count()]);
    $models = $query->offset($pages->offset)
        ->limit($pages->limit)
        ->all();

    return $this->render('index', [
         'models' => $models,
         'pages' => $pages,
    ]);
}
```

Затем в представлении мы выводим модели для текущей страницы и передаем объект постраничного разделения данных в элемент нумерации страниц:

```php
foreach ($models as $model) {
    // отображаем здесь $model
}

// отображаем ссылки на страницы
echo LinkPager::widget([
    'pagination' => $pages,
]);
```
