Предзагрузка
============

Предзагрузка это процесс настройки рабочей среды до того, как будет запущено приложение и обработан входящий запрос. 
Предзагрузка осуществляется в двух местах: [во входном скрипте](structure-entry-scripts.md) и в [приложении](structure-applications.md).

Во [входном скрипте](structure-entry-scripts.md), регистрируются автозагрузчики классов различных библиотек. Этот процесс
включает в себя автозагрузчик классов Composer через `autoload.php` файл и автозагрузчик классов Yii через его `Yii` файл. 
Затем входной скрипт загружает [конфигурацию](concept-configurations.md) приложения и создает объект [приложения](structure-applications.md).

В конструкторе приложения происходит следующий процесс предзагрузки:

1. Вызывается метод [[yii\base\Application::preInit()|preInit()]], который конфигурирует свойства приложения, имеющие
   наивысший приоритет, такие как [[yii\base\Application::basePath|basePath]];
2. Регистрируется [[yii\base\Application::errorHandler|обработчик ошибок]];
3. Происходит инициализация свойств приложения согласно заданной конфигурации;
4. Вызывается метод [[yii\base\Application::init()|init()]], который в свою очередь вызывает метод [[yii\base\Application::bootstrap()|bootstrap()]] для
   запуска компонентов предзагрузки.
   - Подключается файл манифеста `vendor/yiisoft/extensions.php`;
   - Создаются и запускаются [компоненты предзагрузки](structure-extensions.md#bootstrapping-classes) объявленные в расширениях;
   - Создаются и запускаются [компоненты приложения](structure-application-components.md) и/или [модули](structure-modules.md), объявленные
     в свойстве [предзагрузка](structure-applications.md#bootstrap) приложения.

Поскольку предзагрузка осуществляется прежде чем будет обработан *каждый* запрос, то очень важно, чтобы этот процесс был легким и максимально оптимизированным.

Старайтесь не регистрировать слишком много компонентов в предзагрузке. Компонент предзагрузки нужен только тогда, когда он должен
участвовать в полном жизненном цикле процесса обработки запроса. Например, если модуль должен зарегистрировать дополнительные правила парсинга URL, 
то он должен быть указан в свойстве [предзагрузка](structure-applications.md#bootstrap), чтобы новые правила URL были учтены при обработке запроса.

В производственном режиме включите байткод кэшеры, такие как [PHP OPcache] или [APC], для минимизации времени 
подключения и парсинг php файлов.

[PHP OPcache]: https://www.php.net/manual/ru/intro.opcache.php
[APC]: https://www.php.net/manual/ru/book.apcu.php

Некоторые большие приложения могут иметь сложную [конфигурацию](concept-configurations.md), которая разделена на несколько мелких файлов.
Если это тот самый случай, возможно вам стоит кэшировать весь конфигурационный файл и загружать его прямо из кэша до создания объекта 
приложения во входном скрипте.
