Говорим «Привет»
================

В этом разделе рассмотрим как создать новую страницу с надписью «Привет». В процессе решения задачи вы создадите
[действие контроллера](structure-controllers.md) и [представление](structure-views.md):

* Приложение обработает запрос и передаст управление соответствующему действию;
* Действие, в свою очередь, отобразит представление с надписью "Привет" конечному пользователю.

С помощью данного руководства вы изучите

* Как создавать [действие](structure-controllers.md), чтобы отвечать на запросы;
* Как создавать [представление](structure-views.md), чтобы формировать содержимое ответа;
* Как приложение отсылает запросы к [действию](structure-controllers.md).


Создание Действия <span id="creating-action"></span>
------------------------------------------------

Для нашей задачи потребуется [действие](structure-controllers.md) `say`, которое читает параметр `message` из
запроса и отображает его значение пользователю. Если в запросе не содержится параметра `message`, то действие будет
выводить «Привет».

> Info: [Действия](structure-controllers.md) могут быть запущены непосредственно пользователем и сгруппированы в
  [контроллеры](structure-controllers.md). Результатом выполнения действия является ответ, который получает пользователь.

Действия объявляются в [контроллерах](structure-controllers.md). Для простоты, вы можете объявить действие
`say` в уже существующем контроллере `SiteController`, который определен в файле класса `controllers/SiteController.php`:

```php
<?php

namespace app\controllers;

use yii\web\Controller;

class SiteController extends Controller
{
    // ...существующий код...

    public function actionSay($message = 'Привет')
    {
        return $this->render('say', ['message' => $message]);
    }
}
```

В приведенном коде действие `say` объявлено как метод `actionSay` в классе `SiteController`.
Yii использует префикс `action` чтобы различать методы-действия и обычные методы. Название после префикса `action`
считается идентификатором соответствующего действия.

> Info: Идентификаторы действий задаются в нижнем регистре. Если идентификатор состоит из нескольких слов, они
  соединяются дефисами, то есть `create-comment`. Имена методов действий получаются путём удаления дефисов
  из идентификатора, преобразования первой буквы каждого слова в верхний регистр и добавления префикса `action`.
  Например, идентификатор действия `create-comment` соответствует методу `actionCreateComment`.

Метод действия принимает параметр `$message`, который по умолчанию равен `"Привет"`. Когда приложение получает запрос
и определяет, что действие `say` ответственно за его обработку, параметр заполняется одноимённым значением из запроса.

Внутри метода действия, для вывода отображения [представления](structure-views.md) с именем `say`, используется метод
[[yii\web\Controller::render()|render()]]. Для того, чтобы вывести сообщение, в отображение передаётся параметр `message`.
Результат отображения при помощи `return` передаётся приложению, которое отдаёт его пользователю.


Создание представления <span id="creating-view"></span>
---------------------------------------------------

[Представления](structure-views.md) являются скриптами, которые используются для формирования тела ответа. Для нашего
приложения вы создадите представление `say`, которое будет выводить параметр `message`, полученный из метода действия:

```php
<?php
use yii\helpers\Html;
?>
<?= Html::encode($message) ?>
```

Представление `say` должно быть сохранено в файле `views/site/say.php`. Когда метод [[yii\web\Controller::render()|render()]]
вызывается в действии, он будет искать PHP файл с именем вида `views/ControllerID/ViewName.php`.

Стоит отметить, что в коде выше параметр `message` [[yii\helpers\Html::encode()|экранируется для HTML]] перед выводом.
Это обязательно так как параметр приходит от пользователя, который может попытаться провести
[XSS атаку](https://ru.wikipedia.org/wiki/%D0%9C%D0%B5%D0%B6%D1%81%D0%B0%D0%B9%D1%82%D0%BE%D0%B2%D1%8B%D0%B9_%D1%81%D0%BA%D1%80%D0%B8%D0%BF%D1%82%D0%B8%D0%BD%D0%B3)
путём вставки зловредного JavaScript кода.

Вы можете дополнить представление `say` HTML тегами, текстом или кодом PHP. Фактически, представление `say` является
простым PHP скриптом, который выполняется методом [[yii\web\Controller::render()|render()]]. Содержимое, выводимое
скриптом представления, будет передано пользователю приложением.


Попробуем <span id="trying-it-out"></span>
--------------------------------------

После создания действия и представления вы можете перейти на новую страницу по следующему URL:

```
https://hostname/index.php?r=site%2Fsay&message=Привет+мир
```

![Привет, мир](images/start-hello-world.png)

Будет отображена страница с надписью «Привет мир». Она использует ту же шапку и футер, что и остальные страницы приложения.
Если вы не укажете параметр `message`, то увидите на странице «Привет». Это происходит потому, как `message` передаётся
в метод `actionSay()` и значение по умолчанию — «Привет».

> Info: Новая страница использует ту же шапку и футер, что и другие страницы, потому что метод
  [[yii\web\Controller::render()|render()]] автоматически вставляет результат представления `say` в, так называемый, 
  [макет](structure-views.md) `views/layouts/main.php`.

Параметр `r` в нашем URL требует дополнительных пояснений. Он связан с [маршрутом (route)](runtime-routing.md), который представляет
собой уникальный идентификатор, указывающий на действие. Его формат `ControllerID/ActionID`. Когда приложение получает
запрос, оно проверяет параметр `r` и, используя `ControllerID`, определяет какой контроллер использовать для
обработки запроса. Затем, контроллер использует часть `ActionID`, чтобы определить, какое действие выполняет реальную работу.
В нашем случае маршрут `site/say` будет соответствовать контроллеру `SiteController` и его действию `say`. 
В результате для обработки запроса будет вызван метод `SiteController::actionSay()`.

> Info: Как и действия, контроллеры также имеют идентификаторы, которые однозначно определяют их в приложении.
  Идентификаторы контроллеров используют те же правила именования, что и идентификаторы действий. Имена классов
  контроллеров получаются путём удаления дефисов из идентификатора, преобразования первой буквы каждого слова в
  верхний регистр и добавления в конец `Controller`. Например, идентификатор контроллера `post-comment` соответствует
  имени класса контроллера `PostCommentController`.


Заключение <span id="summary"></span>
-----------------------------

В этом разделе вы затронули тему контроллеров и представлений в паттерне MVC. Вы создали действие как часть контроллера,
обрабатывающего запросы, и представление, участвующее в формировании ответа. В этом процессе никак не была задействована
модель, так как в качестве данных выступает лишь простой параметр `message`.

Также вы познакомились с концепцией маршрутизации, которая является связующим звеном между запросом пользователя и
действием контроллера.

В следующем разделе вы узнаете как создавать модели и добавлять новые страницы с HTML формами.

