Unit Tests
==========

A unit test verifies that a single unit of code is working as expected. That is, given different input parameters,
the test verifies the class method returns expected results. Unit tests are usually developed by people who write the
classes being tested.

Unit testing in Yii is built on top of PHPUnit and, optionally, Codeception so it's recommended to go through their docs:

- [Codeception for Yii framework](https://codeception.com/for/yii)
- [Codeception Unit Tests](https://codeception.com/docs/05-UnitTests)
- [PHPUnit docs starting from chapter 2](https://phpunit.de/manual/current/en/writing-tests-for-phpunit.html)

## Running basic and advanced template tests

If you've started with advanced template, please refer to ["testing" guide](https://github.com/yiisoft/yii2-app-advanced/blob/master/docs/guide/start-testing.md)
for more details about running tests.  

If you've started with basic template, check its [README "testing" section](https://github.com/yiisoft/yii2-app-basic/blob/master/README.md#testing).

## Framework unit tests

If you want to run unit tests for Yii framework itself follow
"[Getting started with Yii 2 development](https://github.com/yiisoft/yii2/blob/master/docs/internals/getting-started.md)".
