 Yii 2.0 الدليل التقني الخاص ببيئة العمل
===============================

تم تحرير هذا الملف اعتمادا على [الشروط الخاصة بتوثيف ال Yii](https://www.yiiframework.com/doc/terms/).

جميع الحقوق محفوظة

2014 (c) Yii Software LLC.


المقدمة
------------

* [عن بيئة العمل Yii](intro-yii.md)
* [التحديث من الإصدار 1.1](../guide/intro-upgrade-from-v1.md)


البداية من هنا
---------------

* [ماذا يجب أن تعرف عن بيئة العمل](start-prerequisites.md)
* [تثبيت ال Yii](start-installation.md)
* [تشغيل التطبيقات - Running Applications](start-workflow.md)
* [قل مرحبا - المشروع الأول](start-hello.md)
* [التعامل مع ال forms](start-forms.md)
* [التعامل مع قواعد البيانات](start-databases.md)
* [إنشاء الشيفرة البرمجية من خلال ال gii](start-gii.md)
* [ماذا الآن - الخطوة القادمة](start-looking-ahead.md)


الهيكلية الخاصة بالتطبيق (Application Structure)
---------------------

* [نظرة عامة عن الهيكلية الخاصة بالتطبيق](../guide/structure-overview.md)
* [Entry Scripts](../guide/structure-entry-scripts.md)
* [التطبيقات](../guide/structure-applications.md)
* [مكونات التطبيقات](../guide/structure-application-components.md)
* [Controllers](../guide/structure-controllers.md)
* [Models](../guide/structure-models.md)
* [Views](../guide/structure-views.md)
* [Modules](../guide/structure-modules.md)
* [Filters](../guide/structure-filters.md)
* [Widgets](../guide/structure-widgets.md)
* [Assets](../guide/structure-assets.md)
* [Extensions](../guide/structure-extensions.md)


التعامل مع ال requests
-----------------

* [نظرة عامة عن التعامل مع ال requests](../guide/runtime-overview.md)
* [Bootstrapping](../guide/runtime-bootstrapping.md)
* [Routing and URL Creation](../guide/runtime-routing.md)
* [Requests](../guide/runtime-requests.md)
* [Responses](../guide/runtime-responses.md)
* [Sessions and Cookies](../guide/runtime-sessions-cookies.md)
* [Handling Errors - التحكم بالأخطاء](../guide/runtime-handling-errors.md)
* [Logging - تسجيل الحركات](../guide/runtime-logging.md)


المفاهيم الرئيسية (Key Concepts)
------------

* [Components](../guide/concept-components.md)
* [Properties](../guide/concept-properties.md)
* [Events](../guide/concept-events.md)
* [Behaviors](../guide/concept-behaviors.md)
* [Configurations](../guide/concept-configurations.md)
* [Aliases](../guide/concept-aliases.md)
* [Class Autoloading](../guide/concept-autoloading.md)
* [Service Locator](../guide/concept-service-locator.md)
* [Dependency Injection Container](../guide/concept-di-container.md)


التعامل مع قواعد البيانات
----------------------

* [Database Access Objects](../guide/db-dao.md): Connecting to a database, basic queries, transactions, and schema manipulation
* [Query Builder](../guide/db-query-builder.md): Querying the database using a simple abstraction layer
* [Active Record](../guide/db-active-record.md): The Active Record ORM, retrieving and manipulating records, and defining relations
* [Migrations](../guide/db-migrations.md): Apply version control to your databases in a team development environment
* [Sphinx](https://www.yiiframework.com/extension/yiisoft/yii2-sphinx/doc/guide)
* [Redis](https://www.yiiframework.com/extension/yiisoft/yii2-redis/doc/guide)
* [MongoDB](https://www.yiiframework.com/extension/yiisoft/yii2-mongodb/doc/guide)
* [ElasticSearch](https://www.yiiframework.com/extension/yiisoft/yii2-elasticsearch/doc/guide)


الحصول على البيانات من خلال المستخدمين
-----------------------

* [Creating Forms](../guide/input-forms.md)
* [Validating Input](../guide/input-validation.md)
* [Uploading Files](../guide/input-file-upload.md)
* [Collecting Tabular Input](../guide/input-tabular-input.md)
* [Getting Data for Multiple Models](../guide/input-multiple-models.md)
* [Extending ActiveForm on the Client Side](../guide/input-form-javascript.md)


عرض البيانات
---------------

* [Data Formatting](../guide/output-formatting.md)
* [Pagination](../guide/output-pagination.md)
* [Sorting](../guide/output-sorting.md)
* [Data Providers](../guide/output-data-providers.md)
* [Data Widgets](../guide/output-data-widgets.md)
* [Working with Client Scripts](../guide/output-client-scripts.md)
* [Theming](../guide/output-theming.md)


الامان والحماية
--------

* [Security Overview](../guide/security-overview.md)
* [Authentication](../guide/security-authentication.md)
* [Authorization](../guide/security-authorization.md)
* [Working with Passwords](../guide/security-passwords.md)
* [Cryptography](../guide/security-cryptography.md)
* [Auth Clients](https://www.yiiframework.com/extension/yiisoft/yii2-authclient/doc/guide)
* [Best Practices](../guide/security-best-practices.md)


Caching التخزين المؤقت
-------

* [Caching Overview](../guide/caching-overview.md)
* [Data Caching](../guide/caching-data.md)
* [Fragment Caching](../guide/caching-fragment.md)
* [Page Caching](../guide/caching-page.md)
* [HTTP Caching](../guide/caching-http.md)


RESTful Web Services
--------------------

* [Quick Start](../guide/rest-quick-start.md)
* [Resources](../guide/rest-resources.md)
* [Controllers](../guide/rest-controllers.md)
* [Routing](../guide/rest-routing.md)
* [Response Formatting](../guide/rest-response-formatting.md)
* [Authentication](../guide/rest-authentication.md)
* [Rate Limiting](../guide/rest-rate-limiting.md)
* [Versioning](../guide/rest-versioning.md)
* [Error Handling](../guide/rest-error-handling.md)


الأدوات المساعدة أثناء تطوير التطبيقات
-----------------

* [Debug Toolbar and Debugger](https://www.yiiframework.com/extension/yiisoft/yii2-debug/doc/guide)
* [Generating Code using Gii](https://www.yiiframework.com/extension/yiisoft/yii2-gii/doc/guide)
* [Generating API Documentation](https://www.yiiframework.com/extension/yiisoft/yii2-apidoc)


فحص واختبار التطبيقات
-------

* [Testing Overview](../guide/test-overview.md)
* [Testing environment setup](../guide/test-environment-setup.md)
* [Unit Tests](../guide/test-unit.md)
* [Functional Tests](../guide/test-functional.md)
* [Acceptance Tests](../guide/test-acceptance.md)
* [Fixtures](../guide/test-fixtures.md)


مواضيع وعناوين مميزة
--------------

* [Advanced Project Template](https://www.yiiframework.com/extension/yiisoft/yii2-app-advanced/doc/guide)
* [Building Application from Scratch](../guide/tutorial-start-from-scratch.md)
* [Console Commands](../guide/tutorial-console.md)
* [Core Validators](../guide/tutorial-core-validators.md)
* [Docker](../guide/tutorial-docker.md)
* [Internationalization](../guide/tutorial-i18n.md)
* [Mailing](../guide/tutorial-mailing.md)
* [Performance Tuning](../guide/tutorial-performance-tuning.md)
* [Shared Hosting Environment](../guide/tutorial-shared-hosting.md)
* [Template Engines](../guide/tutorial-template-engines.md)
* [Working with Third-Party Code](../guide/tutorial-yii-integration.md)
* [Using Yii as a micro framework](../guide/tutorial-yii-as-micro-framework.md)


Widgets
-------

* [GridView](https://www.yiiframework.com/doc-2.0/yii-grid-gridview.html)
* [ListView](https://www.yiiframework.com/doc-2.0/yii-widgets-listview.html)
* [DetailView](https://www.yiiframework.com/doc-2.0/yii-widgets-detailview.html)
* [ActiveForm](https://www.yiiframework.com/doc-2.0/guide-input-forms.html#activerecord-based-forms-activeform)
* [Pjax](https://www.yiiframework.com/doc-2.0/yii-widgets-pjax.html)
* [Menu](https://www.yiiframework.com/doc-2.0/yii-widgets-menu.html)
* [LinkPager](https://www.yiiframework.com/doc-2.0/yii-widgets-linkpager.html)
* [LinkSorter](https://www.yiiframework.com/doc-2.0/yii-widgets-linksorter.html)
* [Bootstrap Widgets](https://www.yiiframework.com/extension/yiisoft/yii2-bootstrap/doc/guide)
* [jQuery UI Widgets](https://www.yiiframework.com/extension/yiisoft/yii2-jui/doc/guide)


Helpers
-------

* [Helpers Overview](../guide/helper-overview.md)
* [ArrayHelper](../guide/helper-array.md)
* [Html](../guide/helper-html.md)
* [Url](../guide/helper-url.md)

