暗号化
======

このセクションでは、セキュリティの以下の側面について見ていきます。

- 乱数データの生成
- 暗号化と復号化
- データの完全性の確認

擬似乱数データを生成する
------------------------

擬似乱数データはさまざまな状況で役に立ちます。
例えば、メール経由でパスワードをリセットするときは、トークンを生成してデータベースに保存し、それをユーザにメールで送信します。
そして、ユーザはこのトークンを自分がアカウントの所有者であることの証拠として使用します。このトークンがユニークかつ推測困難なものであることは非常に重要なことです。
さもなくば、攻撃者がトークンの値を推測してユーザのパスワードをリセットする可能性があります。

Yii のセキュリティヘルパは擬似乱数データの生成を単純な作業にしてくれます。


```php
$key = Yii::$app->getSecurity()->generateRandomString();
```

暗号化と復号化
--------------

Yii は秘密鍵を使ってデータを暗号化/復号化することを可能にする便利なヘルパ関数を提供しています。データを暗号化関数に渡して、秘密鍵を持つ者だけが復号化することが出来るようにすることが出来ます。
例えば、何らかの情報をデータベースに保存する必要があるけれども、(たとえアプリケーションのデータベースが第三者に漏洩した場合でも) 秘密鍵を持つユーザだけがそれを見ることが出来るようにする必要がある、という場合には次のようにします。


```php
// $data と $secretKey はフォームから取得する
$encryptedData = Yii::$app->getSecurity()->encryptByPassword($data, $secretKey);
// $encryptedData をデータベースに保存する
```

そして、後でユーザがデータを読みたいときは、次のようにします。

```php
// $secretKey はユーザ入力から取得、$encryptedData はデータベースから取得
$data = Yii::$app->getSecurity()->decryptByPassword($encryptedData, $secretKey);
```

[[\yii\base\Security::encryptByKey()]] と [[\yii\base\Security::decryptByKey()]] によって、
パスワードの代わりにキーを使うことも可能です。

データの完全性を確認する
------------------------

データが第三者によって改竄されたり、更には何らかの形で毀損されたりしていないことを確認する必要がある、という場合があります。Yii は二つのヘルパ関数の形で、データの完全性を確認するための簡単な方法を提供しています。

秘密鍵とデータから生成されたハッシュをデータにプレフィクスします。


```php
// $secretKey はアプリケーションまたはユーザの秘密、$genuineData は信頼できるソースから取得
$data = Yii::$app->getSecurity()->hashData($genuineData, $secretKey);
```

データの完全性が毀損されていないかチェックします。

```php
// $secretKey はアプリケーションまたはユーザの秘密、$data は信頼できないソースから取得
$data = Yii::$app->getSecurity()->validateData($data, $secretKey);
```
