测试
=======

测试是软件开发的一个重要组成部分。不管我们是否意识到，我们一直在不断地进行测试。
例如，当我们在用 PHP 写一个类的时候，我们可能用 echo 或者 die 语句一步一步简单的调试
验证我们实现的代码是否按照最初的计划工作。在开发 web 应用的时候，我们在表单中输入
一些测试数据来确保页面能够如预期那样和我们进行交互。

测试过程可能是自动的，所以每次我们需要验证的时候，我们只需要调用它就可以测试代码了。
验证代码执行结果是否符合我们的计划叫做测试，
测试过程的创建以及进一步执行叫做*自动化测试*，
这是这些测试章节的主要主题。


## 带着测试进行开发

测试驱动开发（TDD）和行为驱动开发（BDD）在开始编写实际代码之前，
首先通过描述一段代码的行为或将其作为一组场景或测试的全部特征，
然后创建符合这些测试预期验证
的行为实现。

开发一个功能的过程如下：

- 创建一个描述一个功能被实现测试。
- 运行这个测试来确保功能失败，因为这是没有实现之前的预期。
- 编写简单代码确保这个测试通过。
- 运行所有测试确保所有测试都通过。
- 优化代码确保测试依然可以通过。

走完上面的过程之后，为其他功能或者扩展重复上面测试过程。如果功能发生变化，测试也需
要跟着变化。

> Tip: 如果你觉得你做一些很小很简单的迭代是在浪费时间，请尝试覆盖更多的测试
> 场景，这样你就可以在执行测试之前做更多的尝试。如果你的调试过多，试着做相反的工作。

在做一些具体的实现之前创建测试的原因是，这允许我们后期专注于我们想要的实现，并且
可以花费更多的精力到实现细节。在涉及功能调整的时候，这会使得抽象更合理、测试维护
更简单或者使得耦合元件更少。

这种做法的优点如下：

- 在计划和实现发生变更的时候，可以让你在同一时间只专注于一件事情。
- 更多功能更详细的覆盖测试的结果，如果测试都通过好比再也没有什么问题了。

在很长一段时间内，这通常会给你提供一个有效的时间节省。

## 什么时候测试，怎么测试？

在测试的时候，对于一些相对复杂的项目上面的内容是非常有意义的，但对于一些比较
简单的项目就做的有些极端了。适用场景如下：

- 项目已经很大且复杂。
- 项目需求开始变得复杂起来。项目不断发展。
- 项目历时很长。
- 失败的代价非常高。

在现有的实现行为中进行覆盖测试是非常适合的。

- 项目是一个逐步更新的遗产。
- 你有一个还没有经过测试的项目要做。

在一些情况下，任何形式的自动化测试都是过于极端的：

- 项目很简单，也不会变得复杂。
- 过期不再工作的一次性项目。

假如你有很多的时间，在这种情况下进行自动测试也很好。

## 深度阅读

- 测试驱动开发：示例 / Kent Beck。 ISBN：0321146530。
