Окружение виртуального хостинга
==========================

Зачастую окружение виртуальных хостингов весьма ограничено как в настройках конфигурации, так и в настройках структуры директорий. В большинстве случаев, однако, возможно запустить Yii 2 на виртуальном хостинге, внеся некоторые корректировки.

Установка приложения Basic.
---------------------------

Поскольку на виртуальном хостинге обычно только один webroot, то лучше использовать шаблонное приложение Basic. Прочитайте раздел [Установка Yii](start-installation.md) и локально установите приложение. После того как оно начнет работать, можно внести необходимые корректировки, которые помогут разместить Basic на виртуальном хостинге.

### Переименование webroot <span id="renaming-webroot"></span>

Подключитесь к вашему виртуальному хостингу, используя FTP или другой способ. Скорее всего вы увидите следующее: 
 
```
config
logs
www
```

В приведенном выше описании `www` - это webroot директория веб-сервера. Она может называться по-другому. Возможные названия: `www`, `htdocs` или `public_html`.

В Basic webroot называется `web`. Перед загрузкой своего приложения на виртуальный хостинг, переименуйте локальный webroot на название webroot виртуального хостинга. Например, `web` в `www` или `public_html`, в зависимости от наименования webroot вашего хостинга.

### Корневая директория FTP доступна для записи

Если вы можете записать в корневую директорию, где располагаются `config`, `logs` и `www`, то загрузите сюда же `assets`, `commands` и остальные директории, так же, как и у вас, локально.

### Добавим настройки для веб-сервера <span id="add-extras-for-webserver"></span>

В случае, если ваш сервер Apache, добавьте в директорию `web` или аналогичную, где располагается `index.php`, файл `.htaccess` со следующим содержимым:

```
Options +FollowSymLinks
IndexIgnore */*

RewriteEngine on

# if a directory or a file exists, use it directly
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d

# otherwise forward it to index.php
RewriteRule . index.php
```

В случае использования nginx не требуется каких-либо дополнительных настроек.

### Проверка требований

Для того чтобы запустить Yii, ваш веб-сервер должен соответствовать его требованиям. Минимальное требование к PHP - это его версия 5.4. Для того чтобы проверить требования, скопируйте `requirements.php` из корневого каталога в каталог webroot и запустите его с помощью браузера, используя url `https://example.com/requirements.php`. Не забудьте после проверки требований удалить файл `requirements.php`.

Установка шаблона приложения Advanced
---------------------------------

Установка шаблона Advanced немного сложнее, чем установка Basic, из-за того, что в Advanced имеются две директории webroot, работа с которыми на виртуальном хостинге не поддерживается. По этой причине нам потребуется внести изменения в структуру директорий.

### Перемещение входных скриптов в одну директорию webroot

Для начала нам необходима директория webroot. Создайте новую директорию и назовите её так же, как на виртуальном хостинге, например, `www` или `public_html`, как описывалось выше в разделе [Переименование webroot](#renaming-webroot). Затем создайте следующую структуру в `www`:

```
www
    admin
backend
common
console
environments
frontend
...
```

Нашей фронтенд директорией будет `www`. Переместите в неё всё из `frontend/web`. Так же поступите и для `backend/web`, скопировав всё в `www/admin`. В каждом случае нужно настроить пути внутри файлов `index.php` и `index-test.php`.

### Отдельные сессии и куки
  
Изначально подразумевалось, что приложения бекенд и фронтенд располагаются на разных доменах. Теперь, когда мы перенесли всё на один домен, куки и сессии из бекенда и фронтенда стали пересекаться. Для решения этой проблемы требуется внести следующие настройки в конфигурацию бекенд-приложения `backend/config/main.php`:

```php
'components' => [
    'request' => [
        'csrfParam' => '_backendCSRF',
        'csrfCookie' => [
            'httpOnly' => true,
            'path' => '/admin',
        ],
    ],
    'user' => [
        'identityCookie' => [
            'name' => '_backendIdentity',
            'path' => '/admin',
            'httpOnly' => true,
        ],
    ],
    'session' => [
        'name' => 'BACKENDSESSID',
        'cookieParams' => [
            'path' => '/admin',
        ],
    ],
],
```
