Сесії та кукі
====================

Сесії та кукі дозволяють зберігати користувацькі дані між запитами. При використанні чистого PHP можна отримати доступ до цих даних через глобальні змінні `$_SESSION` та `$_COOKIE`, відповідно. Yii інкапсулює сесії та кукі в об'єкти, що дає можливість звертатися до них в об'єктноорієнтованому стилі та забезпечує додаткову зручність в роботі.


## Сесії <span id="sessions"></span>

За аналогією з [запитами](runtime-requests.md) та [відповідями](runtime-responses.md), до сесій можна отримати доступ через `session` [компонент додатка](structure-application-components.md), який за замовчуванням є екземпляром [[yii\web\Session]].


### Відкриття та закриття сесії <span id="opening-closing-sessions"></span>

Відкрити та закрити сесію можна наступним чином:

```php
$session = Yii::$app->session;

// перевіряєм що сесія вже відкрита
if ($session->isActive) ...

// відкиваєм сесію
$session->open();

// закриваємо сесію
$session->close();

// знищуємо сесію і всі пов'язані з нею дані.
$session->destroy();
```

Можна викликати [[yii\web\Session::open()|open()]] і [[yii\web\Session::close()|close()]] багаторазово без виникнення помилок; всередині компонента всі методи перевіряють сесію на те, відкрита вона чи ні.


### Доступ до даних сесії <span id="access-session-data"></span>

Отримати доступ до збережених в сесію даних можна наступним чином:

```php
$session = Yii::$app->session;

// отримання змінної з сесії. Наступні способи використання еквівалентні:
$language = $session->get('language');
$language = $session['language'];
$language = isset($_SESSION['language']) ? $_SESSION['language'] : null;

// запис змінної в сесію. Наступні способи використання еквівалентні:
$session->set('language', 'en-US');
$session['language'] = 'en-US';
$_SESSION['language'] = 'en-US';

// видалення змінної з сесії. Наступні способи використання еквівалентні:
$session->remove('language');
unset($session['language']);
unset($_SESSION['language']);

// перевірка на існування змінної в сесії. Наступні способи використання еквівалентні:
if ($session->has('language')) ...
if (isset($session['language'])) ...
if (isset($_SESSION['language'])) ...

// обхід усіх змінних у сесії. Наступні способи використання еквівалентні:
foreach ($session as $name => $value) ...
foreach ($_SESSION as $name => $value) ...
```

> Info: При отриманні даних з сесії через компонент `session`, сесія буде автоматично відкрита, якщо вона не була відкрита до цього. У цьому полягає відмінність від отримання даних з глобальної змінної `$_SESSION`, що вимагає обов'язкового виклику `session_start()`.

При роботі з сесійними даними, які є масивами, компонент `session` має обмеження, що забороняє пряму модифікацію окремих елементів масиву. Наприклад,

```php
$session = Yii::$app->session;

// наступний код НЕ БУДЕ працювати
$session['captcha']['number'] = 5;
$session['captcha']['lifetime'] = 3600;

// а цей буде:
$session['captcha'] = [
    'number' => 5,
    'lifetime' => 3600,
];

// цей код також буде працювати:
echo $session['captcha']['lifetime'];
```

Для вирішення цієї проблеми можна використовувати такі обхідні прийоми:

```php
$session = Yii::$app->session;

// пряме використання $_SESSION (переконайтеся, що Yii::$app->session->open() був викликаний)
$_SESSION['captcha']['number'] = 5;
$_SESSION['captcha']['lifetime'] = 3600;

// отримайте весь масив, модифікуйте і збережіть назад у сесію
$captcha = $session['captcha'];
$captcha['number'] = 5;
$captcha['lifetime'] = 3600;
$session['captcha'] = $captcha;

// використовуйте ArrayObject замість масиву
$session['captcha'] = new \ArrayObject;
...
$session['captcha']['number'] = 5;
$session['captcha']['lifetime'] = 3600;

// записуйте дані з ключами, які мають однаковий префікс
$session['captcha.number'] = 5;
$session['captcha.lifetime'] = 3600;
```

Для покращення продуктивності та читабельності коду рекомендується використовувати останній прийом. Іншими словами, замість того, щоб зберігати масив як одну змінну сесії, ми зберігаємо кожен елемент масиву як звичайну сесійну змінну зі спільним префіксом.


### Користувацьке сховище для сесії <span id="custom-session-storage"></span>

За замовчуванням клас [[yii\web\Session]] зберігає дані сесії у вигляді файлів на сервері. Однак Yii надає ряд класів, які реалізують різні способи зберігання даних сесії:

* [[yii\web\DbSession]]: зберігає дані сесії в базі даних.
* [[yii\web\CacheSession]]: зберігання даних сесії в попередньо сконфігурованому компоненті кешу [кеш](caching-data.md#cache-components).
* [[yii\redis\Session]]: зберігання даних сесії в [redis](https://redis.io/).
* [[yii\mongodb\Session]]: зберігання сесії в [MongoDB](https://www.mongodb.com/).

Усі ці класи підтримують однаковий набір методів API. В результаті ви можете перемикатися між різними сховищами сесій без модифікації коду додатку.

> Note: Якщо ви хочете отримати дані з змінної `$_SESSION` при використанні користувацького сховища, ви повинні бути впевнені, що сесія вже стартувала [[yii\web\Session::open()]], оскільки обробники зберігання користувацьких сесій реєструються в цьому методі.

Щоб дізнатися, як налаштувати і використовувати ці компоненти, зверніться до документації по API. Нижче наведено приклад конфігурації [[yii\web\DbSession]] для використання бази даних для зберігання сесії:

```php
return [
    'components' => [
        'session' => [
            'class' => 'yii\web\DbSession',
            // 'db' => 'mydb',  // ID компонента для взаємодії з БД. По замовчуванню 'db'.
            // 'sessionTable' => 'my_session', // назва таблиці для даних сесії. По замовчуванню 'session'.
        ],
    ],
];
```

Також необхідно створити таблицю для зберігання даних сесії:

```sql
CREATE TABLE session
(
    id CHAR(40) NOT NULL PRIMARY KEY,
    expire INTEGER,
    data BLOB
)
```

де 'BLOB' відповідає типу даних вашої DBMS. Нижче наведені приклади відповідності типів BLOB у найбільш популярних DBMS:

- MySQL: LONGBLOB
- PostgreSQL: BYTEA
- MSSQL: BLOB

> Note: В залежності від налаштувань параметра `session.hash_function` у вашому php.ini, може знадобитися змінити довжину поля `id`. Наприклад, якщо `session.hash_function=sha256`, потрібно встановити довжину поля на 64 замість 40.

### Flash-повідомлення <span id="flash-data"></span>

Flash-повідомлення - це особливий тип даних у сесії, які встановлюються один раз під час запиту і доступні лише протягом наступного запиту, після чого вони автоматично видаляються. Такий спосіб зберігання інформації в сесії найчастіше використовується для реалізації повідомлень, які будуть відображені кінцевому користувачу один раз, наприклад, підтвердження про успішну відправку форми.

Встановити та отримати flash-повідомлення можна через компонент програми `session`. Наприклад:

```php
$session = Yii::$app->session;

// Запит #1
// встановлення flash-повідомлення з назвою "postDeleted"
$session->setFlash('postDeleted', 'Ви успішно видалили пост.');

// Запит #2
// відображення flash-повідомлення "postDeleted"
echo $session->getFlash('postDeleted');

// Запит #3
// змінна $result буде мати значення false, оскільки flash-повідомлення було автоматично видалено
$result = $session->hasFlash('postDeleted');
```

Оскільки flash-повідомлення зберігаються в сесії як звичайні дані, в них можна записувати довільну інформацію, і вона буде доступна лише в наступному запиті.

При виклику [[yii\web\Session::setFlash()]] відбувається перезаписування flash-повідомлень з таким же назвою. Для того, щоб додати нові дані до вже існуючого flash-повідомлення, необхідно викликати [[yii\web\Session::addFlash()]]. 
Наприклад:

```php
$session = Yii::$app->session;

// Запит #1
// додати нове flash-повідомлення з назвою "alerts"
$session->addFlash('alerts', 'Ви успішно видалили пост.');
$session->addFlash('alerts', 'Ви успішно додали нового друга.');
$session->addFlash('alerts', 'Дякуємо.');

// Запит #2
// Змінна $alerts тепер містить масив flash-повідомлень з назвою "alerts"
$alerts = $session->getFlash('alerts');
```

> Note: Намагайтеся не використовувати [[yii\web\Session::setFlash()]] спільно з [[yii\web\Session::addFlash()]] для flash-повідомлень з однаковою назвою. Це пов'язано з тим, що останній метод автоматично перетворює збережені дані в масив, щоб мати можливість зберігати та додавати нові дані в flash-повідомлення з тією ж назвою. В результаті, при виклику [[yii\web\Session::getFlash()]] можна виявити, що повертається масив, тоді як очікувалася строка.

## Кукі <span id="cookies"></span>

Yii представляє кожну з cookie як об'єкт [[yii\web\Cookie]]. Обидва компоненти програми [[yii\web\Request]] і [[yii\web\Response]] 
підтримують колекції кукі через своє властивість cookies. У першому випадку колекція кукі є їх представленням з HTTP-запиту, у другому — представляє кукі, які будуть відправлені користувачу.

### Читання кукі <span id="reading-cookies"></span>

Отримати кукі з поточного запиту можна наступним чином:

```php
// отримання колекції кукі (yii\web\CookieCollection) з компонента "request"
$cookies = Yii::$app->request->cookies;

// отримання кукі з назвою "language". Якщо кукі не існує, "en" буде повернуто як значення за замовчуванням.
$language = $cookies->getValue('language', 'en');

// альтернативний спосіб отримання кукі "language"
if (($cookie = $cookies->get('language')) !== null) {
    $language = $cookie->value;
}

// тепер змінну $cookies можна використовувати як масив
if (isset($cookies['language'])) {
    $language = $cookies['language']->value;
}

// перевірка на існування кукі "language"
if ($cookies->has('language')) ...
if (isset($cookies['language'])) ...
```


### Відправка кукі <span id="sending-cookies"></span>

Відправити кукі кінцевому користувачу можна наступним чином:

```php
// отримання колекції (yii\web\CookieCollection) з компонента "response"
$cookies = Yii::$app->response->cookies;

// додавання нової кукі в HTTP-відповідь
$cookies->add(new \yii\web\Cookie([
    'name' => 'language',
    'value' => 'zh-CN',
]));

// видалення кукі...
$cookies->remove('language');
// ...що еквівалентно наступному:
unset($cookies['language']);
```

Крім властивостей [[yii\web\Cookie::name|name]] та [[yii\web\Cookie::value|value]], клас [[yii\web\Cookie]] також надає ряд властивостей для отримання інформації про куки: [[yii\web\Cookie::domain|domain]], [[yii\web\Cookie::expire|expire]]. Ці властивості можна сконфігурувати, а потім додати кукі в колекцію для HTTP-відповіді.

> Note: Для більшої безпеки значення властивості [[yii\web\Cookie::httpOnly]] за замовчуванням встановлено в `true`. Це зменшує ризики доступу до захищеної кукі на клієнтській стороні (якщо браузер підтримує таку можливість). Ви можете звернутися до [httpOnly wiki](https://owasp.org/www-community/HttpOnly) для додаткової інформації.

### Валідація кукі <span id="cookie-validation"></span>

Під час запису та читання куків через компоненти `request` та `response`, як буде показано в двох наступних підрозділах, фреймворк надає автоматичну валідацію, яка забезпечує захист кукі від модифікації на стороні клієнта. Це досягається завдяки підписанню кожної кукі секретним ключем, що дозволяє додатку розпізнавати кукі, які були модифіковані на клієнтській стороні. У такому випадку кукі НЕ БУДЕ доступна через властивість [[yii\web\Request::cookies|cookie collection]] компонента `request`.

> Note: Валідація кукі захищає тільки від їх модифікації. Якщо валідація не була пройдена, отримати доступ до кукі все ще можна через глобальну змінну `$_COOKIE`. Це пов'язано з тим, що додаткові пакети та бібліотеки можуть маніпулювати кукі без виклику валідації, яку забезпечує Yii.


За замовчуванням валідація кукі увімкнена. Її можна вимкнути, встановивши властивість [[yii\web\Request::enableCookieValidation]] в `false`, однак ми настійливо не рекомендуємо цього робити.

> Note: Кукі, які безпосередньо читаються/пишуться через `$_COOKIE` та `setcookie()`, НЕ БУДУТЬ валідовуватися.

При використанні валідації кукі необхідно вказати значення властивості [[yii\web\Request::cookieValidationKey]], яке буде використано для генерації згаданого вище секретного ключа. Це можна зробити, налаштувавши компонент `request` у конфігурації додатка:

```php
return [
    'components' => [
        'request' => [
            'cookieValidationKey' => 'fill in a secret key here',
        ],
    ],
];
```

> Note: Властивість [[yii\web\Request::cookieValidationKey|cookieValidationKey]] є секретним значенням і повинно бути відомо лише тим, кому ви довіряєте. Не розміщуйте цю інформацію в системі контролю версій.
