設計上の決定
============

この文書は、私たちが詳細な議論の末に達した設計上の決定を記載するものです。
非常に強固な理由があるのでない限りは、これらの決定は一貫性のために守られなければなりません。
これらの決定に対するいかなる変更もコア開発者間の同意を得なければなりません。

1. **[いかなる時にパス・エイリアスをサポートするか](https://github.com/yiisoft/yii2/pull/3079#issuecomment-40312268)**
   構成情報にパス・エイリアスを使用することは非常に利便性が高いため、構成可能なプロパティに対してはパス・エイリアスをサポートすべきである。
   その他の場合には、パス・エイリアスに対するサポートを制限すべきである。
2. **いかなる時にメッセージを翻訳するか**
   技術者でないエンド・ユーザに対して表示され、また、そういうユーザに対して意味を持つメッセージは翻訳されるべきである。
   HTTP ステータス・メッセージ、コードに関する例外などは翻訳されるべきではない。
   コンソール・メッセージは、エンコーディングとコード・ページの処理に困難が伴うため、常に英語で表示されるものとする。
3. **[認証クライアントのサポートの追加](https://github.com/yiisoft/yii2/issues/1652)**
   保守性を高めるために、コア・エクステンションには認証クライアントをこれ以上追加しない。
   認証クライアントの追加はユーザ・エクステンションの形でなされるべきである。
4. **クロージャを使うときは**、たとえ使用されないものがある場合でも、**渡されるすべてのパラメータをシグニチャに含める** ことが推奨される。
   このようにすると、全ての情報が直接に見えるので、コードの修正やコピーがより容易になり、どのパラメータが実際に利用できるかをドキュメントで調べる必要がなくなる。
   ([#6584](https://github.com/yiisoft/yii2/pull/6584), [#6875](https://github.com/yiisoft/yii2/issues/6875))
5. データベース・スキーマでは **unsigned int より int** を使う。
   int を使うと、PHP で整数として表現できるという利点がある。
   unsigned の場合、32 bit システムでは、文字列を使って表現しなければならなくなる。
   また、unsigned int はサイズを倍にするとはいうものの、そのような広大な数値空間を必要とするテーブルを持っている場合は、unsigned に頼るより bigint または mediumint を使用する方が安全である。
   <https://github.com/yiisoft/yii/pull/1923#issuecomment-11881967>
6. [ヘルパか、独立した非スタティックなクラスか](https://github.com/yiisoft/yii2/pull/12661#issuecomment-251599463)
7. **セッター・メソッド・チェイニング** は、意味のある値を返すメソッドがそのクラスに存在する場合は、避けるべきである。
   チェイニングは、クラスがビルダーであり、全てのセッターが内部状態を修正するものである場合にサポートされうる。https://github.com/yiisoft/yii2/issues/13026
8. ローカルな try-catch の替りに **グローバルな例外/エラーハンドラ** が使われる。なぜなら、その方が、ブートストラップなどのように `run()` メソッドのスコープ外で発生するデストラクタなど全てのものをキャッチする点において信頼性が高いからである。[#14348](https://github.com/yiisoft/yii2/issues/14348) を参照。
