
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `zenphoto168`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrators`
--

CREATE TABLE `[[dbprefix]]administrators` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(64) COLLATE [[collation]] NOT NULL,
  `pass` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `passhash` int(1) DEFAULT NULL,
  `passupdate` datetime DEFAULT NULL,
  `name` text COLLATE [[collation]],
  `email` text COLLATE [[collation]],
  `rights` int(11) DEFAULT NULL,
  `custom_data` text COLLATE [[collation]],
  `valid` int(1) NOT NULL DEFAULT '1',
  `group` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `loggedin` datetime DEFAULT NULL,
  `lastloggedin` datetime DEFAULT NULL,
  `quota` int(11) DEFAULT NULL,
  `language` varchar(5) COLLATE [[collation]] DEFAULT NULL,
  `prime_album` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `other_credentials` text COLLATE [[collation]],
  `challenge_phrase` text COLLATE [[collation]],
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `lastvisit` datetime DEFAULT NULL,
  `street` tinytext COLLATE [[collation]],
  `website` tinytext COLLATE [[collation]],
  `city` tinytext COLLATE [[collation]],
  `country` tinytext COLLATE [[collation]],
  `state` tinytext COLLATE [[collation]],
  `postal` tinytext COLLATE [[collation]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`,`valid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]administrators`
--

INSERT INTO `[[dbprefix]]administrators` VALUES
(1, 'administrators', NULL, NULL, NULL, 'group', NULL, 1996419053, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Users with full privileges', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'viewers', NULL, NULL, NULL, 'group', NULL, 9985, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Users allowed only to view zenphoto objects', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'blocked', NULL, NULL, NULL, 'group', NULL, 0, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Banned users', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(4, 'album managers', NULL, NULL, NULL, 'template', NULL, 68216581, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Managers of one or more albums', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'default', NULL, NULL, NULL, 'template', NULL, 10084, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Default user settings', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'newuser', NULL, NULL, NULL, 'template', NULL, 1, NULL, 0, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 'Newly registered and verified users', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, '[[admin_username]]', '[[admin_pass]]', 3, '[[regtime]]', '[[admin_realname]]', '[[admin_email]]', 1996419053, NULL, 1, NULL, '[[regtime]]', NULL, NULL, NULL, '[[language]]', NULL, NULL, NULL, '[[regtime]]', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_to_object`
--

CREATE TABLE `[[dbprefix]]admin_to_object` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `adminid` int(11) unsigned NOT NULL,
  `objectid` int(11) unsigned NOT NULL,
  `type` varchar(32) COLLATE [[collation]] DEFAULT 'album',
  `edit` int(11) DEFAULT '32767',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums`
--

CREATE TABLE `[[dbprefix]]albums` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(11) unsigned DEFAULT NULL,
  `folder` varchar(255) COLLATE [[collation]] NOT NULL DEFAULT '',
  `title` text COLLATE [[collation]],
  `desc` text COLLATE [[collation]],
  `date` datetime DEFAULT NULL,
  `updateddate` datetime DEFAULT NULL,
  `location` text COLLATE [[collation]],
  `show` int(1) unsigned NOT NULL DEFAULT '1',
  `closecomments` int(1) unsigned NOT NULL DEFAULT '0',
  `commentson` int(1) unsigned NOT NULL DEFAULT '1',
  `thumb` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `mtime` int(32) DEFAULT NULL,
  `sort_type` varchar(128) COLLATE [[collation]] DEFAULT NULL,
  `subalbum_sort_type` varchar(128) COLLATE [[collation]] DEFAULT NULL,
  `sort_order` int(11) unsigned DEFAULT NULL,
  `image_sortdirection` int(1) unsigned DEFAULT '0',
  `album_sortdirection` int(1) unsigned DEFAULT '0',
  `hitcounter` int(11) unsigned DEFAULT '0',
  `password` varchar(255) COLLATE [[collation]] NOT NULL DEFAULT '',
  `password_hint` text COLLATE [[collation]],
  `publishdate` datetime DEFAULT NULL,
  `expiredate` datetime DEFAULT NULL,
  `total_value` int(11) DEFAULT '0',
  `total_votes` int(11) DEFAULT '0',
  `used_ips` longtext COLLATE [[collation]],
  `custom_data` text COLLATE [[collation]],
  `dynamic` int(1) DEFAULT '0',
  `search_params` text COLLATE [[collation]],
  `album_theme` varchar(127) COLLATE [[collation]] DEFAULT NULL,
  `user` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `rating` float DEFAULT NULL,
  `rating_status` int(1) DEFAULT '3',
  `watermark` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `watermark_thumb` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `owner` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `codeblock` text COLLATE [[collation]],
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `folder` (`folder`(191)),
  KEY `albums_parentid` (`parentid`),
  KEY `albums_dynamic_parentid` (`dynamic`,`parentid`),
  KEY `albums_dynamic_parentid_show` (`dynamic`,`parentid`,`show`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]captcha`
--

CREATE TABLE `[[dbprefix]]captcha` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ptime` int(32) unsigned NOT NULL,
  `hash` varchar(255) COLLATE [[collation]] NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ownerid` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE [[collation]] NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE [[collation]] NOT NULL DEFAULT '',
  `website` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `comment` text COLLATE [[collation]],
  `inmoderation` int(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(52) COLLATE [[collation]] DEFAULT 'images',
  `IP` text COLLATE [[collation]],
  `private` int(1) DEFAULT '0',
  `anon` int(1) DEFAULT '0',
  `custom_data` text COLLATE [[collation]],
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ownerid` (`ownerid`),
  KEY `ownerid_2` (`ownerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images`
--

CREATE TABLE `[[dbprefix]]images` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `albumid` int(11) unsigned DEFAULT NULL,
  `filename` varchar(255) COLLATE [[collation]] NOT NULL DEFAULT '',
  `title` text COLLATE [[collation]],
  `desc` text COLLATE [[collation]],
  `location` text COLLATE [[collation]],
  `city` tinytext COLLATE [[collation]],
  `state` tinytext COLLATE [[collation]],
  `country` tinytext COLLATE [[collation]],
  `credit` text COLLATE [[collation]],
  `copyright` text COLLATE [[collation]],
  `commentson` int(1) unsigned NOT NULL DEFAULT '1',
  `show` int(1) NOT NULL DEFAULT '1',
  `date` datetime DEFAULT NULL,
  `sort_order` int(11) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `width` int(10) unsigned DEFAULT NULL,
  `thumbX` int(10) unsigned DEFAULT NULL,
  `thumbY` int(10) unsigned DEFAULT NULL,
  `thumbW` int(10) unsigned DEFAULT NULL,
  `thumbH` int(10) unsigned DEFAULT NULL,
  `mtime` int(32) DEFAULT NULL,
  `publishdate` datetime DEFAULT NULL,
  `expiredate` datetime DEFAULT NULL,
  `hitcounter` int(11) unsigned DEFAULT '0',
  `total_value` int(11) unsigned DEFAULT '0',
  `total_votes` int(11) unsigned DEFAULT '0',
  `used_ips` longtext COLLATE [[collation]],
  `custom_data` text COLLATE [[collation]],
  `rating` float DEFAULT NULL,
  `rating_status` int(1) DEFAULT '3',
  `hasMetadata` int(1) DEFAULT '0',
  `watermark` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `watermark_use` int(1) DEFAULT '7',
  `owner` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `filesize` int(11) DEFAULT NULL,
  `codeblock` text COLLATE [[collation]],
  `user` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password_hint` text COLLATE [[collation]],
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `EXIFMake` mediumtext COLLATE [[collation]],
  `EXIFModel` mediumtext COLLATE [[collation]],
  `EXIFDescription` mediumtext COLLATE [[collation]],
  `IPTCObjectName` mediumtext COLLATE [[collation]],
  `IPTCImageHeadline` mediumtext COLLATE [[collation]],
  `IPTCImageCaption` mediumtext COLLATE [[collation]],
  `IPTCImageCaptionWriter` mediumtext COLLATE [[collation]],
  `EXIFDateTime` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFDateTimeOriginal` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFDateTimeDigitized` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `IPTCDateCreated` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `IPTCTimeCreated` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `IPTCDigitizeDate` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `IPTCDigitizeTime` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFArtist` mediumtext COLLATE [[collation]],
  `IPTCImageCredit` mediumtext COLLATE [[collation]],
  `IPTCByLine` mediumtext COLLATE [[collation]],
  `IPTCByLineTitle` mediumtext COLLATE [[collation]],
  `IPTCSource` mediumtext COLLATE [[collation]],
  `IPTCContact` mediumtext COLLATE [[collation]],
  `EXIFCopyright` mediumtext COLLATE [[collation]],
  `IPTCCopyright` mediumtext COLLATE [[collation]],
  `IPTCKeywords` mediumtext COLLATE [[collation]],
  `EXIFExposureTime` mediumtext COLLATE [[collation]],
  `EXIFFNumber` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFISOSpeedRatings` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFExposureBiasValue` mediumtext COLLATE [[collation]],
  `EXIFMeteringMode` mediumtext COLLATE [[collation]],
  `EXIFFlash` mediumtext COLLATE [[collation]],
  `EXIFImageWidth` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFImageHeight` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFOrientation` mediumtext COLLATE [[collation]],
  `EXIFSoftware` mediumtext COLLATE [[collation]],
  `EXIFContrast` mediumtext COLLATE [[collation]],
  `EXIFSharpness` mediumtext COLLATE [[collation]],
  `EXIFSaturation` mediumtext COLLATE [[collation]],
  `EXIFWhiteBalance` mediumtext COLLATE [[collation]],
  `EXIFSubjectDistance` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFFocalLength` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFLensType` mediumtext COLLATE [[collation]],
  `EXIFLensInfo` mediumtext COLLATE [[collation]],
  `EXIFFocalLengthIn35mmFilm` mediumtext COLLATE [[collation]],
  `IPTCCity` mediumtext COLLATE [[collation]],
  `IPTCSubLocation` mediumtext COLLATE [[collation]],
  `IPTCState` mediumtext COLLATE [[collation]],
  `IPTCLocationCode` mediumtext COLLATE [[collation]],
  `IPTCLocationName` mediumtext COLLATE [[collation]],
  `IPTCContentLocationCode` mediumtext COLLATE [[collation]],
  `IPTCContentLocationName` mediumtext COLLATE [[collation]],
  `EXIFGPSLatitude` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFGPSLatitudeRef` mediumtext COLLATE [[collation]],
  `EXIFGPSLongitude` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFGPSLongitudeRef` mediumtext COLLATE [[collation]],
  `EXIFGPSAltitude` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `EXIFGPSAltitudeRef` mediumtext COLLATE [[collation]],
  `IPTCOriginatingProgram` mediumtext COLLATE [[collation]],
  `IPTCProgramVersion` mediumtext COLLATE [[collation]],
  `VideoFormat` mediumtext COLLATE [[collation]],
  `VideoSize` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoArtist` mediumtext COLLATE [[collation]],
  `VideoTitle` mediumtext COLLATE [[collation]],
  `VideoBitrate` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoBitrate_mode` mediumtext COLLATE [[collation]],
  `VideoBits_per_sample` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoCodec` mediumtext COLLATE [[collation]],
  `VideoCompression_ratio` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoDataformat` mediumtext COLLATE [[collation]],
  `VideoEncoder` mediumtext COLLATE [[collation]],
  `VideoSamplerate` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoChannelmode` mediumtext COLLATE [[collation]],
  `VideoChannels` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoFramerate` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoResolution_x` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoResolution_y` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoAspect_ratio` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `VideoPlaytime` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `XMPrating` mediumtext COLLATE [[collation]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `filename` (`filename`(191),`albumid`),
  KEY `albumid` (`albumid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu`
--

CREATE TABLE `[[dbprefix]]menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(11) unsigned DEFAULT NULL,
  `title` text COLLATE [[collation]],
  `link` varchar(255) COLLATE [[collation]] NOT NULL,
  `include_li` int(1) unsigned DEFAULT '1',
  `type` varchar(16) COLLATE [[collation]] NOT NULL,
  `sort_order` varchar(48) COLLATE [[collation]] NOT NULL DEFAULT '',
  `show` int(1) unsigned NOT NULL DEFAULT '1',
  `menuset` varchar(32) COLLATE [[collation]] NOT NULL,
  `span_class` varchar(32) COLLATE [[collation]] DEFAULT NULL,
  `span_id` varchar(32) COLLATE [[collation]] DEFAULT NULL,
  `open_newtab` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news`
--

CREATE TABLE `[[dbprefix]]news` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE [[collation]],
  `content` longtext COLLATE [[collation]],
  `extracontent` text COLLATE [[collation]],
  `show` int(1) unsigned NOT NULL DEFAULT '1',
  `date` datetime DEFAULT NULL,
  `titlelink` varchar(255) COLLATE [[collation]] NOT NULL,
  `commentson` int(1) unsigned DEFAULT '0',
  `codeblock` text COLLATE [[collation]],
  `author` varchar(64) COLLATE [[collation]] NOT NULL,
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `hitcounter` int(11) unsigned DEFAULT '0',
  `permalink` int(1) unsigned NOT NULL DEFAULT '0',
  `locked` int(1) unsigned NOT NULL DEFAULT '0',
  `expiredate` datetime DEFAULT NULL,
  `total_value` int(11) unsigned DEFAULT '0',
  `total_votes` int(11) unsigned DEFAULT '0',
  `used_ips` longtext COLLATE [[collation]],
  `rating` float DEFAULT NULL,
  `rating_status` int(1) DEFAULT '3',
  `sticky` int(1) DEFAULT '0',
  `custom_data` text COLLATE [[collation]],
  `truncation` int(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `titlelink` (`titlelink`(191))
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news2cat`
--

CREATE TABLE `[[dbprefix]]news2cat` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) unsigned NOT NULL,
  `news_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news_categories`
--

CREATE TABLE `[[dbprefix]]news_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE [[collation]],
  `titlelink` varchar(255) COLLATE [[collation]] NOT NULL,
  `permalink` int(1) unsigned NOT NULL DEFAULT '0',
  `hitcounter` int(11) unsigned DEFAULT '0',
  `user` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password_hint` text COLLATE [[collation]],
  `parentid` int(11) DEFAULT NULL,
  `sort_order` varchar(48) COLLATE [[collation]] DEFAULT NULL,
  `desc` text COLLATE [[collation]],
  `custom_data` text COLLATE [[collation]],
  `show` int(1) unsigned NOT NULL DEFAULT '1',
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `titlelink` (`titlelink`(191))
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]obj_to_tag`
--

CREATE TABLE `[[dbprefix]]obj_to_tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tagid` int(11) unsigned NOT NULL,
  `type` tinytext COLLATE [[collation]],
  `objectid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tagid` (`tagid`),
  KEY `objectid` (`objectid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]options`
--

CREATE TABLE `[[dbprefix]]options` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ownerid` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE [[collation]] NOT NULL,
  `value` text COLLATE [[collation]],
  `theme` varchar(127) COLLATE [[collation]] NOT NULL,
  `creator` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_option` (`name`(95),`ownerid`,`theme`(95))
) ENGINE=InnoDB  DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1133 ;

--
-- Dumping data for table `[[dbprefix]]options`
--

INSERT INTO `[[dbprefix]]options` VALUES
(1, 0, 'zenphoto_install', '', '', NULL),
(2, 0, 'setup_unprotected_by_adminrequest', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(4, 0, 'libauth_version', '4', '', NULL),
(5, 0, 'strong_hash', '3', '', NULL),
(6, 0, 'extra_auth_hash_text', '[[extra_hash]]', '', 'zp-core/setup/setup-option-defaults.php'),
(7, 0, 'password_strength', '10', '', 'zp-core/setup/setup-option-defaults.php'),
(8, 0, 'min_password_lenght', '6', '', 'zp-core/setup/setup-option-defaults.php'),
(9, 0, 'user_album_edit_default', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(10, 0, 'time_offset', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(11, 0, 'mod_rewrite_detected', '0', '', NULL),
(12, 0, 'server_protocol', 'http', '', 'zp-core/setup/setup-option-defaults.php'),
(13, 0, 'charset', 'UTF-8', '', 'zp-core/setup/setup-option-defaults.php'),
(14, 0, 'filesystem_charset', 'UTF-8', '', 'zp-core/setup/setup-option-defaults.php'),
(15, 0, 'image_quality', '85', '', 'zp-core/setup/setup-option-defaults.php'),
(16, 0, 'thumb_quality', '75', '', 'zp-core/setup/setup-option-defaults.php'),
(17, 0, 'search_password', '', '', 'zp-core/setup/setup-option-defaults.php'),
(18, 0, 'watermark_h_offset', '90', '', 'zp-core/setup/setup-option-defaults.php'),
(19, 0, 'watermark_w_offset', '90', '', 'zp-core/setup/setup-option-defaults.php'),
(20, 0, 'watermark_scale', '5', '', 'zp-core/setup/setup-option-defaults.php'),
(21, 0, 'perform_video_watermark', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(22, 0, 'image_sorttype', 'Filename', '', 'zp-core/setup/setup-option-defaults.php'),
(23, 0, 'image_sortdirection', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(24, 0, 'hotlink_protection', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(25, 0, 'search_fields', 'title,desc,tags,file,location,city,state,country,content,author', '', 'zp-core/setup/setup-option-defaults.php'),
(26, 0, 'allowed_tags_default', 'abbr =>(class=>() id=>() title =>() lang=>())\nacronym =>(class=>() id=>() title =>() lang=>())\nb => (class=>() id=>() lang=>())\nblockquote =>(class=>() id=>() cite =>() lang=>())\nbr => (class=>() id=>())\ncode => (class=>() id=>() lang=>())\nem => (class=>() id=>() lang=>())\ni => (class=>() id=>() lang=>())\nstrike => (class=>() id=>() lang=>())\nstrong => (class=>() id=>() lang=>())\nsup => (class=>() id=>() lang=>())\nsub => (class=>() id=>() lang=>())\ndel => (class=>() id=>() lang=>())\na => (href =>() title =>() target=>() class=>() id=>() rel=>() lang=>())\nul =>(class=>() id=>() lang=>())\nol =>(class=>() id=>() lang=>())\nli =>(class=>() id=>() lang=>())\ndl =>(class=>() id=>() lang=>())\ndt =>(class=>() id=>() lang=>())\ndd =>(class=>() id=>() lang=>())\np => (class=>() id=>() style=>() lang=>())\nh1=>(class=>() id=>() style=>() lang=>())\nh2=>(class=>() id=>() style=>() lang=>())\nh3=>(class=>() id=>() style=>() lang=>())\nh4=>(class=>() id=>() style=>() lang=>())\nh5=>(class=>() id=>() style=>() lang=>())\nh6=>(class=>() id=>() style=>() lang=>())\npre=>(class=>() id=>() style=>() lang=>())\naddress=>(class=>() id=>() style=>() lang=>())\nspan=>(class=>() id=>() style=>() lang=>())\ndiv=>(class=>() id=>() style=>() lang=>())\nimg=>(class=>() id=>() style=>() src=>() title=>() alt=>() width=>() height=>() sizes=>() srcset=>() loading=>() lang=>())\niframe=>(class=>() id=>() style=>() src=>() title=>() width=>() height=>() loading=>() lang=>())\nfigure=>(class=>() id=>() style=>() lang=>())\nfigcaption=>(class=>() id=>() style=>() lang=>())\narticle=>(class=>() id=>() style=>() lang=>())\nsection => (class=>() id=>() style=>() lang=>())\nnav => (class=>() id=>() style=>() lang=>())\nvideo => (class=>() id=>() style=>() src=>() controls=>() autoplay=>() buffered=>() height=>() width=>() loop=>() muted=>() preload=>() poster=>() lang=>())\naudio => (class=>() id=>() style=>() src=>() controls=>() autoplay=>() buffered=>() height=>() width=>() loop=>() muted=>() preload=>() volume=>() lang=>())\npicture=>(class=>() id=>() lang=>())\nsource=>(src=>() scrset=>() size=>() type=>() media=>() lang=>())\ntrack=>(src=>() kind=>() srclang=>() label=>() default=>() lang=>())\ntable => (class=>() id=>() lang=>())\ncaption => (class=>() id=>() lang=>())\nth => (class=>() id=>() lang=>())\ntr => (class=>() id=>() lang=>())\ntd => (class=>() id=>() colspan=>() lang=>())\nthead => (class=>() id=>() lang=>())\ntbody => (class=>() id=>() lang=>())\ntfoot => (class=>() id=>() lang=>())\ncolgroup => (class=>() id=>() lang=>())\ncol => (class=>() id=>() lang=>())\nform => (action=>() method=>() accept-charset=>() id=>() class=>() title=>() name=>() target=>() lang=>())\n', '', NULL),
(27, 0, 'allowed_tags', 'abbr =>(class=>() id=>() title =>() lang=>())\nacronym =>(class=>() id=>() title =>() lang=>())\nb => (class=>() id=>() lang=>())\nblockquote =>(class=>() id=>() cite =>() lang=>())\nbr => (class=>() id=>())\ncode => (class=>() id=>() lang=>())\nem => (class=>() id=>() lang=>())\ni => (class=>() id=>() lang=>())\nstrike => (class=>() id=>() lang=>())\nstrong => (class=>() id=>() lang=>())\nsup => (class=>() id=>() lang=>())\nsub => (class=>() id=>() lang=>())\ndel => (class=>() id=>() lang=>())\na => (href =>() title =>() target=>() class=>() id=>() rel=>() lang=>())\nul =>(class=>() id=>() lang=>())\nol =>(class=>() id=>() lang=>())\nli =>(class=>() id=>() lang=>())\ndl =>(class=>() id=>() lang=>())\ndt =>(class=>() id=>() lang=>())\ndd =>(class=>() id=>() lang=>())\np => (class=>() id=>() style=>() lang=>())\nh1=>(class=>() id=>() style=>() lang=>())\nh2=>(class=>() id=>() style=>() lang=>())\nh3=>(class=>() id=>() style=>() lang=>())\nh4=>(class=>() id=>() style=>() lang=>())\nh5=>(class=>() id=>() style=>() lang=>())\nh6=>(class=>() id=>() style=>() lang=>())\npre=>(class=>() id=>() style=>() lang=>())\naddress=>(class=>() id=>() style=>() lang=>())\nspan=>(class=>() id=>() style=>() lang=>())\ndiv=>(class=>() id=>() style=>() lang=>())\nimg=>(class=>() id=>() style=>() src=>() title=>() alt=>() width=>() height=>() sizes=>() srcset=>() loading=>() lang=>())\niframe=>(class=>() id=>() style=>() src=>() title=>() width=>() height=>() loading=>() lang=>())\nfigure=>(class=>() id=>() style=>() lang=>())\nfigcaption=>(class=>() id=>() style=>() lang=>())\narticle=>(class=>() id=>() style=>() lang=>())\nsection => (class=>() id=>() style=>() lang=>())\nnav => (class=>() id=>() style=>() lang=>())\nvideo => (class=>() id=>() style=>() src=>() controls=>() autoplay=>() buffered=>() height=>() width=>() loop=>() muted=>() preload=>() poster=>() lang=>())\naudio => (class=>() id=>() style=>() src=>() controls=>() autoplay=>() buffered=>() height=>() width=>() loop=>() muted=>() preload=>() volume=>() lang=>())\npicture=>(class=>() id=>() lang=>())\nsource=>(src=>() scrset=>() size=>() type=>() media=>() lang=>())\ntrack=>(src=>() kind=>() srclang=>() label=>() default=>() lang=>())\ntable => (class=>() id=>() lang=>())\ncaption => (class=>() id=>() lang=>())\nth => (class=>() id=>() lang=>())\ntr => (class=>() id=>() lang=>())\ntd => (class=>() id=>() colspan=>() lang=>())\nthead => (class=>() id=>() lang=>())\ntbody => (class=>() id=>() lang=>())\ntfoot => (class=>() id=>() lang=>())\ncolgroup => (class=>() id=>() lang=>())\ncol => (class=>() id=>() lang=>())\nform => (action=>() method=>() accept-charset=>() id=>() class=>() title=>() name=>() target=>() lang=>())\n', '', 'zp-core/setup/setup-option-defaults.php'),
(28, 0, 'style_tags', 'abbr =>(class=>() id=>() title =>() lang=>())\nacronym =>(class=>() id=>() title =>() lang=>())\nb => (class=>() id=>() lang=>())\nblockquote =>(class=>() id=>() cite =>() lang=>())\nbr => (class=>() id=>())\ncode => (class=>() id=>() lang=>())\nem => (class=>() id=>() lang=>())\ni => (class=>() id=>() lang=>())\nstrike => (class=>() id=>() lang=>())\nstrong => (class=>() id=>() lang=>())\nsup => (class=>() id=>() lang=>())\nsub => (class=>() id=>() lang=>())\ndel => (class=>() id=>() lang=>())\n', '', 'zp-core/setup/setup-option-defaults.php'),
(29, 0, 'daily_logs', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(30, 0, 'full_image_quality', '75', '', 'zp-core/setup/setup-option-defaults.php'),
(31, 0, 'protect_full_image', 'protected', '', 'zp-core/setup/setup-option-defaults.php'),
(32, 0, 'locale', '', '', 'zp-core/setup/setup-option-defaults.php'),
(33, 0, 'date_format', 'Y-m-d', '', 'zp-core/setup/setup-option-defaults.php'),
(34, 0, 'date_format_localized', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(35, 0, 'use_lock_image', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(36, 0, 'search_user', '', '', 'zp-core/setup/setup-option-defaults.php'),
(37, 0, 'multi_lingual', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(38, 0, 'tagsort', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(39, 0, 'albumimagesort', 'ID', '', 'zp-core/setup/setup-option-defaults.php'),
(40, 0, 'albumimagedirection', 'DESC', '', 'zp-core/setup/setup-option-defaults.php'),
(41, 0, 'albumimagesort_status', 'all', '', 'zp-core/setup/setup-option-defaults.php'),
(42, 0, 'cache_full_image', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(43, 0, 'custom_index_page', '', '', 'zp-core/setup/setup-option-defaults.php'),
(44, 0, 'picture_of_the_day', 'a:3:{s:3:"day";N;s:6:"folder";N;s:8:"filename";N;}', '', 'zp-core/setup/setup-option-defaults.php'),
(45, 0, 'exact_tag_match', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(46, 0, 'image_max_size', '3000', '', 'zp-core/setup/setup-option-defaults.php'),
(47, 0, 'EXIFMake', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(48, 0, 'EXIFModel', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(49, 0, 'EXIFExposureTime', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(50, 0, 'EXIFFNumber', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(51, 0, 'EXIFFocalLength', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(52, 0, 'EXIFISOSpeedRatings', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(53, 0, 'EXIFDateTimeOriginal', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(54, 0, 'EXIFExposureBiasValue', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(55, 0, 'EXIFMeteringMode', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(56, 0, 'EXIFFlash', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(59, 0, 'EXIFDescription', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(60, 0, 'IPTCObjectName', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(61, 0, 'IPTCImageHeadline', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(62, 0, 'IPTCImageCaption', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(63, 0, 'IPTCImageCaptionWriter', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(64, 0, 'EXIFDateTime', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(66, 0, 'EXIFDateTimeDigitized', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(67, 0, 'IPTCDateCreated', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(68, 0, 'IPTCTimeCreated', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(69, 0, 'IPTCDigitizeDate', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(70, 0, 'IPTCDigitizeTime', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(71, 0, 'EXIFArtist', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(72, 0, 'IPTCImageCredit', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(73, 0, 'IPTCByLine', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(74, 0, 'IPTCByLineTitle', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(75, 0, 'IPTCSource', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(76, 0, 'IPTCContact', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(77, 0, 'EXIFCopyright', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(78, 0, 'IPTCCopyright', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(79, 0, 'IPTCKeywords', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(86, 0, 'EXIFImageWidth', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(87, 0, 'EXIFImageHeight', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(88, 0, 'EXIFOrientation', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(89, 0, 'EXIFSoftware', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(90, 0, 'EXIFContrast', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(91, 0, 'EXIFSharpness', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(92, 0, 'EXIFSaturation', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(93, 0, 'EXIFWhiteBalance', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(94, 0, 'EXIFSubjectDistance', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(96, 0, 'EXIFLensType', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(97, 0, 'EXIFLensInfo', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(98, 0, 'EXIFFocalLengthIn35mmFilm', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(99, 0, 'IPTCCity', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(100, 0, 'IPTCSubLocation', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(101, 0, 'IPTCState', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(102, 0, 'IPTCLocationCode', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(103, 0, 'IPTCLocationName', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(104, 0, 'IPTCContentLocationCode', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(105, 0, 'IPTCContentLocationName', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(106, 0, 'EXIFGPSLatitude', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(107, 0, 'EXIFGPSLatitudeRef', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(108, 0, 'EXIFGPSLongitude', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(109, 0, 'EXIFGPSLongitudeRef', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(110, 0, 'EXIFGPSAltitude', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(111, 0, 'EXIFGPSAltitudeRef', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(112, 0, 'IPTCOriginatingProgram', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(113, 0, 'IPTCProgramVersion', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(114, 0, 'VideoFormat', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(115, 0, 'VideoSize', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(116, 0, 'VideoArtist', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(117, 0, 'VideoTitle', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(118, 0, 'VideoBitrate', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(119, 0, 'VideoBitrate_mode', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(120, 0, 'VideoBits_per_sample', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(121, 0, 'VideoCodec', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(122, 0, 'VideoCompression_ratio', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(123, 0, 'VideoDataformat', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(124, 0, 'VideoEncoder', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(125, 0, 'VideoSamplerate', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(126, 0, 'VideoChannelmode', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(127, 0, 'VideoChannels', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(128, 0, 'VideoFramerate', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(129, 0, 'VideoResolution_x', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(130, 0, 'VideoResolution_y', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(131, 0, 'VideoAspect_ratio', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(132, 0, 'VideoPlaytime', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(133, 0, 'XMPrating', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(134, 0, 'IPTC_encoding', 'ISO-8859-1', '', 'zp-core/setup/setup-option-defaults.php'),
(135, 0, 'IPTC_convert_linebreaks', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(136, 0, 'metadata_refresh_behaviour', 'full-refresh', '', 'zp-core/setup/setup-option-defaults.php'),
(137, 0, 'UTF8_image_URI', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(138, 0, 'sharpen_amount', '40', '', 'zp-core/setup/setup-option-defaults.php'),
(139, 0, 'sharpen_radius', '0.5', '', 'zp-core/setup/setup-option-defaults.php'),
(140, 0, 'sharpen_threshold', '3', '', 'zp-core/setup/setup-option-defaults.php'),
(142, 0, 'search_no_albums', '0', '', 'zp-core/setup/setup-option-defaults.php'),
(143, 0, 'search_fieldsselector_enabled', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(144, 0, 'defined_groups', 'a:6:{i:0;s:14:"administrators";i:1;s:7:"viewers";i:2;s:7:"blocked";i:3;s:14:"album managers";i:4;s:7:"default";i:5;s:7:"newuser";}', '', NULL),
(145, 0, 'AlbumThumbSelect', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(146, 0, 'site_email', 'zenphoto@[[domhost]]', '', 'zp-core/setup/setup-option-defaults.php'),
(147, 0, 'site_email_name', 'Zenphoto', '', 'zp-core/setup/setup-option-defaults.php'),
(148, 0, 'Zenphoto_theme_list', 'a:4:{i:0;s:5:"basic";i:31;s:7:"garland";i:72;s:7:"zenpage";i:110;s:8:"zpmobile";}', '', NULL),
(149, 0, 'graphicslib_selected', 'gd', '', 'zp-core/classes/class-graphicsoptions.php'),
(150, 0, 'admin_lastvisit_timeframe', '600', '', 'zp-core/classes/class-authority.php'),
(151, 0, 'admin_lastvisit', '1', '', 'zp-core/classes/class-authority.php'),
(152, 0, 'Allow_search', '1', 'basic', 'themes/basic'),
(153, 0, 'Theme_colors', 'light', 'basic', 'themes/basic'),
(154, 0, 'albums_per_page', '6', 'basic', 'themes/basic'),
(155, 0, 'albums_per_row', '2', 'basic', 'themes/basic'),
(156, 0, 'images_per_page', '20', 'basic', 'themes/basic'),
(157, 0, 'images_per_row', '5', 'basic', 'themes/basic'),
(158, 0, 'image_size', '595', 'basic', 'themes/basic'),
(159, 0, 'image_use_side', 'longest', 'basic', 'themes/basic'),
(160, 0, 'thumb_size', '100', 'basic', 'themes/basic'),
(161, 0, 'thumb_crop_width', '100', 'basic', 'themes/basic'),
(162, 0, 'thumb_crop_height', '100', 'basic', 'themes/basic'),
(163, 0, 'thumb_crop', '1', 'basic', 'themes/basic'),
(164, 0, 'thumb_transition', '1', 'basic', 'themes/basic'),
(168, 0, 'cachemanager_defaultthumb', '1', '', NULL),
(169, 0, 'cachemanager_defaultsizedimage', '1', '', NULL),
(176, 0, 'thumb_use_side', 'longest', 'basic', 'themes/basic'),
(185, 0, 'Allow_search', '1', 'garland', 'themes/garland'),
(186, 0, 'Allow_cloud', '1', 'garland', 'themes/garland'),
(187, 0, 'albums_per_page', '6', 'garland', 'themes/garland'),
(188, 0, 'albums_per_row', '2', 'garland', 'themes/garland'),
(189, 0, 'images_per_page', '20', 'garland', 'themes/garland'),
(190, 0, 'images_per_row', '5', 'garland', 'themes/garland'),
(191, 0, 'image_size', '520', 'garland', 'themes/garland'),
(192, 0, 'image_use_side', 'longest', 'garland', 'themes/garland'),
(193, 0, 'thumb_transition', '1', 'garland', 'themes/garland'),
(194, 0, 'thumb_size', '85', 'garland', 'themes/garland'),
(195, 0, 'thumb_crop_width', '85', 'garland', 'themes/garland'),
(196, 0, 'thumb_crop_height', '85', 'garland', 'themes/garland'),
(197, 0, 'thumb_crop', '1', 'garland', 'themes/garland'),
(198, 0, 'garland_customHome', '', 'garland', 'themes/garland'),
(199, 0, 'garland_personality', 'image_page', 'garland', 'themes/garland'),
(200, 0, 'garland_transition', 'slide-hori', 'garland', 'themes/garland'),
(201, 0, 'garland_caption_location', 'image', 'garland', 'themes/garland'),
(205, 0, 'garland_menu', '', 'garland', 'themes/garland'),
(206, 0, 'custom_index_page', '', 'garland', 'themes/garland'),
(214, 0, 'thumb_use_side', 'longest', 'garland', 'themes/garland'),
(223, 0, 'zenpage_zp_index_news', '', 'zenpage', 'themes/zenpage'),
(224, 0, 'Allow_search', '1', 'zenpage', 'themes/zenpage'),
(225, 0, 'Use_thickbox', '1', 'zenpage', 'themes/zenpage'),
(226, 0, 'zenpage_homepage', 'none', 'zenpage', 'themes/zenpage'),
(227, 0, 'zenpage_contactpage', '1', 'zenpage', 'themes/zenpage'),
(228, 0, 'zenpage_custommenu', '', 'zenpage', 'themes/zenpage'),
(229, 0, 'albums_per_page', '6', 'zenpage', 'themes/zenpage'),
(230, 0, 'albums_per_row', '2', 'zenpage', 'themes/zenpage'),
(231, 0, 'images_per_page', '20', 'zenpage', 'themes/zenpage'),
(232, 0, 'images_per_row', '5', 'zenpage', 'themes/zenpage'),
(233, 0, 'image_size', '580', 'zenpage', 'themes/zenpage'),
(234, 0, 'image_use_side', 'longest', 'zenpage', 'themes/zenpage'),
(235, 0, 'thumb_size', '95', 'zenpage', 'themes/zenpage'),
(236, 0, 'thumb_crop_width', '95', 'zenpage', 'themes/zenpage'),
(237, 0, 'thumb_crop_height', '95', 'zenpage', 'themes/zenpage'),
(238, 0, 'thumb_crop', '1', 'zenpage', 'themes/zenpage'),
(239, 0, 'thumb_transition', '1', 'zenpage', 'themes/zenpage'),
(243, 0, 'custom_index_page', '', 'zenpage', 'themes/zenpage'),
(251, 0, 'thumb_use_side', 'longest', 'zenpage', 'themes/zenpage'),
(260, 0, 'Allow_search', '1', 'zpmobile', 'themes/zpmobile'),
(261, 0, 'thumb_transition', '1', 'zpmobile', 'themes/zpmobile'),
(262, 0, 'colorbox_default_album', '1', '', 'themes/zpmobile/themeoptions.php'),
(263, 0, 'colorbox_default_image', '1', '', 'themes/zpmobile/themeoptions.php'),
(264, 0, 'colorbox_default_search', '1', '', 'themes/zpmobile/themeoptions.php'),
(265, 0, 'thumb_size', '79', 'zpmobile', 'themes/zpmobile'),
(266, 0, 'thumb_crop_width', '79', 'zpmobile', 'themes/zpmobile'),
(267, 0, 'thumb_crop_height', '79', 'zpmobile', 'themes/zpmobile'),
(268, 0, 'thumb_crop', '1', 'zpmobile', 'themes/zpmobile'),
(269, 0, 'custom_index_page', 'gallery', 'zpmobile', 'themes/zpmobile'),
(270, 0, 'albums_per_page', '6', 'zpmobile', 'themes/zpmobile'),
(271, 0, 'albums_per_row', '1', 'zpmobile', 'themes/zpmobile'),
(272, 0, 'images_per_page', '24', 'zpmobile', 'themes/zpmobile'),
(273, 0, 'images_per_row', '6', 'zpmobile', 'themes/zpmobile'),
(279, 0, 'image_size', '595', 'zpmobile', 'themes/zpmobile'),
(280, 0, 'image_use_side', 'longest', 'zpmobile', 'themes/zpmobile'),
(281, 0, 'thumb_use_side', 'longest', 'zpmobile', 'themes/zpmobile'),
(287, 0, 'copyright_image_notice', 'Copyright 2025: [[domhost]]', '', 'zp-core/setup/setup-option-defaults.php'),
(290, 0, 'gallery_data', 'a:18:{s:21:"gallery_sortdirection";i:0;s:16:"gallery_sorttype";s:2:"ID";s:13:"gallery_title";s:7:"Gallery";s:19:"Gallery_description";s:73:"You can insert your Gallery description on the Admin Options Gallery tab.";s:16:"gallery_password";N;s:12:"gallery_user";N;s:12:"gallery_hint";N;s:10:"hitcounter";N;s:13:"current_theme";s:5:"basic";s:13:"website_title";N;s:11:"website_url";N;s:16:"gallery_security";s:6:"public";s:16:"login_user_field";N;s:24:"album_use_new_image_date";N;s:19:"thumb_select_images";N;s:17:"unprotected_pages";a:2:{i:0;s:8:"register";i:1;s:7:"contact";}s:13:"album_publish";i:1;s:13:"image_publish";i:1;}', '', NULL),
(291, 0, 'display_copyright_notice', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(293, 0, 'search_cache_duration', '30', '', 'zp-core/setup/setup-option-defaults.php'),
(294, 0, 'search_within', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(295, 0, 'last_update_check', '30', '', NULL),
(296, 0, 'plugins_per_page', '20', '', 'zp-core/setup/setup-option-defaults.php'),
(297, 0, 'plugins_per_page_options', '10', '', 'zp-core/setup/setup-option-defaults.php'),
(298, 0, 'users_per_page', '10', '', 'zp-core/setup/setup-option-defaults.php'),
(299, 0, 'articles_per_page', '15', '', 'zp-core/setup/setup-option-defaults.php'),
(300, 0, 'debug_log_size', '5000000', '', 'zp-core/setup/setup-option-defaults.php'),
(301, 0, 'imageProcessorConcurrency', '30', '', 'zp-core/setup/setup-option-defaults.php'),
(302, 0, 'zp_plugin_legacySpam', '8197', '', 'zp-core/setup/setup-option-defaults.php'),
(303, 0, 'search_album_sort_type', 'title', '', 'zp-core/setup/setup-option-defaults.php'),
(304, 0, 'search_album_sort_direction', '', '', 'zp-core/setup/setup-option-defaults.php'),
(305, 0, 'search_image_sort_type', 'title', '', 'zp-core/setup/setup-option-defaults.php'),
(306, 0, 'search_image_sort_direction', '', '', 'zp-core/setup/setup-option-defaults.php'),
(307, 0, 'search_newsarticle_sort_type', 'date', '', 'zp-core/setup/setup-option-defaults.php'),
(308, 0, 'search_newsarticle_sort_direction', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(309, 0, 'search_page_sort_type', 'title', '', 'zp-core/setup/setup-option-defaults.php'),
(310, 0, 'search_page_sort_direction', '', '', 'zp-core/setup/setup-option-defaults.php'),
(311, 0, 'image_processor_flooding_protection', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(312, 0, 'codeblock_first_tab', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(313, 0, 'GD_FreeType_Path', '[[softpath]]/plugins/gd_fonts', '', 'zp-core/setup/setup-option-defaults.php'),
(314, 0, 'disallow_zh_Hans_CN', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(315, 0, 'disallow_zh_CN', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(316, 0, 'disallow_zh_Hant_TW', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(317, 0, 'disallow_da_DK', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(318, 0, 'disallow_nl_NL', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(319, 0, 'disallow_fr_FR', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(320, 0, 'disallow_gl_ES', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(321, 0, 'disallow_de_DE', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(322, 0, 'disallow_he_IL', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(323, 0, 'disallow_is_IS', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(324, 0, 'disallow_it_IT', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(325, 0, 'disallow_ja_JP', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(326, 0, 'disallow_pl_PL', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(327, 0, 'disallow_ru_RU', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(328, 0, 'disallow_sk_SK', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(329, 0, 'disallow_es_AR', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(330, 0, 'disallow_es_BO', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(331, 0, 'disallow_es_LA', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(332, 0, 'disallow_es_ES', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(333, 0, 'disallow_es_US', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(334, 0, 'disallow_es_UY', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(335, 0, 'disallow_sv_SE', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(336, 0, 'disallow_tr_TR', '1', '', 'zp-core/setup/setup-option-defaults.php'),
(343, 0, 'backup_interval', '7', '', 'zp-core/zp-extensions/auto_backup.php'),
(344, 0, 'backups_to_keep', '5', '', 'zp-core/zp-extensions/auto_backup.php'),
(348, 0, 'bxslider_minitems', '3', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(349, 0, 'bxslider_maxitems', '8', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(350, 0, 'bxslider_width', '50', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(351, 0, 'bxslider_height', '50', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(352, 0, 'bxslider_croph', '50', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(353, 0, 'bxslider_cropw', '50', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(354, 0, 'bxslider_speed', '500', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(355, 0, 'bxslider_fullimagelink', '', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(356, 0, 'bxslider_mode', 'horizontal', '', 'zp-core/zp-extensions/bxslider_thumb_nav.php'),
(369, 0, 'video_videoposter', '1', '', 'zp-core/zp-extensions/class-video.php'),
(370, 0, 'video_audioposter', '1', '', 'zp-core/zp-extensions/class-video.php'),
(371, 0, 'video_videoposter_width', '1280', '', 'zp-core/zp-extensions/class-video.php'),
(372, 0, 'video_videoposter_height', '720', '', 'zp-core/zp-extensions/class-video.php'),
(373, 0, 'video_audioposter_width', '1280', '', 'zp-core/zp-extensions/class-video.php'),
(374, 0, 'video_audioposter_height', '720', '', 'zp-core/zp-extensions/class-video.php'),
(375, 0, 'video_videoposter_maxspace', '1', '', 'zp-core/zp-extensions/class-video.php'),
(376, 0, 'video_audioposter_maxspace', '1', '', 'zp-core/zp-extensions/class-video.php'),
(377, 0, 'video_videoposter_css', '1', '', 'zp-core/zp-extensions/class-video.php'),
(378, 0, 'video_audioposter_css', '1', '', 'zp-core/zp-extensions/class-video.php'),
(382, 0, 'WEBdocs_pdf_provider', 'local', '', 'zp-core/zp-extensions/class-WEBdocs.php'),
(383, 0, 'WEBdocs_pps_provider', 'google', '', 'zp-core/zp-extensions/class-WEBdocs.php'),
(384, 0, 'WEBdocs_tif_provider', 'zoho', '', 'zp-core/zp-extensions/class-WEBdocs.php'),
(391, 0, 'colorbox_theme', 'example1', '', 'zp-core/zp-extensions/colorbox_js.php'),
(395, 0, 'email_new_comments', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(396, 0, 'comment_name_required', 'required', '', 'zp-core/zp-extensions/comment_form.php'),
(397, 0, 'comment_email_required', 'required', '', 'zp-core/zp-extensions/comment_form.php'),
(398, 0, 'comment_web_required', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(399, 0, 'Use_Captcha', '', '', 'zp-core/zp-extensions/comment_form.php'),
(400, 0, 'comment_form_addresses', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(401, 0, 'comment_form_require_addresses', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(402, 0, 'comment_form_members_only', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(403, 0, 'comment_form_albums', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(404, 0, 'comment_form_images', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(405, 0, 'comment_form_articles', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(406, 0, 'comment_form_pages', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(407, 0, 'comment_form_rss', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(408, 0, 'comment_form_private', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(409, 0, 'comment_form_anon', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(410, 0, 'comment_form_showURL', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(411, 0, 'comment_form_comments_per_page', '10', '', 'zp-core/zp-extensions/comment_form.php'),
(412, 0, 'comment_form_pagination', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(413, 0, 'comment_form_toggle', '1', '', 'zp-core/zp-extensions/comment_form.php'),
(414, 0, 'comment_form_dataconfirmation', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(415, 0, 'comment_form_remember', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(416, 0, 'comment_form_autocomplete', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(417, 0, 'comment_form_textquiz', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(418, 0, 'comment_form_textquiz_question', '', '', 'zp-core/zp-extensions/comment_form.php'),
(419, 0, 'comment_form_textquiz_answer', '', '', 'zp-core/zp-extensions/comment_form.php'),
(420, 0, 'comment_form_mathquiz', '0', '', 'zp-core/zp-extensions/comment_form.php'),
(421, 0, 'comment_form_mathquiz_question', '', '', 'zp-core/zp-extensions/comment_form.php'),
(425, 0, 'contactform_rewrite', '_PAGE_/contact', '', 'zp-core/zp-extensions/contact_form.php'),
(426, 0, 'contactform_introtext', '', '', 'zp-core/zp-extensions/contact_form.php'),
(427, 0, 'contactform_confirmtext', '', '', 'zp-core/zp-extensions/contact_form.php'),
(428, 0, 'contactform_thankstext', '', '', 'zp-core/zp-extensions/contact_form.php'),
(429, 0, 'contactform_newmessagelink', '', '', 'zp-core/zp-extensions/contact_form.php'),
(430, 0, 'contactform_title', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(431, 0, 'contactform_name', 'required', '', 'zp-core/zp-extensions/contact_form.php'),
(432, 0, 'contactform_company', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(433, 0, 'contactform_street', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(434, 0, 'contactform_city', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(435, 0, 'contactform_state', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(436, 0, 'contactform_postal', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(437, 0, 'contactform_country', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(438, 0, 'contactform_email', 'required', '', 'zp-core/zp-extensions/contact_form.php'),
(439, 0, 'contactform_website', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(440, 0, 'contactform_phone', 'show', '', 'zp-core/zp-extensions/contact_form.php'),
(441, 0, 'contactform_captcha', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(442, 0, 'contactform_confirm', '1', '', 'zp-core/zp-extensions/contact_form.php'),
(443, 0, 'contactform_sendcopy', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(444, 0, 'contactform_sendcopy_text', '', '', 'zp-core/zp-extensions/contact_form.php'),
(445, 0, 'contactform_dataconfirmation', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(446, 0, 'contactform_autocomplete', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(447, 0, 'contactform_textquiz', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(448, 0, 'contactform_textquiz_question', '', '', 'zp-core/zp-extensions/contact_form.php'),
(449, 0, 'contactform_textquiz_answer', '', '', 'zp-core/zp-extensions/contact_form.php'),
(450, 0, 'contactform_mathquiz', '0', '', 'zp-core/zp-extensions/contact_form.php'),
(451, 0, 'contactform_mathquiz_question', '', '', 'zp-core/zp-extensions/contact_form.php'),
(455, 0, 'zpcookieconsent_expirydays', '365', '', 'zp-core/zp-extensions/cookieconsent.php'),
(456, 0, 'zpcookieconsent_theme', 'block', '', 'zp-core/zp-extensions/cookieconsent.php'),
(457, 0, 'zpcookieconsent_position', 'bottom', '', 'zp-core/zp-extensions/cookieconsent.php'),
(458, 0, 'zpcookieconsent_colorpopup', '#000', '', 'zp-core/zp-extensions/cookieconsent.php'),
(459, 0, 'zpcookieconsent_colorbutton', '#f1d600', '', 'zp-core/zp-extensions/cookieconsent.php'),
(460, 0, 'zpcookieconsent_compliancetype', 'info', '', 'zp-core/zp-extensions/cookieconsent.php'),
(461, 0, 'zpcookieconsent_consentrevokable', '0', '', 'zp-core/zp-extensions/cookieconsent.php'),
(462, 0, 'zpcookieconsent_layout', 'basic', '', 'zp-core/zp-extensions/cookieconsent.php'),
(472, 0, 'zp_plugin_deprecated-functions', '9092', '', NULL),
(476, 0, 'downloadList_directory', 'uploaded', '', 'zp-core/zp-extensions/downloadList.php'),
(477, 0, 'downloadList_showfilesize', '1', '', 'zp-core/zp-extensions/downloadList.php'),
(478, 0, 'downloadList_showdownloadcounter', '1', '', 'zp-core/zp-extensions/downloadList.php'),
(479, 0, 'downloadList_zipFromCache', '0', '', 'zp-core/zp-extensions/downloadList.php'),
(480, 0, 'downloadList_subalbums', 'none', '', 'zp-core/zp-extensions/downloadList.php'),
(481, 0, 'downloadList_externaldownload_allowed', '', '', 'zp-core/zp-extensions/downloadList.php'),
(485, 0, 'dynamic_locale_visual', '0', '', 'zp-core/zp-extensions/dynamic-locale.php'),
(486, 0, 'dynamic_locale_subdomain', '0', '', 'zp-core/zp-extensions/dynamic-locale.php'),
(490, 0, 'elFinder_files', '1', '', 'zp-core/zp-extensions/elFinder.php'),
(491, 0, 'elFinder_tinymce', '0', '', 'zp-core/zp-extensions/elFinder.php'),
(501, 0, 'favorites_multi', '0', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(502, 0, 'favorites_link', '_PAGE_/favorites', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(503, 0, 'favorites_title', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(504, 0, 'favorites_linktext', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(505, 0, 'favorites_desc', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(506, 0, 'favorites_add_button', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(507, 0, 'favorites_remove_button', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(508, 0, 'favorites_album_sort_type', 'title', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(509, 0, 'favorites_image_sort_type', 'title', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(510, 0, 'favorites_album_sort_direction', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(511, 0, 'favorites_image_sort_direction', '', '', 'zp-core/zp-extensions/favoritesHandler.php'),
(518, 0, 'flag_thumbnail_date', 'date', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(519, 0, 'flag_thumbnail_range', '3', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(520, 0, 'flag_thumbnail_new_text', 'NEW', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(521, 0, 'flag_thumbnail_unpublished_text', 'unpub', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(522, 0, 'flag_thumbnail_locked_text', 'locked', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(523, 0, 'flag_thumbnail_geodata_text', 'GPS', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(524, 0, 'flag_thumbnail_use_text', '', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(525, 0, 'flag_thumbnail_flag_new', '1', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(526, 0, 'flag_thumbnail_flag_locked', '1', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(527, 0, 'flag_thumbnail_flag_unpublished', '1', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(528, 0, 'flag_thumbnail_flag_geodata', '1', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(529, 0, 'flag_thumbnail_new_icon', 'new.png', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(530, 0, 'flag_thumbnail_unpublished_icon', 'action.png', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(531, 0, 'flag_thumbnail_locked_icon', 'lock.png', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(532, 0, 'flag_thumbnail_geodata_icon', 'GPS.png', '', 'zp-core/zp-extensions/flag_thumbnail.php'),
(536, 0, 'galleryArticles_albumCategory', '0', '', 'zp-core/zp-extensions/galleryArticles.php'),
(537, 0, 'galleryArticles_album_text', 'New album: %1$s', '', 'zp-core/zp-extensions/galleryArticles.php'),
(538, 0, 'galleryArticles_image_text', 'New image: [%2$s]%1$s', '', 'zp-core/zp-extensions/galleryArticles.php'),
(539, 0, 'galleryArticles_size', '80', '', 'zp-core/zp-extensions/galleryArticles.php'),
(540, 0, 'galleryArticles_protected', '0', '', 'zp-core/zp-extensions/galleryArticles.php'),
(544, 0, 'gmap_map_roadmap', '1', '', 'zp-core/zp-extensions/GoogleMap.php'),
(545, 0, 'gmap_map_hybrid', '1', '', 'zp-core/zp-extensions/GoogleMap.php'),
(546, 0, 'gmap_map_satellite', '1', '', 'zp-core/zp-extensions/GoogleMap.php'),
(547, 0, 'gmap_map_terrain', '1', '', 'zp-core/zp-extensions/GoogleMap.php'),
(548, 0, 'gmap_starting_map', 'HYBRID', '', 'zp-core/zp-extensions/GoogleMap.php'),
(549, 0, 'gmap_control_type', 'HORIZONTAL_BAR', '', 'zp-core/zp-extensions/GoogleMap.php'),
(550, 0, 'gmap_zoom_size', 'LARGE', '', 'zp-core/zp-extensions/GoogleMap.php'),
(551, 0, 'gmap_cluster_max_zoom', '13', '', 'zp-core/zp-extensions/GoogleMap.php'),
(552, 0, 'gmap_sessions', '1', '', 'zp-core/zp-extensions/GoogleMap.php'),
(553, 0, 'gmap_display', 'hide', '', 'zp-core/zp-extensions/GoogleMap.php'),
(558, 0, 'hitcounter_ignoreIPList_enable', '0', '', 'zp-core/zp-extensions/hitcounter.php'),
(559, 0, 'hitcounter_ignoreSearchCrawlers_enable', '0', '', 'zp-core/zp-extensions/hitcounter.php'),
(560, 0, 'hitcounter_ignoreIPList', '', '', 'zp-core/zp-extensions/hitcounter.php'),
(561, 0, 'hitcounter_searchCrawlerList', 'Teoma, alexa, froogle, Gigabot,inktomi, looksmart, URL_Spider_SQL, Firefly, NationalDirectory, Ask Jeeves, TECNOSEEK, InfoSeek, WebFindBot, girafabot, crawler, www.galaxy.com, Googlebot, Scooter, Slurp, msnbot, appie, FAST, WebBug, Spade, ZyBorg, rabaz ,Baiduspider, Feedfetcher-Google, TechnoratiSnoop, Rankivabot, Mediapartners-Google, Sogou web spider, WebAlta Crawler', '', 'zp-core/zp-extensions/hitcounter.php'),
(565, 0, 'htmlmeta_cache_control', 'no-cache', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(566, 0, 'htmlmeta_robots', 'index', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(567, 0, 'htmlmeta_revisit_after', '10 Days', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(568, 0, 'htmlmeta_expires', '43200', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(569, 0, 'htmlmeta_tags', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(570, 0, 'htmlmeta_google-site-verification', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(571, 0, 'htmlmeta_baidu-site-verification', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(572, 0, 'htmlmeta_bing-site-verification', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(573, 0, 'htmlmeta_pinterest-site-verification', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(574, 0, 'htmlmeta_yandex-site-verification', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(575, 0, 'htmlmeta_htmlmeta_tags', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(576, 0, 'htmlmeta_http-equiv-cache-control', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(577, 0, 'htmlmeta_http-equiv-pragma', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(578, 0, 'htmlmeta_name=keywords', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(579, 0, 'htmlmeta_name-description', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(580, 0, 'htmlmeta_name-robot', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(581, 0, 'htmlmeta_name-publisher', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(582, 0, 'htmlmeta_name-creator', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(583, 0, 'htmlmeta_name-author', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(584, 0, 'htmlmeta_name-copyright', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(585, 0, 'htmlmeta_name-generator', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(586, 0, 'htmlmeta_name-revisit-after', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(587, 0, 'htmlmeta_name-expires', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(589, 0, 'htmlmeta_name-date', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(590, 0, 'htmlmeta_canonical-url', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(591, 0, 'htmlmeta_sitelogo', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(592, 0, 'htmlmeta_fb-app_id', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(593, 0, 'htmlmeta_twittercard', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(594, 0, 'htmlmeta_twittername', '', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(595, 0, 'htmlmeta_ogimage_width', '1280', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(596, 0, 'htmlmeta_ogimage_height', '900', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(597, 0, 'htmlmeta_prevnext-gallery', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(598, 0, 'htmlmeta_prevnext-image', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(599, 0, 'htmlmeta_prevnext-news', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(600, 0, 'htmlmeta_canonical-url_dynalbum', '1', '', 'zp-core/zp-extensions/html_meta_tags.php'),
(604, 0, 'securityheaders_csp', '1', '', 'zp-core/zp-extensions/http_security_headers.php'),
(605, 0, 'securityheaders_xframeoptions', 'disabled', '', 'zp-core/zp-extensions/http_security_headers.php'),
(606, 0, 'securityheaders_referrerpolicy', 'disabled', '', 'zp-core/zp-extensions/http_security_headers.php'),
(613, 0, 'ipBlocker_list', 'a:0:{}', '', 'zp-core/zp-extensions/ipBlocker.php'),
(614, 0, 'ipBlocker_type', 'block', '', 'zp-core/zp-extensions/ipBlocker.php'),
(615, 0, 'ipBlocker_threshold', '10', '', 'zp-core/zp-extensions/ipBlocker.php'),
(616, 0, 'ipBlocker_timeout', '60', '', 'zp-core/zp-extensions/ipBlocker.php'),
(620, 0, 'zp_plugin_jplayer', '0', '', NULL),
(621, 0, 'jplayer_autoplay', '', '', 'zp-core/zp-extensions/jplayer.php'),
(622, 0, 'jplayer_poster', '1', '', 'zp-core/zp-extensions/jplayer.php'),
(623, 0, 'jplayer_postercrop', '1', '', 'zp-core/zp-extensions/jplayer.php'),
(624, 0, 'jplayer_showtitle', '', '', 'zp-core/zp-extensions/jplayer.php'),
(625, 0, 'jplayer_playlist', '', '', 'zp-core/zp-extensions/jplayer.php'),
(626, 0, 'jplayer_playlist_numbered', '1', '', 'zp-core/zp-extensions/jplayer.php'),
(627, 0, 'jplayer_playlist_playtime', '0', '', 'zp-core/zp-extensions/jplayer.php'),
(628, 0, 'jplayer_download', '', '', 'zp-core/zp-extensions/jplayer.php'),
(629, 0, 'jplayer_size', 'jp-video-270p', '', 'zp-core/zp-extensions/jplayer.php'),
(630, 0, 'jplayer_skin', 'zenphotolight', '', 'zp-core/zp-extensions/jplayer.php'),
(631, 0, 'jplayer_counterparts', '0', '', 'zp-core/zp-extensions/jplayer.php'),
(635, 0, 'lazyload_nativeonly', '0', '', 'zp-core/zp-extensions/lazyload.php'),
(642, 0, 'matomo_disablecookies', '0', '', 'zp-core/zp-extensions/matomo.php'),
(643, 0, 'matomo_requireconsent', 'no-consent', '', 'zp-core/zp-extensions/matomo.php'),
(644, 0, 'matomo_contenttracking', 'disabled', '', 'zp-core/zp-extensions/matomo.php'),
(648, 0, 'menu_truncate_string', '0', '', 'zp-core/zp-extensions/menu_manager.php'),
(649, 0, 'menu_truncate_indicator', '', '', 'zp-core/zp-extensions/menu_manager.php'),
(653, 0, 'mergedrss_items', '10', '', 'zp-core/zp-extensions/mergedRSS.php'),
(660, 0, 'multiple_layouts_images', '0', '', 'zp-core/zp-extensions/multiple_layouts.php'),
(661, 0, 'multiple_layouts_albums', '0', '', 'zp-core/zp-extensions/multiple_layouts.php'),
(662, 0, 'multiple_layouts_pages', '1', '', 'zp-core/zp-extensions/multiple_layouts.php'),
(663, 0, 'multiple_layouts_news', '1', '', 'zp-core/zp-extensions/multiple_layouts.php'),
(664, 0, 'multiple_layouts_news_categories', '1', '', 'zp-core/zp-extensions/multiple_layouts.php'),
(668, 0, 'osmap_width', '100%', '', 'zp-core/zp-extensions/openstreetmap.php'),
(669, 0, 'osmap_height', '300px', '', 'zp-core/zp-extensions/openstreetmap.php'),
(670, 0, 'osmap_zoom', '13', '', 'zp-core/zp-extensions/openstreetmap.php'),
(671, 0, 'osmap_minzoom', '2', '', 'zp-core/zp-extensions/openstreetmap.php'),
(672, 0, 'osmap_maxzoom', '18', '', 'zp-core/zp-extensions/openstreetmap.php'),
(673, 0, 'osmap_zoomcontrolpos', 'topleft', '', 'zp-core/zp-extensions/openstreetmap.php'),
(674, 0, 'osmap_defaultlayer', 'OpenStreetMap.Mapnik', '', 'zp-core/zp-extensions/openstreetmap.php'),
(675, 0, 'osmap_clusterradius', '40', '', 'zp-core/zp-extensions/openstreetmap.php'),
(676, 0, 'osmap_markerpopup', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(677, 0, 'osmap_markerpopup_title', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(678, 0, 'osmap_markerpopup_desc', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(679, 0, 'osmap_markerpopup_thumb', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(680, 0, 'osmap_markerpopup_thumb-type', 'custom', '', 'zp-core/zp-extensions/openstreetmap.php'),
(681, 0, 'osmap_markerpopup_thumb-size', '120', '', 'zp-core/zp-extensions/openstreetmap.php'),
(682, 0, 'osmap_markerpopup_title-length', '50', '', 'zp-core/zp-extensions/openstreetmap.php'),
(683, 0, 'osmap_markerpopup_desc-length', '100', '', 'zp-core/zp-extensions/openstreetmap.php'),
(684, 0, 'osmap_markerpopup_css-default', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(685, 0, 'osmap_showlayerscontrol', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(686, 0, 'osmap_layerscontrolpos', 'topright', '', 'zp-core/zp-extensions/openstreetmap.php'),
(687, 0, 'osmap_layer_OpenStreetMap_Mapnik', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(688, 0, 'osmap_layer_OpenStreetMap_DE', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(689, 0, 'osmap_layer_OpenStreetMap_France', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(690, 0, 'osmap_layer_OpenStreetMap_HOT', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(691, 0, 'osmap_layer_OpenTopoMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(692, 0, 'osmap_layer_OpenRailwayMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(693, 0, 'osmap_layer_Thunderforest_OpenCycleMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(694, 0, 'osmap_layer_Thunderforest_Transport', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(695, 0, 'osmap_layer_Thunderforest_TransportDark', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(696, 0, 'osmap_layer_Thunderforest_SpinalMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(697, 0, 'osmap_layer_Thunderforest_Landscape', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(698, 0, 'osmap_layer_Thunderforest_Outdoors', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(699, 0, 'osmap_layer_Thunderforest_Pioneer', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(700, 0, 'osmap_layer_Thunderforest_MobileAtlas', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(701, 0, 'osmap_layer_Thunderforest_Neighbourhood', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(702, 0, 'osmap_layer_MapBox_streets', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(703, 0, 'osmap_layer_MapBox_light', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(704, 0, 'osmap_layer_MapBox_dark', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(705, 0, 'osmap_layer_MapBox_satellite', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(706, 0, 'osmap_layer_MapBox_streets-satellite', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(707, 0, 'osmap_layer_MapBox_wheatpaste', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(708, 0, 'osmap_layer_MapBox_streets-basic', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(709, 0, 'osmap_layer_MapBox_comic', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(710, 0, 'osmap_layer_MapBox_outdoors', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(711, 0, 'osmap_layer_MapBox_run-bike-hike', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(712, 0, 'osmap_layer_MapBox_pencil', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(713, 0, 'osmap_layer_MapBox_pirates', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(714, 0, 'osmap_layer_MapBox_emerald', '0', '', 'zp-core/zp-extensions/openstreetmap.php');
INSERT INTO `[[dbprefix]]options` VALUES
(715, 0, 'osmap_layer_MapBox_high-contrast', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(716, 0, 'osmap_layer_Stadia_AlidadeSmooth', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(717, 0, 'osmap_layer_Stadia_AlidadeSmoothDark', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(718, 0, 'osmap_layer_Stadia_AlidadeSatellite', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(719, 0, 'osmap_layer_Stadia_OSMBright', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(720, 0, 'osmap_layer_Stadia_Outdoors', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(721, 0, 'osmap_layer_Stadia_StamenToner', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(722, 0, 'osmap_layer_Stadia_StamenTonerBackground', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(723, 0, 'osmap_layer_Stadia_StamenTonerLite', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(724, 0, 'osmap_layer_Stadia_StamenWatercolor', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(725, 0, 'osmap_layer_Stadia_StamenTerrain', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(726, 0, 'osmap_layer_Stadia_StamenTerrainBackground', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(727, 0, 'osmap_layer_Esri_WorldStreetMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(728, 0, 'osmap_layer_Esri_WorldTopoMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(729, 0, 'osmap_layer_Esri_WorldImagery', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(730, 0, 'osmap_layer_Esri_WorldTerrain', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(731, 0, 'osmap_layer_Esri_WorldShadedRelief', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(732, 0, 'osmap_layer_Esri_WorldPhysical', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(733, 0, 'osmap_layer_Esri_OceanBasemap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(734, 0, 'osmap_layer_Esri_NatGeoWorldMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(735, 0, 'osmap_layer_Esri_WorldGrayCanvas', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(736, 0, 'osmap_layer_HEREv3_normalDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(737, 0, 'osmap_layer_HEREv3_normalDayCustom', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(738, 0, 'osmap_layer_HEREv3_normalDayGrey', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(739, 0, 'osmap_layer_HEREv3_normalDayMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(740, 0, 'osmap_layer_HEREv3_normalDayGreyMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(741, 0, 'osmap_layer_HEREv3_normalDayTransit', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(742, 0, 'osmap_layer_HEREv3_normalDayTransitMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(743, 0, 'osmap_layer_HEREv3_normalNight', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(744, 0, 'osmap_layer_HEREv3_normalNightMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(745, 0, 'osmap_layer_HEREv3_normalNightGrey', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(746, 0, 'osmap_layer_HEREv3_normalNightGreyMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(747, 0, 'osmap_layer_HEREv3_basicMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(748, 0, 'osmap_layer_HEREv3_mapLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(749, 0, 'osmap_layer_HEREv3_trafficFlow', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(750, 0, 'osmap_layer_HEREv3_carnavDayGrey', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(751, 0, 'osmap_layer_HEREv3_hybridDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(752, 0, 'osmap_layer_HEREv3_hybridDayMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(753, 0, 'osmap_layer_HEREv3_pedestrianDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(754, 0, 'osmap_layer_HEREv3_pedestrianNight', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(755, 0, 'osmap_layer_HEREv3_satelliteDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(756, 0, 'osmap_layer_HEREv3_terrainDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(757, 0, 'osmap_layer_HEREv3_terrainDayMobile', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(758, 0, 'osmap_layer_MtbMap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(759, 0, 'osmap_layer_CartoDB_Positron', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(760, 0, 'osmap_layer_CartoDB_PositronNoLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(761, 0, 'osmap_layer_CartoDB_PositronOnlyLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(762, 0, 'osmap_layer_CartoDB_DarkMatter', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(763, 0, 'osmap_layer_CartoDB_DarkMatterNoLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(764, 0, 'osmap_layer_CartoDB_DarkMatterOnlyLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(765, 0, 'osmap_layer_CartoDB_Voyager', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(766, 0, 'osmap_layer_CartoDB_VoyagerNoLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(767, 0, 'osmap_layer_CartoDB_VoyagerOnlyLabels', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(768, 0, 'osmap_layer_CartoDB_VoyagerLabelsUnder', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(769, 0, 'osmap_layer_GeoportailFrance_plan', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(770, 0, 'osmap_layer_GeoportailFrance_orthos', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(771, 0, 'osmap_layer_BaseMapDE_Color', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(772, 0, 'osmap_layer_BaseMapDE_Grey', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(773, 0, 'osmap_layer_CyclOSM', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(774, 0, 'osmap_layer_Jawg_Streets', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(775, 0, 'osmap_layer_Jawg_Terrain', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(776, 0, 'osmap_layer_Jawg_Lagoon', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(777, 0, 'osmap_layer_Jawg_Sunny', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(778, 0, 'osmap_layer_Jawg_Dark', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(779, 0, 'osmap_layer_Jawg_Light', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(780, 0, 'osmap_layer_Jawg_Matrix', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(781, 0, 'osmap_layer_MapBox', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(782, 0, 'osmap_layer_NASAGIBS_ModisTerraTrueColorCR', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(783, 0, 'osmap_layer_NASAGIBS_ModisTerraBands367CR', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(784, 0, 'osmap_layer_NASAGIBS_ModisTerraLSTDay', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(785, 0, 'osmap_layer_NASAGIBS_ModisTerraSnowCover', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(786, 0, 'osmap_layer_NASAGIBS_ModisTerraAOD', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(787, 0, 'osmap_layer_NASAGIBS_ModisTerraChlorophyll', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(788, 0, 'osmap_layer_USGS_USTopo', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(789, 0, 'osmap_layer_USGS_USImagery', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(790, 0, 'osmap_layer_USGS_USImageryTopo', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(791, 0, 'osmap_layer_TopPlusOpen_Color', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(792, 0, 'osmap_layer_TopPlusOpen_Grey', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(793, 0, 'osmap_showscale', '1', '', 'zp-core/zp-extensions/openstreetmap.php'),
(794, 0, 'osmap_showalbummarkers', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(795, 0, 'osmap_showminimap', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(796, 0, 'osmap_minimap_width', '100', '', 'zp-core/zp-extensions/openstreetmap.php'),
(797, 0, 'osmap_minimap_height', '100', '', 'zp-core/zp-extensions/openstreetmap.php'),
(798, 0, 'osmap_minimap_zoom', '-5', '', 'zp-core/zp-extensions/openstreetmap.php'),
(799, 0, 'osmap_cluster_showcoverage_on_hover', '0', '', 'zp-core/zp-extensions/openstreetmap.php'),
(803, 0, 'pagedthumbs_imagesperpage', '10', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(804, 0, 'pagedthumbs_counter', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(805, 0, 'pagedthumbs_prevtext', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(806, 0, 'pagedthumbs_nexttext', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(807, 0, 'pagedthumbs_width', '50', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(808, 0, 'pagedthumbs_height', '50', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(809, 0, 'pagedthumbs_crop', '1', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(810, 0, 'pagedthumbs_placeholders', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(811, 0, 'pagedthumbs_pagelist', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(812, 0, 'pagedthumbs_pagelistprevnext', '', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(813, 0, 'pagedthumbs_pagelistlength', '6', '', 'zp-core/zp-extensions/paged_thumbs_nav.php'),
(817, 0, 'PHPMailer_mail_protocol', 'sendmail', '', 'zp-core/zp-extensions/PHPMailer.php'),
(818, 0, 'PHPMailer_server', '', '', 'zp-core/zp-extensions/PHPMailer.php'),
(819, 0, 'PHPMailer_pop_port', '110', '', 'zp-core/zp-extensions/PHPMailer.php'),
(820, 0, 'PHPMailer_smtp_port', '25', '', 'zp-core/zp-extensions/PHPMailer.php'),
(821, 0, 'PHPMailer_user', '', '', 'zp-core/zp-extensions/PHPMailer.php'),
(822, 0, 'PHPMailer_password', '', '', 'zp-core/zp-extensions/PHPMailer.php'),
(823, 0, 'PHPMailer_secure', '0', '', 'zp-core/zp-extensions/PHPMailer.php'),
(827, 0, 'print_album_menu_showsubs', '0', '', 'zp-core/zp-extensions/print_album_menu.php'),
(828, 0, 'print_album_menu_count', '1', '', 'zp-core/zp-extensions/print_album_menu.php'),
(835, 0, 'quota_default', '250000', '', 'zp-core/zp-extensions/quota_manager.php'),
(836, 0, 'quota_allowZIP', '1', '', 'zp-core/zp-extensions/quota_manager.php'),
(840, 0, 'rating_recast', '1', '', 'zp-core/zp-extensions/rating.php'),
(841, 0, 'rating_stars_count', '5', '', 'zp-core/zp-extensions/rating.php'),
(842, 0, 'rating_split_stars', '2', '', 'zp-core/zp-extensions/rating.php'),
(843, 0, 'rating_status', '3', '', 'zp-core/zp-extensions/rating.php'),
(844, 0, 'rating_image_individual_control', '0', '', 'zp-core/zp-extensions/rating.php'),
(848, 0, 'reCaptcha_theme', 'light', '', 'zp-core/zp-extensions/reCaptcha.php'),
(849, 0, 'reCaptcha_type', 'image', '', 'zp-core/zp-extensions/reCaptcha.php'),
(850, 0, 'reCaptcha_size', 'normal', '', 'zp-core/zp-extensions/reCaptcha.php'),
(857, 0, 'redirector_catalogue', '', '', 'zp-core/zp-extensions/redirector.php'),
(861, 0, 'register_user_link', '_PAGE_/register', '', 'zp-core/zp-extensions/register_user.php'),
(862, 0, 'register_user_text', '', '', 'zp-core/zp-extensions/register_user.php'),
(863, 0, 'register_user_text_auth', '', '', 'zp-core/zp-extensions/register_user.php'),
(864, 0, 'register_user_page_link', '1', '', 'zp-core/zp-extensions/register_user.php'),
(865, 0, 'register_user_page_linktext', '', '', 'zp-core/zp-extensions/register_user.php'),
(866, 0, 'register_user_captcha', '0', '', 'zp-core/zp-extensions/register_user.php'),
(867, 0, 'register_user_email_is_id', '1', '', 'zp-core/zp-extensions/register_user.php'),
(868, 0, 'register_user_create_album', '0', '', 'zp-core/zp-extensions/register_user.php'),
(869, 0, 'register_user_notify', '0', '', NULL),
(870, 0, 'register_user_moderated', '0', '', 'zp-core/zp-extensions/register_user.php'),
(871, 0, 'register_user_dataconfirmation', '0', '', 'zp-core/zp-extensions/register_user.php'),
(872, 0, 'register_user_textquiz', '0', '', 'zp-core/zp-extensions/register_user.php'),
(873, 0, 'register_user_textquiz_question', '', '', 'zp-core/zp-extensions/register_user.php'),
(874, 0, 'register_user_textquiz_answer', '', '', 'zp-core/zp-extensions/register_user.php'),
(875, 0, 'register_user_mathquiz', '0', '', 'zp-core/zp-extensions/register_user.php'),
(876, 0, 'register_user_mathquiz_question', '', '', 'zp-core/zp-extensions/register_user.php'),
(886, 0, 'zp_plugin_rewriteTokens', '5046', '', 'zp-core/zp-extensions/rewriteTokens.php'),
(891, 0, 'zp_plugin_rss', '7044', '', 'zp-core/zp-extensions/rss.php'),
(892, 0, 'RSS_album_image', '1', '', 'zp-core/zp-extensions/rss.php'),
(893, 0, 'RSS_comments', '1', '', 'zp-core/zp-extensions/rss.php'),
(894, 0, 'RSS_articles', '1', '', 'zp-core/zp-extensions/rss.php'),
(895, 0, 'RSS_pages', '1', '', 'zp-core/zp-extensions/rss.php'),
(896, 0, 'RSS_article_comments', '1', '', 'zp-core/zp-extensions/rss.php'),
(897, 0, 'RSS_truncate_length', '100', '', 'zp-core/zp-extensions/rss.php'),
(898, 0, 'RSS_zenpage_items', '10', '', 'zp-core/zp-extensions/rss.php'),
(899, 0, 'RSS_items', '10', '', 'zp-core/zp-extensions/rss.php'),
(900, 0, 'RSS_imagesize', '240', '', 'zp-core/zp-extensions/rss.php'),
(901, 0, 'RSS_sortorder', 'latest', '', 'zp-core/zp-extensions/rss.php'),
(902, 0, 'RSS_items_albums', '10', '', 'zp-core/zp-extensions/rss.php'),
(903, 0, 'RSS_imagesize_albums', '240', '', 'zp-core/zp-extensions/rss.php'),
(904, 0, 'RSS_sortorder_albums', 'latest', '', 'zp-core/zp-extensions/rss.php'),
(905, 0, 'RSS_enclosure', '0', '', 'zp-core/zp-extensions/rss.php'),
(906, 0, 'RSS_mediarss', '0', '', 'zp-core/zp-extensions/rss.php'),
(907, 0, 'RSS_cache', '1', '', 'zp-core/zp-extensions/rss.php'),
(908, 0, 'RSS_cache_expire', '86400', '', 'zp-core/zp-extensions/rss.php'),
(909, 0, 'RSS_hitcounter', '1', '', 'zp-core/zp-extensions/rss.php'),
(910, 0, 'RSS_title', 'both', '', 'zp-core/zp-extensions/rss.php'),
(911, 0, 'RSS__cache_albums', '0', '', 'zp-core/zp-extensions/rss.php'),
(912, 0, 'RSS__cache_images', '0', '', 'zp-core/zp-extensions/rss.php'),
(913, 0, 'RSS__cache_news', '0', '', 'zp-core/zp-extensions/rss.php'),
(914, 0, 'RSS__cache_pages', '0', '', 'zp-core/zp-extensions/rss.php'),
(918, 0, 'scriptless_socialsharing_profiles_alignment', 'center', '', 'zp-core/zp-extensions/scriptless-socialsharing.php'),
(919, 0, 'scriptless_socialsharing_rssurlmode', 'custom', '', 'zp-core/zp-extensions/scriptless-socialsharing.php'),
(926, 0, 'zp_plugin_security-logger', '8292', '', 'zp-core/zp-extensions/security-logger.php'),
(927, 0, 'logger_log_guests', '1', '', 'zp-core/zp-extensions/security-logger.php'),
(928, 0, 'logger_log_admin', '1', '', 'zp-core/zp-extensions/security-logger.php'),
(929, 0, 'logger_log_type', 'all', '', 'zp-core/zp-extensions/security-logger.php'),
(930, 0, 'logge_access_log_type', 'all_user', '', 'zp-core/zp-extensions/security-logger.php'),
(931, 0, 'security_log_size', '5000000', '', 'zp-core/zp-extensions/security-logger.php'),
(938, 0, 'zp_plugin_seo_locale', '0', '', NULL),
(945, 0, 'zenphoto_seo_lowercase', '1', '', 'zp-core/zp-extensions/seo_zenphoto.php'),
(952, 0, 'Words_to_die_on', 'cialis,ebony,nude,porn,porno,pussy,upskirt,ringtones,phentermine,viagra,levitra', '', 'zp-core/zp-extensions/simpleSpam.php'),
(953, 0, 'Patterns_to_die_on', '\\[url=.*\\]', '', 'zp-core/zp-extensions/simpleSpam.php'),
(954, 0, 'Excessive_URL_count', '5', '', 'zp-core/zp-extensions/simpleSpam.php'),
(955, 0, 'Forgiving', '0', '', 'zp-core/zp-extensions/simpleSpam.php'),
(956, 0, 'Banned_IP_list', 'a:0:{}', '', 'zp-core/zp-extensions/simpleSpam.php'),
(965, 0, 'sitemap_changefreq_index', 'daily', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(966, 0, 'sitemap_changefreq_albums', 'daily', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(967, 0, 'sitemap_changefreq_images', 'daily', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(968, 0, 'sitemap_changefreq_pages', 'weekly', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(969, 0, 'sitemap_changefreq_newsindex', 'daily', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(970, 0, 'sitemap_changefreq_news', 'daily', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(971, 0, 'sitemap_changefreq_newscats', 'weekly', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(972, 0, 'sitemap_lastmod_albums', 'mtime', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(973, 0, 'sitemap_lastmod_images', 'mtime', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(974, 0, 'sitemap_processing_chunk', '25', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(975, 0, 'sitemap_google', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(976, 0, 'sitemap_google_fullimage', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(977, 0, 'sitemap_includepagination_gallery', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(978, 0, 'sitemap_includepagination_album', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(979, 0, 'sitemap_includepagination_news', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(980, 0, 'sitemap_includepaginaion_category', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(981, 0, 'sitemap_include_dynamicalbums', '0', '', 'zp-core/zp-extensions/sitemap-extended.php'),
(985, 0, 'cycle-slideshow_width', '595', '', 'zp-core/zp-extensions/slideshow2.php'),
(986, 0, 'cycle-slideshow_height', '595', '', 'zp-core/zp-extensions/slideshow2.php'),
(987, 0, 'cycle-slideshow_mode', 'cycle', '', 'zp-core/zp-extensions/slideshow2.php'),
(988, 0, 'cycle-slideshow_effect', 'fade', '', 'zp-core/zp-extensions/slideshow2.php'),
(989, 0, 'cycle-slideshow_speed', '1000', '', 'zp-core/zp-extensions/slideshow2.php'),
(990, 0, 'cycle-slideshow_timeout', '3000', '', 'zp-core/zp-extensions/slideshow2.php'),
(991, 0, 'cycle-slideshow_showdesc', '0', '', 'zp-core/zp-extensions/slideshow2.php'),
(992, 0, 'cycle-slideshow_colorbox_transition', 'fade', '', 'zp-core/zp-extensions/slideshow2.php'),
(993, 0, 'cycle-slideshow_colorbox_imagetype', 'sizedimage', '', 'zp-core/zp-extensions/slideshow2.php'),
(994, 0, 'cycle-slideshow_colorbox_imagetitle', '1', '', 'zp-core/zp-extensions/slideshow2.php'),
(998, 0, 'static_cache_expire', '86400', '', 'zp-core/zp-extensions/static_html_cache.php'),
(999, 0, 'static_cache_excludedpages', 'search.php/,contact.php/,register.php/,favorites.php/', '', 'zp-core/zp-extensions/static_html_cache.php'),
(1000, 0, 'static_cache_albums', '0', '', 'zp-core/zp-extensions/static_html_cache.php'),
(1001, 0, 'static_cache_images', '0', '', 'zp-core/zp-extensions/static_html_cache.php'),
(1002, 0, 'static_cache_news', '0', '', 'zp-core/zp-extensions/static_html_cache.php'),
(1003, 0, 'static_cache_pages', '0', '', 'zp-core/zp-extensions/static_html_cache.php'),
(1010, 0, 'tagsuggest_excludeunassigned', '1', '', 'zp-core/zp-extensions/tag_suggest.php'),
(1011, 0, 'tagsuggest_checkaccess', '0', '', 'zp-core/zp-extensions/tag_suggest.php'),
(1015, 0, 'themeSwitcher_theme_basic', '1', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1016, 0, 'themeSwitcher_theme_garland', '1', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1017, 0, 'themeSwitcher_theme_zenpage', '1', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1018, 0, 'themeSwitcher_theme_zpmobile', '1', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1019, 0, 'themeSwitcher_timeout', '120', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1020, 0, 'themeSwitcher_css', '.themeSwitcherControlLink {\n position: fixed;\n z-index: 10000;\n left: 0px;\n top: 0px;\n border-bottom: 1px solid #444;\n border-left: 1px solid #444;\n color: black;\n padding: 2px;\n background-color: #f5f5f5 !important;\n}\n', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1021, 0, 'themeSwitcher_css_loggedin', '.themeSwitcherControlLink {\n position: fixed;\n z-index: 10000;\n left: 0px;\n top: 30px;\n border-bottom: 1px solid #444;\n border-left: 1px solid #444;\n color: black;\n padding: 2px;\n background-color: #f5f5f5 !important;\n}\n', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1022, 0, 'themeSwitcher_adminOnly', '1', '', 'zp-core/zp-extensions/themeSwitcher.php'),
(1026, 0, 'tinymce_zenphoto', 'zenphoto-basic.js.php', '', 'zp-core/zp-extensions/tinymce.php'),
(1027, 0, 'tinymce_zenpage', 'zenpage-basic.js.php', '', 'zp-core/zp-extensions/tinymce.php'),
(1028, 0, 'tinymce_entitiyencoding', 'raw', '', 'zp-core/zp-extensions/tinymce.php'),
(1029, 0, 'tinymce_textfield-height', '400', '', 'zp-core/zp-extensions/tinymce.php'),
(1030, 0, 'tinymce_browser-spellcheck', '', '', 'zp-core/zp-extensions/tinymce.php'),
(1031, 0, 'tinymce_browser-menu', '', '', 'zp-core/zp-extensions/tinymce.php'),
(1035, 0, 'zp_plugin_tinyURL', '8197', '', 'zp-core/zp-extensions/tinyURL.php'),
(1036, 0, 'tinyURL_agressive', '0', '', 'zp-core/zp-extensions/tinyURL.php'),
(1037, 0, 'tinyURL_text', 'tiny', '', 'zp-core/zp-extensions/tinyURL.php'),
(1042, 0, 'spamFilter_none_action', 'pass', '', 'zp-core/zp-extensions/trivialSpam.php'),
(1047, 0, 'zp_plugin_uploader_http', '4101', '', 'zp-core/zp-extensions/uploader_http.php'),
(1052, 0, 'zp_plugin_uploader_jQuery', '4101', '', 'zp-core/zp-extensions/uploader_jQuery.php'),
(1054, 0, 'uploaderjquery_behaviour', 'rename', '', 'zp-core/zp-extensions/uploader_jQuery.php'),
(1061, 0, 'user_logout_login_form', '0', '', 'zp-core/zp-extensions/user_login-out.php'),
(1068, 0, 'user_expiry_interval', '365', '', 'zp-core/zp-extensions/user-expiry.php'),
(1069, 0, 'user_expiry_warn_interval', '7', '', 'zp-core/zp-extensions/user-expiry.php'),
(1070, 0, 'user_expiry_auto_renew', '0', '', 'zp-core/zp-extensions/user-expiry.php'),
(1071, 0, 'user_expiry_password_cycle', '0', '', 'zp-core/zp-extensions/user-expiry.php'),
(1075, 0, 'zp_plugin_userAddressFields', '8197', '', 'zp-core/zp-extensions/userAddressFields.php'),
(1076, 0, 'userAddressFields_addedFields', 'a:1:{s:14:"administrators";a:6:{s:6:"street";b:1;s:7:"website";b:1;s:4:"city";b:1;s:7:"country";b:1;s:5:"state";b:1;s:6:"postal";b:1;}}', '', NULL),
(1082, 0, 'xmpMetadata_suffix', 'xmp', '', 'zp-core/zp-extensions/xmpMetadata.php'),
(1083, 0, 'xmpMetadata_exportmultilingual', '1', '', 'zp-core/zp-extensions/xmpMetadata.php'),
(1087, 0, 'zenpageNewsLink', 'news', '', 'zp-core/zp-extensions/zenpage.php'),
(1088, 0, 'zenpageCategoryLink', '_NEWS_/category', '', 'zp-core/zp-extensions/zenpage.php'),
(1089, 0, 'zenpageNewsArchiveLink', '_NEWS_/archive', '', 'zp-core/zp-extensions/zenpage.php'),
(1090, 0, 'zenpagePagesLink', 'pages', '', 'zp-core/zp-extensions/zenpage.php'),
(1091, 0, 'zenpage_articles_per_page', '10', '', 'zp-core/zp-extensions/zenpage.php'),
(1092, 0, 'zenpage_text_length', '500', '', 'zp-core/zp-extensions/zenpage.php'),
(1093, 0, 'zenpage_textshorten_indicator', ' (...)', '', 'zp-core/zp-extensions/zenpage.php'),
(1094, 0, 'zenpage_read_more', '', '', 'zp-core/zp-extensions/zenpage.php'),
(1095, 0, 'zenpage_indexhitcounter', '', '', 'zp-core/zp-extensions/zenpage.php'),
(1096, 0, 'enabled-zenpage-items', 'news-and-pages', '', 'zp-core/zp-extensions/zenpage.php'),
(1097, 0, 'zenpage_titlelinkdate_articles', '0', '', 'zp-core/zp-extensions/zenpage.php'),
(1098, 0, 'zenpage_titlelinkdate_categories', '0', '', 'zp-core/zp-extensions/zenpage.php'),
(1099, 0, 'zenpage_titlelinkdate_pages', '0', '', 'zp-core/zp-extensions/zenpage.php'),
(1100, 0, 'zenpage_titlelinkdate_location', 'after', '', 'zp-core/zp-extensions/zenpage.php'),
(1101, 0, 'zenpage_titlelinkdate_dateformat', 'timestamp', '', 'zp-core/zp-extensions/zenpage.php'),
(1105, 0, 'zenphoto_news_length', '0', '', 'zp-core/zp-extensions/zenphoto_news.php'),
(1112, 0, 'last_garbage_collect', '[[timestamp]]', '', NULL),
(1120, 0, 'license_accepted', '1.6.8', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(11) unsigned DEFAULT NULL,
  `title` text COLLATE [[collation]],
  `content` longtext COLLATE [[collation]],
  `extracontent` text COLLATE [[collation]],
  `sort_order` varchar(48) COLLATE [[collation]] DEFAULT NULL,
  `show` int(1) unsigned NOT NULL DEFAULT '1',
  `titlelink` varchar(255) COLLATE [[collation]] NOT NULL,
  `commentson` int(1) unsigned DEFAULT '0',
  `codeblock` text COLLATE [[collation]],
  `author` varchar(64) COLLATE [[collation]] NOT NULL,
  `date` datetime DEFAULT NULL,
  `lastchange` datetime DEFAULT NULL,
  `lastchangeuser` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `hitcounter` int(11) unsigned DEFAULT '0',
  `permalink` int(1) unsigned NOT NULL DEFAULT '0',
  `locked` int(1) unsigned NOT NULL DEFAULT '0',
  `expiredate` datetime DEFAULT NULL,
  `total_value` int(11) unsigned DEFAULT '0',
  `total_votes` int(11) unsigned DEFAULT '0',
  `used_ips` longtext COLLATE [[collation]],
  `rating` float DEFAULT NULL,
  `rating_status` int(1) DEFAULT '3',
  `user` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password` varchar(64) COLLATE [[collation]] DEFAULT NULL,
  `password_hint` text COLLATE [[collation]],
  `custom_data` text COLLATE [[collation]],
  `truncation` int(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `titlelink` (`titlelink`(191))
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin_storage`
--

CREATE TABLE `[[dbprefix]]plugin_storage` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(32) COLLATE [[collation]] NOT NULL,
  `aux` varchar(255) COLLATE [[collation]] DEFAULT NULL,
  `data` longtext COLLATE [[collation]],
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `aux` (`aux`(191))
) ENGINE=InnoDB  DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]plugin_storage`
--

INSERT INTO `[[dbprefix]]plugin_storage` VALUES
(1, 'cacheManager', 'garland', 'a:14:{s:5:"theme";s:7:"garland";s:5:"apply";b:0;s:10:"image_size";i:520;s:11:"image_width";N;s:12:"image_height";N;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:0;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(2, 'cacheManager', 'garland', 'a:14:{s:5:"theme";s:7:"garland";s:5:"apply";b:0;s:10:"image_size";i:85;s:11:"image_width";N;s:12:"image_height";N;s:10:"crop_width";s:3:"100";s:11:"crop_height";s:3:"100";s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(3, 'cacheManager', 'zenpage', 'a:14:{s:5:"theme";s:7:"zenpage";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:580;s:12:"image_height";i:580;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";N;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:1;s:5:"valid";i:1;}'),
(4, 'cacheManager', 'zenpage', 'a:14:{s:5:"theme";s:7:"zenpage";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:95;s:12:"image_height";i:95;s:10:"crop_width";i:95;s:11:"crop_height";i:95;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";N;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:0;s:5:"valid";i:1;}'),
(5, 'cacheManager', 'zpMobile', 'a:14:{s:5:"theme";s:8:"zpMobile";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:640;s:12:"image_height";i:640;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";N;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:1;s:5:"valid";i:1;}'),
(6, 'cacheManager', 'zpMobile', 'a:14:{s:5:"theme";s:8:"zpMobile";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:230;s:12:"image_height";i:230;s:10:"crop_width";i:230;s:11:"crop_height";i:230;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:0;s:5:"valid";i:1;}'),
(7, 'cacheManager', 'zpMobile', 'a:14:{s:5:"theme";s:8:"zpMobile";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:79;s:12:"image_height";i:79;s:10:"crop_width";i:79;s:11:"crop_height";i:79;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:0;s:5:"valid";i:1;}'),
(8, 'cacheManager', 'bxslider_thumb_nav', 'a:14:{s:5:"theme";s:18:"bxslider_thumb_nav";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";s:2:"50";s:12:"image_height";s:2:"50";s:10:"crop_width";s:2:"50";s:11:"crop_height";s:2:"50";s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(9, 'defaultCodeblocks', '', 'a:0:{}'),
(10, 'cacheManager', 'galleryArticles', 'a:14:{s:5:"theme";s:15:"galleryArticles";s:5:"apply";b:0;s:10:"image_size";i:80;s:11:"image_width";N;s:12:"image_height";N;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:0;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(11, 'cacheManager', 'GoogleMap', 'a:14:{s:5:"theme";s:9:"GoogleMap";s:5:"apply";b:0;s:10:"image_size";i:150;s:11:"image_width";N;s:12:"image_height";N;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(12, 'cacheManager', 'html_meta_tags', 'a:14:{s:5:"theme";s:14:"html_meta_tags";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";i:1280;s:12:"image_height";i:900;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";N;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:1;s:5:"valid";i:1;}'),
(13, 'cacheManager', 'openstreetmap', 'a:14:{s:5:"theme";s:13:"openstreetmap";s:5:"apply";b:0;s:10:"image_size";i:120;s:11:"image_width";N;s:12:"image_height";N;s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(14, 'cacheManager', 'paged_thumbs_nav', 'a:14:{s:5:"theme";s:16:"paged_thumbs_nav";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";s:2:"50";s:12:"image_height";s:2:"50";s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";b:1;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";N;s:5:"valid";i:1;}'),
(15, 'cacheManager', 'cycle', 'a:14:{s:5:"theme";s:5:"cycle";s:5:"apply";b:0;s:10:"image_size";N;s:11:"image_width";s:3:"595";s:12:"image_height";s:3:"595";s:10:"crop_width";N;s:11:"crop_height";N;s:6:"crop_x";N;s:6:"crop_y";N;s:5:"thumb";N;s:3:"wmk";N;s:4:"gray";N;s:8:"maxspace";b:1;s:5:"valid";i:1;}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_cache`
--

CREATE TABLE `[[dbprefix]]search_cache` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `criteria` text COLLATE [[collation]],
  `date` datetime DEFAULT NULL,
  `data` longtext COLLATE [[collation]],
  PRIMARY KEY (`id`),
  UNIQUE KEY `criteria` (`criteria`(191))
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE [[collation]] NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`(191))
) ENGINE=InnoDB DEFAULT CHARSET=[[charset]] COLLATE=[[collation]] AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
