<?php
namespace NumbersPHP\Tests;

use NumbersPHP\Prime;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-25 at 11:39:58.
 */
class PrimeTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Prime
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Prime;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    /**
     * @covers NumbersPHP\Prime::simple
     */
    public function testSimple()
    {
        $primes = array(2, 17, 839, 3733, 999983);
        $composites = array(1, 4, 18, 25, 838, 3007);
        foreach ($primes as $prime) {
            $this->assertTrue(\NumbersPHP\Prime::simple($prime));
        }

        foreach ($composites as $composite) {
            $this->assertFalse(\NumbersPHP\Prime::simple($composite));
        }
    }

    /**
     * @covers NumbersPHP\Prime::factorization
     * @todo   Implement Prime::factorization().
     */
    public function testFactorization()
    {
        $results[] = \NumbersPHP\Prime::factorization(INF);
        $results[] = \NumbersPHP\Prime::factorization();
        $results[] = \NumbersPHP\Prime::factorization(null);
        $results[] = \NumbersPHP\Prime::factorization(-1);
        $results[] = \NumbersPHP\Prime::factorization(0);
        $results[] = \NumbersPHP\Prime::factorization(1);
        foreach ($results as $result) {
            $this->assertTrue(empty($result));
        }
        unset($results);

        $results[] = array(\NumbersPHP\Prime::factorization(2), 2);
        $results[] = array(\NumbersPHP\Prime::factorization(6), 2, 3);
        $results[] = array(\NumbersPHP\Prime::factorization(9), 3, 3);
        $results[] = array(\NumbersPHP\Prime::factorization('729'), 3, 3, 3, 3, 3, 3);
        $results[] = array(\NumbersPHP\Prime::factorization(3333333791), 2347, 1420253);
        $results[] = array(\NumbersPHP\Prime::factorization(123456789), 3, 3, 3607, 3803);
        $results[] = array(\NumbersPHP\Prime::factorization(9876543210), 2, 3, 3, 5, 17, 17, 379721);
        $results[] = array(\NumbersPHP\Prime::factorization('103103103'), 3, 103, 333667);
        foreach ($results as $result) {
            $this->assertEquals(array_slice($result, 1), $result[0]);
        }
    }

    /**
     * @covers NumbersPHP\Prime::millerRabin
     */
    public function testMillerRabin()
    {
        $primes = array(2, 17, 839, 3733, 999983);
        $composites = array(1, 4, 18, 25, 838, 3007);
        foreach ($primes as $prime) {
            $this->assertTrue(\NumbersPHP\Prime::millerRabin($prime));
        }

        foreach ($composites as $composite) {
            $this->assertFalse(\NumbersPHP\Prime::millerRabin($composite));
        }
    }

    /**
     * @covers NumbersPHP\Prime::sieve
     */
    public function testSieve()
    {
        $results[] = array(\NumbersPHP\Prime::sieve(1));
        $results[] = array(\NumbersPHP\Prime::sieve(2), 2);
        $results[] = array(\NumbersPHP\Prime::sieve(17), 2, 3, 5, 7, 11, 13, 17);
        foreach ($results as $result) {
            $this->assertEquals(array_slice($result, 1), $result[0]);
        }
    }

    /**
     * @covers NumbersPHP\Prime::coprime
     */
    public function testCoprime()
    {
        $this->assertTrue(\NumbersPHP\Prime::coprime(3, 4));
        $this->assertTrue(\NumbersPHP\Prime::coprime(48, 65));
        $this->assertFalse(\NumbersPHP\Prime::coprime(48, 64));
    }

    /**
     * @covers NumbersPHP\Prime::getPerfectPower
     */
    public function testGetPerfectPower()
    {
        $this->assertEquals(array(2, 2), \NumbersPHP\Prime::getPerfectPower(4));

        $this->assertFalse(\NumbersPHP\Prime::getPerfectPower(1));

        $this->assertFalse(\NumbersPHP\Prime::getPerfectPower(3));

        $this->assertEquals(array(3, 2), \NumbersPHP\Prime::getPerfectPower(9));
    }

    /**
     * @covers NumbersPHP\Prime::getPrimePower
     */
    public function testGetPrimePower()
    {
        $this->assertEquals(array(2, 2), \NumbersPHP\Prime::getPrimePower(4));

        $this->assertFalse(\NumbersPHP\Prime::getPrimePower(1));

        $this->assertEquals(array(3, 1), \NumbersPHP\Prime::getPrimePower(3));

        $this->assertEquals(array(3, 2), \NumbersPHP\Prime::getPrimePower(9));


    }
}
