<?php
/*
 * Copyright (c) 2025, Tribal Limited
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Zenario, Tribal Limited nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL TRIBAL LTD BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
if (!defined('NOT_ACCESSED_DIRECTLY')) exit('This file may not be directly accessed');


class zenario_common_features__organizer__site_settings extends ze\moduleBaseClass {
	
	public function preFillOrganizerPanel($path, &$panel, $refinerName, $refinerId, $mode) {
		if ($path != 'zenario__administration/panels/site_settings') return;
		
		//Either show the "site disabled" icon or the "site enabled" icon,
		//depending on whether a language has been enabled,
		//and whether the site is enabled or not.
		if (!ze::setting('default_language')) {
			unset($panel['items']['site_enabled']);
			unset($panel['items']['site_disabled']);
		
		} elseif (!ze::setting('site_enabled')) {
			unset($panel['items']['site_enabled']);
			unset($panel['items']['site_offline']);
		
		} else {
			unset($panel['items']['site_disabled']);
			unset($panel['items']['site_offline']);
		}
		
		
		//If a branding logo is set, change the icon of "Logos and branding" to that logo
		if ($ogImage = ze::setting('default_icon')) {
			$width = $height = $url = false;
			ze\image::link($width, $height, $url, $ogImage, 48, 46);
			$panel['items']['logos_and_branding']['image'] = $url;
		}
		
		if (!ze\module::isRunning('zenario_newsletter')) {
			$panel['items']['email']['name'] = 'Email';
			$panel['items']['email']['desc'] = 'Settings for sending emails from this website.';
		}
		
		if (ze\module::isRunning('zenario_location_manager')) {
			if (ze\module::isRunning('zenario_organization_manager')) {
				if (ze\module::isRunning('zenario_company_locations_manager')) {
					$panel['items']['zenario_location_manager__site_settings_group']['name'] = ze\admin::phrase('Organizations, locations and user roles');
					$panel['items']['zenario_location_manager__site_settings_group']['desc'] = ze\admin::phrase('Settings for organizations/companies, locations, and user roles.');
				} else {
					$panel['items']['zenario_location_manager__site_settings_group']['name'] = ze\admin::phrase('Locations and user roles');
					$panel['items']['zenario_location_manager__site_settings_group']['desc'] = ze\admin::phrase('Settings for locations and user roles.');
				}
			} elseif (ze\module::isRunning('zenario_company_locations_manager')) {
				$panel['items']['zenario_location_manager__site_settings_group']['name'] = ze\admin::phrase('Organizations and locations');
				$panel['items']['zenario_location_manager__site_settings_group']['desc'] = ze\admin::phrase('Settings for organizations/companies and locations.');
			} else {
				$panel['items']['zenario_location_manager__site_settings_group']['name'] = ze\admin::phrase('Locations');
				$panel['items']['zenario_location_manager__site_settings_group']['desc'] = ze\admin::phrase('Settings for locations (places in the real world).');
			}
		}

	}
	
	public function fillOrganizerPanel($path, &$panel, $refinerName, $refinerId, $mode) {
		
	}
	
	public function handleOrganizerPanelAJAX($path, $ids, $ids2, $refinerName, $refinerId) {
		
	}
	
	public function organizerPanelDownload($path, $ids, $refinerName, $refinerId) {
		
	}
}
