﻿// Version du 01/03/2025 : openLayers v10.4.0,
//						amélioration du style de PlanIGN en TMS, pour ce style utilsation de olms_12-4-0.
// Version du 20/05/2024 : openLayers v9.1.0, utlisation PlanIGN en TMS pour remplacer Scan25 si pas de clé IGN,
// Version du 10/12/2023 : openLayers v8.2.0, nouvelles URL IGN,
//							fonction "Direction" d'un itin
// Version du 27/09/2022 : openLayers v7.1.0
// Version du 01/08/2022 : impression d'un itin en entier au 1/25000
// Version du 01/06/2022 : impression A3
// Version du 08/01/2022 : openLayers 6.10.0
// Version du 06/12/2021 : affichage profil altimétrie
// Version du 27/07/2021 : nouvelles licenses IGN, voir Geoservices.ign.fr
// Version du 01/02/2021 : ol6 avec ol-contextmenu

var traces = [];
var tracesP = [];
var urlIGN='https://data.geopf.fr/wmts';
var clickTrackBusy = false;
const dashStyleList = [["dot","Points"],["dash","Tirets"],["dashdot","Points et tirets"],
					["longdash","Tirets longs"],["longdashdot","Tirets longs et points"],["solid","Plein"]];
var newColorTag = newStrokeWidthTag = newStrokeOpacityTag = newDashStyleTag = false;
var nomTraces = [];
var nomServices = [];
var services = [];
var tracesGPX = [];
var servicesGPX = [];
var icones = [];
var fichiersImage = [];
var image = [];
var map,w,itinGraph,pointDisplay;
var featureBornes = ['',''];
var descTraces = [];
var infoTraces = [];
const impIGN = '<div id="IGN"><a href="https://geoservices.ign.fr/" target="_blank"><img src="module/visualizer/vendor/system/img/IGN.gif"></a><a href="https://openlayers.org/" target="_blank"><img src="module/visualizer/vendor/system/img/openLayers.png" alt="Geoportail"></a></div><div id="copyCarte">Pour usage strictement privé<br/>&copy; IGN ' + new Date().getFullYear() +', copie et reproduction interdite</div>';
const couleurs = ["#ff4500","#a52a2a","#7fff00","#dc143c","#00008b","#008b8b","#b8860b","#006400","#ff8C00","#2f4f4f","#8b0000",
					"#00ced1","#1e90ff","#b22222","#008000","#4b0082","#000080","#808000","#800080","#4169e1","#8b4513","#4682b4"];
var indexCouleur = 0;
const A4 = [19,27.5];
const A3 = [27.5,39.5];
const dimPage = {
	paysageA4 : [A4[1],A4[0],'imgWin1',20.5],
	portraitA4 : [A4[0],A4[1],'imgWin2',29.5],
	paysageA3 : [A3[1],A3[0],'imgWin3',29.2],
	portraitA3 : [A3[0],A3[1],'imgWin4',41.7]
}
var impItin = false;

function diplayFiles() {// affichage des noms des traces et des services dans la colonne de droite
	
	if (fichiersTraces.length > 0) {
		document.getElementById("listeTraces").style.display = 'block';
		affichageTraces(fichiersTraces);
	} else {
		htmlT = '<div class="pasDeFichier">Le répertoire des traces est vide !</div>';
		document.getElementById('traces').innerHTML = htmlT;
		document.getElementById("listeTraces").style.display = 'block';
	}
	
	if (repServices) {//Lister les services si validé
		if (fichiersServices.length > 0) {
			document.getElementById("listeServices").style.display = 'block';
			affichageServices(fichiersServices);
		} else {
			htmlS = '<div class="pasDeFichier">Le répertoire des WP est vide !</div>';
			document.getElementById('services').innerHTML = htmlS;
			document.getElementById("listeServices").style.display = 'block';
		}
	} 
	
	if (repTraces != '' && repServices == '') {//Il n'y a que les itinétaires à afficher
		document.getElementById('choice2').style.display = 'none';
		document.getElementById('content2').style.display = 'none';
	}
}

function listImg() {// Lister le nom des images
	
	var formImgWP = new FormData();
	formImgWP.append('Rep','img/wayPoints/');
	fetch('module/visualizer/vendor/system/listeImagesWP.php', { method: 'POST', body: formImgWP })// Lancement du script PHP qui liste le nom des images
	.then(res => res.text())
	.then(result => {
			listeImages(result.split(';'));			
	})
	.catch(err => console.error(err));
}

function editorChoice(choice) {

	// Get all elements with class="contentChoice" and hide them
	let contentChoice = document.getElementsByClassName("contentChoice");
	for (let i = 0; i < contentChoice.length; i++) {
		contentChoice[i].style.display = "none";
	}

	// Get all elements with class="tablinks" and remove the class "active"
	let tablinks = document.getElementsByClassName("tablinks");
	for (let i = 0; i < tablinks.length; i++) {
		tablinks[i].classList.remove("active");
	}

	// Show the current tab, and add an "active" class to the button that opened the tab
	document.getElementById(choice.title).style.display = "block";
	document.getElementById(choice.id).classList.add("active");
}

function loadCarto() {//Chargement de la cartographie et connexe
	
	document.getElementById("titre").innerHTML += titre;
	document.getElementById('map').style.width = mapWidth;
	document.getElementById('map').style.height = mapHeight;
	
	var coll = document.getElementById('collapsible');// Pour rétracter colonne droite
	coll.addEventListener("click", function() {
		let collapsibleDiv = document.getElementById('collapsibleDiv');
		if (collapsibleDiv.style.display === 'none') {
		  collapsibleDiv.style.display = 'block';
		  coll.innerHTML = 'Réduire';
		} else {
		  collapsibleDiv.style.display = 'none';
		  coll.innerHTML = 'Ouvrir';
		}
	});
	
	centreCarte = ol.proj.transform([2.213749, 46.227638], 'EPSG:4326', 'EPSG:3857');// Centre de la France
	zoomCarte = 0;
	
	map = new ol.Map({
		target: 'map',
		controls: [],
		interactions: [],
		keyboardEventTarget: document,// Permet  d'utiliser le clavier pour zoomer et bouger la carte
		view: new ol.View({
			maxResolution: 2445.98490512564,//4891.96981025128,
			minResolution: 0.2985821417,//0.5971642834779395,
			constrainOnlyCenter: true,
			constrainResolution: true,//Supprimer  zooms/résolutions intermédiaires
			extent: [-575000, 4800000, 1250000, 6640000],// [minx, miny, maxx, maxy].
			zoom: zoomCarte,
			center: centreCarte
		})
	});
	//console.log(map.getView().calculateExtent());
	twoClick = new ol.interaction.DoubleClickZoom();
	map.addInteraction(twoClick);
	dragPan = new ol.interaction.DragPan();
	map.addInteraction(dragPan);
	mouseWheelZoom = new ol.interaction.MouseWheelZoom();
	//map.addInteraction(mouseWheelZoom);
	keyboardPan = new ol.interaction.KeyboardPan();
	map.addInteraction(keyboardPan);
	keyboardZoom = new ol.interaction.KeyboardZoom();
	map.addInteraction(keyboardZoom);
	pinchZoom = new ol.interaction.PinchZoom();//Pour écran tactile
	map.addInteraction(pinchZoom);

	var zoomPlusMinus = new ol.control.Zoom();
	map.addControl(zoomPlusMinus);
	
	var fullScreen = new ol.control.FullScreen({
			tipLabel: 'Plein écran',
			source: 'main'
		});
	map.addControl(fullScreen);
	//mapSize = map.getSize();
	fullScreen.on('enterfullscreen', function(evt){
		document.getElementById('map').style.width = '100%';
		document.getElementById('map').style.height = '100%';
	});
	fullScreen.on('leavefullscreen', function(evt){
		document.getElementById('map').style.width = mapWidth;
		document.getElementById('map').style.height = mapHeight;
	});
	
	var mousePosition = new ol.control.MousePosition({
		className: 'mousePosition',
		coordinateFormat: ol.coordinate.createStringXY(5),
		projection: 'EPSG:4326',
		undefinedHTML: ' '
	});
	map.addControl(mousePosition);
	var attributionMap = new ol.control.Attribution({
		className: 'attributionMap',
		collapsible: false
	});
	map.addControl(attributionMap);
	var scaleLine = new ol.control.ScaleLine({
		className: 'scaleLine'
	});
	map.addControl(scaleLine);
	
	var layerSwitcher = new ol.control.LayerSwitcher({
		tipLabel: 'Couches' // Optional label for button
	});
	map.addControl(layerSwitcher);
	
	let lonFormatter = function(lon) {// nécessaire car bien que fourni en décimal lon est affichée en degrés ...
		return lon.toFixed(3);
	};

	let latFormatter = function(lat) {// nécessaire car bien que fourni en déci lat est affichée en degrés ...
		return lat.toFixed(3);
	};
	
	graticule = new ol.layer.Graticule({
		//title: 'Quadrillage',// ce qui permet de l'afficher dans le layerSwitcher
		visible: false,
		zIndex: 100,
		strokeStyle: new ol.style.Stroke({
				color: '#aa0000',
				width: 1,
				lineDash: [15, 15]
			}),
		showLabels: true,
		lonLabelFormatter: lonFormatter,
		latLabelFormatter: latFormatter,		
		latLabelPosition: 0.97,		
		lonLabelStyle: new ol.style.Text({
			font: 'italic 12px Calibri,sans-serif',
			offsetX: -25,
			textBaseline: 'bottom',
			fill: new ol.style.Fill({
					//color: '#ffffff'
					color: '#aa0000'
				}),
			/*backgroundFill: new ol.style.Fill({
					color: '#aa0000'
				}),*/
			stroke: new ol.style.Stroke({
					//color: '#ffffff',
					color: '#aa0000',
					width: 0.5
				})
			}),
		latLabelStyle: new ol.style.Text({
			font: 'italic 12px Calibri,sans-serif',
			textBaseline: 'bottom',
			fill: new ol.style.Fill({
					//color: '#ffffff'
					color: '#aa0000'
				}),
			/*backgroundFill: new ol.style.Fill({
					color: '#aa0000'
				}),*/
			stroke: new ol.style.Stroke({
					//color: '#ffffff',
					color: '#aa0000',
					width: 0.5
				})
			}),
		intervals:  [5,2, 1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1,
					0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02,0.01,
					0.005, 0.003, 0.001],
		wrapX: false
	});
	
	var extent = [-20037508.342789244, -20037508.342789244, 20037508.342789244,
	20037508.342789244];
	
	var resolutions = [/*9.5546285356,*/4.777314267823516, 2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.2985821417];
	
	var resolutions2 = [ 2445.98490512564, 1222.99245256282, 611.49622628141, 305.7481131407048, 152.8740565703525,
	76.43702828517624, 38.21851414258813, 19.10925707129406, 9.5546285356];

	var resolutions3 = [ 2445.98490512564, 1222.99245256282, 611.49622628141, 305.7481131407048, 152.8740565703525,
	76.43702828517624, 38.21851414258813, 19.10925707129406, 9.5546285356, 4.777314267823516,
	2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.2985821417];

	var tileGrid = new ol.tilegrid.WMTS({
		origin: [extent[0], extent[3]],
		extent: [-575000, 4800000, 1250000, 6640000],// [minx, miny, maxx, maxy].
		resolutions: resolutions,
		matrixIds: [/*14,*/15,16,17,18,19]
	});
	var tileGrid2 = new ol.tilegrid.WMTS({
		origin: [extent[0], extent[3]],
		extent: [-575000, 4800000, 1250000, 6640000],// [minx, miny, maxx, maxy].
		resolutions: resolutions2,
		matrixIds: [6,7,8,9,10,11,12,13,14]
	});
	
	var tileGrid3 = new ol.tilegrid.WMTS({
		origin: [extent[0], extent[3]],
		extent: [-575000, 4800000, 1250000, 6640000],// [minx, miny, maxx, maxy].
		resolutions: resolutions3,
		matrixIds: [6,7,8,9,10,11,12,13,14,15,16,17,18,19]
	});
	
	if ( cleAPI == '') {	
		ign_source = new ol.source.VectorTile({
			tilePixelRatio: 1,
			tileGrid: ol.tilegrid.createXYZ({ maxZoom: 19 }),
			format: new ol.format.MVT(),
			//projection: 'EPSG:3857',
			url : 'https://data.geopf.fr/tms/1.0.0/PLAN.IGN/{z}/{x}/{y}.pbf',
			attributions: impIGN
		});
		ign = new ol.layer.VectorTile({
			//title: 'Plan IGN vecteur',
			renderMode: 'hybrid',//hybrid
			minResolution: 0.5971642834779395,//incluse 0.2985821417
			maxResolution: 19.10925707129406,//exclue 9.554628535647032 19.10925707129406
			source: ign_source,
			declutter: false
		  });
		  
		  /*// Pour fichier json distant
		  url_1 =  'https://data.geopf.fr/annexes/ressources/vectorTiles/styles/PLAN.IGN/classique.json';
		  url_2 =  'https://data.geopf.fr/annexes/ressources/vectorTiles/styles/PLAN.IGN/standard.json';
		  fetch(url_1).then(res => res.json()).then(style => {
			  console.log(style);
			  olms.stylefunction(ign, style, 'plan_ign');
			  //map.addLayer(ign);
		  })*/
		  
		  olms.stylefunction(ign, styleTMScustom, 'plan_ign');// styleTMScustom : variable chargée via un fichier js local
		  
	}
	else {
		ign_source = new ol.source.WMTS({
			//url: 'https://wxs.ign.fr/'+ cleAPI +'/geoportail/wmts',
			url: 'https://data.geopf.fr/private/wmts?apikey=' + cleAPI,
			layer: 'GEOGRAPHICALGRIDSYSTEMS.MAPS',
			attributions: impIGN,
			matrixSet: 'PM',
			crossOrigin: 'anonymous',
			format: 'image/jpeg',
			projection: 'EPSG:3857',
			cacheSize: 300,// Valeur nécessaire pour affichage sur tout l'écran lors de displayImpArea()
			tileGrid: tileGrid,
			style: 'normal'
		});
		ign = new ol.layer.Tile({
			//title: 'TopoIGN',// si présent : affichage dans le layerSwitcher
			//title: 'SCAN',
			minResolution: 0.5971642834779395,//incluse 0.2985821417
			//maxResolution: 9.554628535647032,//exclue 9.554628535647032 19.10925707129406
			maxResolution: 19.10925707129406,//exclue 9.554628535647032 19.10925707129406
			source: ign_source
		});
		//map.addLayer(ign1);
	}
	
	var ign_source2 = new ol.source.WMTS({
		//url: 'https://wxs.ign.fr/essentiels/geoportail/wmts',
		url: urlIGN,
		layer: 'GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2',
		attributions: impIGN,
		matrixSet: 'PM',
		crossOrigin: 'anonymous',
		format: 'image/png',
		projection: 'EPSG:3857',
		tileGrid: tileGrid2,
		style: 'normal'
	});	
	var ign_source3 = new ol.source.WMTS({
		//url: 'https://wxs.ign.fr/essentiels/geoportail/wmts',
		url: urlIGN,
		layer: 'ORTHOIMAGERY.ORTHOPHOTOS',
		attributions: impIGN,
		matrixSet: 'PM',
		crossOrigin: 'anonymous',
		format: 'image/jpeg',
		projection: 'EPSG:3857',
		cacheSize: 300,// Valeur nécessaire pour affichage sur tout l'écran lors de displayImpArea()
		tileGrid: tileGrid3,
		style: 'normal'
	});
	
	/*ign = new ol.layer.Tile({
		//title: 'TopoIGN',// si présent : affichage dans le layerSwitcher
		minResolution: 0.5971642834779395,//incluse 0.5971642834779395 0.2985821417
		maxResolution: 9.554628535647032,//exclue
		source: ign_source
	});*/
	ign2 = new ol.layer.Tile({
		//title: 'TopoIGN 2',// // si présent : affichage dans le layerSwitcher		
		//minResolution: 9.554628535647032,//incluse
		minResolution: 19.10925707129406,//incluse
		maxResolution: 9783.939620502562,//exclue
		source: ign_source2
	});
	ign3 = new ol.layer.Tile({
		title: 'Photos',
		visible: false,
		source: ign_source3
	});
	
	osmTopo = new ol.layer.Tile({
		title: 'OSM Topo',
		visible: false,
		//minResolution: 0.2985821417,//incluse
		minResolution: 1.194328566955879,//incluse
		maxResolution: 4891.96981025128,//exclue
		source: new ol.source.XYZ({
				//attributions: '<div id="OSM"><div id="OSMTexte">&copy; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a></div></div><div id="copyCarte">&copy; OSM ' + new Date().getFullYear() +'</div>',
				attributions: '<div id="IGN" class="osm">&copy; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap contributors</a></div><div id="copyCarte">&copy; OSM ' + new Date().getFullYear() +'</div>',
				url: 'https://{a-c}.tile.opentopomap.org/{z}/{x}/{y}.png',
				cacheSize: 300,// Valeur nécessaire pour affichage sur tout l'écran lors de displayImpArea()
				crossOrigin: 'anonymous'
			})
	});

	map.addLayer(ign);
	map.addLayer(ign2);
	map.addLayer(ign3);
	map.addLayer(osmTopo);
	map.addLayer(graticule);
	
	if (dep) {//Affichage des limites du Département si souhaité
		nomFichier = dep + ".gpx";
		limitesDepartement (nomFichier);
	}
	
	/*map.on('moveend', function(evt){
		console.log(map.getView().getResolution());
	});*/
	
	osmTopo.on('change:visible', function(evt){
		switch (evt.oldValue) {        
			case false:
				ign_source.setAttributions('');
				ign_source2.setAttributions('');
				ign_source3.setAttributions('');
				ign.setVisible(false);
				ign2.setVisible(false);
				if(ign3.getVisible() == true){
					ign3.setVisible(false);
				}
				break;
			case true:
				ign_source.setAttributions(impIGN);
				ign_source2.setAttributions(impIGN);
				ign_source3.setAttributions(impIGN);
				if(ign3.getVisible() != true){
					ign.setVisible(true);
					ign2.setVisible(true);
				}
				break;
		}		
	});
	ign3.on('change:visible', function(evt){
		switch (evt.oldValue) {        
			case false:
				ign.setVisible(false);
				ign2.setVisible(false);
				if(osmTopo.getVisible() == true){
					osmTopo.setVisible(false);
				}
				break;
			case true:
				if(osmTopo.getVisible() != true){
					ign.setVisible(true);
					ign2.setVisible(true);
				}
				break;
		}		
	});
	
	var contextmenuMain_items = [// pour menu contextuel principal
		{
			text: 'Légende pour zoom "scan25"',
			callback: legende,
		},
		{
			text: 'Centrer carte ici',
			callback: centrerCarte,
		},
		{
			text: 'Afficher/Masquer Quadrillage',
			callback: quadrillage,
		},
		{
			text: 'Imprimer',
			items: [
				{
					text: 'A4-Portrait : Comme à l\'écran',
					callback: impContextuel_1,
				},
				{
					text: 'A4-Paysage : Comme à l\'écran',
					callback: impContextuel_2,
				},
				{
					text: 'A3-Portrait : Comme à l\'écran',
					callback: impContextuel_3,
				},
				{
					text: 'A3-Paysage : Comme à l\'écran',
					callback: impContextuel_4,
				},
				{
					text: 'A4 : 1/25000',
					callback: impContextuel_5,
				},
				{
					text: 'A3 : 1/25000',
					callback: impContextuel_6,
				},
			],
		},
	];
	
	featuresItinItem = [// pour menu contextuel
		'-', // séparateur
		{
			text: 'Itinéraire',
			items: [
				{
					text: 'Centrer',
					callback: centrerItin,
				},
				{
					text: 'Modifier Style',
					callback: styleItin,
				},
				{
					text: 'Direction',
					callback: dirItin,
				},
				{
					text: 'Direction inversée',
					callback: dirItinInv,
				},
				{
					text: 'Afficher/Masquer Bornes',
					callback: bornesItin,
				},
				{
					text: 'Profil altimétrie',
					callback: graphAlti,
				},
			],			
		},
		{
			text: 'Itinéraire - Imprimer',
			items: [
				{
					text: 'A4-Paysage : 1/25000',
					callback: impContextuel_7,
				},
				{
					text: 'A4-Portrait : 1/25000',
					callback: impContextuel_8,
				},
				{
					text: 'A3-Paysage : 1/25000',
					callback: impContextuel_9,
				},
				{
					text: 'A3-Portrait : 1/25000',
					callback: impContextuel_10,
				},
			],
			
		},
	];
	
	contextImpItin = [// pour menu contextuel fenêtre imp
		{
			text: 'Ajout fenêtre ici',
			callback: ajoutWin,
		},
		{
			text: 'Suppression fenêtre',
			callback: suppWin,
		},
		{
			text: 'Inverser orientation',
			callback: inverserOrientation,
		},
	];
	
	contextMenuMain = new ContextMenu({// menu contextuel sur clic droit
			width: 210,
			defaultItems: false,
			items: contextmenuMain_items,
		});
	contextMenuMain.setTarget('main');// le controle est placé dans la div main au lieu de map (par defaut) : sa div peut alors être au dessous de toutes les autres
	map.addControl(contextMenuMain);
	
	contextMenuMain.on('beforeopen', (evt) => {
		const feature = map.forEachFeatureAtPixel(evt.pixel, (ft, l) => ft);// récupération de la feature de l'endroit du clic
		contextMenuMain.clear();
		if (feature && feature.get('name')) {// feature.get('name') : pour couche TMS car considérée comme feature
			typeFeature = feature.getGeometry().getType();
			if (typeFeature != 'Point') {
				//itinToolTip.hide();
				toolTip1.style.visibility = 'hidden';			
				switch (typeFeature) {        
					case 'LineString':
					case 'MultiLineString':
						if (impItin == false) {
							contextMenuMain.extend(contextmenuMain_items);
							contextMenuMain.extend(featuresItinItem);
							featuresItinItem.data = {
								id: feature.getId(),
								feature: feature,
							};
						} else {
							contextMenuMain.extend(contextImpItin);
							featuresItinItem.data = {};
							featuresItinItem.data.type = 'Carte';
							
						}
						break;
					case 'Polygon':
						contextMenuMain.extend(contextImpItin);
						featuresItinItem.data = {
							type: typeFeature,
							id: feature.getId(),
							feature: feature
						};
						break;
					default:
						contextMenuMain.extend(contextmenuMain_items);
				}
			} else {
				//servicesToolTip.hide();
				toolTip3.style.visibility = 'hidden';
				contextMenuMain.extend(contextmenuMain_items);
			}
		} else {
			if (impItin == false) {
				contextMenuMain.extend(contextmenuMain_items);
			} else {
				contextMenuMain.extend(contextImpItin);
				featuresItinItem.data = {};
				featuresItinItem.data.type = 'Carte';
				
			}
		}
	});
	
	if (typeof affTracesCharg != "undefined") {
		if (affTracesCharg == 1 && fichiersTraces.length > 0) {
			visualiserTraces(fichiersTraces);// permet de visualiser les itinéraires au chargement de la page
		}
	}
}

function ajoutWin(contexte){
	const center = contexte.coordinate;
	const winAdd = new ol.Feature(// création du polygone qui simule une page au 1/25000
		new ol.geom.Polygon([[[center[0]-W/2, center[1]-H/2], [center[0]+W/2, center[1]-H/2],[center[0]+W/2, center[1]+H/2], [center[0]-W/2, center[1]+H/2], [center[0]-W/2, center[1]-H/2]]])
	)
	winAdd.setId('win' + winAdd.ol_uid);
	winAdd.set('page', page);
	winAdd.set('name', 'win');
	let colorArray = ol.color.asArray('#f2f3f4');
	colorArray[3] = 0.2;
	winAdd.setStyle(
		new ol.style.Style({
			stroke: new ol.style.Stroke({
					color: ' #17202a'
				}),
			fill: new ol.style.Fill({
					color: colorArray
				})
		})
	);
	dragImpLayer.getSource().addFeature(winAdd);
}

function suppWin(contexte){
	if (featuresItinItem.data.type == 'Polygon') {
		const winToRemove = dragImpLayer.getSource().getFeatureById(featuresItinItem.data.id);
		dragImpLayer.getSource().removeFeature(winToRemove);
	}
	else {
		alert ('Se positionner sur une fenêtre pour la supprimer !');		
	}	
}

function inverserOrientation(){
	const resolution = map.getView().getResolution();
	
	if (featuresItinItem.data.type == 'Polygon') {
		const winToModify = dragImpLayer.getSource().getFeatureById(featuresItinItem.data.id);
		let Wc,Hc,pageC;
		
		switch (winToModify.get('page')) {
			case 'portraitA4':
				Wc = length_1 * resolution;
				Hc = length_2 * resolution;
				pageC = 'paysageA4';
				break;
			case 'portraitA3':
				Wc = length_3 * resolution;
				Hc = length_4 * resolution;
				pageC = 'paysageA3';
				break;
			case 'paysageA4':
				Wc = length_2 * resolution;
				Hc = length_1 * resolution;
				pageC = 'portraitA4';
				break;
			case 'paysageA3':
				Wc = length_4 * resolution;
				Hc = length_3 * resolution;
				pageC = 'portraitA3';
				break;
		}
		const center = ol.extent.getCenter(winToModify.getGeometry().getExtent());
		const coord = [[[center[0]-Wc/2, center[1]-Hc/2], [center[0]+Wc/2, center[1]-Hc/2],[center[0]+Wc/2, center[1]+Hc/2], [center[0]-Wc/2, center[1]+Hc/2], [center[0]-Wc/2, center[1]-Hc/2]]];
		winToModify.set('page', pageC);
		winToModify.getGeometry().setCoordinates(coord);
	}
	else {	
		const winsToModify = dragImpLayer.getSource().getFeatures();
		const nbrWin = winsToModify.length;	
		let W,H;
		switch (page) {
			case 'portraitA4':
				W = length_1 * resolution;
				H = length_2 * resolution;
				page = 'paysageA4';
				pageCheck = 'paysage et A4';
				break;
			case 'portraitA3':
				W = length_3 * resolution;
				H = length_4 * resolution;
				page = 'paysageA3';
				pageCheck = 'paysage et A3';
				break;
			case 'paysageA4':
				W = length_2 * resolution;
				H = length_1 * resolution;
				page = 'portraitA4';
				pageCheck = 'portrait et A4';
				break;
			case 'paysageA3':
				W = length_4 * resolution;
				H = length_3 * resolution;
				page = 'portraitA3';
				pageCheck = 'portrait et A3';
				break;
		}
		
		for (let n = 0; n < nbrWin; n++) {
			const center = ol.extent.getCenter(winsToModify[n].getGeometry().getExtent());
			const coord = [[[center[0]-W/2, center[1]-H/2], [center[0]+W/2, center[1]-H/2],[center[0]+W/2, center[1]+H/2], [center[0]-W/2, center[1]+H/2], [center[0]-W/2, center[1]-H/2]]];
			winsToModify[n].set('page', page);
			winsToModify[n].getGeometry().setCoordinates(coord);
		}
	}
}

function legende(){
	//window.open('legendePerso.pdf','','menubar=yes, resizable=yes, status=no, scrollbars=yes, width==700, height=600');
	let legend = document.createElement('a');
	legend.target = '_blank';
	legend.href = 'module/visualizer/vendor/system/legendePerso.pdf';
	legend.click();
	legend.remove();
}

function centrerCarte(contexte){
	map.getView().setCenter(contexte.coordinate);
}

function quadrillage(){
	if(graticule.getVisible() == false){
		graticule.setVisible(true);
	} else {
		graticule.setVisible(false);
	}
}

function impContextuel_1(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "Comme à l'écran";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A4";
	document.getElementsByName('orientation')[0].checked = true;
	validImp();
}

function impContextuel_2(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "Comme à l'écran";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A4";
	document.getElementsByName('orientation')[1].checked = true;
	validImp();
}

function impContextuel_3(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "Comme à l'écran";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A3";
	document.getElementsByName('orientation')[0].checked = true;
	validImp();
}

function impContextuel_4(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "Comme à l'écran";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A3";
	document.getElementsByName('orientation')[1].checked = true;
	validImp();
}

function impContextuel_5(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A4";
	validImp();
}

function impContextuel_6(){
	document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A3";
	validImp();
}

function impContextuel_7(){
	//document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A4";
	document.getElementsByName('orientation')[1].checked = true;
	itinDisplayImpArea(featuresItinItem.data);
}

function impContextuel_8(){
	//document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A4";
	document.getElementsByName('orientation')[0].checked = true;
	itinDisplayImpArea(featuresItinItem.data);
}

function impContextuel_9(){
	//document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A3";
	document.getElementsByName('orientation')[1].checked = true;
	itinDisplayImpArea(featuresItinItem.data);
}

function impContextuel_10(){
	//document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value = "1/25000";
	document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value = "A3";
	document.getElementsByName('orientation')[0].checked = true;
	itinDisplayImpArea(featuresItinItem.data);
}

function centrerItin(){
	//centrerFT(featuresItinItem.data.id);
	map.getView().fit(featuresItinItem.data.feature.getGeometry().getExtent());//centrage et zoom en même temps
}

function styleItin(){
	if ( clickTrackBusy == false) {
		document.getElementById('modifOk').style.display = 'inline-block';
		//itinToolTip.hide();
		toolTip1.style.visibility = 'hidden';
		let modifStyle = '';
		fSelectM = featuresItinItem.data.feature;
		document.getElementById('boutonsModif').innerHTML = `Modification style :<br/>${fSelectM.get('name')}`;
		
		modifStyle += `Couleur : <input type="color" value="${fSelectM.get('color')}" id="color" class="color" onchange="myColor(this)">    `;
		modifStyle += ' Largeur : <select id="width" class="bouton" onchange="strokeWidth(this);">';
		for (let x = 1 ; x < 11 ; x++) {
			if (fSelectM.get('width') == x){
				modifStyle += '							<option value="' + x + '" selected>' + x + '</option>';
			}
			else
			{
				modifStyle += '							<option value="' + x + '" >' + x + '</option>';		
			}
		}
		modifStyle += '			</select>    ';
		modifStyle += ' Opacité : <select id="opacity" class="bouton" onchange="strokeOpacity(this);">';
		for (let x = 1 ; x < 11 ; x++) {
			if (fSelectM.get('opacity') == x/10){
				modifStyle += '							<option value="' + x/10 + '" selected>' + x + '</option>';
			}
			else
			{
				modifStyle += '							<option value="' + x/10 + '" >' + x + '</option>';		
			}
		}
		modifStyle += '			</select><br/><br/>';
		modifStyle += 'Type de trait : <select id="dash" class="bouton" onchange="dashStyleSet(this);">';
		for (let y = 0 ; y < dashStyleList.length ; y++) {
			if (dashStyleList[y][0] == fSelectM.get('lineDashText')){
				modifStyle += '							<option value="' + dashStyleList[y][0] + '" selected>' + dashStyleList[y][1] + '</option></div></li>';
			}
			else
			{
				modifStyle += '							<option value="' + dashStyleList[y][0] + '" >' + dashStyleList[y][1] + '</option></div></li>';		
			}
		}
		modifStyle += '			</select><br/>';			
		
		document.getElementById('modifStyle').innerHTML = modifStyle;
		document.getElementById('divModif').style.display = 'block';
		clickTrackBusy = true;
	}
}

function bornesItin(){
	let fSelect = featuresItinItem.data.feature;
	let featureName = fSelect.get('name');
	let nameItin = fSelect.get('nameItin');
	switch (featureBornes[0]) {        
		case '':
			bornesCreate(fSelect);
			featureBornes = [featureName, nameItin];
			break;
		case featureName:
			map.removeLayer(bornes);
			bornes.getSource().clear();
			bornes = [];
			map.removeInteraction(selectBorne);
			selectBorne = '';
			featureBornes = ['',''];
			break;
		default:
			map.removeLayer(bornes);
			bornes.getSource().clear();
			bornes = [];
			map.removeInteraction(selectBorne);
			selectBorne = '';
			bornesCreate(fSelect);
			featureBornes = [featureName, nameItin];
		}
}

function graphAlti(){
	if (typeof(itinGraph) == 'object' ) {
		map.removeLayer(pointDisplay);
		pointDisplay = [];
		itinGraph.close();
	}
	
	let feature = featuresItinItem.data.feature;
	let coord = [];

	//if (feature.getGeometry().getLayout() != 'XY'){
		if (feature.getGeometry().getLayout() != 'XY'){// récupération des coordonnées et altitudes (si dans fichier GPX du serveur)
			coord = feature.getGeometry().getCoordinates()[0];
			drawGraph();
		}
		else // Alti à récupérer
		{
			getAlti(feature, getAltiFXY);
			function getAltiFXY() {
				if (feature.get('CoordOk') == 'ok') {
					coord = feature.get('Coord');
					drawGraph();		
				}
				else {
					const message = 'Données altimétries non récupérées pour cette trace, à faire :\n'+
								' 1) effacer tout l\'historique de votre navigateur,\n'+
								' 2) arrêter puis relancer votre navigateur,\n'+
								' 3) afficher l\'altimétrie de la trace.\n'+
								'\n'+
								' Si cela persiste, le réseau ou le serveur IGN est en cause :\n'+
								' refaire votre travail utérieurement.';
					alert (message);
					return;
				}
			}
		}
		
		function drawGraph() {
			let alt = [];// tableau des altitudes
			let l = coord.length;
			for (let n = 0 ;n < l; n++) {//	récupération des altitudes
				alt.push(coord[n][2]);
			}
			let altMin = Math.min.apply(null, alt);
			let altMax = Math.max.apply(null, alt);
			
			// calcul cumuls dénivelés positif et négatif
			let deniPos = 0;
			let deniNeg = 0;
			const stepInc = 10;// ne sert plus ; min = 1, step incrémental pour lisser valeurs et courbe, réutilisé par drawGraph
			const seuil = 3;// seuil en m d'altitude pour lisser valeurs et courbe, réutilisé par drawGraph
			let altRef = alt[0];
			//for (let n = 0 ;n < l-stepInc; n += stepInc) {
			for (let n = 0 ;n < l-1; n += 1) {
				let alt1 = altRef;
				//let alt1 = alt[n];
				//let alt2 = alt[n+stepInc];
				let alt2 = alt[n+1];
				let deltaAlti = alt2 - alt1;
				if( Math.abs(deltaAlti) > seuil) {
					if( Math.sign(deltaAlti) == 1) {
						deniPos += deltaAlti;						
					}
					else {
						deniNeg += deltaAlti;
					}
					altRef = alt[n+1];
				}	
			}
			
			const nomTrace = feature.get('name');
			const lonTrace = feature.get('longueur')
			
			itinGraph = window.open('','','menubar=yes, resizable=yes, status=no, scrollbars=yes, left=5, top=5, width=650, height=420');
			itinGraph.document.write('<html><head><title>Info Altimétrie</title><link rel="stylesheet" type="text/css" href="module/visualizer/vendor/system/stylesDev.css"><link rel="stylesheet" type="text/css" href="module/visualizer/vendor/system/stylesImpDev.css" media="print"></head>');
			itinGraph.document.write('<body>');
			itinGraph.document.write('<div id="printInfo"><input type="image" class="icone" src="module/visualizer/vendor/system/img/print-2.png" onclick="window.print(); return false;" /></div>');
			itinGraph.document.write('<div id="graphe">');
			itinGraph.document.write('<div id="titre" class="div_titre">' + nomTrace + ' : profil à titre indicatif.</div>');
			itinGraph.document.write('<canvas id="myGraph" width="600" height="250"></canvas>');
			itinGraph.document.write('<canvas id="sup" width="600" height="250"></canvas>');
			itinGraph.document.write('<div id="infoTrk">');
			itinGraph.document.write('<p class="infoTrk">Longueur du tracé = ' + lonTrace + ' km</p>');
			itinGraph.document.write('<p class="infoTrk">Altitude min = ' + altMin.toFixed(0) + ' m, Altitude max = ' + altMax.toFixed(0) + ' m</p>');
			itinGraph.document.write('<p class="infoTrk">Dénivelé positif = ' + deniPos.toFixed(0) + ' m, Dénivelé négatif = ' + Math.abs(deniNeg.toFixed(0)) + ' m</p>');
			itinGraph.document.write('<div id="clickDiv" class="infoTrk"><button id="click">Parcourir ...</button></div>');
			itinGraph.document.write('</div></div></div></body></html>');
			itinGraph.document.write('<script>'+ drawGraphSuite(coord, alt, lonTrace, stepInc, seuil) +';<\/script>');
		}
	/*}
	else
	{
		alert('La trace ne contient pas de données d\'altimétrie !');
	}*/
	
	function drawGraphSuite(coord, alt, lonTrace, stepInc, seuil) {
		
		let l = coord.length;
		let coordWGS84 = [];
		for (let x = 0 ; x < l ; x++) {// transformation des coordonnées en WGS84
			coordWGS84[x] = ol.proj.transform(coord[x], 'EPSG:3857', 'EPSG:4326');
		}

		let dist = [];// tableaux de la distance de chaque point de la trace
		dist.push(0);// distance du 1er point
		let distance = 0;
		for (let n = 0 ;n < l-1; n++) {
			distance += ol.sphere.getDistance([coordWGS84[n][0], coordWGS84[n][1]], [coordWGS84[n+1][0], coordWGS84[n+1][1]]);
			dist.push(distance / 1000);
		}

		pointDisplay = new ol.layer.Vector({
			source: new ol.source.Vector()
		});
		let pointDisplayFormat = new ol.format.GeoJSON();
		let stylePoint = new ol.style.Style({
			zIndex:1,
			image: new ol.style.Circle({
				radius: 6,
				fill: new ol.style.Fill({ color: '#3cb371' })
				})
		});
		pointDisplay.setVisible(false);
		map.addLayer(pointDisplay);
		// Préparation affichage point sur trace
		let line = turf.lineString(coordWGS84);// avec points en WGS84
		
		lineGraph = new jlcGraphe({
			id : 'myGraph',
			window : itinGraph
		
		});
		lineGraph.addGraph(dist, alt, lonTrace, stepInc, seuil);
		lineGraph.moveOnTrk(id = 'sup', action1 = raz, action2 = display);
		
		itinGraph.document.getElementById('click').addEventListener('click', followLineOn);
		
		function followLineOn() {
			lineGraph.followLine(id = 'sup', action1 = raz, action2 = display);
		}		

		function raz() {// action si curseur sur canvas, ou pour fonction followLineOn()
			pointDisplay.getSource().clear();
			pointDisplay.setVisible(false);
		}
			
		function display(pointX,pointY) {// action si curseur sur courbe alti, ou pour fonction followLineOn()
			// affichage point sur trace
			let pointToDisplay = pointDisplayFormat.readFeature(turf.along(line, pointX, {units:'kilometers'}),{
					dataProjection: 'EPSG:4326',
					featureProjection: 'EPSG:3857'
			});
			pointToDisplay.setStyle(stylePoint);
			pointDisplay.getSource().addFeature(pointToDisplay);
			pointDisplay.setVisible(true);
			
		}
	}
}

function dirItin(){
	let fSelect = featuresItinItem.data.feature;
	if (Array.isArray(fSelect.get('Styles'))) {
		let colorArray = ol.color.asArray(fSelect.get('color'));
		colorArray[3] = Number(fSelect.get('opacity'));			
		fSelect.setStyle(
			new ol.style.Style({
				stroke: new ol.style.Stroke({
					color: colorArray,
					width: fSelect.get('width'),
					lineDash: fSelect.get('lineDash')
				})
			})
		);
		fSelect.set('Styles',fSelect.getStyle());
		if ( fSelect.get('dir') == 'inv') {
			const traceCoord = fSelect.getGeometry().getCoordinates()[0];
			fSelect.set('dir', 'nor');
			directionCreate(fSelect, traceCoord);
		}
	}
	else {
		const traceCoord = fSelect.getGeometry().getCoordinates()[0];
		fSelect.set('dir', 'nor');
		directionCreate(fSelect, traceCoord);
	}
}

function dirItinInv(){
	let fSelect = featuresItinItem.data.feature;
	if (Array.isArray(fSelect.get('Styles'))) {
		let colorArray = ol.color.asArray(fSelect.get('color'));
		colorArray[3] = Number(fSelect.get('opacity'));			
		fSelect.setStyle(
			new ol.style.Style({
				stroke: new ol.style.Stroke({
					color: colorArray,
					width: fSelect.get('width'),
					lineDash: fSelect.get('lineDash')
				})
			})
		);
		fSelect.set('Styles',fSelect.getStyle());
		if ( fSelect.get('dir') == 'nor') {
			const traceCoord = fSelect.getGeometry().getCoordinates()[0].reverse();
			fSelect.set('dir', 'inv');
			directionCreate(fSelect, traceCoord);
		}
	}
	else {
		const traceCoord = fSelect.getGeometry().getCoordinates()[0].reverse();
		fSelect.set('dir', 'inv');
		directionCreate(fSelect, traceCoord);
	}
}

function directionCreate(fSelect, traceCoord) {
	//const colorArray = ol.color.asArray(fSelect.get('color'));
	let trace = new ol.format.GeoJSON();			
	const nbreCoord = traceCoord.length;
	for (let x = 0 ; x < nbreCoord ; x++) {
		traceCoord[x] = ol.proj.transform(traceCoord[x], 'EPSG:3857', 'EPSG:4326');
		
	}
	
	line = turf.lineString(traceCoord);
	const longueurTrace = turf.length(line, {units:'kilometers'});
	const intervalleFleche = 2;// en km
	const nbreFleches = parseInt(longueurTrace / intervalleFleche);
	let colorArray = ol.color.asArray(fSelect.get('color'));
	colorArray[3] = Number(fSelect.get('opacity'));	
	const styleF = new ol.style.Style({// style actuelle de la feature
				stroke: new ol.style.Stroke({
					color: colorArray,
					width: fSelect.get('width'),
					lineDash: fSelect.get('lineDash')
				})
			});
	
	let styles = [];
	styles.push(styleF);// sauvegarde style actuelle de la feature
	for (let i = 1; i <= nbreFleches; i++) {// Positionnemnt des flêches de direction
		const turfPoint1 = turf.along(line, i * intervalleFleche, {units:'kilometers'});
		const end = trace.readFeature(turfPoint1,{
				dataProjection: 'EPSG:4326',
				featureProjection: 'EPSG:3857'
		});
		const turfPoint2 = turf.along(line, i * intervalleFleche - 0.005, {units:'kilometers'});
		const start = trace.readFeature(turfPoint2,{
				dataProjection: 'EPSG:4326',
				featureProjection: 'EPSG:3857'
		});
		let endCoord = end.getGeometry().getCoordinates();
		let startCoord = start.getGeometry().getCoordinates();
		const dx = endCoord[0] - startCoord[0];
		const dy = endCoord[1] - startCoord[1];
		const rotation = Math.atan2(dy, dx);
		
		styles.push(
			new ol.style.Style({
				geometry: new ol.geom.Point(endCoord),
				image: new ol.style.Icon({
					src: 'module/visualizer/vendor/system/img/arrow3.png',
					color: colorArray,
					crossOrigin: 'anonymous',
					anchor: [1, 0.5],
					scale: 0.65,
					rotateWithView: true,
					rotation: -rotation,
				}),
			})
		);
	}
	fSelect.setStyle(styles);
	fSelect.set('Styles',styles);
}

function listeImages(liste) {// utiliser par listeImagesWP.php
	fichiersImage = liste.sort();
	let nbrF = fichiersImage.length;
	/*for(let i = 0 ; i < nbrF ; i++){// préchargement des images pour utilisation ultérieure
		image[i] = new Image();
		//image[i].src = '../systeme/img/wayPoints/'+ fichiersImage[i];
		image[i].src = 'module/visualizer/vendor/system/img/wayPoints/'+ fichiersImage[i];
	}*/
}

function docListe(fichiersDocItin,fichiersDocServices) {
	fichiersDocItin2 = fichiersDocItin;
	fichiersDocServices2 = fichiersDocServices;
}

function affichageTraces(fichiersTraces) {
	htmlT = '';
	if 	(fichiersTraces.length > 0) {
		htmlT = '<div class="traceInfo">Cocher une case pour afficher un itinéraire et cliquer sur son nom pour avoir son descriptif et le télécharger.</div>';
		fichiersTraces.sort();
		var reg= /.gpx$/i;
		htmlT += '<form name="selectT">';
		for (let x = 0 ; x < fichiersTraces.length; x++) {
			let nomAfficher = fichiersTraces[x].replace(reg,"");
			let id = nomAfficher.replace(/[\s-]/g,"");
			const idT = id + "T";
			htmlT += '<span class="trace"><input id='+ idT +' class="trace" type="checkbox" name="traceSelect" value="'+ fichiersTraces[x] +'" onClick="selectTraces(this.value)"><span class="itinPlus" title="'+ nomAfficher + '" onClick="teleItin(this.title)" onmouseover="surligne(this.title)" onmouseout="surligne2(this.title)">' + nomAfficher + '</span></span><br/>';
			htmlT += '<span id='+ id +' class="montrer"><input type="radio" name="'+ id +'" value="'+ nomAfficher +'" onClick="afficherT(this.value)" checked="true">Afficher';
			htmlT += '<input type="radio" name="'+ id +'" value="'+ nomAfficher +'" onClick="masquerT(this.value)">Masquer';
			htmlT += '    <button type="button" name="'+ id +'" value="'+ nomAfficher +'" onclick="centrerTrace(this.value)">Centrer</button>';
			htmlT += '    <button type="button" name="'+ id +'" value="'+ nomAfficher +'" onclick="rechargerTrace(this.value)">Recharger</button><br></span>';
		}
		htmlT += '</form>';
		document.getElementById('traces').innerHTML = htmlT;
		document.getElementById("toutVoirT").style.display = 'inline';//Affichage du bouton "Tout visualiser"
	}
	/*if (typeof affTracesCharg != "undefined") {
		if (affTracesCharg == true) {
			visualiserTraces(fichiersTraces);// permet de visualiser les itinéraires au chargement de la page
		}
	}*/
}

function surligne(info) {
	if (typeof tracesP[info] != "undefined") {
		var features = tracesP[info].getSource().getFeatures();
		if (features != "") {
			var numFeatures = features.length;
			for (let i = 0; i < numFeatures; i++) {
				if (features[i].getGeometry().getType() != 'Point') {// ne pas prendre en compte les wayPoints
					features[i].setStyle(
						new ol.style.Style({
							stroke: new ol.style.Stroke({
								color: '#4b0082',
								width: 4,
								lineDash: [0,0]
							 })
						})
					);
				}
			}
		}
	}
}

function surligne2(info) {
	if (typeof tracesP[info] != "undefined") {
		let features = tracesP[info].getSource().getFeatures();
		if (features != "") {
			var numFeatures = features.length;
			for (let i = 0; i < numFeatures; i++) {
				if (features[i].getGeometry().getType() != 'Point') {// ne pas prendre en compte les wayPoints
					let colorArray = ol.color.asArray(features[i].get('color'));
					colorArray[3] = Number(features[i].get('opacity'));			
					features[i].setStyle(
						new ol.style.Style({
							stroke: new ol.style.Stroke({
								color: colorArray,
								width: features[i].get('width'),
								lineDash: features[i].get('lineDash')
							 })
						})
					);
				}
			}
		}
	}
}

function teleItin(name) {
	let liens = '';
	let entete = '';
	let info = '';
	
	//Affichage des éléments d'info de l'itinéraire
	reg = new RegExp(name,'i');
	
	info += '<html><head><title>Info itinéraire</title><link rel="stylesheet" type="text/css" href="module/visualizer/vendor/system/styles.css" media="screen"><link rel="stylesheet" type="text/css" href="module/visualizer/vendor/system/stylesImptoolTip1.css" media="print"></head><body>';
	info += '<div id="titre2" class="div_titre2">' + name + ' </div>';
	info += '<div class="div_droite2">';
	info += '<fieldset id="listeTraces"  class="descItin">';
	info += '<legend id ="legend" align="center">L\'itinéraire</legend>';
	info += '<div id="docItin">';
	entete = '<div class="bulle2">Doc de présentation de l\'itinéraire :</div><div class="bulle1">';
	
	for (let n = 0 ;n < fichiersDocItin.length; n++) {//Sélection des fichiers pdf relatifs à l'itinéraire
		if (reg.test(fichiersDocItin[n])) {
			liens += '<a href="' + repDocTraces + fichiersDocItin[n] +'" download>'+ fichiersDocItin[n] +'</a><br/>';
		}		
	}		
	if (liens != "") {
		info += entete + liens +'</div>';
	}
	else
	{
		info += entete + 'Cet itinéraire n\'a pas de doc de description.</div><br/>';
	}
	info += '<br/><div class="bulle1"><span class="bulle2">Télécharger l\'itinéraire :</span><br/><!--br/>Format ZIP : <a href="'+ repTraces + name +'.zip">'+ name + '.zip</a--><br/>';
	info += 'Format GPX : <a href="' + repTraces + name +'.gpx" download>'+ name +'.gpx</a></div>';
	info += '</div>';
	
	if(descTraces[name] || infoTraces[name]){
		if (descTraces[name] != '' || infoTraces[name] != '') {
			info += '<div id="titreInfo"> Infos complémentaires lors du chargement de l\'itinéraire :</div>';
			info += '<div id="printInfo"><input type="image" class="icone" src="module/visualizer/vendor/system/img/print-2.png" onclick="window.print(); return false;" /></div>';
			if (descTraces[name] != '') {
				info += '<div class="pointInfo">' + descTraces[name] + '</div>';
			}
			if (infoTraces[name] != '') {
				info += '<div class="pointInfo">' + infoTraces[name] + '</div>';
			}
		}
	}	
	info += '</fieldset></div></body></html>';
	let itinInfo = window.open("","","menubar=yes, resizable=yes, status=no, scrollbars=yes, width==420, height=400");
	//itinInfo.document.write('<br/>' + info);
	itinInfo.document.write('<link rel="stylesheet" href="module/visualizer/vendor/system/descStyle.css" type="text/css">');
	itinInfo.document.write(info);
}

function centrageInit() {
	if (dep) {
		map.getView().fit(limitesDep);
	}
	else if (affTracesCharg == 1  && fichiersTraces.length > 0) {
		map.getView().fit(affTracesChargExtent);
	}
	else {
		//map.setCenter(centre,6);
		map.getView().setCenter(centreCarte);
		map.getView().setZoom(zoomCarte);		
	}
}

function centrerTrace(nomTrace) {//Centrage itinéraire concerné
	var limites = tracesP[nomTrace].getSource().getExtent();
	map.getView().fit(limites);//centrage et zoom en même temps
}

function rechargerTrace(nomTrace) {//Rechargement itinéraire concerné
	if (clickTrackBusy == false) {
		if (tracesP[nomTrace].getVisible()) {//Pas de Rechargement si la trace est masquée
			tracesP[nomTrace].getSource().refresh();
		}
	}
	else {
		alert ('Fermer "Modification de Style" !');
	}
}

function afficherT(nomTrace) {//Afficher itinéraire concerné	
	tracesP[nomTrace].setVisible(true);
}

function masquerT(nomTrace) {//Masquer itinéraire concerné
	if(featureBornes[1] == nomTrace){
		map.removeLayer(bornes);
		bornes.getSource().clear();
		bornes = [];
		map.removeInteraction(selectBorne);
		selectBorne = '';
		featureBornes = ['',''];
	}
	tracesP[nomTrace].setVisible(false);
}

function affichageServices(fichiersServices) {
	fichiersServices.sort();
	serviceInformations = 0;
	let reg= /.gpx$/i;
	//Détermination de l'icone de chaque service conventionnellement nommé et constitution de la liste des fichiers services à retenir
	//Début
	for (let x =0 ; x < fichiersServices.length; x++) {// détermination des icônes par défaut, utilser dans visualiserServices()
		let nomAfficher = fichiersServices[x].replace(reg,"");
		icones[nomAfficher]='';// reste vide si nom de fichier non prédéfini
		if (/^centres/i.test(fichiersServices[x])) {
				icones[nomAfficher]='centres.png';
			}
		if (/^dentistes/i.test(fichiersServices[x])) {
				icones[nomAfficher]='dentistes.png';
			}
		if (/^hebergements/i.test(fichiersServices[x])) {
				icones[nomAfficher]='hebergements.png';
			}
		if (/^informations/i.test(fichiersServices[x])) {
				icones[nomAfficher]='informations.png';
				serviceInformations = 1;
				nomserviceInformations = fichiersServices[x];
				indexserviceInformations = x;
			}
		if (/^marechaux/i.test(fichiersServices[x])) {
				icones[nomAfficher]='marechaux.png';
			}
		if (/^osteo/i.test(fichiersServices[x])) {
				icones[nomAfficher]='osteos.png';
			}
		if (/^pensions/i.test(fichiersServices[x])) {
				icones[nomAfficher]='pensions.png';
			}
		if (/^prestatairesDivers/i.test(fichiersServices[x])) {
				icones[nomAfficher]='prestatairesDivers.png';
			}
		if (/^selliers/i.test(fichiersServices[x])) {
				icones[nomAfficher]='selliers.png';
			}
		if (/^stationnements/i.test(fichiersServices[x])) {
				icones[nomAfficher]='stationnements.png';
			}
		if (/^pointsDeVue/i.test(fichiersServices[x])) {
				icones[nomAfficher]='pointsDeVue.png';
			}
		if (/^sitesHistoriques/i.test(fichiersServices[x])) {
				icones[nomAfficher]='sitesHistoriques.png';
			}
	}
	//Fin
	
	htmlS = "";
	if 	(fichiersServices.length > 0) {
		htmlS = '<div class="traceInfo">Cocher une case pour afficher un service et cliquer sur son nom pour le télécharger.</div>';
		htmlS += '<form name="selectS">';
		for (let x =0 ; x < fichiersServices.length; x++) {
			let nomAfficher = fichiersServices[x].replace(reg,"");
			let idS = nomAfficher + "S";
			let idSA = nomAfficher + "SA";
			htmlS += '<span id='+ idS +' class="service"><input class="service" type="checkbox" name="serviceSelect" value="'+ fichiersServices[x] +'" onClick="selectServices(this.value)"><a href="' + repServices + nomAfficher +'.gpx" download>' + nomAfficher + '</a><br/></span>';
			htmlS += '<span id='+ idSA +' class="montrer"></span>';
		}
		htmlS += '</form>';
		document.getElementById('services').innerHTML = htmlS;
		document.getElementById("toutVoirS").style.display = 'inline';//Affichage du bouton "Tout visualiser"
	}	
	if (serviceInformations == 1) {
		document.selectS.serviceSelect[indexserviceInformations].checked = true;
		selectServices(nomserviceInformations);
	}
	
}

function afficherS(nomService) {//Afficher service concerné
	for (let x =0 ; x < services.length; x++) {
		if (services[x].get('name') == nomService) {
			services[x].setVisible(true);
			return;
		}
	}
}

function masquerS(nomService) {//Masquer service concerné
	for (let x =0 ; x < services.length; x++) {
		if (services[x].get('name') == nomService) {
			services[x].setVisible(false);
			return;
		}
	}
}

function centrerWP(nomService) {
	for (let x =0 ; x < services.length; x++) {
		if (services[x].get('name') == nomService) {
			map.getView().fit(services[x].getSource().getExtent());//centrage et zoom en même temps
			return;
		}
	}
}

function deSelectT() {
	for (let x =0 ; x < document.selectT.traceSelect.length; x++) {
		if ( document.selectT.traceSelect[x].checked) {
			document.selectT.traceSelect[x].checked = false;			
		} 
	}
}

function selectTraces(trace) {
	var tracesSelect = [];
	if(document.selectT.traceSelect.length === undefined){
		tracesSelect.push(trace);
	}
	else
	{
		for (let x =0 ; x < fichiersTraces.length; x++) {
			if ( document.selectT.traceSelect[x].checked == true) {
				tracesSelect.push(document.selectT.traceSelect[x].value);
			}	
		}
	}
	visualiserTraces(tracesSelect);
}

function deSelectS() {
	for (let x =0 ; x < document.selectS.serviceSelect.length; x++) {
		if ( document.selectS.serviceSelect[x].checked) {
			document.selectS.serviceSelect[x].checked = false;			
		} 
	}
}

function selectServices(service) {
	var servicesSelect = [];
	if(document.selectS.serviceSelect.length === undefined){
		servicesSelect.push(service);
	}
	else
	{
		for (let x =0 ; x < fichiersServices.length; x++) {
			if ( document.selectS.serviceSelect[x].checked == true) {
				servicesSelect.push(document.selectS.serviceSelect[x].value);			
			}	
		}
	}
	visualiserServices(servicesSelect);
}

function afficherTraces() {//Afficher tous les itinéraires
	var y = 1;
	for (let x =0 ; x < fichiersTraces.length; x++) {
		document.forms["selectT"].elements[y].checked = true;
		y = y + 5;
		traces[x].setVisible(true);
	}
}

function masquerTraces() {//Masquer tous les itinéraires
	if(featureBornes[1] != ''){
		map.removeLayer(bornes);
		bornes.getSource().clear();
		bornes = [];
		map.removeInteraction(selectBorne);
		selectBorne = '';
		featureBornes = ['',''];
	}
	var y = 2;
	for (let x =0 ; x < fichiersTraces.length; x++) {
		document.forms["selectT"].elements[y].checked = true;
		y = y + 5;
		traces[x].setVisible(false);
	}
}

function afficherServices() {//Afficher tous les services
	var y = 1;//1
	for (let x =0 ; x < fichiersServices.length; x++) {
		document.forms["selectS"].elements[y].checked = true;		
		y = y + 4;//3
		services[x].setVisible(true);
	}
}

function masquerServices() {//Masquer tous les services
	var y = 2;//2
	for (let x =0 ; x < fichiersServices.length; x++) {
		document.forms["selectS"].elements[y].checked = true;
		y = y + 4;//3
		services[x].setVisible(false);
	}
}

function visualiserTraces(tracesGPX) {
	nomTraces =[];
	let sourceExtent = new ol.source.Vector();
	let reg= /.gpx$/i;
	if (traces.length > 0) {//Création de la table des noms de traces si nbre de traces non nul, permet de ne pas recréer une trace existante
		for (let x =0 ; x < traces.length; x++) {
			nomTraces.push(traces[x].get('name'));
		}			
	}
	let nbrT=tracesGPX.length;
	for (let x =0 ; x < nbrT; x++) {		
		//let Fichier = repSys2 + repCata_1 + repTraces + tracesGPX[x];
		let Fichier = repTraces + tracesGPX[x];
		let nomAfficher = tracesGPX[x].replace(reg,"");
		let testT = nomTraces.includes(nomAfficher);
		if(testT == false) {
			t = x;
			if(traces.length > 0) {//ajout de la nouvelle trace en fin de tableau
				t = traces.length;
			}
			
			descTraces [nomAfficher] = '';
			let descTrace = '';
			infoTraces [nomAfficher] = '';
			let infoTrace = '';
			
			tracesP[nomAfficher] = new ol.layer.Vector({
				source:new ol.source.Vector({
					url: Fichier,
					format: new ol.format.GPX({
					 readExtensions: function(feature, extensionsNode) {//Récupération de l'extension style si elle existe
					 //readExtensions: function(feature) {//Récupération de l'extension style si elle existe
						//const extensionsNode = feature.get('Yp');
						// Valeurs par défaut, sauf pour la couleur, si pas d'extension ou si paramètres manquants
						feature.set('lineDashText','solid');
						feature.set('lineDash',[0,0]);						
						feature.set('width',4);
						feature.set('opacity',1);
						
						if(extensionsNode){
							const extension = extensionsNode.children;
							const nbrChildren = extension.length;
							for (let i = 0 ;i < nbrChildren; i++) {
								const child = extension[i];
								switch (child.nodeName) {									
									case 'line':// cas développé par JLC
										if (child.attributes.length == 0 ) {// ne pas prendre en compte ce qui ressemble à ma norme (par exemple visuGPX)
											var children = child.children;
											const nbrNodes = children.length;
											for (let n = 0 ;n < nbrNodes; n++) {
												const nodeName = children[n].nodeName;
												const nodeContent = children[n].innerHTML;
												if (nodeName == 'linecap'){
													switch (nodeContent) {        
														case 'solid':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[0,0]);
															break;
														case 'dot':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[1,8]);
															break;
														case 'dash':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[15,15]);
															break;
														case 'dashdot':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[15,12,1,12]);
															break;
														case 'longdash':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[50,20]);
															break;
														case 'longdashdot':
															feature.set('lineDashText',nodeContent);
															feature.set('lineDash',[50,18,1,18]);
															break;
													}
												}
												else {// Pour color, width et opacity
													feature.set(nodeName,nodeContent);
												}
											}
										}else {
											if (indexCouleur < couleurs.length) {
												itinCouleur = couleurs[indexCouleur];
												indexCouleur += 1;
											}
											else
											{
												indexCouleur = 0;
												itinCouleur = couleurs[indexCouleur];
											}
											feature.set('color',itinCouleur);
										}
										break;
									case 'gpxx:TrackExtension':// cas GPS Garmin
										children = child.children;
										const nodeName = children[0].nodeName;
										if (nodeName == 'gpxx:DisplayColor') {
											feature.set('color',children[0].innerHTML);
										}
										else {
											feature.set('color','#ff4500');
										}
										break;
									/*default:// cas non connu
										feature.set('lineDashText','solid');
										feature.set('lineDash',[0,0]);
										feature.set('color','#ff4500');
										feature.set('width',4);
										feature.set('opacity',1);*/
								}
							}
						}
						else {// Valeurs par défaut si pas d'extension
							//if (feature.getGeometry().getType() != 'Point') {// ne pas prendre en compte les wayPoints
								if (indexCouleur < couleurs.length) {
									itinCouleur = couleurs[indexCouleur];
									indexCouleur += 1;
								}
								else
								{
									indexCouleur = 0;
									itinCouleur = couleurs[indexCouleur];
								}
								feature.set('color',itinCouleur);
							//}
						}
					  }
					})
				})
			});
			tracesP[nomAfficher].set('name',nomAfficher);
			
			tracesP[nomAfficher].getSource().on('addfeature', function(evt){//exécutée à chaque ajout d'une feature de la trace : pour longueur et style de la trace
				if (evt.target.getState() === 'ready') {
					
					let feature = evt.feature;//récupération de la feature qui a été ajoutée
					if (feature.getGeometry().getType() != 'Point') {// ne pas prendre en compte les wayPoints						
						
						feature.set('nameItin', tracesP[nomAfficher].get('name'));
						//Longueur de la trace					
						const longueur = ol.sphere.getLength(feature.getGeometry());
						feature.set('longueur',(longueur/1000).toFixed(2));
						if (feature.get('desc') && feature.get('desc') != ''){
							descTrace += '<p><a style="font-weight: bold;">' + feature.get('name') + ', ' + feature.get('longueur') + ' Km :</a></p>' + feature.get('desc');
							descTraces [nomAfficher] = descTrace;
						}
						//Affectation du style à la trace
						let colorArray = ol.color.asArray(feature.get('color'));
						colorArray[3] = Number(feature.get('opacity'));			
						feature.setStyle(
							new ol.style.Style({
								stroke: new ol.style.Stroke({
									color: colorArray,
									width: feature.get('width'),
									lineDash: feature.get('lineDash')
								})
							})
						);
						
					}
					else// Pour les wayPoints qui seraient dans le fichier trace
					{
						/*feature.setStyle(
							new ol.style.Style({
								stroke: new ol.style.Stroke()
							})
						);*/
						let icone = '';
						if (feature.get('sym')){// icône dans fichier wayPoints ?
							if (fichiersImage.includes(feature.get('sym'))){
								icone = feature.get('sym');
							}
							else
							{
								icone = 'info.png';
							}
						}
						else
						{
							icone = 'info.png';
						}
						feature.set('nameItin',nomAfficher);					
						feature.setStyle(
							new ol.style.Style({
								image: new ol.style.Icon({
									anchor: [0.5, 1],//10,22
									//anchorXUnits: 'pixels',
									//anchorYUnits: 'pixels',
									size: [32,37],//21, 25
									scale: 0.45,//0.9
									//src: '../systeme/img/wayPoints/'+ icone
									src: 'module/visualizer/vendor/system/img/wayPoints/'+ icone
								})
							})
						);
						let coord = ol.proj.transform(feature.getGeometry().getCoordinates(), 'EPSG:3857', 'EPSG:4326');
						infoTrace += '<p>' + feature.get('name') + ' (' + coord[0].toFixed(5) + ', ' + coord[1].toFixed(5) +') :</p>' + feature.get('desc');
						infoTraces [nomAfficher] = infoTrace;
					}
					if (! feature.get('name')){
						feature.set('name',nomAfficher);
					}
					sourceExtent.addFeature(feature);
				}				
			});
			
			traces.push(tracesP[nomAfficher]);
			map.addLayer(traces[t]);
			
			let id = nomAfficher.replace(/[\s-]/g,"");
			let idT = id + "T";
			document.getElementById(id).style.display = 'block';
			document.getElementById(idT).style.display = 'none';
		}
	}
	if (nbrT == fichiersTraces.length) {//test si tous les itinéraires sont à visualiser
			document.getElementById("toutVoirT").style.display = 'none';//Masquage du bouton "Tout visualiser"
			document.getElementById("afficherT").style.display = 'block';			
	}
	if (traces.length > 0 && services.length > 0 ) {// Ordonnancement des couches si il y a des couches services
		ordreCouches();
	}
	//itinSelectors();
	if (typeof(selectTRK) != 'object'){// Création des selects itin si ils n'existent pas
		itinSelectors();
	}
	
	if (affTracesCharg == 1 && nbrT>0) {// centrage sur toutes les traces si elles sont affichées au chargement de la page
		traces[nbrT-1].getSource().on('featuresloadend', function(evt){
			affTracesChargExtent = sourceExtent.getExtent();
			map.getView().fit(affTracesChargExtent);//centrage et zoom en même temps
		});
	}
}

function getAlti(feature, callBack){
	
	let coord = feature.getGeometry().getCoordinates()[0];
	const l = coord.length;
	let nbr = 200;// nombre max de coordonnées à traiter par requête IGN
	if ( nbr > l ) {
		nbr = l;
	}
	const nbrR = parseInt(l/nbr);// nombre de requêtes max à traiter						
	const reste = l - nbr * nbrR;// nombre restant de coordonnées à traiter
	let coordTable = [];
	let y = nbrR;// nbre de requètes à faire
	let x = 0;// nbre de requètes faites
	
	if ( reste != 0) {// nbre de requêtes total à faire
		y += 1;
	}	
	
	feature.set('CoordOk','En cours');
	
	function tempo() {
		return new Promise(resolve => setTimeout(resolve, 250));
	}
	
	async function getAltiSuite() {
		for (let i = 0; i < nbrR; i++) {// traitement des requêtes max					
			const offset = i * nbr;
			await tempo();
			getDataAlti(coord, coordTable, i, nbr, offset);
		}
		
		if ( reste != 0) {//  traitement de la requête restante qui est donc non max (<nbr)
			const offset = nbrR * nbr;
			getDataAlti(coord, coordTable, nbrR, reste, offset);
		}
	}
	getAltiSuite();

	function getDataAlti(coord, coordTable, i, u, offset){
		let lon = lat = '';
		coordTable[i] = [];
		for (let n = 0; n < u; n++) {
			let coord_ = ol.proj.transform([coord[offset+n][0],coord[offset+n][1]], 'EPSG:3857', 'EPSG:4326')
			if (n != u-1){
				lon += coord_[0] + '|';
				lat += coord_[1] + '|';
			}
			else
			{
				lon += coord_[0];
				lat += coord_[1];
			}
		}
		
		//coordTable[i].url = 'https://wxs.ign.fr/essentiels/alti/rest/elevation.json?lon=' + lon + '&lat=' + lat + '&zonly=true';
		coordTable[i].url = 'https://data.geopf.fr/altimetrie/1.0/calcul/alti/rest/elevation.json?resource=ign_rge_alti_wld&lon=' + lon + '&lat=' + lat + '&zonly=true';
		fetch(coordTable[i].url)
			.then(res => res.json())
			.then(parsetexte => {// analyse des données si ok
				coordTable[i].parsetexte = parsetexte;
				for (let n = 0; n < u; n++) {
					coord[offset+n][2] = coordTable[i].parsetexte['elevations'][n];						
				}
				x+=1;
				testDisplay(x);
			})
			.catch((error) => {// traitement de l'échec de récupération des données d'élévation
				x+=1;
				feature.set('CoordOk','nok');
				testDisplay(x);
				console.log('Pas de données d\'élévation.');
			});
	}
	
	function testDisplay(x) {// Permet de récupérer toutes les alti avant de sauvegarder les coordonnées/alti
		if (x == y) {
			if (feature.get('CoordOk') != 'nok') {
				feature.set('Coord',coord);
				feature.set('CoordOk','ok');
			}
			callBack(feature);
		}
	}
}

function ordreCouches(){ // Permet de mettre les couches services au dessus des couches traces
	for (let x =0 ; x < services.length; x++) {
		map.removeLayer(services[x]);
		map.addLayer(services[x]);
	}
}

function visualiserServices(servicesGPX) {
	nomServices =[];
	htmlService = [];
	let reg1 = /.gpx$/i;	
	if (services.length > 0) {//Création de la table des noms de services si nbre de services non nul
		for (let x =0 ; x < services.length; x++) {
			nomServices.push(services[x].get('name'));
		}		
	}
	
	for (let x =0 ; x < servicesGPX.length; x++) {		
		//let Fichier = repSys + repCata_2  + repServices + servicesGPX[x];
		let Fichier = repServices + servicesGPX[x];
		let nomAfficher = servicesGPX[x].replace(reg1,"");
		htmlService[nomAfficher] = false;
		var idS = nomAfficher + "S";
		var idSA = nomAfficher + "SA";
		//let icone = icones[nomAfficher];
		let testS = nomServices.includes(nomAfficher);
		if(testS == false) {
			t = x;
			if(services.length > 0) {//ajout du nouveau service en fin de tableau
				t = services.length;
			}
		 
			services[t] = new ol.layer.Vector({
				source: new ol.source.Vector({
					url: Fichier,
					format: new ol.format.GPX()
				})
			});
			services[t].set('name',nomAfficher);
			
			services[t].getSource().on('addfeature',function(evt){					
				if (evt.target.getState() === 'ready') {	
					let feature = evt.feature;// récupération de la feature qui a été ajoutée
					if (feature.getGeometry().getType() == 'Point') {// ne pas prendre les features 'Trace'
						//console.log(evt.target.Li);
						//let url_ = evt.target.Li;
						//let nomAfficher_ = url_.slice(url_.lastIndexOf('/') + 1,url_.length - 4);
						let id = nomAfficher + "SA";
						let icone = '';
						if (feature.get('sym')){// icône dans fichier wayPoints ?
							if (fichiersImage.includes(feature.get('sym'))){
								icone = feature.get('sym');
							}
							else
							{
								if(icones[nomAfficher] != ''){// icone prédéfini lors de affichageServices()
									icone = icones[nomAfficher];			
								}
								else
								{
									icone = 'star.png';
								}
							}
							if(icones[nomAfficher] == '' ){
								icones[nomAfficher] = icone;
							}
						}
						else
						{
							if(icones[nomAfficher] != ''){// icone prédéfini lors de affichageServices() + cas ci-dessous
								icone = icones[nomAfficher];				
							}
							else
							{
								icone = 'star.png';
								icones[nomAfficher] = icone;
							}
						}
						
						feature.setStyle(
							new ol.style.Style({
								image: new ol.style.Icon({
									//anchor: [0.5, 1],//5,8
									//anchorXUnits: 'pixels',
									//anchorYUnits: 'pixels',
									size: [32,37],
									scale: 0.8,
									src: 'module/visualizer/vendor/system/img/wayPoints/'+ icone
								})
							})
						);
						if (htmlService[nomAfficher] == false) {
							document.getElementById(id).innerHTML = '<img class="icone" src="module/visualizer/vendor/system/img/wayPoints/'+ icones[nomAfficher] +'" /><span class="service"><a href="' + repServices + nomAfficher +'.gpx" download>' + nomAfficher + '</a></span><br/><span class="select"><input type="radio" name="'+ nomAfficher +'" value="'+ nomAfficher +'" onClick="afficherS(this.value)" checked="true">Afficher<input type="radio" name="'+ nomAfficher +'" value="'+ nomAfficher +'" onClick="masquerS(this.value)">Masquer</span>  <button title="'+ nomAfficher +'" type="button" onclick="centrerWP(this.title)">Centrer</button><br>';
							htmlService[nomAfficher] = true;
						}
					}
				}
			});
			
			map.addLayer(services[t]);
			document.getElementById(idSA).style.display = 'block';
			document.getElementById(idS).style.display = 'none';
		}
	}
	if (servicesGPX.length == fichiersServices.length) {//test si tous les services sont à visualiser
			document.getElementById("toutVoirS").style.display = 'none';//Masquage du bouton "Tout visualiser"
			document.getElementById("afficherS").style.display = 'block';
	}
	//servicesSelectors();
	if (typeof(selectWPT) != 'object'){// Création des selects services si ils n'existent pas
		servicesSelectors();
	}	
}

function itinSelectors() {
	/*if (typeof(selectTRK) == 'object'){// Suppression des selects itin si ils existent
		selectTRK.setActive(false);
		map.removeInteraction(selectTRK);
		clickTRK.setActive(false);
		map.removeInteraction(clickTRK);		
	}*/
	
	// Création Select feature
	//Début
	selectTRK = new ol.interaction.Select({
		condition: ol.events.condition.pointerMove,
		layers: traces,
		/*style: new ol.style.Style({
				stroke: new ol.style.Stroke({
						color: '#dc143c',
						width: 5
					})
		})*/
		style: false
	});
	/*clickTRK = new ol.interaction.Select({
		condition: ol.events.condition.singleClick,
		layers: traces,
		style: false
	});*/
	
	map.addInteraction(selectTRK);
	
	/*itinToolTip = new jlcToolTip ({
		id : 'infoBulle2',
		idRecept: 'map'
	});*/
	toolTip1 = document.getElementById('toolTip1');
    
    selectTRK.on('select', function(e) {
		const pixelMap = e.mapBrowserEvent.pixel;
		toolTip1.style.left = pixelMap[0] + 'px';
		toolTip1.style.top = pixelMap[1] + 'px';
		if (e.selected.length > 0 && e.deselected.length > 0){// 2 traces se chevauchent
			if (e.selected[0].getGeometry().getType() != 'Point') {// ne concerne pas les wayPoints descriptifs d'une trace
				/*if (e.selected[0].get('desc') && e.selected[0].get('desc') != ''){
					var descTrace = ', ' + e.selected[0].get('desc');
				}
				else
				{
					var descTrace = '.';
				}*/
				const descTrace = '.';// du fait des lignes précédentes en commentaire				
				if (document.getElementById('prepaImp').style.display == 'block' || clickTrackBusy == true ){// pas de commentaire sur click si imp ni si modif en cours
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}<br/>Trace ${e.selected[0].get('name')} : ${e.selected[0].get('longueur')} Km ${descTrace}`;
				}
				else
				{
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}<br/>Trace ${e.selected[0].get('name')} : ${e.selected[0].get('longueur')} Km ${descTrace}<br/>- Cliquer pour le télécharger et pour afficher son descriptif.<br/>- Clic droit pour accéder au menu contextuel.`;
				}
				toolTip1.innerHTML = textSelect;
				toolTip1.style.visibility = 'visible';
			}
			else if (e.selected[0].getGeometry().getType() == 'Point') {// ne concerne pas les traces
				if (document.getElementById('prepaImp').style.display == 'block' || clickTrackBusy == true ){// pas de commentaire sur click si imp ni si modif en cours
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.`;
				}
				else
				{
					textSelect = textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.<br/>- Cliquer pour afficher le descriptif.`;
				}
				//textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.<br/>- Cliquer pour afficher le descriptif.`;
				toolTip1.innerHTML = textSelect;
				toolTip1.style.visibility = 'visible';
			}
		}		
		else if (e.selected.length > 0){// 1 trace est sélectionnée
			if (e.selected[0].getGeometry().getType() != 'Point') {// ne concerne pas les wayPoints descriptifs d'une trace
				/*if (e.selected[0].get('desc') && e.selected[0].get('desc') != ''){
					var descTrace = ', ' + e.selected[0].get('desc');
				}
				else
				{
					var descTrace = '.';
				}*/
				const descTrace = '.';// du fait des lignes précédentes en commentaire
				if (document.getElementById('prepaImp').style.display == 'block' || clickTrackBusy == true ){// pas de commentaire sur click si imp ni si modif en cours
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}<br/>Trace ${e.selected[0].get('name')} : ${e.selected[0].get('longueur')} Km ${descTrace}`;
				}
				else
				{
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}<br/>Trace ${e.selected[0].get('name')} : ${e.selected[0].get('longueur')} Km ${descTrace}<br/>- Cliquer pour le télécharger et pour afficher son descriptif.<br/>- Clic droit pour accéder au menu contextuel.`;
				}
				toolTip1.innerHTML = textSelect;
				toolTip1.style.visibility = 'visible';
			}
			else if (e.selected[0].getGeometry().getType() == 'Point') {// ne concerne pas les traces
				if (document.getElementById('prepaImp').style.display == 'block' || clickTrackBusy == true ){// pas de commentaire sur click si imp ni si modif en cours
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.`;
				}
				else
				{
					textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.<br/>- Cliquer pour afficher le descriptif.`;
				}
				//textSelect = `Itinéraire ${e.selected[0].get('nameItin')}, Point info ${e.selected[0].get('name')}.<br/>- Cliquer pour afficher le descriptif.`;
				toolTip1.innerHTML = textSelect;
				toolTip1.style.visibility = 'visible';
			}
		}
		else if (e.deselected.length > 0){// la trace sélectionnée est désélectionnée
			toolTip1.style.visibility = 'hidden';
		}
    });
    
    clickTRK = new ol.interaction.Select({
		condition: ol.events.condition.singleClick,
		layers: traces,
		style: false
	});
	map.addInteraction(clickTRK);
    clickTRK.on('select', function(e) {
		if (e.selected.length > 0){
			if (clickTrackBusy == false) {
				let featuresSelected = clickTRK.getFeatures();
				if (e.selected[0].getGeometry().getType() != 'Point') {// ne concerne pas les wayPoints
					toolTip1.style.visibility = 'hidden';
					teleItin(e.selected[0].get('nameItin'));
				}
				else {
					toolTip1.style.visibility = 'hidden';
					let desc = e.selected[0].get('desc');
					let cmt = '<div style="margin: 10px"><div style="text-decoration: underline;font-weight: bold;text-align: center">' + e.selected[0].get('name') + '</div><br/><div class="bulle3">'+ desc + '</div></div>';
					let w = window.open("","_blank","menubar=no, resizable=yes, status=no, scrollbars=yes, width=400, height=450");
					w.document.write('<link rel="stylesheet" href="module/visualizer/vendor/system/descStyle.css" type="text/css">');
					w.document.write(cmt);
				}
				featuresSelected.clear();
			}
		}
    });
    	
	/*affichageBornes = new ol.interaction.Select({
		condition: ol.events.condition.shiftKeyOnly,
		layers: traces,
		style: false
	});
	map.addInteraction(affichageBornes);
	affichageBornes.on('select', function(e) {
		if (e.selected.length > 0){
			let fSelect = e.selected[0];
			let nameItin = fSelect.get('nameItin');
			switch (featureBornes) {        
				case '':
					bornesCreate(fSelect);
					featureBornes = nameItin;
					break;
				case nameItin:
					map.removeLayer(bornes);
					bornes.getSource().clear();
					bornes = [];
					map.removeInteraction(selectBorne);
					selectBorne = [];
					featureBornes = '';
					break;
				default:
					map.removeLayer(bornes);
					bornes.getSource().clear();
					bornes = [];
					map.removeInteraction(selectBorne);
					selectBorne = [];
					bornesCreate(fSelect);
					featureBornes = nameItin;				
			}
		}
	});*/
	//Fin
	/*borneToolTip = new jlcToolTip ({
		id : 'infoBulle3',
		idRecept: 'main'
	});*/
	toolTip2 = document.getElementById('toolTip2');
}

function bornesCreate(fSelect) {
	bornes = new ol.layer.Vector({
		source: new ol.source.Vector()
	});			
	var traceAvecBornes_ = fSelect.getGeometry().getCoordinates()[0];
	var traceAvecBornes = new ol.format.GeoJSON();			
	var nbreCoord = traceAvecBornes_.length;
	for (let x = 0 ; x < nbreCoord ; x++) {
		traceAvecBornes_[x] = ol.proj.transform(traceAvecBornes_[x], 'EPSG:3857', 'EPSG:4326');
	}
	line = turf.lineString(traceAvecBornes_);
	var longueurTrace = turf.length(line, {units:'kilometers'});
	var longueurBornes = 5;
	var nbreBornes = longueurTrace / longueurBornes;
	
	for (let i = 1; i <= nbreBornes; i++) {
		var turfPoint = turf.along(line, i * longueurBornes, {units:'kilometers'});
		var borne = traceAvecBornes.readFeature(turfPoint,{
				dataProjection: 'EPSG:4326',
				featureProjection: 'EPSG:3857'
		});
		let n = longueurBornes * i;
		let m = parseInt(n/100);
		if (n > m * 100) {
			n = n - m * 100;
		}
		if (n == m * 100) {
			n = 100;
		}
		borne.setStyle(
			new ol.style.Style({
				image: new ol.style.Icon({
					anchor: [0.5, 1],//10,22
					//anchorXUnits: 'pixels',
					//anchorYUnits: 'pixels',
					size: [32,37],//21, 25
					scale: 0.8,//0.9
					//src: repSys + '../systeme/img/bornes/marker.png'
					src:'module/visualizer/vendor/system/img/bornes/red' + n + '.png'
				})
			})
		);
		borne.set('coordBorne', longueurBornes * i);
		bornes.getSource().addFeature(borne);
	}
	borneSelector();			
	map.addLayer(bornes);
}

function borneSelector() {		
	selectBorne = new ol.interaction.Select({
			condition: ol.events.condition.pointerMove,
			layers: [bornes],
			style: false
	});		
	map.addInteraction(selectBorne);
	
	selectBorne.on('select', function(e) {
		const pixelMap = e.mapBrowserEvent.pixel;
		toolTip2.style.left = pixelMap[0] + 'px';
		toolTip2.style.top = pixelMap[1] + 'px';
		if (e.selected.length > 0){// l'icone est sélectionné
			let fSelect = e.selected[0];
			let coord = ol.proj.transform(fSelect.getGeometry().getCoordinates(), 'EPSG:3857', 'EPSG:4326');
			textSelect = `Borne ${e.selected[0].get('coordBorne')} Km <br/>Coordonnées :  ${coord[0].toFixed(5)}, ${coord[1].toFixed(5)}`;
			//borneToolTip.show(textSelect);
			toolTip2.innerHTML = textSelect;
			toolTip2.style.visibility = 'visible';
		}
		else if (e.deselected.length > 0){// l'icone sélectionné est déselectionné
			//borneToolTip.hide();
			toolTip2.style.visibility = 'hidden';
		}
	});
}

function servicesSelectors() {
	/*if (typeof(selectWPT) == 'object'){// Suppression des selects services si ils existent
		selectWPT.setActive(false);
		map.removeInteraction(selectWPT);
		clickWPT.setActive(false);
		map.removeInteraction(clickWPT);
	}*/
	
	// Création Select feature
	//Début
	selectWPT = new ol.interaction.Select({
		condition: ol.events.condition.pointerMove,
		layers: services,
		style: false
	});
	
	map.addInteraction(selectWPT);
	
	/*servicesToolTip = new jlcToolTip ({
		id : 'infoBulle',
		idRecept: 'main'
	});*/
	toolTip3 = document.getElementById('toolTip3');
	
	selectWPT.on('select', function(e) {
		const pixelMap = e.mapBrowserEvent.pixel;
		toolTip3.style.left = pixelMap[0] + 'px';
		toolTip3.style.top = pixelMap[1] + 'px';
		if (e.selected.length > 0 && e.deselected.length > 0){// 2 icones se chevauchent
			//servicesToolTip.show(e.selected[0].get('name'));
			toolTip3.innerHTML = e.selected[0].get('name');
			toolTip3.style.visibility = 'visible';
		}		
		else if (e.selected.length > 0){// 1 icone est sélectionné
			//servicesToolTip.show(e.selected[0].get('name'));
			toolTip3.innerHTML = e.selected[0].get('name');
			toolTip3.style.visibility = 'visible';
		}
		else if (e.deselected.length > 0){// l'icone sélectionné est déselectionné
			//servicesToolTip.hide();
			toolTip3.style.visibility = 'hidden';
		}		
    });
	
	clickWPT = new ol.interaction.Select({
		condition: ol.events.condition.singleClick,
		layers: services,
		style: false
	});
	map.addInteraction(clickWPT);	
	clickWPT.on('select', function(e) {
		if (e.selected.length > 0){
			toolTip3.style.visibility = 'hidden';
			let matchFile = false;
			let fileName;
			let featuresSelected = clickWPT.getFeatures();
			let desc = e.selected[0].get('desc');
			
			if(desc){
				for (let i = 0; i < fichiersDocServices.length; i++) {
					//matchFile = desc.includes(fichiersDocServices[i]);
					matchFile = desc.toLowerCase().includes(fichiersDocServices[i].toLowerCase());
					if (matchFile) {
						fileName = fichiersDocServices[i];
						break;
					}
				} 
			
				if (matchFile == true){//Action si desc est un nom de fichier ou du texte
					w=(window.open(repDocServices + fileName));
				}
				else
				{		
					let cmt = '<div style="margin: 10px"><div style="text-decoration: underline;font-weight: bold;text-align: center">' + e.selected[0].get('name') + '</div><br/><div class="bulle3">'+ desc + '</div></div>';
					//let w = window.open("","_blank","menubar=no, resizable=yes, status=no, scrollbars=yes, width=350, height=250");
					let w = window.open("","_blank","menubar=no, resizable=yes, status=no, scrollbars=yes, width=400, height=450");
					w.document.write('<link rel="stylesheet" href="module/visualizer/vendor/system/descStyle.css" type="text/css">');
					w.document.write(cmt);
				}
			}
			featuresSelected.clear();			
		}
    });
	//Fin
}

function myColor(colorInput){	
	newColor = document.getElementById(colorInput.id).value;
	newColorTag = true;
}
function strokeWidth(strokeWidthInput) {
	let selectStrokeWidth = document.getElementById(strokeWidthInput.id);
	newStrokeWidth = selectStrokeWidth.options[selectStrokeWidth.selectedIndex].value;
	newStrokeWidthTag = true;
}
function strokeOpacity(strokeOpacityInput) {
	let selectStrokeOpacity = document.getElementById(strokeOpacityInput.id);
	newStrokeOpacity = selectStrokeOpacity.options[selectStrokeOpacity.selectedIndex].value;
	newStrokeOpacityTag = true;
}
function dashStyleSet(dashStyleInput) {
	let selectDashStyle = document.getElementById(dashStyleInput.id);
	newDashStyleName = selectDashStyle.options[selectDashStyle.selectedIndex].value;
	newDashStyleTag = true;
	switch (newDashStyleName) {        
		case 'solid':
			newDashStyle = [0,0];
			break;
		case 'dot':
			newDashStyle = [1,8];
			break;
		case 'dash':
			newDashStyle = [15,15];
			break;
		case 'dashdot':
			newDashStyle = [15,12,1,12];
			break;
		case 'longdash':
			newDashStyle = [50,20];
			break;
		case 'longdashdot':
			newDashStyle = [50,18,1,18];
			break;
	}	
}
function appliquerModif() {	
	if (newColorTag == true){
		fSelectM.set('color', newColor);
		newColorTag = false;
	}
	if (newStrokeWidthTag == true){
		fSelectM.set('width',newStrokeWidth);
		newStrokeWidthTag = false;
	}
	if (newStrokeOpacityTag == true){
		fSelectM.set('opacity',newStrokeOpacity);
		newStrokeOpacityTag = false;
	}
	if (newDashStyleTag == true){
		fSelectM.set('lineDashText',newDashStyleName);
		fSelectM.set('lineDash',newDashStyle);
		newDashStyleTag = false;
	}
	
	var colorArray = ol.color.asArray(fSelectM.get('color'));
	colorArray[3] = Number(fSelectM.get('opacity'));
	fSelectM.setStyle(
		new ol.style.Style({
			stroke: new ol.style.Stroke({
			color: colorArray,
			width: fSelectM.get('width'),
			lineDash: fSelectM.get('lineDash')
		  })
		})
	);
}

function sortirModif() {
	document.getElementById('divModif').style.display = 'none';
	clickTrackBusy = false;
}

function limitesDepartement (nomFichier) {
	
	const dep = new ol.layer.Vector({
				title: 'Département/Région',
				source:new ol.source.Vector({
					url: nomFichier,
					format: new ol.format.GPX({
					  readExtensions: function(feature, extensionsNode) {//Récupération de l'extension style si elle existe
						//const extensionsNode = feature.get('Yp');
						if(extensionsNode){
							const extension = extensionsNode.children;
							const nbrChildren = extension.length;
							for (let i = 0 ;i < nbrChildren; i++) {
								let child = extension[i];
								if (child.nodeName == 'line'){
									const children = child.children;
									const nbrNodes = children.length;
									for (let n = 0 ;n < nbrNodes; n++) {
										const nodeName = children[n].nodeName;
										const nodeContent = children[n].innerHTML;
										if (nodeName == 'linecap'){
											switch (nodeContent) {        
												case 'solid':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[0,0]);
													break;
												case 'dot':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[1,8]);
													break;
												case 'dash':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[15,15]);
													break;
												case 'dashdot':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[15,12,1,12]);
													break;
												case 'longdash':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[50,20]);
													break;
												case 'longdashdot':
													feature.set('lineDashText',nodeContent);
													feature.set('lineDash',[50,18,1,18]);
													break;
											}
										}
										else {// Pour color, width et opacity
											feature.set(nodeName,nodeContent);
										}
									}
								}
							}
						}
						else {// Valeurs par défaut si pas d'extension					
							feature.set('lineDash',[50,20]);
							feature.set('color','#000000');
							feature.set('width',3);
							feature.set('opacity',1);
						}
							
					  }
					})
				})
			});
			
			dep.set('name','Département/Région');
			
			dep.getSource().on('addfeature', function(evt){//exécutée à chaque ajout d'une feature de la trace : pour longueur et style de la trace
				if (evt.target.getState() === 'ready') {
					let feature = evt.feature;//récupération de la feature qui a été ajoutée
					//Affectation du style à la trace
					let colorArray = ol.color.asArray(feature.get('color'));
					colorArray[3] = Number(feature.get('opacity'));			
					feature.setStyle(
						new ol.style.Style({
							stroke: new ol.style.Stroke({
								color: colorArray,
								width: feature.get('width'),
								lineDash: feature.get('lineDash')
							})
						})
					);
					
					limitesDep = dep.getSource().getExtent();
					map.getView().fit(limitesDep);//centrage et zoom en même temps
				}				
			});
			map.addLayer(dep);
}

function validImp() {//Aperçu avant impression
	
	if (document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value == '1/25000'){
		displayImpArea();
	}
	else
	{
		let taille = document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value;
		if (document.getElementsByName('orientation')[1].checked) {
			switch (taille) {// réglage taille papier + mise en page
				case 'A4':
					page = 'paysageA4';
					pageCheck = 'paysage et A4';
					break;
				case 'A3':
					page = 'paysageA3';
					pageCheck = 'paysage et A3';
					break;
			}
		}
		if (document.getElementsByName('orientation')[0].checked) {
			switch (taille) {// réglage taille papier + mise en page
				case 'A4':
					page = 'portraitA4';
					pageCheck = 'portrait et A4';
					break;
				case 'A3':
					page = 'portraitA3';
					pageCheck = 'portrait et A3';
					break;
			}
		}
		if(osmTopo.getVisible() != true){
			document.getElementById('impAvert').innerHTML = `Vérifier que l'imprimante est en mode <span class="impAvert">${pageCheck}</span>. <br/><br/><span class="impAvertIGN">Impression pour usage strictement privé</span>`;
		}
		else {
			document.getElementById('impAvert').innerHTML = `Vérifier que l'imprimante est en mode <span class="impAvert">${pageCheck}</span>.`;
		}
		//document.getElementsByTagName('header')[0].style.display = 'none';
		//document.getElementsByTagName('nav')[0].style.display = 'none';
		//document.getElementsByTagName('footer')[0].style.display = 'none';
		//document.getElementById('backToTop').style.display = 'none';
		document.getElementById('colDroite').style.display = 'none';
		document.getElementById('divImp').classList.remove('divImp');
		document.getElementById('divImp').classList.add('mapImp');
		document.getElementById('map').classList.remove('map');
		document.getElementById('map').classList.add(page);
		document.getElementById('map').style.width = dimPage[page][0] + 'cm';
		document.getElementById('map').style.height = dimPage[page][1] + 'cm';
		document.getElementsByClassName('ol-zoom')[0].style.display = 'none';
		document.getElementsByClassName('ol-full-screen')[0].style.display = 'none';
		document.getElementsByClassName('mousePosition')[0].style.display = 'none';
		document.getElementsByClassName('layer-switcher')[0].style.display = 'none';
		document.getElementById('copyCarte').style.display = 'block';
		document.getElementById('IGN').style.display = 'none';
		//twoClick.setActive(false);
		dragPan.setActive(false);
		keyboardPan.setActive(false);
		mouseWheelZoom.setActive(false);
		keyboardZoom.setActive(false);
		contextMenuMain.disable();
		if (typeof(selectTRK) == 'object'){
			selectTRK.setActive(false);
			clickTRK.setActive(false);
		}
		if (typeof(selectBorne) == 'object'){
			selectBorne.setActive(false);
		}
		if (typeof(selectWPT) == 'object'){
			selectWPT.setActive(false);
			clickWPT.setActive(false);
		}
		centerBeforeAperImp = map.getView().getCenter();
		resolutionBeforeAperImp = map.getView().getResolution();
		map.updateSize();
	}
}

function displayImpArea() {
	if (document.getElementById('divModif').style.display == 'none'){		
		const center = map.getView().getCenter();
		centerBeforeImp = map.getView().getCenter();
		resolutionBeforeImp = map.getView().getResolution();
		map.getView().setConstrainResolution(false);//Autoriser zooms/résolutions intermédiaires
		const screenDpi = getScreenResolution() / 100 * 2.54;// calcul de la résolution en dpi de l'écran
		let centerMapDpi = ol.proj.getPointResolution(map.getView().getProjection(), screenDpi/25.4, [center[0], center[1]]);//résolution du point central de la carte pour un resoDpi donné
		var customResolution25000 = 25 / centerMapDpi;
		
		const taille = document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value;
		switch (taille) {// réglage échelle pour polygone
			case 'A4':
				scale = 1.5;
				break;
			case 'A3':
				scale = 2.5;
				break;
		}
		
		const customResolutionForFirstDisplay = customResolution25000 * scale;// résolution pour une échelle de "scale" fois 1/25000
		map.getView().setResolution(customResolutionForFirstDisplay);
		const resolution = map.getView().getResolution();
		
		length_1 = Math.round((A4[1] / 2.54) * screenDpi / scale);// longueur_1 en pixels pour une échelle de 1.5 fois 1/25000
		length_2 = Math.round((A4[0] / 2.54) * screenDpi / scale);// longueur_2 en pixels pour une échelle de 1.5 fois 1/25000
		length_3 = Math.round((A3[1] / 2.54) * screenDpi / scale);// longueur_1 en pixels pour une échelle de 1.5 fois 1/25000
		length_4 = Math.round((A3[0] / 2.54) * screenDpi / scale);// longueur_2 en pixels pour une échelle de 1.5 fois 1/25000
		
		if (ign3.getVisible() == false && osmTopo.getVisible() == false) {
			//ign2.setMinResolution(19.10925707129406);
			//ign.setMaxResolution(19.10925707129406);
			ign2.setMinResolution(38.21851414258813);
			ign.setMaxResolution(38.21851414258813);
		}	
				
		if (document.getElementsByName("orientation")[1].checked) {// half width and half hight du polygone pour "1/25000"
			switch (taille) {// réglage taille papier + mise en page
				case 'A4':
					var hW = length_1 * resolution / 2;
					var hH = length_2 * resolution / 2;
					page ='paysageA4';
					pageCheck = 'paysage et A4';
					break;
				case 'A3':
					var hW = length_3 * resolution / 2;
					var hH = length_4 * resolution / 2;
					page ='paysageA3';
					pageCheck = 'paysage et A3';
					break;
			}
		}
		if (document.getElementsByName("orientation")[0].checked) {// half width and half hight du polygone pour "1/25000"
			switch (taille) {// réglage taille papier + mise en page
				case 'A4':
					var hH = length_1 * resolution / 2;
					var hW = length_2 * resolution / 2;
					page ='portraitA4';
					pageCheck = 'portrait et A4';
					break;
				case 'A3':
					var hH = length_3 * resolution / 2;
					var hW = length_4 * resolution / 2;
					page ='portraitA3';
					pageCheck = 'portrait et A3';
					break;
			}
		}
		
		impArea = new ol.Feature(// création du polygone qui simule une page au 1/25000
			new ol.geom.Polygon([[[center[0]-hW, center[1]-hH], [center[0]+hW, center[1]-hH],[center[0]+hW, center[1]+hH], [center[0]-hW, center[1]+hH], [center[0]-hW, center[1]-hH]]])
		)
		impArea.setId('win' + impArea.ol_uid);
		impArea.set('page', page);
		dragImpLayer = new ol.layer.Vector({
			source: new ol.source.Vector({
				features: [impArea]
			})
		})
		map.addLayer(dragImpLayer);

		dragImp = new ol.interaction.Translate({// La position de la zone imp est modifiable par cliquer/glisser (mode drag)
			layers: [dragImpLayer]	
		});	
		map.addInteraction(dragImp);
		document.getElementsByClassName('ol-zoom')[0].style.display = 'none';
		document.getElementsByClassName('ol-full-screen')[0].style.display = 'none';
		document.getElementsByClassName('mousePosition')[0].style.display = 'none';
		document.getElementsByClassName('layer-switcher')[0].style.display = 'none';
		document.getElementById('boutonsImp').innerHTML = 'Imprimer carte au 1/25000 en ' + taille;
		document.getElementById('prepaImp').style.display = 'block';
		document.getElementById('colDroite').style.display = 'none';
		document.getElementById('copyCarte').style.display = 'block';
		document.getElementById('IGN').style.display = 'none';
		//twoClick.setActive(false);
		mouseWheelZoom.setActive(false);
		keyboardZoom.setActive(false);
		contextMenuMain.disable();
		if (typeof(clickWPT) == 'object'){
			clickWPT.setActive(false);
		}
		if (typeof(clickTRK) == 'object'){
			clickTRK.setActive(false);
		}
	}
}

function itinDisplayImpArea(data) {
	if (document.getElementById('divModif').style.display == 'none'){
		if (data.feature.get('longueur')<= 45) {
			impItin = true;
			if (ign3.getVisible() == false && osmTopo.getVisible() == false) {
				//ign2.setMinResolution(19.10925707129406);
				//ign1.setMaxResolution(19.10925707129406);
				ign2.setMinResolution(38.21851414258813);
				ign.setMaxResolution(38.21851414258813);
			}		
			
			// Caractéristiques de la page origine, pour retour arrière (bouton 'Fermer')
			centerBeforeImp = map.getView().getCenter();
			resolutionBeforeImp = map.getView().getResolution();
			map.getView().setConstrainResolution(false);//Autoriser zooms/résolutions intermédiaires
			const screenDpi = getScreenResolution() / 100 * 2.54;// calcul de la résolution en dpi de l'écran
			
			// Caractéristiques des limites de l'itinéraire à imprimer
			const limitesitin = data.feature.getGeometry().getExtent();// limites d'extension
			const center = ol.extent.getCenter(limitesitin);
			const widthItin = ol.extent.getWidth(limitesitin);
			const heightitin = ol.extent.getHeight(limitesitin);
			const xy0 = ol.extent.getTopLeft(limitesitin);
			const coordItin = data.feature.getGeometry().getCoordinates()[0];
			const coordItinL = coordItin.length;
			const nomItin = data.feature.get('name');// non utilisé
			const centerMapDpi = ol.proj.getPointResolution(map.getView().getProjection(), screenDpi/25.4, [center[0], center[1]]);//résolution du point central de la carte pour un resoDpi donné
			const customResolution25000 = 25 / centerMapDpi;
			map.getView().setCenter(center);
			
			let taille = document.forms['formImp'].elements['taille'].options[document.forms['formImp'].elements['taille'].selectedIndex].value;
			switch (taille) {// réglage échelle pour polygone
				case 'A4':
					scale = 4.5;
					break;
				case 'A3':
					scale = 5;
					break;
			}
			
			const customResolutionForFirstDisplay = customResolution25000 * scale;// résolution pour une échelle de "scale" fois 1/25000
			map.getView().setResolution(customResolutionForFirstDisplay);
			const resolution = map.getView().getResolution();
			
			length_1 = Math.round((A4[1] / 2.54) * screenDpi / scale);// longueur_1 en pixels pour une échelle de 1.5 fois 1/25000
			length_2 = Math.round((A4[0] / 2.54) * screenDpi / scale);// longueur_2 en pixels pour une échelle de 1.5 fois 1/25000
			length_3 = Math.round((A3[1] / 2.54) * screenDpi / scale);// longueur_1 en pixels pour une échelle de 1.5 fois 1/25000
			length_4 = Math.round((A3[0] / 2.54) * screenDpi / scale);// longueur_2 en pixels pour une échelle de 1.5 fois 1/25000
					
			if (document.getElementsByName("orientation")[1].checked) {// width and hight du polygone pour "1/25000"
				switch (taille) {// réglage taille papier + mise en page
					case 'A4':
						W = length_1 * resolution;
						H = length_2 * resolution;
						page ='paysageA4';
						pageCheck = 'paysage et A4';
						break;
					case 'A3':
						W = length_3 * resolution;
						H = length_4 * resolution;
						page ='paysageA3';
						pageCheck = 'paysage et A3';
						break;
				}
			}
			if (document.getElementsByName("orientation")[0].checked) {// width and hight du polygone pour "1/25000" en m
				switch (taille) {// réglage taille papier + mise en page
					case 'A4':
						H = length_1 * resolution;
						W = length_2 * resolution;
						page ='portraitA4';
						pageCheck = 'portrait et A4';
						break;
					case 'A3':
						H = length_3 * resolution;
						W = length_4 * resolution;
						page ='portraitA3';
						pageCheck = 'portrait et A3';
						break;
				}
			}
			
			// Nombre de fenêtres par largeur de l'itin en fonction du type d'impression
			const nbreWinW = Math.ceil(widthItin / W);
			// Nombre de fenêtres par hauteur de l'itin en fonction du type d'impression
			const nbreWinH = Math.ceil(heightitin / H);
			
			winArea = [];
			let z = 0;
			const lengthCouleurs = couleurs.length;
			
			for (let x = 0; x < nbreWinW; x++) {
				for (let y = 0; y < nbreWinH; y++) {					
					let coordWin = [[[xy0[0]+x*W, xy0[1]-y*H], [xy0[0]+(x+1)*W, xy0[1]-y*H], [xy0[0]+(x+1)*W, xy0[1]-(y+1)*H], [xy0[0]+x*W, xy0[1]-(y+1)*H], [xy0[0]+x*W, xy0[1]-y*H]]];
					let winImp = new ol.Feature(// création du polygone qui simule une page au 1/25000
						new ol.geom.Polygon(coordWin)
					)				
					
					let extentWinImp = winImp.getGeometry().getExtent();
					let include = 0;
					
					for (let i = 0; i < coordItinL; i++) {
						if ( ol.extent.containsXY(extentWinImp, coordItin[i][0], coordItin[i][1])) {
							include++;
						}					
					}
					
					if (z == lengthCouleurs ) {z=0}
					if ( include > 0 ) {
						let colorArray = ol.color.asArray(couleurs[z]);
						colorArray[3] = 0.1;
						winImp.setStyle(
							new ol.style.Style({
								stroke: new ol.style.Stroke({
										color: ' #17202a '
										//color: couleurs[z]
									}),
								fill: new ol.style.Fill({
									color: colorArray
									})
							})
						);
						winImp.setId('win' + winImp.ol_uid);
						winImp.set('page', page);
						winImp.set('name', 'win');
						z++;
						winArea.push(winImp);
					}
				}			
			}
			
			dragImpLayer = new ol.layer.Vector({
				source: new ol.source.Vector({
					features: winArea
				})
			})
			map.addLayer(dragImpLayer);
			dragImp = new ol.interaction.Translate({// La position de la zone imp est modifiable par cliquer/glisser (mode drag)
				layers: [dragImpLayer]	
			});	
			map.addInteraction(dragImp);
			
			document.getElementsByClassName('ol-zoom')[0].style.display = 'none';
			document.getElementsByClassName('ol-full-screen')[0].style.display = 'none';
			document.getElementsByClassName('mousePosition')[0].style.display = 'none';
			document.getElementsByClassName('layer-switcher')[0].style.display = 'none';
			document.getElementById('boutonsImp').innerHTML = 'Imprimer itin au 1/25000 en ' + taille;
			document.getElementById('paysage').style.display = 'none';
			document.getElementById('portrait').style.display = 'none';
			document.getElementById('prepaImp').style.display = 'block';
			document.getElementById('colDroite').style.display = 'none';
			document.getElementById('copyCarte').style.display = 'block';
			document.getElementById('IGN').style.display = 'none';
			//twoClick.setActive(false);
			mouseWheelZoom.setActive(false);
			keyboardZoom.setActive(false);
			if (typeof(clickWPT) == 'object'){
				clickWPT.setActive(false);
			}
			if (typeof(clickTRK) == 'object'){
				clickTRK.setActive(false);
			}
		}
		else {
			alert ('Fonction impossible : longueur itin > 45Km !');
		}
	}
}
function fermerImp() {
	map.getView().setConstrainResolution(true);//Supprimer zooms/résolutions intermédiaires
	impItin
	if (ign3.getVisible() == false && osmTopo.getVisible() == false) {
		//rétablissement des résolutions initiales
		ign2.setMinResolution(9.554628535647032);
		ign.setMaxResolution(9.554628535647032);
	}
	
	//document.getElementsByTagName('header')[0].style.display = 'block';
	//document.getElementsByTagName('nav')[0].style.display = 'block';
	//document.getElementsByTagName('footer')[0].style.display = 'block';
	//document.getElementById('backToTop').style.display = 'block';
	document.getElementById('prepaImp').style.display = 'none';
	document.getElementById('portrait').style.display = 'inline-block';
	document.getElementById('paysage').style.display = 'inline-block';
	document.getElementById('colDroite').style.display = 'block';
	document.getElementById('copyCarte').style.display = 'none';
	document.getElementById('IGN').style.display = 'block';
	document.getElementsByClassName('ol-zoom')[0].style.display = 'block';
	document.getElementsByClassName('ol-full-screen')[0].style.display = 'block';
	document.getElementsByClassName('mousePosition')[0].style.display = 'block';
	document.getElementsByClassName('layer-switcher')[0].style.display = 'block';
	map.removeLayer(dragImpLayer);
	map.removeInteraction(dragImp);
	//dragImpLayer.getSource().removeFeature(impArea);
	dragImpLayer = [];
	impArea = [];
	dragImp = [];
	map.getView().setCenter(centerBeforeImp);
	map.getView().setResolution(resolutionBeforeImp);
	//twoClick.setActive(true);
	mouseWheelZoom.setActive(true);
	keyboardZoom.setActive(true);
	impItin = false;
	contextMenuMain.enable();
	if (typeof(clickWPT) == 'object'){
		clickWPT.setActive(true);
	}
	if (typeof(clickTRK) == 'object'){
		clickTRK.setActive(true);
	}
}
function Paysage() {
	if ( page == 'portraitA4' || page == 'portraitA3' ) {
		
		var resolution = map.getView().getResolution();
		switch (page) {
			case 'portraitA4':
				var W = length_1 * resolution;
				var H = length_2 * resolution;
				page = 'paysageA4';
				pageCheck = 'paysage et A4';
				break;
			case 'portraitA3':
				var W = length_3 * resolution;
				var H = length_4 * resolution;
				page = 'paysageA3';
				pageCheck = 'paysage et A3';
				break;
		}
		
		const center = ol.extent.getCenter(impArea.getGeometry().getExtent());
		const coord = [[[center[0]-W/2, center[1]-H/2], [center[0]+W/2, center[1]-H/2],[center[0]+W/2, center[1]+H/2], [center[0]-W/2, center[1]+H/2], [center[0]-W/2, center[1]-H/2]]];
		impArea.getGeometry().setCoordinates(coord);
		impArea.set('page', page);
	}
}
function Portrait() {
	if ( page == 'paysageA4' || page == 'paysageA3' ) {
		
		var resolution = map.getView().getResolution();
		switch (page) {
			case 'paysageA4':
				var W = length_2 * resolution;
				var H = length_1 * resolution;
				page = 'portraitA4';
				pageCheck = 'portrait et A4';
				break;
			case 'paysageA3':
				var W = length_4 * resolution;
				var H = length_3 * resolution;
				page = 'portraitA3';
				pageCheck = 'portrait et A3';
				break;
		}
		
		const center = ol.extent.getCenter(impArea.getGeometry().getExtent());
		const coord = [[[center[0]-W/2, center[1]-H/2], [center[0]+W/2, center[1]-H/2],[center[0]+W/2, center[1]+H/2], [center[0]-W/2, center[1]+H/2], [center[0]-W/2, center[1]-H/2]]];
		impArea.getGeometry().setCoordinates(coord);
		impArea.set('page', page);
	}
}

function aperImp() {
	const win = dragImpLayer.getSource().getFeatures().sort(function(a, b){return a.ol_uid - b.ol_uid});// Tri des features par ordre de création;
	const nbrWin = win.length;
	
	if (nbrWin > 0){
		let resoDpi = 150;// en dpi, résolution pour l'impression au 1/25 000
		if(osmTopo.getVisible() != true){
			document.getElementById('impAvert').innerHTML = `Vérifier que l'imprimante est en mode <span class="impAvert">${pageCheck}</span>. <br/><br/><span class="impAvertIGN">Impression pour usage strictement privé</span>`;
		}
		else {
			document.getElementById('impAvert').innerHTML = `Vérifier que l'imprimante est en mode <span class="impAvert">${pageCheck}</span>.`;
		}
		document.getElementById('prepaImp').style.display = 'none';
		//document.getElementsByTagName('header')[0].style.display = 'none';
		//document.getElementsByTagName('nav')[0].style.display = 'none';
		//document.getElementsByTagName('footer')[0].style.display = 'none';
		//document.getElementById('backToTop').style.display = 'none';
		/*document.getElementById('divImp').classList.remove('divImp');
		document.getElementById('divImp').classList.add('mapImp');*/
		document.getElementById('site').classList.remove('container');
		document.getElementById('site').classList.add('containerBis');
		document.getElementsByTagName('header')[0].classList.add('container');
		document.getElementsByTagName('nav')[0].classList.add('container');
		document.getElementById('impMap').classList.add(page);
		document.getElementById('impMap').style.width = dimPage[page][0] + 'cm';
		//document.getElementById('impMap').style.height = dimPage[page][1] + 'cm';
		dragImpLayer.setVisible(false);
		dragPan.setActive(false);
		keyboardPan.setActive(false);
		
		if (typeof(selectTRK) == 'object'){
			selectTRK.setActive(false);
		}
		if (typeof(selectWPT) == 'object'){
			selectWPT.setActive(false);
		}
		centerBeforeAperImp = map.getView().getCenter();
		resolutionBeforeAperImp = map.getView().getResolution();
		let screenDpi = getScreenResolution()/100;
		
		const width = Math.round((dimPage[page][0] / 2.54) * resoDpi);// en pixels
		const height = Math.round((dimPage[page][1] / 2.54) * resoDpi);// en pixels
		const widthIMG = Math.round(screenDpi * dimPage[page][0]);// en pixels 
		const heightIMG = Math.round(screenDpi * dimPage[page][1]);// en pixels

		/*const win = dragImpLayer.getSource().getFeatures().sort(function(a, b){return a.ol_uid - b.ol_uid});// Tri des features par ordre de création;
		const nbrWin = win.length;*/
		
		let img = [];
		let nbr = 0;
		let modif = false;
				
		map.once('rendercomplete', imgWin);
		mapWin();
		
		function imgWin() {
			domtoimage
			.toJpeg(map.getViewport())
			.then(function (dataUrl) {
				const node = document.createElement('div');
				node.id = win[nbr].getId();
				document.getElementById('impMap').appendChild(node);			
				const pageWin = win[nbr].get('page');
				let img = new Image();
				img.className = 'imgWin';
				img.src = dataUrl;
				if ( pageWin == page ) {
					img.width = widthIMG;
					img.height = heightIMG;
					if ( modif == true) {
						img.className = dimPage[page][2];
						modif = false;
					}
				}
				else {
					document.getElementById(node.id).style.height = dimPage[page][3] + 'cm';
					//const widthIMGw = Math.round(screenDpi * dimPage[pageWin][0]);// en pixels 
					//const heightIMGw = Math.round(screenDpi * dimPage[pageWin][1]);// en pixels
					//img.width = widthIMGw;
					//img.height = heightIMGw;
					img.width = heightIMG;
					img.height = widthIMG;
					//img.width = widthIMG;
					//img.height = heightIMG;
					img.style.transform = 'rotate(-0.25turn)';
					img.style.transformOrigin = dimPage[page][1]/2 + 'cm ' + dimPage[page][1]/2 +'cm';
					
					if ( pageWin == 'portraitA4' || pageWin == 'portraitA3') {
						img.className = 'imgWin0';
					}
					if ( modif == true) {
						img.className = dimPage[page][2];
					}
					if ( nbr != 0 ) {
						node.className = 'impWin';
					}
					modif = true;
				}
				
				document.getElementById(node.id).appendChild(img);
				
				if ( nbr == nbrWin -1 ) {
					document.body.style.cursor = 'auto';
					document.getElementById('aperImp25000').style.display = 'none';
					document.getElementById('divImp').classList.remove('divImp');
					document.getElementById('divImp').classList.add('mapImp');
					document.getElementById('map').style.display = 'none';
					document.getElementById('impMap').style.display = 'block';
					if ( modif == true) {// permet, associé avec la hauteur de cet élément, de ne pas avoir une page blanche
						//document.getElementById(node.id).style.height = dimPage[page][3] + 'cm';
						document.getElementById(node.id).style.overflow = 'hidden';// quand modif orientation en portrait
					}
				}
				else /*( nbrWin > 1 && nbr < nbrWin -1)*/ {
					nbr++;
					map.once('rendercomplete', imgWin);
					mapWin();
				}
			});
		}
		
		function mapWin() {
			const extentImp = win[nbr].getGeometry().getExtent();
			const center = ol.extent.getCenter(extentImp);
			const centerMapDpi = ol.proj.getPointResolution(map.getView().getProjection(), resoDpi/25.4, center);//résolution de l'écran pour un resoDpi donné
			const customResolution25000 = 25 / centerMapDpi;
			const pageWin = win[nbr].get('page');
			if ( pageWin == page ) {
				map.getTargetElement().style.width = width + 'px';
				map.getTargetElement().style.height = height + 'px';
			}
			else {
				//const widthM = Math.round((dimPage[pageWin][0] / 2.54) * resoDpi);// en pixels
				//const heightM = Math.round((dimPage[pageWin][1] / 2.54) * resoDpi);// en pixels
				//map.getTargetElement().style.width = widthM + 'px';
				//map.getTargetElement().style.height = heightM + 'px';
				map.getTargetElement().style.width = height + 'px';
				map.getTargetElement().style.height = width + 'px';
			}
			
			map.getView().setCenter(center);
			map.getView().setResolution(customResolution25000);
			map.updateSize();
			document.body.style.cursor = 'progress';
			document.getElementById('aperImp25000').style.display = 'block';
		}
	}
	else {
		alert ('Absence de fenêtres d\'impression !');		
	}
}
function annulerImp() {	
	document.getElementById('divImp').classList.remove('mapImp');
	document.getElementById('divImp').classList.add('divImp');
	//document.getElementsByTagName('header')[0].style.display = 'block';
	//document.getElementsByTagName('nav')[0].style.display = 'block';
	//document.getElementsByTagName('footer')[0].style.display = 'block';
	//document.getElementById('backToTop').style.display = 'block';
	document.getElementById('prepaImp').style.display = 'none';
		
	dragPan.setActive(true);
	keyboardPan.setActive(true);
	
	if (document.forms['formImp'].elements['liste'].options[document.forms['formImp'].elements['liste'].selectedIndex].value == "1/25000"){
		if (typeof(selectTRK) == 'object'){
			selectTRK.setActive(true);
		}
		if (typeof(selectWPT) == 'object'){
			selectWPT.setActive(true);
		}
		map.getTargetElement().style.width = '';
		map.getTargetElement().style.height = '';
		document.getElementById('prepaImp').style.display = 'block';
		document.getElementById('impMap').style.display = 'none';
		//document.getElementById('impMap').removeChild(img);
		document.getElementById('impMap').innerHTML = '';
		document.getElementById('impMap').classList.remove(page);
		//document.getElementById('impMap').style.overflow = 'hidden';
		document.getElementById('impMap').style.removeProperty('overflow');
		document.getElementById('impMap').style.removeProperty('width');
		document.getElementById('impMap').style.removeProperty('height');
		document.getElementById('map').style.display = 'block';
		dragImpLayer.setVisible(true);
		
	}
	else
	{
		if (typeof(selectTRK) == 'object'){
			clickTRK.setActive(true);
			selectTRK.setActive(true);
		}
		if (typeof(selectBorne) == 'object'){
			selectBorne.setActive(true);
		}
		if (typeof(selectWPT) == 'object'){
			clickWPT.setActive(true);
			selectWPT.setActive(true);
		}
		//twoClick.setActive(true);
		mouseWheelZoom.setActive(true);
		keyboardZoom.setActive(true);
		contextMenuMain.enable();
		document.getElementById('map').classList.remove(page);
		document.getElementById('map').style.removeProperty('width');
		document.getElementById('map').style.removeProperty('height');
		document.getElementById('map').classList.add('map');
		document.getElementById('colDroite').style.display = 'block';
		document.getElementsByClassName('ol-zoom')[0].style.display = 'block';
		document.getElementsByClassName('ol-full-screen')[0].style.display = 'block';
		document.getElementsByClassName('mousePosition')[0].style.display = 'block';
		document.getElementsByClassName('layer-switcher')[0].style.display = 'block';
		document.getElementById('copyCarte').style.display = 'none';
		document.getElementById('IGN').style.display = 'block'
	}
	document.getElementById('site').classList.remove('containerBis');
	document.getElementById('site').classList.add('container');
	document.getElementById('map').style.width = mapWidth;
	document.getElementById('map').style.height = mapHeight;
	map.getView().setCenter(centerBeforeAperImp);
	map.getView().setResolution(resolutionBeforeAperImp);
	map.updateSize();	
}

function getScreenResolution() {
	screenResolution = document.getElementById('divResolution').offsetWidth * 10;
	return screenResolution;
}
