﻿// Ce fichier est utilisé pour le style de la couche IGN_TMS

var styleTMScustom = 
{
	"version": 8,
	"name": "PLAN IGN",
    "glyphs":"https://data.geopf.fr/annexes/ressources/vectorTiles/fonts/{fontstack}/{range}.pbf",
	"sprite": "https://data.geopf.fr/annexes/ressources/vectorTiles/styles/PLAN.IGN/sprite/PlanIgn",
    "sources": {
        "plan_ign": {
            "type": "vector",
            "tiles": [
                "https://data.geopf.fr/tms/1.0.0/PLAN.IGN/{z}/{x}/{y}.pbf"
            ]
        }
    },
	"transition": {
		"duration": 300,
		"delay": 0
	},
	"layers": [
        {
            "id": "bckgrd",
             "type": "fill",
             "source": "plan_ign",
             "source-layer": "fond_opaque",
             "minzoom": 0,
             "layout": {
                 "visibility": "visible"
             },
             "paint": {
                 "fill-color": "#FFFFFF",
                 "fill-opacity": 1
             }
        },
        {
			"id": "orographie : relief - 0m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_0"],
			"paint": {
				"fill-color": "#D6E5BA",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 100m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_100"],
			"paint": {
				"fill-color": "#F7F2DA",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 200m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_200"],
			"paint": {
				"fill-color": "#EBDEBF",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 1000m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_1000"],
			"paint": {
				"fill-color": "#DABE97",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 3000m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_3000"],
			"paint": {
				"fill-color": "#B28773",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 4000m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_4000"],
			"paint": {
				"fill-color": "#9E6A54",
		        "fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - 5000m",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","HYPSO_5000"],
			"paint": {
				"fill-color": "#773A2B",
				"fill-opacity": 1
			}
		},
		{
			"id": "orographie : relief - glacier",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "oro_relief",
			"minzoom": 0,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","GLACIER"],
			"paint": {
				"fill-color": "#FFFFFF",
				"fill-opacity": 0.7
			}
		},
        {
            "id": "ocs - vegetation - zone boiséee, foret fermee, peupleraie",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["in","symbo",
                                    "ZONE_BOISEE",
                                    "ZONE_FORET_FERMEE_MIXTE",
                                    "ZONE_PEUPLERAIE"
            ],
            "paint": {
                "fill-color": "#D1FFBA",
				"fill-outline-color": "#D1FFBA"
            }
        },
	  {
	   "id": "jlc 1",
	   "type": "fill",
	   "source": "plan_ign",
	   "source-layer": "ocs_vegetation_surf",
	   "layout": {
		"visibility": "visible"
	   },
	   "filter": [
		"==",
		"symbo",
		"ZONE_FORET_FERMEE_CONI"
	   ],
	   "paint": {
		"fill-color": "#90EE90",
		"fill-outline-color": "#5dd55d"
	   }	   
	  },
	  {
	   "id": "jlc 2",
	   "type": "fill",
	   "source": "plan_ign",
	   "source-layer": "ocs_vegetation_surf",
	   "layout": {
		"visibility": "visible"
	   },
	   "filter": [
		"==",
		"symbo",
		"ZONE_FORET_FERMEE_FEUIL"
	   ],
	   "paint": {
		"fill-color": "#B0F2B6",
		"fill-outline-color": "#5dd55d"
	   }
	  },
        {
            "id": "ocs - vegetation - forêt ouverte",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["in","symbo",
									"ZONE_FORET_OUVERTE"
            ],
            "paint": {
                "fill-color": "#D1FFBA",
				"fill-outline-color": "#D1FFBA"
            }
        },
        {
            "id": "ocs - vegetation - lande ligneuse",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_LANDE_LIGNEUSE"],
            "paint": {
                "fill-color": "#E0FFD1"
            }
        },
        {
            "id": "ocs - vegetation - vigne",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_VIGNE"],
            "paint": {
                "fill-color": "#F4D5B3"
            }
        },
        {
            "id": "ocs - vegetation - verger",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_VERGER"],
            "paint": {
                "fill-color": "#239b56"
            }
        },
        {
            "id": "ocs - vegetation - canne à sucre, bananeraie",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_CANNE_BANANE"],
            "paint": {
                "fill-color": "#FAEDFA"
            }
        },
        {
			"id": "hydro surfacique - Estran",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "hydro_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","ZONE_D_ESTRAN"],
			"paint": {
				"fill-color": "#D3E9FF",
				"fill-outline-color": "#D3E9FF"
			}
		},
        {
            "id": "ocs - vegetation - mangrovre",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_MANGROVE"],
            "paint": {
                "fill-color": {"stops": [[9, "#85CCCB"], [10, "#90CCCB"]]}
            }
        },
        {
            "id": "ocs - vegetation - marais",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_MARAIS"],
            "paint": {
                "fill-pattern": "Marais"
            }
        },
        {
            "id": "hydro surfacique - marais",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "hydro_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_MARAIS"],
            "paint": {
                "fill-pattern": "Marais"
            }
        },
        {
            "id": "ocs - vegetation - marais salant",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_vegetation_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_MARAIS_SALANT"],
            "paint": {
                "fill-pattern": "MaraisSalant"
            }
        },
        {
            "id": "ocs - Zone",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_ROCHEUSE"],
            "paint": {
                "fill-color": "#D0D0D0",
				"fill-opacity": 0.3
            }
        },
        {
            "id": "ocs - Zone sable sec",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_SABLE_SEC"],
            "paint": {
				"fill-pattern": "Sable"
            }
        },
        {
            "id": "ocs - Zone sable humide",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["in","symbo",
                                    "ZONE_SABLE_HUMIDE",
                                    "FOND_CUVETTE_HUMIDE"
            ],
            "paint": {
				"fill-pattern": "SableHumide"
            }
        },
        {
            "id": "ocs - Zone graviers galets secs",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","GRAVIERS_GALETS_SEC"],
            "paint": {
				"fill-pattern": "GravierSec"
            }
        },
        {
            "id": "ocs - Zone graviers galets humides",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","GRAVIERS_GALETS_HUM"],
            "paint": {
				"fill-pattern": "Gravier"
            }
        },
        {
            "id": "ocs - Zone rocher hydro",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_ROCHER_HYDRO"],
            "paint": {
				"fill-pattern": "RocherHydro"
            }
        },
        {
            "id": "ocs - Zone glacier",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "ocs_nature_sol_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_GLACIER"],
            "paint": {
				"fill-pattern": "Glacier",
				"fill-opacity": {"stops": [[10, 0.5], [12, 0.3]]}
            }
        },
		{
			"id": "bati ZAI - Gris 14à18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Aérodrome",
									"Aéroport"
            ],
			"paint": {
				"fill-color": "#C8C8C8",
                "fill-opacity": 0.3,
				"fill-outline-color": "#787878"
			}
		},
		{
			"id": "bati ZAI - Gris 16à18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Aire de repos ou de service",
									"Aire d'accueil des gens du voyage",
									"Parc des expositions",
									"Déchèterie",
									"Carrière",
									"Divers commercial",
									"Marché",
									"Divers industriel",
									"Zone industrielle",
									"Usine",
									"Station d'épuration"
            ],
			"paint": {
				"fill-color": "#C8C8C8",
                "fill-opacity": 0.3,
				"fill-outline-color": "#787878"
			}
		},
		{
			"id": "bati ZAI - Gris clair",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","nature","Parking"],
			"paint": {
				"fill-color": "#EBEBF5",
                "fill-opacity": 0.3,
				"fill-outline-color": "#AAAAAA"
			}
		},
		{
			"id": "bati ZAI - Vert clair 14à18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","nature","Espace public Vert"],
			"paint": {
				"fill-color": "#C0EBD2",
                "fill-opacity": 0.5,
				"fill-outline-color": "#76D764"
			}
		},
		{
			"id": "bati ZAI - Vert clair 16à18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Aire de détente",
									"Camping",
									"Parc de loisirs",
									"Parc zoologique"
            ],
			"paint": {
				"fill-color": "#C0EBD2",
                "fill-opacity": 0.5,
				"fill-outline-color": "#76D764"
			}
		},
		{
			"id": "bati ZAI - Beige",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","nature","Espace public Beige"],
			"paint": {
				"fill-color": "#FAE6A0",
                "fill-opacity": 0.5,
				"fill-outline-color": "#FAE6A0"
			}
		},
		{
			"id": "bati ZAI - Vert foncé",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Golf",
									"Hippodrome",
									"Piscine",
									"Sports mécaniques",
									"Equipement de cyclisme",
									"Autre équipement sportif",
									"Centre équestre",
									"Haras",
									"Stade"
            ],
			"paint": {
				"fill-color": "#99C12B",
                "fill-opacity": 0.3,
				"fill-outline-color": "#99C12B"
			}
		},
		{
			"id": "bati ZAI - Marron",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Construction",
									"Vestige archéologique"
            ],
			"paint": {
				"fill-color": "#99642B",
                "fill-opacity": 0.3,
				"fill-outline-color": "#99642B"
			}
		},
		{
			"id": "bati ZAI - Gris Bleu Elec",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","nature","Centrale électrique"],
			"paint": {
				"fill-color": "#7993B6",
                "fill-opacity": 0.3,
				"fill-outline-color": "#7993B6"
			}
		},
        {
            "id": "zone batie",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "bati_zone_surf",
			"minzoom": 7,
			"maxzoom": 15,
            "layout": {
                "visibility": "none"
            },
            "filter": ["==","symbo","ZONE_BATI"],
            "paint": {
                "fill-color": "#7a7a7a",
                "fill-opacity": {"stops": [[12, 1], [13, 0.9], [14, 0.5]]}
            }
        },
        {
            "id": "zone d'activité",
            "type": "fill",
            "source": "plan_ign",
            "source-layer": "bati_zone_surf",
            "layout": {
                "visibility": "visible"
            },
            "filter": ["==","symbo","ZONE_INDUS_ACTI"],
            "paint": {
                "fill-color": "#CBCBCB"
            }
        },
        {
            "id": "oro - courbe et cuvette maitresse",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_MAITRESSE",
                                    "CUVETTE_MAITRESSE"
            ],
			"paint": {
				"line-color": "#d3824a",
                "line-width": {
					"stops": [[13, 2], [15, 3.5]]
				}
			}
        },
        {
            "id": "oro - courbe et cuvette normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_NORMALE",
                                    "CUVETTE_NORMALE"
            ],
			"paint": {
				"line-color": "#D9C8A9",
                "line-width": {
					"stops": [[13, 1], [15, 1.2]]
				}
			}
        },
        {
            "id": "oro - courbe et cuvette intercalaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_INTERCALAIRE",
                                    "CUVETTE_INTERCAL",
                                    "CNV_SS_INTERCALAIRE"
            ],
			"paint": {
				"line-color": "#D9C8A9",
                "line-width": 0.7,
				"line-dasharray": [20,7]
			}
        },
        {
            "id": "oro - courbe et cuvette glacier maitresse",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_GLACIER_MAITRESSE",
                                    "CUV_GLACIER_MAITRESSE"
            ],
			"paint": {
				"line-color": "#A4BFD9",
                "line-width": {
					"stops": [[13, 1.7], [15, 2]]
				}
			}
        },
        {
            "id": "oro - courbe et cuvette glacier normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_GLACIER_NORMALE",
                                    "CUV_GLACIER_NORMALE"
            ],
			"paint": {
				"line-color": "#A4BFD9",
                "line-width": {
					"stops": [[13, 1], [15, 1.2]]
				}
			}
        },
        {
            "id": "oro - courbe et cuvette glacier intercalaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_GLACIER_INTERCAL",
                                    "CUV_GLACIER_INTERCAL"
            ],
			"paint": {
				"line-color": "#A4BFD9",
                "line-width": {
					"stops": [[13, 0.7], [15, 0.9]]
				},
				"line-dasharray": [20,7]
			}
        },
        {
            "id": "oro - courbe et cuvette rocher maitresse",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_ROCHER_MAITRESSE",
                                    "CUV_ROCHER_MAITRESSE"
            ],
			"paint": {
				"line-color": "#AAAAAA",
                "line-width": 1.7
            }
        },
        {
            "id": "oro - courbe et cuvette rocher normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_ROCHER_NORMALE",
                                    "CUV_ROCHER_NORMALE"
            ],
			"paint": {
				"line-color": "#AAAAAA",
                "line-width": 1
			}
        },
        {
            "id": "oro - courbe et cuvette rocher intercalaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_ROCHER_INTERCAL",
                                    "CUV_ROCHER_INTERCAL"
            ],
			"paint": {
				"line-color": "#AAAAAA",
                "line-width": {
					"stops": [[13, 0.7], [15, 0.9]]
				},
				"line-dasharray": [20,7]
			}
        },
        {
            "id": "oro - courbe et cuvette bathymetrique",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_courbe",
            "maxzoom":16,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "CNV_BATHYMETRIQUE",
                                    "CUV_BATHYMETRIQUE"
            ],
			"paint": {
				"line-color": "#0000FF",
                "line-width": 1
			}
        },
        {
            "id": "oro lin - talus",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_lin",
			"minzoom": 14,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","TALUS"],
			"paint": {
				"line-color": "#D9C8A9",
                "line-width": 1
			}
        },
        {
            "id": "oro lin - talus - trait perpendiculaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "oro_lin",
			"minzoom": 14,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","TALUS"],
			"paint": {
				"line-color": "#D9C8A9",
		        "line-width": {
					"stops": [[14, 7], [16, 9]]
				},
				"line-dasharray": [0.1,1],
                "line-offset": 4
			}
        },
		{
            "id": "toponyme - cote de courbe normale",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "oro_courbe",
			"minzoom":13,
            "maxzoom":16,
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 10], [15, 13]]},
                "text-anchor": "center",
                "text-rotation-alignment":"map",
                "text-pitch-alignment": "viewport",
                "text-keep-upright": false,
                "text-max-angle": 20,
                "text-max-width": 100,
                "text-font": ["Source Sans Pro Italic bold"]
            },
            "filter": ["all",
                        ["!=","texte","0"],
                        ["==","hors_zone",true],
                        ["in","symbo",
                                    "CNV_MAITRESSE",
                                    "CUVETTE_MAITRESSE"
                        ]
            ],
            "paint": {
                "text-color": "#8e5527",
                "text-halo-width": 0.5,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - cote de courbe rocher",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "oro_courbe",
			"minzoom":13,
            "maxzoom":16,
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 10], [15, 13]]},
                "text-anchor": "center",
                "text-rotation-alignment":"map",
                "text-pitch-alignment": "viewport",
                "text-keep-upright": false,
                "text-max-angle": 20,
                "text-max-width": 100,
                "text-font": ["Source Sans Pro Italic"]
            },
            "filter": ["all",
                        ["!=","texte","0"],
                        ["==","hors_zone",true],
                        ["in","symbo",
                                    "CNV_ROCHER_MAITRESSE",
                                    "CUV_ROCHER_MAITRESSE"
                        ]
            ],
            "paint": {
                "text-color": "#333333",
                "text-halo-width": 0.5,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - cote de courbe glacier",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "oro_courbe",
			"minzoom":13,
            "maxzoom":16,
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 10], [15, 13]]},
                "text-anchor": "center",
                "text-rotation-alignment":"map",
                "text-pitch-alignment": "viewport",
                "text-keep-upright": false,
                "text-max-angle": 20,
                "text-max-width": 100,
                "text-font": ["Source Sans Pro Italic"]
            },
            "filter": ["all",
                        ["!=","texte","0"],
                        ["==","hors_zone",true],
                        ["in","symbo",
                                    "CNV_GLACIER_MAITRESSE",
									"CUV_GLACIER_MAITRESSE"
                        ]
            ],
            "paint": {
                "text-color": "#629FD9",
                "text-halo-width": 0.5,
                "text-halo-color": "#FFFFFF"
            }
        },
        {
			"id": "hydro surfacique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "hydro_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "SURFACE_D_EAU",
                                    "BASSIN",
                                    "ZONE_MARINE"
            ],
			"paint": {
				"fill-color": "#B3D9FF",
				"fill-outline-color": "#B3D9FF"
			}
		},
        {
			"id": "hydro surfacique temporaire",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "hydro_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","SURFACE_D_EAU_TEMP"],
			"paint": {
				"fill-color": "rgba(164, 198, 233, 0.5)"
			}
		},
		{
			"id": "réseau hydro  - cours d'eau souterrain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sou",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"COURS_D_EAU_SOU",
									"COURS_D_EAU_MOY_SOU"
			],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
					"stops": [[12, 1.5], [17, 6.5]]
                },
                "line-dasharray": [2,2]
			}
		},
        {
			"id": "réseau hydro - filet interieur - aqueduc souterrain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sou",
			"minzoom": 12,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_SOU"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
					"stops": [[12, 1.4], [16, 3.5], [17, 5.9]]
				},
				"line-dasharray": [2,2]
			}
		},
		{
			"id": "réseau hydro - carre - aqueduc souterrain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sou",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_SOU"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
					"stops": [[12, 3.5], [16, 8.7], [17, 14.7]]
				},
				"line-dasharray": [1,5]
			}
		},
        {
			"id": "Ferre souterrain - voie normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
            "minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1_SOU",
									"VF_2_SOU",
									"VF_3_SOU",
									"VF_4_SOU",
                                    "VF_ELEC_1_SOU",
									"VF_ELEC_2_SOU",
									"VF_ELEC_3_SOU",
									"VF_ELEC_4_SOU",
                                    "VF_FERRO_ROUTIER_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 0.8], [17, 2.5]]
				}
			}
		},
        {
			"id": "Ferre souterrain - trait perpendic épais",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1_SOU",
									"VF_2_SOU",
									"VF_3_SOU",
									"VF_4_SOU",
                                    "VF_ELEC_1_SOU",
									"VF_ELEC_2_SOU",
									"VF_ELEC_3_SOU",
									"VF_ELEC_4_SOU",
                                    "VF_FERRO_ROUTIER_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre souterrain - voie etroite",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1_SOU",
									"VF_ETROITE_2_SOU",
									"VF_ETROITE_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
        {
			"id": "Ferre souterrain - trait perpendic fin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1_SOU",
									"VF_ETROITE_2_SOU",
									"VF_ETROITE_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre souterrain - voie service",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"minzoom": 14,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_SERVICE_SOU",
                                    "VF_NON_EXPLOITEE_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				},
				"line-dasharray": [5,2,1,2]
			}
		},
        {
        	"id": "Ferre souterrain - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE_SOU",
                                    "TRANSPORT_URBAIN_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
        {
			"id": "Ferre souterrain - 2 trait perpendic - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sou",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE_SOU",
                                    "TRANSPORT_URBAIN_SOU"
            ],
			"paint": {
				"line-color": "#838383",
		        "line-width": {
					"stops": [[10, 3.5], [17, 17]]
				},
				"line-dasharray": [0.1,0.2,0.1,10]
			}
		},
        {
			"id": "Chemin souterrain - piste cyclable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["in","symbo","PISTE_CYCLABLE_SOU",
									"VOIE_VERTE_SOU"
			],
			"paint": {
				"line-color": "#e9383f",
		        "line-width": {
				"stops": [[14, 2.5], [15, 2.1], [16, 2.5], [17, 3.5]]
                },
				"line-dasharray": [6,4]
			}
		},
        {
			"id": "Chemin souterrain - filet exterieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER_SOU"],
			"paint": {
				"line-color": "#717171",
		        "line-width": {
				"stops": [[14, 1.75], [15, 3], [16, 4.2], [17, 9.5]]
                }
			}
		},
        {
			"id": "Chemin souterrain - filet interieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER_SOU"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 1], [15, 1.9], [16, 2.7], [17, 5.8]]
                },
				"line-dasharray": [1,0.2]
			}
		},
        {
			"id": "Chemin souterrain - Rue pietonne",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","RUE_PIETONNE_SOU"],
			"paint": {
				"line-color": "#717171",
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2]]
                },
				"line-dasharray": [1,3]
			}
		},
        {
			"id": "Chemin souterrain - sentier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","SENTIER_SOU"],
			"paint": {
				"line-color": "#717171",
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2]]
                },
				"line-dasharray": [4,3]
			}
		},
        {
			"id": "Chemin souterrain - chemin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sou",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","CHEMIN_SOU"],
			"paint": {
				"line-color": "#717171",
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT_SOU"],
			"paint": {
				"line-color": "#AFAFAF",
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_SOU"],
			"paint": {
				"line-color": "#AFAFAF",
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3_SOU",
                                    "BRET_AUTO_PEAGE_2_SOU",
                                    "BRET_AUTO_PEAGE_1_SOU",
                                    "BRET_AUTO_LIBRE_3_SOU",
                                    "BRET_AUTO_LIBRE_2_SOU",
                                    "BRET_AUTO_LIBRE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 0, 51, 0.5)",
				"line-width": {
					"stops": [[12, 2.5], [14, 3.7], [15, 6.8], [16, 8.4], [17, 14]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT_SOU"],
			"paint": {
				"line-color": "#AFAFAF",
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4_SOU",
                                    "NON_CLASSEE_SOU"
            ],
			"paint": {
				"line-color": "#AFAFAF",
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE_SOU",
                                    "LOCALE_4_SOU",
                                    "LOCALE_3_SOU",
                                    "LOCALE_2_SOU",
                                    "LOCALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(130, 130, 130, 0.5)",
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR_SOU"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE_SOU",
                                    "REGIONALE_4_SOU",
                                    "REGIONALE_3_SOU",
                                    "REGIONALE_2_SOU",
                                    "REGIONALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(130, 130, 130, 0.5)",
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR_SOU"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 7,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE_SOU",
                                    "PRINCIPALE_4_SOU",
                                    "PRINCIPALE_3_SOU",
                                    "PRINCIPALE_2_SOU",
                                    "PRINCIPALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 0, 51, 0.5)",
		        "line-width": {
                    "stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","PRINCIPALE_CONSTR_SOU"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 7,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SOU",
                                    "AUTOROU_LIBRE_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 0, 51, 0.5)",
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet extérieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","AUTOROU_CONSTR_SOU"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT_SOU"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_SOU"],
			"paint": {
				"line-color": "#DCDCDC",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3_SOU",
                                    "BRET_AUTO_PEAGE_2_SOU",
                                    "BRET_AUTO_PEAGE_1_SOU",
                                    "BRET_AUTO_LIBRE_3_SOU",
                                    "BRET_AUTO_LIBRE_2_SOU",
                                    "BRET_AUTO_LIBRE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 255, 255, 0.5)",
				"line-width": {
					"stops": [[12, 1.5], [14, 2.6], [15, 5.2], [16, 6.7], [17, 10.8]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT_SOU"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4_SOU",
                                    "NON_CLASSEE_SOU"
            ],
			"paint": {
				"line-color": "#DCDCDC",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE_SOU",
                                    "LOCALE_4_SOU",
                                    "LOCALE_3_SOU",
                                    "LOCALE_2_SOU",
                                    "LOCALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 255, 255, 0.5)",
		        "line-width": {
				"stops": [[9, 1.3], [14, 2.3], [15, 4.1], [16, 6.1], [17, 13.1]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR_SOU"],
			"paint": {
				"line-color": {
                    "stops": [[12, "#FFFFFF"], [13, "#FFA35D"], [17, "#FFAD6F"]]
                },
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                },
				"line-dasharray": [2, 2]
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE_SOU",
                                    "REGIONALE_4_SOU",
                                    "REGIONALE_3_SOU",
                                    "REGIONALE_2_SOU",
                                    "REGIONALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 255, 255, 0.5)",
		        "line-width": {
					"stops": [[6, 1.4], [9, 1.5], [14, 3.2], [15, 5.8], [16, 8.3], [17, 16.2]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR_SOU"],
			"paint": {
				"line-color": {
                    "stops": [[9, "#FFFFFF"], [10, "#FF994C"], [17, "#FFAD6F"]]
                },
		        "line-width": {
					"stops": [[4, 0.4], [6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE_SOU",
                                    "PRINCIPALE_4_SOU",
                                    "PRINCIPALE_3_SOU",
                                    "PRINCIPALE_2_SOU",
                                    "PRINCIPALE_1_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 255, 255, 0.5)",
		        "line-width": {
					"stops": [[4, 0.5], [6, 1.8], [9, 2.1], [14, 4.4], [15, 7.3], [16, 10], [17, 18.5]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","PRINCIPALE_CONSTR_SOU"],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.5], [6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier souterrain - filet interieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SOU",
                                    "AUTOROU_LIBRE_SOU"
            ],
			"paint": {
				"line-color": "rgba(255, 255, 255, 0.5)",
		        "line-width": {
					"stops": [[4, 0.7], [6, 2.5], [9, 2.7], [14, 5.8], [15, 9], [16, 12], [17, 20.8]]
                }
			}
		},
        {
			"id": "Routier souterrain - axe central - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SOU",
                                    "AUTOROU_LIBRE_SOU"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "Routier souterrain - filet interieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR_SOU"],
			"paint": {
				"line-color": {"stops": [[9, "#FF476C"], [17, "#FF476C"]]},
		        "line-width": {
                    "stops": [[4, 0.7], [6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                },
                "line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier souterrain - axe central - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sou",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR_SOU"],
			"paint": {
				"line-color": "#808080",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "réseau hydro - cours d'eau temporaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo","COURS_D_EAU_TEMP","COURS_D_EAU_TEMP_MOY"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 1.5], [17, 4]]
                },
                "line-dasharray": [6,2]
			}
		},
        {
			"id": "réseau hydro - cours d'eau",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"minzoom": 3,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","COURS_D_EAU"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[4, 0.3], [7, 1.5], [12, 1.5], [17, 6.5]]
                }
			}
		},
		{
        	"id": "réseau hydro - canal",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","CANAL"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 1.4], [17, 5.9]]
                }
			}
		},
        {
			"id": "réseau hydro - filet interieur - aqueduc",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_AU_SOL"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 1.4], [16, 3.5], [17, 5.9]]
                }
			}
		},
        {
			"id": "réseau hydro - carre - aqueduc",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_AU_SOL"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 3.5], [16, 8.7], [17, 14.7]]
                },
			    "line-dasharray": [1,5]
			}
		},
        {
			"id": "réseau hydro - cours d'eau moyen ",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
           "filter": ["==","symbo","COURS_D_EAU_MOY"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[7, 2], [12, 2.5]]
                }
			}
		},
        {
			"id": "réseau hydro - cours d'eau large ",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","COURS_D_EAU_LAR"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[7, 3], [11, 5]]
                }
			}
		},
		{
			"id": "cimetiere surfacique 1",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "CIMETIERE_SURF",
                                    "CIMETIERE_MILI_SURF",
									"NECROPOLE_NATIONALE"
            ],
			"paint": {
				"fill-color": "#F0F0F0",
				"fill-opacity": 0.5,
				"fill-outline-color": "#818181"
			}
		},
		{
			"id": "cimetiere surfacique 2",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
									"CIMETIERE_MILI_SURF",
									"NECROPOLE_NATIONALE"
            ],
			"paint": {
				"fill-pattern": "Cimetiere"
			}
		},
		{
	   "id": "jlc Cim",
	   "type": "symbol",
	   "source": "plan_ign",
	   "source-layer": "bati_surf",
	   "minzoom": 13,
	   "filter": [
		 "==",
		 "symbo",
		 "CIMETIERE_SURF"
	   ],
	   "layout": {
		"visibility": "visible",
		"text-field": "C.",
		"text-size": 12,
		"text-allow-overlap": true,
		"text-font": [
		 "Source Sans Pro Italic Bold"
		]
	   },
	   "paint": {
		"text-color": "#ff00ff"
	   }
	  },
		{
			"id": "bati surfacique mairie - Zoom 14",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"maxzoom": 14,
			"layout": {
				"visibility": "visible"
			},
			"filter": ["in","symbo",
									"MAIRIE",
									"MAIRIE_ANNEXE"
			],
			"paint": {
				"fill-color": "#FF0032"
			}
		},
		{
			"id": "bati surfacique mairie - Zoom 15,16,17,18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 14,
			"layout": {
				"visibility": "visible"
			},
			"filter": ["in","symbo",
									"MAIRIE",
									"MAIRIE_ANNEXE"
			],
			"paint": {
				"fill-color": {"stops": [[14, "#FF0032"], [15, "#C80032"]]},
				"fill-outline-color": "#000000"
			}
		},
		{
			"id": "bati surfacique fonctionnel industriel ou commercial - Zoom 14,15",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "BATI_COMMERCIAL",
                                    "BATI_INDUSTRIEL",
                                    "HANGAR",
                                    "BATI_QQUE",
                                    "HANGAR_COMMERCIAL",
                                    "HANGAR_INDUSTRIEL"
            ],
			"paint": {
				"fill-color": "#303030"
			}
		},
		{
			"id": "bati surfacique fonctionnel industriel ou commercial - Zoom 16,17,18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "BATI_COMMERCIAL",
                                    "BATI_INDUSTRIEL",
                                    "HANGAR",
                                    "BATI_QQUE",
                                    "HANGAR_COMMERCIAL",
                                    "HANGAR_INDUSTRIEL"
            ],
			"paint": {
				"fill-color": {
                    "stops": [[15, "#303030"], [16, "#303030"]]
                },
				"fill-outline-color": "#000000"
			}
		},
		{
			"id": "bati surfacique fonctionnel public - Zoom 14,15",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                   "BATI_PUBLIC",
                                   "HANGAR_PUBLIC"
            ],
			"paint": {
				"fill-color": "#6C6C8C"
			}
		},
		{
			"id": "bati surfacique fonctionnel public - Zoom 16,17,18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                   "BATI_PUBLIC",
                                   "HANGAR_PUBLIC"
            ],
			"paint": {
				"fill-color": {
                    "stops": [[15, "#66668C"], [16, "#63638C"]]
                },
				"fill-outline-color": "#000000"
			}
		},
		{
			"id": "bati surfacique fonctionnel sportif - bordure",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 15,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","BATI_SPORTIF"],
			"paint": {
				"line-color": "#758275",
				"line-width": 4
			}
		},
		{
			"id": "bati surfacique fonctionnel sportif",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","BATI_SPORTIF"],
			"paint": {
				"fill-color": {
                    "stops": [[14, "#92A292"], [15, "#92A292"]]
                }
			}
		},
		{
			"id": "bati surfacique fonctionnel gare - Zoom 14,15",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","BATI_GARE"],
			"paint": {
				"fill-color": "#9C9EC3"
			}
		},
		{
			"id": "bati surfacique fonctionnel gare - Zoom 16,17,18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","BATI_GARE"],
			"paint": {
				"fill-color": {
                    "stops": [[15, "#9C9EC3"], [16, "#9C9EC3"]]
                },
				"fill-outline-color": "#635D7A"
			}
		},
		{
			"id": "bati hydro surfacique - Autre",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "ECLUSE_SURF",
                                    "RESERVOIR_EAU_SURF"
            ],
			"paint": {
				"fill-color": "#ADCCD9",
				"fill-outline-color": "#336699"
			}
		},
		{
			"id": "bati hydro surfacique - Pecherie",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","PECHERIE_SURF"],
        	"paint": {
				"fill-color": "#BFE2F0",
				"fill-outline-color": "#509FEF"
			}
		},
		{
			"id": "bati hydro surfacique - Barrage",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","BARRAGE_SURF"],
			"paint": {
				"fill-color": "#FFFFFF",
				"fill-outline-color": "#464646"
			}
		},
		{
			"id": "bati hydro surfacique - Chateau d'eau",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","CHATEAU_EAU_SURF"],
			"paint": {
				"fill-color": "#0081FF"
			}
		},
        {
			"id": "bati infra surfacique - Silo",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","SILO_SURF"],
			"paint": {
				"fill-color": "#C7A9AA",
				"fill-outline-color": "#696969"
			}
		},
		{
			"id": "bati infra surfacique - Reservoir indus",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 14,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","RESERVOIR_INDUS_SURF"],
			"paint": {
				"fill-color": "#8D9DAA",
				"fill-outline-color": "#464646"
			}
		},
		{
			"id": "bati infra surfacique - Serre",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo","SERRE_SURF"],
			"paint": {
				"fill-color": "#CAD6D9",
				"fill-outline-color": "#8C8C8C"
			}
		},
		{
			"id": "bati infra surfacique - poste electrique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo","POSTE_ELEC_SURF"],
			"paint": {
				"fill-color": "#7993B6",
				"fill-opacity": 0.3
			}
		},
		{
			"id": "bati infra surfacique - poste electrique bord",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","POSTE_ELEC_SURF"],
			"paint": {
				"line-color": "#000000",
				"line-width": {"stops": [[12, 0.3], [17, 1.2]]}
			}
		},
        {
			"id": "bati religieux surfacique - Zoom 14",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"maxzoom": 14,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
									"CHRETIEN_SURF",
                                    "SYNAGOGUE_SURF",
                                    "MOSQUEE_SURF",
                                    "AUTRE_CULTE_SURF",
									"RELIGIEUX_QQUE"
            ],
			"paint": {
				"fill-color": "#967575"
			}
		},
		{
			"id": "bati religieux surfacique - Zoom 15,16,17,18",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 14,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
									"CHRETIEN_SURF",
                                    "SYNAGOGUE_SURF",
                                    "MOSQUEE_SURF",
                                    "AUTRE_CULTE_SURF",
									"RELIGIEUX_QQUE"
            ],
			"paint": {
				"fill-color": {"stops": [[14, "#967575"], [15, "#A27E7E"]]},
				"fill-outline-color": {"stops": [[14, "#000000"], [15, "#000000"]]}
			}
		},
		{
	   "id": "jlc 3 - Zoom 14",
	   "type": "fill",
	   "source": "plan_ign",
	   "source-layer": "bati_surf",
	   "maxzoom": 14,
	   "layout": {
		"visibility": "visible"
	   },
	   "filter": [
		"in",
		"symbo",
		"CHAPELLE_SURF",
		"EGLISE_SURF"
	   ],
	   "paint": {
		"fill-color": "#ff00ff",
		"fill-outline-color": "#000000"
	   }
	  },
	  {
	   "id": "jlc 4 - Zoom 15,16,17,18",
	   "type": "fill",
	   "source": "plan_ign",
	   "source-layer": "bati_surf",
	   "minzoom": 14,
	   "layout": {
		"visibility": "visible"
	   },
	   "filter": [
		"in",
		"symbo",
		"CHAPELLE_SURF",
		"EGLISE_SURF"
	   ],
	   "paint": {
		"fill-color": {
		 "stops": [
		    [14,"#ff00ff"],
		    [15,"#ff00ff"]
		  ]
		},
		"fill-outline-color": {
		 "stops": [
		   [14,"#000000"],
		   [15,"#000000"]
		 ]
		}
	   }
	  },
		{
			"id": "bati remarquable surfacique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "FORTIF_SURF",
                                    "CHATEAU_SURF",
                                    "TOUR_MOULIN_SURF",
                                    "ARENE_THEATRE",
                                    "ARC_TRIOMPHE_SURF",
                                    "MONUMENT_SURF"
            ],
			"paint": {
				"fill-color": "#9B9B9B",
				"fill-outline-color": "#6E6E6E"
			}
		},
		{
			"id": "bati sportif surfacique fond",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "TENNIS_SURF",
                                    "SPORT_INDIF_SURF",
                                    "FOOT_SURF",
									"MULTI_SPORT_SURF",
                                    "PISTE_SPORT_SURF",
                                    "NATATION_SURF"
            ],
			"paint": {
				"fill-color": "#FFFFFF",
				"fill-outline-color": "#FFFFFF"
			}
		},
		{
			"id": "bati sportif surfacique",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "TENNIS_SURF",
                                    "SPORT_INDIF_SURF",
                                    "FOOT_SURF",
									"MULTI_SPORT_SURF",
                                    "PISTE_SPORT_SURF",
                                    "NATATION_SURF"
            ],
			"paint": {
				"line-color": "#758275",
				"line-width": 2
			}
		},
		{
	   "id": "jlc Tennis",
	   "type": "symbol",
	   "source": "plan_ign",
	   "source-layer": "bati_surf",
	   "minzoom": 13,
	   "filter": [
		 "==",
		 "symbo",
		 "TENNIS_SURF"
	   ],
	   "layout": {
		"visibility": "visible",
		"text-field": "T.",
		"text-size": 12,
		"text-allow-overlap": true,
		"text-font": [
		 "Source Sans Pro Italic Bold"
		]
	   },
	   "paint": {
		"text-color": "#0024ff"
	   }
	  },
		{
	   "id": "jlc Stade",
	   "type": "symbol",
	   "source": "plan_ign",
	   "source-layer": "bati_surf",
	   "minzoom": 13,
	   "filter": [
		 "in",
		 "symbo",
		 "SPORT_INDIF_SURF",
		 "FOOT_SURF",
		 "MULTI_SPORT_SURF",
		 "PISTE_SPORT_SURF"
	   ],
	   "layout": {
		"visibility": "visible",
		"text-field": "S.",
		"text-size": 12,
		"text-allow-overlap": true,
		"text-font": [
		 "Source Sans Pro Italic Bold"
		]
	   },
	   "paint": {
		"text-color": "#0024ff"
	   }
	  },
		{
			"id": "bati transport surfacique - piste",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "PISTE_DUR",
                                    "PISTE_HERBE"
            ],
			"paint": {
                "fill-color": "#DBDBDB",
                "fill-outline-color": "#808080"
			}
		},
		{
			"id": "bati ZAI - Autres",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
									"Lycée",
									"Université",
									"Capitainerie",
									"Gendarmerie",
									"Siège d'EPCI",
									"Musée",
									"Collège",
									"Maison de retraite",
									"Etablissement thermal",
									"Autre service déconcentré de l'Etat",
									"Etablissement pénitentiaire",
									"Divers public ou administratif",
									"Autre établissement d'enseignement",
									"Maison du parc",
									"Palais de justice",
									"Enseignement primaire",
									"Office de tourisme",
									"Hôpital",
									"Police",
									"Enseignement supérieur",
									"Poste",
									"Caserne",
									"Etablissement hospitalier",
									"Etablissement extraterritorial",
									"Science",
									"Structure d'accueil pour personnes handicapées",
									"Administration centrale de l'Etat",
									"Caserne de pompiers",
									"Centre de documentation",
									"Salle de spectacle ou conférence",
									"Ecomusée"
            ],
			"paint": {
				"fill-color": "#E3BFE2",
                "fill-opacity": 0.5,
				"fill-outline-color": "#E39FE1"
			}
		},
		{
			"id": "bati ZAI - Commandement",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_zai",
            "minzoom":15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","nature",
                                    "Hôtel de département",
									"Hôtel de région",
									"Hôtel de collectivité",
									"Préfecture de région",
									"Préfecture",
									"Sous-préfecture"
            ],
			"paint": {
				"fill-color": "#FF0000",
                "fill-opacity": 0.3,
				"fill-outline-color": "#B40000"
			}
		},
        {
			"id": "construction linéaire - mur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","MUR"],
			"paint": {
				"line-color": "#8C8C8C",
		        "line-width": 0.3
			}
		},
        {
			"id": "construction linéaire - autre",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "RUINE_LIN",
                                    "MUR_SOUTENEMENT",
                                    "FORTIF_LIN"
            ],
			"paint": {
				"line-color": "#646464",
		        "line-width": 0.5
			}
		},
        {
			"id": "construction hydrographique linéaire - Barrage",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
            "minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","BARRAGE_LIN"],
			"paint": {
				"line-color": "#646464",
		        "line-width": {"stops": [[13, 1.5], [17, 5]]}
			}
		},
        {
			"id": "construction hydrographique linéaire - Quai",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
            "minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "QUAI",
                                    "DIGUE"
            ],
			"paint": {
				"line-color": "#828282",
		        "line-width": {"stops": [[14, 1], [17, 2.5]]}
			}
		},
      {
			"id": "construction hydrographique linéaire - Pecherie",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
            "minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","PECHERIE_LIN"],
			"paint": {
				"line-color": "#0066CC",
		        "line-width": {"stops": [[14, 1], [17, 2.5]]}
			}
        },
        {
			"id": "Chemin a niveau - piste cyclable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["in","symbo","PISTE_CYCLABLE",
									"VOIE_VERTE"
			],
			"paint": {
				"line-color": {"stops": [[17, "#e9383f"]]},
		        "line-width": {
				"stops": [[14, 2.5], [15, 2.1], [16, 2.5], [17, 3.5], [18, 6]]
                },
				"line-dasharray": [6,4]
			}
		},
        {
        	"id": "Chemin a niveau - filet exterieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1.75], [15, 3], [16, 4.2], [17, 9.5]]
                }
			}
		},
        {
			"id": "Chemin a niveau - filet interieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 1], [15, 1.9], [16, 2.7], [17, 5.8]]
                },
				"line-dasharray": [1,0.2]
			}
		},
        {
			"id": "Chemin a niveau - Rue pietonne",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","RUE_PIETONNE"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2], [18, 5]]
                },
				"line-dasharray": [1,3]
			}
		},
        {
			"id": "Chemin a niveau - sentier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","SENTIER"],
			"paint": {
				"line-color": {"stops": [[17, "#303030"],[18, "#e5e5e5"]]},
		        "line-width": {
				"stops": [[14, 1.5], [15, 1.2], [16, 1.4], [17, 2], [18, 6]]
                },
				"line-dasharray": [4,3]
			}
		},
        {
			"id": "Chemin a niveau - chemin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","CHEMIN"],
			"paint": {
				"line-color": {"stops": [[17, "#303030"],[18, "#e5e5e5"]]},
		        "line-width": {
				"stops": [[14, 1.2], [15, 1.2], [16, 1.4], [17, 2], [18, 7]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT"],
			"paint": {
				"line-color": {"stops": [[12, "#646464"], [17, "#8C8C8C"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO"],
			"paint": {
				"line-color": {"stops": [[12, "#646464"], [17, "#8C8C8C"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3",
                                    "BRET_AUTO_PEAGE_2",
                                    "BRET_AUTO_PEAGE_1",
                                    "BRET_AUTO_LIBRE_3",
                                    "BRET_AUTO_LIBRE_2",
                                    "BRET_AUTO_LIBRE_1"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#000000"], [17, "#000000"]]},
				"line-width": {
					"stops": [[12, 2.5], [14, 3.7], [15, 6.8], [16, 8.4], [17, 14]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT"],
			"paint": {
				"line-color": {"stops": [[17, "#969696"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4",
                                    "NON_CLASSEE"
            ],
			"paint": {
				"line-color": {"stops": [[17, "#000000"],[18, "#e5e5e5"]]},
		        "line-width": {
				"stops": [[14, 3.8], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 7,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE",
                                    "LOCALE_4",
                                    "LOCALE_3",
                                    "LOCALE_2",
                                    "LOCALE_1"
            ],
			"paint": {
				"line-color": {
                    "stops": [[12, "#8C8C8C"], [13, "#B4B4B4"], [17, "#B4B4B4"]]
                },
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE",
                                    "REGIONALE_4",
                                    "REGIONALE_3",
                                    "REGIONALE_2",
                                    "REGIONALE_1"
            ],
			"paint": {
				"line-color": {
                    "stops": [[9, "#6b6b6b"], [10, "#9c9c9c"], [17, "#303030"], [18, "#e5e5e5"]]
                },
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE",
                                    "PRINCIPALE_4",
                                    "PRINCIPALE_3",
                                    "PRINCIPALE_2",
                                    "PRINCIPALE_1"
            ],
			"paint": {
				"line-color": {"stops": [[17, "#000000"]]},
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","PRINCIPALE_CONSTR"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE",
                                    "AUTOROU_LIBRE"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#000000"], [17, "#000000"]]},
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet extérieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3",
                                    "BRET_AUTO_PEAGE_2",
                                    "BRET_AUTO_PEAGE_1",
                                    "BRET_AUTO_LIBRE_3",
                                    "BRET_AUTO_LIBRE_2",
                                    "BRET_AUTO_LIBRE_1"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
				"line-width": {
					"stops": [[12, 1.5], [14, 2.6], [15, 5.2], [16, 6.7], [17, 10.8]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4",
                                    "NON_CLASSEE"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE",
                                    "LOCALE_4",
                                    "LOCALE_3",
                                    "LOCALE_2",
                                    "LOCALE_1"
            ],
			"paint": {
				"line-color": {
                    "stops": [[6, "#F2B361"],[7, "#FFFFFF"], [12, "#FFFFFF"], [13, "#FFA35D"], [17, "#FFAD6F"]]
                },
		        "line-width": {
				"stops": [[9, 1.3], [14, 2.3], [15, 4.1], [16, 6.1], [17, 13.1]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR"],
			"paint": {
				"line-color": {
                    "stops": [[12, "#FFFFFF"], [13, "#FFA35D"], [17, "#FFAD6F"]]
                },
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                },
				"line-dasharray": [2, 2]
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE",
                                    "REGIONALE_4",
                                    "REGIONALE_3",
                                    "REGIONALE_2",
                                    "REGIONALE_1"
            ],
			"paint": {
				"line-color": {
                    "stops": [[6, "#d69131"], [7, "#e5e5e5"], [9, "#e5e5e5"], [10, "#e38135"], [17, "#d35400"]]
                },
		        "line-width": {
					"stops": [[4, 1.1], [6, 1.4], [9, 1.5], [14, 3.2], [15, 5.8], [16, 8.3], [17, 16.2]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR"],
			"paint": {
				"line-color": {
                    "stops": [[9, "#FFFFFF"], [10, "#FF994C"], [17, "#FFAD6F"]]
                },
		        "line-width": {
					"stops": [[4, 0.4], [6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE",
                                    "PRINCIPALE_4",
                                    "PRINCIPALE_3",
                                    "PRINCIPALE_2",
                                    "PRINCIPALE_1"
            ],
			"paint": {
				"line-color": {"stops": [[6, "#F29924"], [7, "#FF0033"], [9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.6], [6, 1.8], [9, 2.1], [14, 4.4], [15, 7.3], [16, 10], [17, 18.5]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","PRINCIPALE_CONSTR"],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.5], [6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier a niveau - filet interieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE",
                                    "AUTOROU_LIBRE"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.7], [6, 2.5], [9, 2.7], [14, 5.8], [15, 9], [16, 12], [17, 20.8]]
                }
			}
		},
        {
			"id": "Routier a niveau - axe central - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE",
                                    "AUTOROU_LIBRE"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "Routier a niveau - filet interieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR"],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.7], [6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                },
                "line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier a niveau - axe centrale - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR"],
			"paint": {
				"line-color": "#808080",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "Ferre a niveau - voie normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1",
                                    "VF_2",
                                    "VF_3",
                                    "VF_4",
                                    "VF_ELEC_1",
                                    "VF_ELEC_2",
                                    "VF_ELEC_3",
                                    "VF_ELEC_4"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.8], [17, 2.5]]
				}
			}
		},
        {
			"id": "Ferre a niveau - voie normale trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1",
                                    "VF_2",
                                    "VF_3",
                                    "VF_4",
                                    "VF_ELEC_1",
                                    "VF_ELEC_2",
                                    "VF_ELEC_3",
                                    "VF_ELEC_4"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre a niveau - voie etroite",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1",
                                    "VF_ETROITE_2",
									"VF_ETROITE"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
        {
			"id": "Ferre a niveau - voie etroite trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1",
                                    "VF_ETROITE_2",
									"VF_ETROITE"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre a niveau - voie service",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_SERVICE",
                                    "VF_NON_EXPLOITEE"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				},
				"line-dasharray": [5,2,1,2]
			}
		},
        {
			"id": "Ferre a niveau - voie en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","VF_EN_CONSTR"],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				},
                "line-dasharray": [2,2]
			}
		},
       {
			"id": "Ferre a niveau - voie en construction trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","VF_EN_CONSTR"],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre a niveau - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE",
                                    "TRANSPORT_URBAIN"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
         {
			"id": "Ferre a niveau - 2 trait perpendic - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE",
                                    "TRANSPORT_URBAIN"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 17]]
				},
				"line-dasharray": [0.1,0.2,0.1,10]
			}
		},
        {
			"id": "liaison routiere - Bac Liaison Maritime",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_liaison",
			"minzoom": 8,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
									"BAC_AUTO",
									"BAC",
									"LIAISON_MARITIME"
			],
			"paint": {
				"line-color": "#5792C2",
		        "line-width": {
					"stops": [[8, 1], [13, 2.5]]
                }
			}
		},
        {
			"id": "liaison routiere - Gue route",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_liaison",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","GUE_ROUTE"],
			"paint": {
				"line-color": {
                    "stops": [[13, "#BEBEBE"], [17, "#646464"], [18, "#FFFFFF"]]
                },
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "liaison routiere - Gue chemin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_liaison",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","GUE_CHEMIN"],
			"paint": {
				"line-color": {
                    "stops": [[13, "#BEBEBE"], [17, "#646464"]]
                },
		        "line-width": {
				"stops": [[14, 1.6], [15, 2.9], [16, 4.4], [17, 6.5]]
                }
			}
		},
        {
			"id": "liaison routiere - filet extérieur - Pont passerelle",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_liaison",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "PONT_PASSERELLE",
                                    "PONT_LIN",
                                    "PONT_MOBILE_LIN"
            ],
			"paint": {
				"line-color": {"stops": [[17, "#000000"], [18, "#000000"]]},
		        "line-width": {
				"stops": [[14, 6], [15, 10], [16, 12], [17, 11.8]]
                }
			}
		},
        {
			"id": "liaison routiere - filet intérieur - Pont passerelle",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_liaison",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "PONT_PASSERELLE",
                                    "PONT_LIN",
                                    "PONT_MOBILE_LIN"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 0.7], [15, 1.1], [16, 1.7], [17, 3.8]]
                }
			}
		},
        {
			"id": "Routier surfacique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "routier_surf",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "SURF_ROUT_PRINC",
                                    "SURF_ROUT_REG",
                                    "SURF_ROUT_LOC",
                                    "SURF_ROUT_NON_CLA"],
			"paint": {
				"fill-color": "#FFFFFF",
                "fill-outline-color": "#000000"
			}
		},
        {
			"id": "Routier surfacique - Dalle de protection",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "routier_surf",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","DALLE_DE_PROTECTION"],
			"paint": {
				"fill-opacity": 0.5,
				"fill-color": "#FFFFFF",
                "fill-outline-color": "#000000"
			}
		},
        {
			"id": "Routier surfacique - Escalier surfacique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "routier_surf",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","ESCALIER_SURF"],
			"paint": {
				"fill-opacity": 0.8,
				"fill-color": "#FFFFFF",
                "fill-outline-color": "#918091"
			}
		},
        {
			"id": "Routier surfacique - Péage surfacique",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "routier_surf",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","SURF_PEAGE"],
			"paint": {
				"fill-color": "#F2DAAA",
                "fill-outline-color": "#000000"
			}
		},
		{
			"id": "bati transport surfacique - bati peage",
			"type": "fill",
			"source": "plan_ign",
			"source-layer": "bati_surf",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","BATI_PEAGE"],
			"paint": {
                "fill-color": "#DCDCDC",
                "fill-outline-color": "#808080"
			}
		},
		{
			"id": "réseau hydro  - cours d'eau superieur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
									"COURS_D_EAU_SUP",
									"COURS_D_EAU_MOY_SUP"
			],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
					"stops": [[12, 1.5], [17, 6.5]]
                }
			}
		},
        {
			"id": "réseau hydro - canal superieur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","CANAL_SUP"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 1.4], [17, 5.9]]
                }
			}
		},
        {
			"id": "réseau hydro - filet interieur - aqueduc superieur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_SUP"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 1.4], [16, 3.5], [17, 5.9]]
                }
			}
		},
        {
			"id": "réseau hydro - carre - aqueduc superieur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "hydro_reseau_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AQUEDUC_SUP"],
			"paint": {
				"line-color": "#B3D9FF",
		        "line-width": {
				"stops": [[12, 3.5], [16, 8.7], [17, 14.7]]
                },
			    "line-dasharray": [1,5]
			}
		},
        {
			"id": "Chemin superieur - piste cyclable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["in","symbo","PISTE_CYCLABLE_SUP",
									"VOIE_VERTE_SUP"
			],
			"paint": {
				"line-color": {"stops": [[17, "#e9383f"]]},
		        "line-width": {
				"stops": [[14, 2.5], [15, 2.1], [16, 2.5], [17, 3.5], [18, 6]]
                },
				"line-dasharray": [6,4]
			}
		},
        {
			"id": "Chemin superieur - filet exterieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER_SUP"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1.75], [15, 3], [16, 4.2], [17, 9.5]]
                }
			}
		},
        {
			"id": "Chemin superieur - filet interieur - escalier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","ESCALIER_SUP"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 1], [15, 1.9], [16, 2.7], [17, 5.8]]
                },
				"line-dasharray": [1,0.2]
			}
		},
        {
			"id": "Chemin superieur - Rue pietonne",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","RUE_PIETONNE_SUP"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2], [18, 5]]
                },
				"line-dasharray": [1,3]
			}
		},
        {
			"id": "Chemin superieur - sentier",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","SENTIER_SUP"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2], [18, 6]]
                },
				"line-dasharray": [4,3]
			}
		},
        {
			"id": "Chemin superieur - chemin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_chemin_sup",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","CHEMIN_SUP"],
			"paint": {
				"line-color": {"stops": [[17, "#555555"]]},
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2], [18, 7]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT_SUP"],
			"paint": {
				"line-color": {"stops": [[12, "#646464"], [17, "#8C8C8C"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_SUP"],
			"paint": {
				"line-color": {"stops": [[12, "#646464"], [17, "#8C8C8C"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier superieur - filet extérieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3_SUP",
                                    "BRET_AUTO_PEAGE_2_SUP",
                                    "BRET_AUTO_PEAGE_1_SUP",
                                    "BRET_AUTO_LIBRE_3_SUP",
                                    "BRET_AUTO_LIBRE_2_SUP",
                                    "BRET_AUTO_LIBRE_1_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#000000"], [17, "#000000"]]},
				"line-width": {
					"stops": [[12, 2.5], [14, 3.7], [15, 6.8], [16, 8.4], [17, 14]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT_SUP"],
			"paint": {
				"line-color": {"stops": [[17, "#969696"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4_SUP",
                                    "NON_CLASSEE_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[17, "#969696"]]},
		        "line-width": {
				"stops": [[14, 3.2], [15, 5.4], [16, 7.7], [17, 16.8]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE_SUP",
                                    "LOCALE_4_SUP",
                                    "LOCALE_3_SUP",
                                    "LOCALE_2_SUP",
                                    "LOCALE_1_SUP"
            ],
			"paint": {
				"line-color": {
                    "stops": [[12, "#8C8C8C"], [13, "#B4B4B4"], [17, "#B4B4B4"]]
                },
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR_SUP"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE_SUP",
                                    "REGIONALE_4_SUP",
                                    "REGIONALE_3_SUP",
                                    "REGIONALE_2_SUP",
                                    "REGIONALE_1_SUP"
            ],
			"paint": {
				"line-color": {
                    "stops": [[9, "#828282"], [10, "#B4B4B4"], [17, "#B4B4B4"]]
                },
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR_SUP"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE_SUP",
                                    "PRINCIPALE_4_SUP",
                                    "PRINCIPALE_3_SUP",
                                    "PRINCIPALE_2_SUP",
                                    "PRINCIPALE_1_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[17, "#000000"]]},
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","PRINCIPALE_CONSTR_SUP"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SUP",
                                    "AUTOROU_LIBRE_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#000000"], [17, "#000000"]]},
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier superieur - filet extérieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","AUTOROU_CONSTR_SUP"],
			"paint": {
				"line-color": "#C8C8C8",
		        "line-width": {
					"stops": [[6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route non revetu carrosable restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_RESTREINT_SUP"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route non revetu carrosable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","NON_REVETUE_CARRO_SUP"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - bretelle autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_AUTO_PEAGE_3_SUP",
                                    "BRET_AUTO_PEAGE_2_SUP",
                                    "BRET_AUTO_PEAGE_1_SUP",
                                    "BRET_AUTO_LIBRE_3_SUP",
                                    "BRET_AUTO_LIBRE_2_SUP",
                                    "BRET_AUTO_LIBRE_1_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
				"line-width": {
					"stops": [[12, 1.5], [14, 2.6], [15, 5.2], [16, 6.7], [17, 10.8]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route non classee restreint",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","NON_CLASSEE_RESTREINT_SUP"],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route non classee",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "NON_CLASSEE_4_SUP",
                                    "NON_CLASSEE_SUP"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
				"stops": [[14, 2.3], [15, 4.1], [16, 6.3], [17, 13.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route locale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_LOCALE_SUP",
                                    "LOCALE_4_SUP",
                                    "LOCALE_3_SUP",
                                    "LOCALE_2_SUP",
                                    "LOCALE_1_SUP"
            ],
			"paint": {
				"line-color": {
                    "stops": [[12, "#FFFFFF"], [13, "#FFA35D"], [17, "#FFAD6F"]]
                },
		        "line-width": {
				"stops": [[9, 1.3], [14, 2.3], [15, 4.1], [16, 6.1], [17, 13.1]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route locale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","LOCALE_CONSTR_SUP"],
			"paint": {
				"line-color": {
                    "stops": [[12, "#FFFFFF"], [13, "#FFA35D"], [17, "#FFAD6F"]]
                },
		        "line-width": {
				"stops": [[9, 2], [14, 3.5], [15, 6], [16, 8.4], [17, 18.3]]
                },
				"line-dasharray": [2, 2]
			}
		},
        {
			"id": "Routier superieur - filet interieur - route regionale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_REGIONALE_SUP",
                                    "REGIONALE_4_SUP",
                                    "REGIONALE_3_SUP",
                                    "REGIONALE_2_SUP",
                                    "REGIONALE_1_SUP"
            ],
			"paint": {
				"line-color": {
                    "stops": [[9, "#FFFFFF"], [10, "#FF994C"], [17, "#FFAD6F"]]
                },
		        "line-width": {
					"stops": [[6, 1.4], [9, 1.5], [14, 3.2], [15, 5.8], [16, 8.3], [17, 16.2]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route regionale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REGIONALE_CONSTR_SUP"],
			"paint": {
				"line-color": {
                    "stops": [[9, "#FFFFFF"], [10, "#FF994C"], [17, "#FFAD6F"]]
                },
		        "line-width": {
					"stops": [[6, 1.5], [9, 2.3], [14, 5], [15, 8.1], [16, 11.2], [17, 22]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier superieur - filet interieur - route principale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "BRET_PRINCIPALE_SUP",
                                    "PRINCIPALE_4_SUP",
                                    "PRINCIPALE_3_SUP",
                                    "PRINCIPALE_2_SUP",
                                    "PRINCIPALE_1_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.5], [6, 1.8], [9, 2.1], [14, 4.4], [15, 7.3], [16, 10], [17, 18.5]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - route principale en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","PRINCIPALE_CONSTR_SUP"],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[6, 1.8], [9, 2.7], [14, 5.9], [15, 9], [16, 12.2], [17, 22.5]]
                },
				"line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier superieur - filet interieur - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SUP",
                                    "AUTOROU_LIBRE_SUP"
            ],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.7], [6, 2.5], [9, 2.7], [14, 5.8], [15, 9], [16, 12], [17, 20.8]]
                }
			}
		},
		{
			"id": "Routier superieur - axe central - autoroute",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "AUTOROU_PEAGE_SUP",
                                    "AUTOROU_LIBRE_SUP"
            ],
			"paint": {
				"line-color": "#FFFFFF",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "Routier superieur - filet interieur - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR_SUP"],
			"paint": {
				"line-color": {"stops": [[9, "#FF0033"], [17, "#FF476C"]]},
		        "line-width": {
					"stops": [[4, 0.7], [6, 2.5], [9, 3.5], [14, 7.5], [15, 11], [16, 15], [17, 26]]
                },
                "line-dasharray": [2,2]
			}
		},
        {
			"id": "Routier superieur - axe centrale - autoroute en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "routier_route_sup",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","AUTOROU_CONSTR_SUP"],
			"paint": {
				"line-color": "#808080",
		        "line-width": {
					"stops": [[9, 0.6], [14, 0.7], [15, 1], [16, 1.2], [17, 2.1]]
                }
			}
		},
        {
			"id": "Ferre superieur - voie normale",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1_SUP",
                                    "VF_2_SUP",
									"VF_3_SUP",
									"VF_4_SUP",
                                    "VF_ELEC_1_SUP",
									"VF_ELEC_2_SUP",
									"VF_ELEC_3_SUP",
									"VF_ELEC_4_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.8], [17, 2.5]]
				}
			}
		},
        {
			"id": "Ferre superieur - voie normale trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_1_SUP",
                                    "VF_2_SUP",
									"VF_3_SUP",
									"VF_4_SUP",
                                    "VF_ELEC_1_SUP",
									"VF_ELEC_2_SUP",
									"VF_ELEC_3_SUP",
									"VF_ELEC_4_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre superieur - voie etroite",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1_SUP",
									"VF_ETROITE_2_SUP",
									"VF_ETROITE_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
        {
			"id": "Ferre superieur - voie etroite trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_ETROITE_1_SUP",
									"VF_ETROITE_2_SUP",
									"VF_ETROITE_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre superieur - voie service",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "VF_SERVICE_SUP",
                                    "VF_NON_EXPLOITEE_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				},
				"line-dasharray": [5,2,1,2]
			}
		},
        {
			"id": "Ferre superieur - voie en construction",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["==","symbo","VF_EN_CONSTR_SUP"],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				},
                "line-dasharray": [2,2]
			}
		},
        {
			"id": "Ferre superieur - voie en construction trait perpendic",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"minzoom": 10,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","VF_EN_CONSTR_SUP"],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 14.7]]
				},
				"line-dasharray": [0.1,10]
			}
		},
        {
			"id": "Ferre superieur - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE_SUP",
                                    "TRANSPORT_URBAIN_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 0.3], [17, 1.8]]
				}
			}
		},
         {
			"id": "Ferre superieur - 2 trait perpendic - funic/urbain",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "ferre_sup",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "FUNI_CREMAILLERE_SUP",
                                    "TRANSPORT_URBAIN_SUP"
            ],
			"paint": {
				"line-color": "#505050",
		        "line-width": {
					"stops": [[10, 3.5], [17, 17]]
				},
				"line-dasharray": [0.1,0.2,0.1,10]
			}
		},
		{
			"id": "Limite - cloture",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","CLOTURE"],
			"paint": {
				"line-color": "#000000",
                "line-width": {
					"stops": [[13, 0.6], [17, 1]]
                },
                "line-dasharray": [1.5, 4]
			}
		},
        {
			"id": "Limite - layon",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 14,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
			"filter": ["==","symbo","LAYON"],
			"paint": {
				"line-color": "#717171",
		        "line-width": {
				"stops": [[14, 1], [15, 1.2], [16, 1.4], [17, 2]]
                },
				"line-dasharray": [4,7]
			}
		},
        {
			"id": "Zone Règlementee - Enceinte militaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "LIM_ZONE_REGLEMENTEE",
                                    "LIM_ENCEINTE_MILITAIRE",
                                    "LIM_ENCEINTE_MILI",
                                    "LIM_CHAMP_TIR"
            ],
			"paint": {
				"line-color": "rgba(226, 130, 92, 0.8)",
                "line-width": {
					"stops": [[13, 1.7], [17, 3.1]]
                },
                "line-dasharray": [4, 1, 2, 5]
			}
		},
        {
			"id": "limite zone naturelle",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_ZONE_NATURELLE",
									"LIM_ZONE_NATURELLE_ILE",
									"LIM_RESERVE_NATURELLE"
			],
			"paint": {
				"line-color": "#FFC2CB",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 1]
			}
		},
        {
			"id": "limite zone naturelle - Parc naturel 10",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"maxzoom": 10,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_PARC_NATUREL",
									"LIM_PARC_NATUREL_ILE"
			],
			"paint": {
				"line-color": "#42A266",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 1]
			}
		},
        {
			"id": "limite zone naturelle - Parc naturel 11",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 10,
			"maxzoom": 11,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_PARC_NATUREL",
									"LIM_PARC_NATUREL_ILE"
			],
			"paint": {
				"line-color": "#42A266",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 2]
			}
		},
        {
			"id": "limite zone naturelle - Parc naturel 12",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 11,
			"maxzoom": 12,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_PARC_NATUREL",
									"LIM_PARC_NATUREL_ILE"
			],
			"paint": {
				"line-color": "#42A266",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 3]
			}
		},
        {
			"id": "limite zone naturelle - Parc naturel 13",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 12,
			"maxzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_PARC_NATUREL",
									"LIM_PARC_NATUREL_ILE"
			],
			"paint": {
				"line-color": "#42A266",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 4]
			}
		},
        {
			"id": "limite zone naturelle - Parc naturel 14",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
            },
            "filter": ["in","symbo",
									"LIM_PARC_NATUREL",
									"LIM_PARC_NATUREL_ILE"
			],
			"paint": {
				"line-color": "rgba(66, 162, 102, 0.7)",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 5]
			}
		},
        {
			"id": "limite zone naturelle - Parc marin",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","LIM_PARC_NATUREL_MARIN"],
			"paint": {
				"line-color": "#2A81A2",
                "line-width": {
					"stops": [[13, 2], [17, 4]]
                },
                "line-dasharray": [2, 1]
			}
		},
		{
            "id": "toponyme - parcellaire - adresse",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_parcellaire_adresse_ponc",
            "filter": ["==","txt_typo","ADRESSE"],
            "layout": {
                "symbol-placement": "point",
                "text-field": ["concat", ["get","numero"], ["get","indice_de_repetition"]],
                "text-size": 11,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-font": ["Source Sans Pro Bold"]
            },
            "paint": {
                "text-color": "#695744",
				"text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
        {
			"id": "limite admin - limite de commune",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "LIM_COMMUNE",
                                    "LIM_CANTON",
                                    "LIM_ARRONDISSEMENT"
            ],
			"paint": {
				"line-color": "#154360",
		        "line-width": {
				"stops": [[13, 2], [17, 5.5]]
                },
                "line-dasharray": [4, 2, 1, 1, 1, 1, 1, 2]
			}
		},
        {
			"id": "limite admin - limite de département bandeau",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 8,
			"maxzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","LIM_DEPARTEMENT"],
			"paint": {
				"line-color": "rgba(178, 175, 219, 0.4)",
		        "line-width": {
				"stops": [[9, 4.1], [12, 6]]
                }
			}
		},
        {
			"id": "limite admin - limite de département tiret",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","LIM_DEPARTEMENT"],
			"paint": {
				"line-color": "rgba(126, 119, 184, 0.5)",
		        "line-width": {
				"stops": [[13, 3], [17, 5.5]]
                },
                "line-dasharray": [4, 2, 1, 1, 1, 2]
			}
		},
        {
			"id": "limite admin - limite de région bandeau",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 7,
			"maxzoom": 13,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","LIM_REGION"],
			"paint": {
				"line-color": "rgba(178, 175, 219, 0.5)",
		        "line-width": {
				"stops": [[9, 4.5], [12, 6.7]]
                }
			}
		},
        {
			"id": "limite admin - limite de région tiret",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 13,
			"maxzoom": 18,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
			"filter": ["==","symbo","LIM_REGION"],
			"paint": {
				"line-color": "rgba(126, 119, 184, 0.5)",
		        "line-width": {
				"stops": [[13, 3], [17, 5.5]]
                },
                "line-dasharray": [4, 2, 1, 2]
			}
		},
        {
			"id": "limite etat 1",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 2,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "LIM_ETAT",
                                    "LIM_ETAT_ETRANGER"
            ],
			"paint": {
				"line-color": "rgba(178, 175, 219, 0.6)",
		        "line-width": {
				"stops": [[2, 2], [3, 3.5], [9, 5], [14, 13], [15, 20], [16, 24], [17, 42]]
                }
			}
		},
        {
			"id": "limite etat 2",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 7,
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "LIM_ETAT",
                                    "LIM_ETAT_ETRANGER"
            ],
			"paint": {
				"line-color": "#9F9CB8",
		        "line-width": {
				"stops": [[9, 1.5], [14, 3.5], [15, 5.5], [16, 6.5], [17, 11]]
                },
                "line-dasharray": [4, 2]
			}
		},
        {
            "id": "limite cote",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "limite_lin",
			"minzoom": 7,
            "maxzoom":10,
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo","LIM_COTE"],
			"paint": {
				"line-color": "#82A3B2",
                "line-width": 1
			}
        },
        {
			"id": "ligne electrique",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
            },
            "filter": ["==","symbo","LIGNE_ELECTRIQUE"],
			"paint": {
				"line-color": "#808080",
		        "line-width": {
					"stops": [[13, 1], [17, 2]]
				}
			}
		},
        {
			"id": "autre construction linéaire",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "round",
                "line-join": "round"
			},
            "filter": ["in","symbo",
									"CABLE",
                                    "REMONTEE_MEC",
                                    "HYDROCARBURES",
                                    "CONDUITE_MATIERES_P",
                                    "SPORT_MONTAGNE_LIN",
									"PISTE_BOBSLEIGH",
									"PISTE_LUGE",
                                    "PISTE_AERO_LIN"
            ],
			"paint": {
				"line-color": "#808080",
		        "line-width": 1
			}
		},
        {
			"id": "autre construction linéaire - trait perpend cable",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","CABLE"],
			"paint": {
				"line-color": "#808080",
		        "line-width": 5,
				"line-dasharray": [0.5,10]
			}
		},
        {
			"id": "autre construction linéaire - trait perpend 1 remont",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REMONTEE_MEC"],
			"paint": {
				"line-color": "#808080",
		        "line-width": 6,
				"line-dasharray": [1,10]
			}
		},
        {
			"id": "autre construction linéaire - trait perpend 2 remont",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["==","symbo","REMONTEE_MEC"],
			"paint": {
				"line-color": "#BEBEBE",
		        "line-width": 6,
				"line-dasharray": [0.3,0.4,0.3,10]
			}
		},
        {
			"id": "autre construction linéaire - trait perpend carbur",
			"type": "line",
			"source": "plan_ign",
			"source-layer": "bati_lin",
			"layout": {
				"visibility": "visible",
                "line-cap": "butt",
                "line-join": "round"
			},
            "filter": ["in","symbo",
                                    "HYDROCARBURES",
                                    "CONDUITE_MATIERES_P"
            ],
			"paint": {
				"line-color": "#808080",
		        "line-width": 5,
				"line-dasharray": [1,10]
			}
		},
		{
			"id": "routier ponctuel - peage ponctuel",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "routier_ponc",
			"minzoom": 8,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","PEAGE_PONC"],
			"paint": {
                "circle-radius": {
				"stops": [[9, 3.5], [12, 6.5]]
                },
                "circle-color": "#FF6D8A",
				"circle-stroke-width": 1,
                "circle-stroke-color": "#808080"
			}
		},
		{
			"id": "routier ponctuel - barriere",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "routier_ponc",
			"minzoom": 12,
			"layout": {
				"visibility": "visible",
				"icon-image": "Barriere",
				"icon-size": {
				"stops": [[13, 0.25], [16, 0.45], [17, 0.7]]
				},
				"icon-allow-overlap": true,
				"icon-rotate": ["get", "rotation"]
			},
            "filter": ["==","symbo","BARRIERE"],
			"paint": {
				"icon-color": "#969696"
			}
		},
		{
			"id": "hydro ponctuel",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "hydro_ponc",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "FONTAINE",
                                    "POINT_D_EAU",
                                    "SOURCE",
                                    "SOURCE_CAPTEE",
                                    "PERTE",
                                    "RESURGENCE",
                                    "CASCADE",
									"AUTRE_HYDRO_PONC"
            ],
			"paint": {
                "circle-radius": {
				"stops": [[14, 3], [17, 7]]
				},
                "circle-color": "#FFFFFF",
                "circle-opacity": 1,
                "circle-stroke-width": {
				"stops": [[14, 2], [17, 5]]
				},
                "circle-stroke-color": "#0081FF"
			}
		},
		{
			"id": "point coté",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "oro_ponc",
			"minzoom": 11,
			"maxzoom": 16,
            "filter": ["in","symbo",
                                    "POINT_COTE",
                                    "POINT_COTE_TOPO",
                                    "POINT_COTE_RESEAU",
                                    "POINT_RBF"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.1,
                "text-field": "{texte}",
                "text-size": 10,
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.2, 0.4],
                "text-padding": 2,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#505050"
			}
		},
		{
			"id": "bati ponctuel : Hopital",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "Hopital",
				"icon-size": 0.33
			},
            "filter": ["==","symbo","HOPITAL_PONC"],
			"paint": {
				"icon-color": "#FE0034"
			}
		},
		{
			"id": "bati ponctuel hydrographique",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 14,
			"layout": {
				"visibility": "visible",
				"icon-image": "Pompage",
				"icon-size": { "stops": [[13, 0.2], [17, 0.6]] },
				"icon-allow-overlap": true
			},
            "filter": ["in","symbo",
                                    "CITERNE",
                                    "LAVOIR",
                                    "STATION_EPURATION",
                                    "STATION_DE_POMPAGE",
									"USINE_PRODUCTION_EAU",
									"USINE_ELEVATRICE"
            ],
			"paint": {
				"icon-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Puits-Abreuvoir",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 13,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["in","symbo",
                                    "PUITS",
                                    "ABREUVOIR"
            ],
			"paint": {
                "circle-radius": {
				"stops": [[14, 3], [17, 7]]
				},
                "circle-color": "#FFFFFF",
                "circle-opacity": 1,
                "circle-stroke-width": {
				"stops": [[14, 2], [17, 5]]
				},
                "circle-stroke-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Phare",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
				"icon-image": "Phare",
				"icon-size": { "stops": [[13, 0.7], [17, 1.3]] }
			},
            "filter": ["==","symbo","PHARE"],
			"paint": {
				"icon-color": "#505050"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Amer-Feu",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
				"icon-image": "Feu",
				"icon-size": { "stops": [[13, 0.7], [17, 1.3]] }
			},
            "filter": ["in","symbo",
                                    "AMER",
                                    "FEU",
                                    "FEU_PONC",
									"TOURELLE_LUMINEUSE"
            ],
			"paint": {
				"icon-color": "#505050"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Balise",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 13,
			"layout": {
				"visibility": "visible",
				"icon-image": "Balise",
				"icon-size": { "stops": [[13, 0.7], [17, 1.3]] }
			},
            "filter": ["in","symbo",
									"BALISE",
									"TOURELLE"
			],
			"paint": {
				"icon-color": "#505050"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Ecluse",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 12,
			"maxzoom": 15,
			"layout": {
				"visibility": "visible",
				"icon-image": "Ecluse",
				"icon-size": 0.2
			},
            "filter": ["==","symbo","ECLUSE_PONC"],
			"paint": {
				"icon-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Barrage",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 12,
			"maxzoom": 14,
			"layout": {
				"visibility": "visible",
				"icon-image": "Barrage",
				"icon-size": 0.25
			},
            "filter": ["==","symbo","BARRAGE_PONC"],
			"paint": {
				"icon-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Chateau d'eau",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","CHATEAU_EAU_PONC"],
			"paint": {
                "circle-radius": {
				"stops": [[14, 3], [17, 8]]
				},
                "circle-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel hydrographique - Réservoir d'eau",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","RESERVOIR_EAU_PONC"],
			"paint": {
                "circle-radius": {
				"stops": [[14, 3], [17, 8]]
				},
                "circle-color": "#B3D9FF",
                "circle-opacity": 1,
                "circle-stroke-width": {
				"stops": [[14, 1], [17, 2.5]]
				},
                "circle-stroke-color": "#0081FF"
			}
		},
		{
			"id": "bati ponctuel infrastructure - Constr spé",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "ConstrSpeciale",
				"icon-size": { "stops": [[13, 0.22], [17, 0.5]] }
			},
            "filter": ["in","symbo",
                                    "ANTENNE",
                                    "CONSTR_INDIF_PONC",
									"CHEMINEE",
									"CHEVALEMENT",
									"PUITS_GAZ",
									"PUITS_PETROLE",
									"PYLONE_METEO",
									"TORCHERE",
									"TOUR_GUET",
									"TOUR_HERTZIENNE"
            ],
			"paint": {
				"icon-color": "#646464"
			}
		},
		{
	   "id": "jlc TF",
	   "type": "symbol",
	   "source": "plan_ign",
	   "source-layer": "bati_ponc",
	   "minzoom": 13,
	   "filter": [
		 "==",
		 "symbo",
		 "TRANSFORMATEUR"
	   ],
	   "layout": {
		"visibility": "visible",
		"text-field": "TF",
		"text-size": 9,
		"text-allow-overlap": true,
		"text-font": [
		 "Source Sans Pro Bold"
		]
	   },
	   "paint": {
		"text-color": "#ffff00",
		"text-halo-color": "#000000",
		"text-halo-width": 2
	   }
	  },
		{
			"id": "bati ponctuel infrastructure - Silo",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible",
				"icon-image": "Silo",
				"icon-size": { "stops": [[13, 0.22], [17, 0.5]] }
			},
            "filter": ["==","symbo","SILO_PONC"],
			"paint": {
				"icon-color": "#646464"
			}
		},
		{
			"id": "bati ponctuel infrastructure - Eolienne",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "Eolienne",
				"icon-size": { "stops": [[13, 0.4], [17, 1], [18, 0.8]] }
			},
            "filter": ["==","symbo","EOLIENNE"],
			"paint": {
				"icon-color": "#646464"
			}
		},
		{
			"id": "bati ponctuel infrastructure - Reservoir",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"maxzoom": 15,
			"layout": {
				"visibility": "visible",
				"icon-image": "Reservoir",
				"icon-size": { "stops": [[13, 0.26], [17, 0.5]] }
			},
            "filter": ["==","symbo","RESERVOIR_PONC"],
			"paint": {
				"icon-color": "#646464"
			}
		},
		{
			"id": "bati ponctuel infrastructure - pylone électrique",
			"type": "circle",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible"
			},
            "filter": ["==","symbo","PYLONE_ELEC"],
			"paint": {
                "circle-radius" : {
					"stops": [[13, 1], [17, 2]]
				},
                "circle-color" : "#000000"
			}
		},
		{
			"id": "bati ponctuel montagne - Abri",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "Abri",
				"icon-size": { "stops": [[13, 0.4], [15, 0.6], [17, 0.9]] }
			},
            "filter": ["==","symbo","ABRI"],
			"paint": {
				"icon-color": "#246138"
			}
		},
		{
			"id": "bati ponctuel montagne - Refuge Garde",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "Refugegard",
				"icon-size": { "stops": [[13, 0.4], [15, 0.6], [17, 0.9]] }
			},
            "filter": ["==","symbo","REFUGE_GARDE"],
			"paint": {
				"icon-color": "#246138"
			}
		},
		{
			"id": "bati ponctuel montagne - Refuge Non Garde",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
				"icon-image": "Refugenongard",
				"icon-size": { "stops": [[13, 0.4], [15, 0.6], [17, 0.9]] }
			},
            "filter": ["==","symbo","REFUGE"],
			"paint": {
				"icon-color": "#246138"
			}
		},
		{
			"id": "bati ponctuel transport aerien - Aeroport FXX",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
                "icon-image": "Aeroport",
				"icon-size": 0.5
			},
            "filter": ["all",
                        ["==","symbo","AEROPORT_PONC"],
                        ["==","territoire","FXX"]
            ],
			"paint": {
                "icon-color": "#646464"
            }
		},
		{
			"id": "bati ponctuel transport aerien - Aerodrome FXX",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
                "icon-image": "Aerodrome",
				"icon-size": 0.4
			},
            "filter": ["all",
						["in","symbo",
										"AERODROME_PONC",
										"AERODROME_IMPORT_PONC"],
                        ["==","territoire","FXX"]
            ],
			"paint": {
                "icon-color": "#646464"
            }
		},
		{
			"id": "bati ponctuel transport aerien - Aeroport DOM",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "icon-image": "Aeroport",
				"icon-size": 0.5
			},
            "filter": ["all",
                        ["==","symbo","AEROPORT_PONC"],
                        ["!=","territoire","FXX"]
            ],
			"paint": {
                "icon-color": "#646464"
            }
		},
		{
			"id": "bati ponctuel transport aerien - Aerodrome DOM",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"minzoom": 8,
			"layout": {
				"visibility": "visible",
                "icon-image": "Aerodrome",
				"icon-size": 0.4
			},
            "filter": ["all",
                        ["==","symbo","AERODROME_PONC"],
                        ["!=","territoire","FXX"]
            ],
			"paint": {
                "icon-color": "#646464"
            }
		},
		{
			"id": "bati ponctuel transport ferroviaire",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "bati_ponc",
			"layout": {
				"visibility": "visible",
                "icon-image": "Gare",
				"icon-size" : 0.33
			},
            "filter": ["==","symbo","GARE_VOYAGEURS"],
			"paint": {
                "icon-color": "#4E4E4E"
            }
		},
		{
            "id": "toponyme - bornes postales haute - chemins",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "CHEMIN",
                                        "CHEMIN_SOU",
                                        "CHEMIN_SUP",
                                        "PISTE_CYCLABLE",
                                        "PISTE_CYCLABLE_SOU",
                                        "PISTE_CYCLABLE_SUP",
										"VOIE_VERTE",
										"VOIE_VERTE_SOU",
										"VOIE_VERTE_SUP",
                                        "RUE_PIETONNE",
                                        "RUE_PIETONNE_SOU",
                                        "RUE_PIETONNE_SUP",
                                        "SENTIER",
                                        "SENTIER_SOU",
                                        "SENTIER_SUP",
                                        "ESCALIER",
                                        "ESCALIER_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sur}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  -1
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales haute - non revetue, non classee",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "NON_CLASSEE",
                                        "NON_CLASSEE_4",
                                        "NON_CLASSEE_4_SUP",
                                        "NON_CLASSEE_RESTREINT",
                                        "NON_CLASSEE_RESTREINT_SUP",
                                        "NON_CLASSEE_SOU",
                                        "NON_CLASSEE_SUP",
                                        "NON_REVETUE_CARRO",
                                        "NON_REVETUE_CARRO_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sur}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  -1.3
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales haute - locales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "LOCALE_1",
                                        "LOCALE_1_SOU",
                                        "LOCALE_1_SUP",
                                        "LOCALE_2",
                                        "LOCALE_2_SOU",
                                        "LOCALE_2_SUP",
                                        "LOCALE_3",
                                        "LOCALE_3_SOU",
                                        "LOCALE_3_SUP",
                                        "LOCALE_4",
                                        "LOCALE_4_SOU",
                                        "LOCALE_4_SUP",
                                        "LOCALE_CONSTR",
                                        "LOCALE_CONSTR_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sur}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  -1.4
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales haute - regionales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "REGIONALE_1",
                                        "REGIONALE_1_SOU",
                                        "REGIONALE_1_SUP",
                                        "REGIONALE_2",
                                        "REGIONALE_2_SOU",
                                        "REGIONALE_2_SUP",
                                        "REGIONALE_3",
                                        "REGIONALE_3_SOU",
                                        "REGIONALE_3_SUP",
                                        "REGIONALE_4",
                                        "REGIONALE_4_SUP",
                                        "REGIONALE_CONSTR"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sur}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  -1.5
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales haute - principales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "PRINCIPALE_1",
										"PRINCIPALE_1_SOU",
                                        "PRINCIPALE_1_SUP",
                                        "PRINCIPALE_2",
                                        "PRINCIPALE_2_SOU",
                                        "PRINCIPALE_2_SUP",
                                        "PRINCIPALE_3",
                                        "PRINCIPALE_3_SOU",
                                        "PRINCIPALE_3_SUP",
                                        "PRINCIPALE_4",
										"PRINCIPALE_4_SOU",
                                        "PRINCIPALE_4_SUP",
                                        "PRINCIPALE_CONSTR"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sur}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  -1.6
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales bas - chemins",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "CHEMIN",
                                        "CHEMIN_SOU",
                                        "CHEMIN_SUP",
                                        "PISTE_CYCLABLE",
                                        "PISTE_CYCLABLE_SOU",
                                        "PISTE_CYCLABLE_SUP",
										"VOIE_VERTE",
										"VOIE_VERTE_SOU",
										"VOIE_VERTE_SUP",
                                        "RUE_PIETONNE",
                                        "RUE_PIETONNE_SOU",
                                        "RUE_PIETONNE_SUP",
                                        "SENTIER",
                                        "SENTIER_SOU",
                                        "SENTIER_SUP",
                                        "ESCALIER",
                                        "ESCALIER_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sous}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  1
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales bas - non revetue, non classee",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "NON_CLASSEE",
                                        "NON_CLASSEE_4",
                                        "NON_CLASSEE_4_SUP",
										"NON_CLASSEE_RESTREINT",
                                        "NON_CLASSEE_RESTREINT_SUP",
                                        "NON_CLASSEE_SOU",
                                        "NON_CLASSEE_SUP",
                                        "NON_REVETUE_CARRO",
                                        "NON_REVETUE_CARRO_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sous}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  1.3
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales bas - locales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "LOCALE_1",
                                        "LOCALE_1_SOU",
                                        "LOCALE_1_SUP",
                                        "LOCALE_2",
                                        "LOCALE_2_SOU",
                                        "LOCALE_2_SUP",
                                        "LOCALE_3",
                                        "LOCALE_3_SOU",
                                        "LOCALE_3_SUP",
                                        "LOCALE_4",
                                        "LOCALE_4_SOU",
                                        "LOCALE_4_SUP",
                                        "LOCALE_CONSTR",
										"LOCALE_CONSTR_SUP"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sous}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  1.4
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales bas - regionales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "REGIONALE_1",
                                        "REGIONALE_1_SOU",
                                        "REGIONALE_1_SUP",
                                        "REGIONALE_2",
                                        "REGIONALE_2_SOU",
                                        "REGIONALE_2_SUP",
                                        "REGIONALE_3",
                                        "REGIONALE_3_SOU",
                                        "REGIONALE_3_SUP",
                                        "REGIONALE_4",
                                        "REGIONALE_4_SUP",
                                        "REGIONALE_CONSTR"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sous}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  1.5
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - bornes postales bas - principales",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_borne",
			"minzoom": 17,
			"maxzoom": 18,
            "filter": ["in","symbo",
                                        "PRINCIPALE_1",
										"PRINCIPALE_1_SOU",
                                        "PRINCIPALE_1_SUP",
                                        "PRINCIPALE_2",
                                        "PRINCIPALE_2_SOU",
                                        "PRINCIPALE_2_SUP",
                                        "PRINCIPALE_3",
                                        "PRINCIPALE_3_SOU",
                                        "PRINCIPALE_3_SUP",
                                        "PRINCIPALE_4",
										"PRINCIPALE_4_SOU",
                                        "PRINCIPALE_4_SUP",
                                        "PRINCIPALE_CONSTR"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{borne_sous}",
                "text-size": 11,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-offset": [
                  0,
                  1.6
                ],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#79654F",
                "text-halo-width": 1,
                "text-halo-color": "#FFFFFF"
            }
        },
		{
            "id": "toponyme - courbe rocher maitresse",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_ponc",
            "filter": ["==","txt_typo","ORO_COURBE_ROCHER"],
            "layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 10,
                "text-allow-overlap": false,
                "text-padding": 30,
                "text-rotate": { "type": "identity", "property": "rotation" },
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#333333",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
        },
		{
            "id": "toponyme - courbe glacier maitresse",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_ponc",
            "filter": ["==","txt_typo","ORO_COURBE_GLACIER"],
            "layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 10,
                "text-allow-overlap": false,
                "text-padding": 30,
                "text-rotate": { "type": "identity", "property": "rotation" },
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#629FD9",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
        },
		{
            "id": "toponyme - courbe maitresse",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_ponc",
            "filter": ["==","txt_typo","ORO_COURBE"],
            "layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 10,
                "text-allow-overlap": false,
                "text-padding": 30,
                "text-rotate": { "type": "identity", "property": "rotation" },
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#604A2F",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
        },
		{
            "id": "toponyme - liaison maritime",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_liaison_lin",
			"minzoom": 8,
			"maxzoom": 18,
            "filter": ["in","txt_typo",
                                    "LIAISON_MARITIME",
                                    "LIAISON_MAR"
			],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 15,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#5792C2",
                "text-halo-width": 5,
                "text-halo-color": "#B3D9FF"
            }
        },
		{
			"id": "toponyme bati station de métro + bati ponctuel metro",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "filter": ["all",
                        ["==","txt_typo","TYPO_E_1"],
                        ["==","symbo","STATION_METRO"]
                      ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
				"text-offset": [0.30, -0.25],
                "text-padding": 3,
				"text-anchor": "bottom-left",
                "text-font": ["Source Sans Pro"],
				"icon-image": "Metro",
				"icon-size": { "stops": [[15, 0.33], [17, 0.6]] }
			},
			"paint": {
                "text-color": "#3C3C3C",
				"icon-color": "#646464"
			}
		},
		{
            "id": "toponyme ferre lineaire",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_ferre_lin",
			"minzoom":12,
			"filter": ["in","txt_typo",
                                    "FER_NOM",
                                    "FER_OUVRAGE"
			],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 10,
                "text-anchor": "center",
				"text-offset": [0,-1],
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#000000",
                "text-halo-width": 1,
                "text-halo-color": "rgba(255, 255, 255, 1)"
            }
        },
		{
			"id": "toponyme religieux zoom 15 16",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "maxzoom":16,
            "filter": ["==","txt_typo","religieux"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme religieux zoom 17 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":16,
            "filter": ["==","txt_typo","religieux"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme religieux ge zoom 18 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":17,
            "filter": ["==","txt_typo","religieux_ge"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme parc d'attractions zoom 14",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":13,
            "maxzoom":14,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["==","symbo","PARC_ATTRACTIONS"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme parc d'attractions zoom 15 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["==","symbo","PARC_ATTRACTIONS"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme parc d'attractions ge zoom 18 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["==","symbo","PARC_ATTRACTIONS"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati divers zoom 15",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "maxzoom":15,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["in","symbo",
										"CENTRALE_ELECTRIQUE",
										"HIPPODROME",
										"STADE"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati divers zoom 16 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["in","symbo",
										"CENTRALE_ELECTRIQUE",
										"HIPPODROME",
										"STADE"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme Hippodrome ge zoom 15 a 17",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "maxzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["==","symbo","HIPPODROME"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati divers ge zoom 18 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["in","symbo",
										"CENTRALE_ELECTRIQUE",
										"HIPPODROME",
										"STADE"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme chateau zoom 16",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "maxzoom":16,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["in","symbo",
										"CHATEAU",
										"CHATEAU_FORT"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme chateau zoom 17 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":16,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["in","symbo",
										"CHATEAU",
										"CHATEAU_FORT"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme chateau ge zoom 16 a 17",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "maxzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["==","symbo","CHATEAU"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme chateau ge zoom 18 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["==","symbo","CHATEAU"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme station epuration, de pompage, usine de production eau",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
			"minzoom":14,
            "filter": ["==","txt_typo","station"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
				"text-anchor": "left",
				"text-offset": [0.8, 0],
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#0080FF"
			}
		},
		{
			"id": "toponyme bati ponc gare",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "filter": ["==","txt_typo","gore"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati ponc barrage",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":12,
            "filter": ["==","txt_typo","BARRAGE_PONC"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "left",
				"text-offset": [0.8, 0],
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#0080FF"
			}
		},
		{
			"id": "toponyme bati ponc phare - niveau 13",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "maxzoom":13,
            "filter": ["==","txt_typo","PHARE"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "right",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#532A2A"
			}
		},
		{
			"id": "toponyme bati ponc phare - niveau 14à19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":13,
            "filter": ["all",
						["==","symbo","PHARE"],
						["in","txt_typo",
										"TYPO_C_6",
										"TYPO_C_7",
										"TYPO_C_8",
										"TYPO_E_GE"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "right",
                "text-size": { "stops": [[13, 12], [18, 18]] },
                "text-allow-overlap": false,
				"text-offset": [-2.00, 0],
                "text-padding": 3,
				"text-anchor": "right",
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#532A2A"
			}
		},
		{
			"id": "toponyme bati ponc autre",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":12,
            "filter": ["in","txt_typo",
                                        "BAT_ACTIVITE",
                                        "BAT_FORTIF",
                                        "BAT_VILLAGE_DETRUIT"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "center",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#532A2A"
			}
		},
		{
			"id": "toponyme bati ponc aerogare",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
			"maxzoom":17,
            "filter": ["all",
                        ["==","txt_typo","TYPO_E_GE"],
                        ["==","symbo","AEROGARE"]
                      ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "center",
                "text-size": {"stops": [[12, 9], [16, 11]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme bati ponc aeroport 12",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":11,
			"maxzoom":12,
            "filter": ["==","txt_typo","AEROPORT_PONC"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "bottom",
				"text-offset": [0, -1.3],
                "text-size": 10.5,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc aeroport 13",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":12,
			"maxzoom":13,
            "filter": ["==","txt_typo","AEROPORT_PONC"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "bottom",
				"text-offset": [0, -2],
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc aeroport",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":13,
			"maxzoom":17,
            "filter": ["all",
                        ["==","txt_typo","TYPO_A_5"],
                        ["==","symbo","AEROPORT"]
                      ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "center",
                "text-size": {"stops": [[12, 11], [16, 13]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc aerodrome 12",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":11,
			"maxzoom":12,
            "filter": ["==","txt_typo","AERODROME_PONC"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "bottom",
				"text-offset": [0, -1.3],
                "text-size": 9.5,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc aerodrome 13",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":12,
			"maxzoom":13,
			"filter": ["in","txt_typo",
										"AERODROME_PONC",
										"AERODROME_IMPORT_PONC"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "bottom",
				"text-offset": [0, -2],
                "text-size": 10,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc aerodrome",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":13,
			"maxzoom":17,
            "filter": ["all",
                        ["==","txt_typo","TYPO_A_7"],
                        ["==","symbo","AERODROME"]
                      ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-anchor": "center",
                "text-size": {"stops": [[12, 10], [16, 12]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#120049",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - hydro ponc 5",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
            "filter": ["in","txt_typo",
                                    "TYPO_D_9",
                                    "TYPO_D_10",
                                    "TYPO_E_1_cyan"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 14]]},
                "text-allow-overlap": true,
                "text-padding": 5,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 1
			}
		},
		{
            "id": "toponyme - hydro ponc glacier",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_ponc",
            "filter": ["==","txt_typo","ORO_GLACIER_2"],
            "layout": {
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 14,
                "text-anchor": "center",
                "text-allow-overlap": true,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - limite militaire ponc 3 et 4",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_limite_ponc",
            "filter": ["in","txt_typo",
                                    "LIM_MILI_3",
                                    "LIM_MILI_4"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 12,
                "text-allow-overlap": false,
                "text-padding": 2,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0D2000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme - limite parc ponc 3 et 4",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_limite_ponc",
            "filter": ["in","txt_typo",
                                    "LIM_PARC_3",
                                    "LIM_PARC_4",
									"RESERVE_NATURELLE_PONC"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": false,
                "text-padding": 2,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
        {
            "id": "toponyme numéro de route - départementale",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_numero_lin",
            "minzoom":11,
            "maxzoom":16,
            "filter": ["==","txt_typo","Départementale"],
            "layout": {
                "visibility": "visible",
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 8,
                "text-anchor": "center",
                "text-font": ["Source Sans Pro Bold"],
                "text-rotation-alignment": "viewport"
            },
            "paint": {
                "text-color": "#363636",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
            }
        },
        {
            "id": "toponyme numéro de route - nationale",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_numero_lin",
            "minzoom":7,
            "maxzoom":16,
            "filter": ["==","txt_typo","Nationale"],
            "layout": {
                "visibility": "visible",
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": false,
                "text-padding": 0,
                "text-anchor": "center",
                "text-font": ["Source Sans Pro Bold"],
                "icon-image": "Ecluse",
                "icon-rotation-alignment": "viewport",
                "text-rotation-alignment": "viewport",
                "icon-text-fit": "both",
                "icon-size": 0
            },
            "paint": {
                "text-color": "#000000",
                "icon-color": "#474747",
            }
        },
        {
            "id": "toponyme numéro de route - autoroute",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_numero_lin",
            "minzoom":7,
            "maxzoom":16,
            "filter": ["==","txt_typo","Autoroute"],
            "layout": {
                "visibility": "visible",
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": false,
                "text-padding": 0,
                "text-anchor": "center",
                "text-font": ["Source Sans Pro Regular"],
                "icon-image": "Ecluse",
                "icon-rotation-alignment": "viewport",
                "text-rotation-alignment": "viewport",
                "icon-text-fit": "both",
                "icon-size": 0
            },
            "paint": {
                "text-color": "#F0F0F0",
                "icon-color": "#646464",
                "text-halo-color": "rgba(80, 80, 80, 0.5)",
                "text-halo-width": 5
            }
        },
		{
            "id": "toponyme - odonyme abrégé",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_odonyme_lin",
			"minzoom": 15,
            "maxzoom":17,
            "layout": {
                "symbol-placement": "line",
                "text-field": "{nom_gauche}",
                "text-size": 10,
                "text-anchor": "center",
                "text-max-angle": 30,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#000000",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 1)"
            }
        },
		{
            "id": "toponyme - odonyme desabrégé",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_routier_odonyme_lin",
			"minzoom": 17,
            "layout": {
                "symbol-placement": "line",
                "text-field": "{nom_desabrege}",
                "text-size": 11,
                "text-anchor": "center",
                "text-max-angle": 30,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#000000",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 1)"
            }
        },
		{
			"id": "toponyme - lieu dit non habité 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","LIEU-DIT_NON_HABITE"],
                        ["in","txt_typo",
                                    "TYPO_B_10",
                                    "TYPO_B_11"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme - bois",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","BOIS"],
                        ["in","txt_typo",
                                    "TYPO_F_9",
                                    "TYPO_F_10"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
            "id": "toponyme - oro lineaire 4",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_lin",
            "filter": ["in","txt_typo",
                                    "ORO_SOMMET_3",
                                    "ORO_GORGE_2"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 11,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#863831",
                "text-halo-width": 1.5,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - oro ponc 4",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
            "filter": ["in","txt_typo",
                                    "ORO_SOMMET_3",
                                    "ORO_GORGE_2",
                                    "GROTTE",
                                    "GORGE",
                                    "TYPO_G_8",
                                    "TYPO_G_9"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 11], [16, 16]]},
                "text-allow-overlap": true,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1.5
			}
		},
		{
			"id": "toponyme - hydro ponc 4",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
            "filter": ["in","txt_typo",
                                    "HYD_SURF_4",
                                    "HYD_SURF_4_T",
                                    "HYD_SURF_5",
                                    "HYD_SURF_5_T",
                                    "TYPO_D_8",
                                    "SOURCE"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[14, 13], [17, 16]]},
                "text-allow-overlap": true,
                "text-padding": 5,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme quartier ",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
            "filter": ["in","txt_typo",
                                    "BAT_QUARTIER",
                                    "BAT_QUARTIER_T"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typo_E_GE Quartier",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 17,
            "maxzoom": 18,
            "filter": ["all",
						["==","symbo","QUARTIER"],
						["==","txt_typo","TYPO_E_GE"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 13.5]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typo_E_GE Lieu-dit",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 16,
            "maxzoom": 18,
            "filter": ["all",
						["==","symbo","LIEU-DIT-HABITE"],
						["==","txt_typo","TYPO_E_GE"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 14]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA10",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
            "maxzoom": 18,
            "filter": ["==","txt_typo","TYPO_A_10"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 13.5]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - lieu dit non habité",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","LIEU-DIT_NON_HABITE"],
                        ["in","txt_typo",
                                    "TYPO_B_7",
                                    "TYPO_B_8",
                                    "TYPO_B_9"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 12,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme - bois 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","BOIS"],
                        ["in","txt_typo",
                                    "TYPO_F_6",
                                    "TYPO_F_7",
                                    "TYPO_F_8"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 16,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite hameau ",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 11,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "BAT_HAMEAU",
                                    "BAT_HAMEAU_T"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.17,
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.10],
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite importance 6et7 - Special DOM",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 7,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "TYPO_A_6",
                                    "TYPO_A_7"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.21,
                "text-field": "{texte}",
                "text-size": 12.5,
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.10],
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite importance 5",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 9,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "TYPO_A_5",
                                    "BAT_COMMUNE_5",
                                    "BAT_COMMUNE_5_T",
                                    "BAT_CHEF_LIEU_COM",
                                    "BAT_CHEF_LIEU_COM_T",
									"BAT_CHEF_LIEU_COM-T",
									"BAT_ANCIENNE_COM",
									"BAT_ANCIENNE_COM_T",
									"BAT_COMMUNE_ASSOCIEE",
									"BAT_COMMUNE_ASSOCIEE_T",
                                    "Commune très petite"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.21,
                "text-field": "{texte}",
                "text-size": 11.5,
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.10],
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - ocs lineaire 3",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_ocs_lin",
            "filter": ["==","txt_typo","OCS_FORET_3"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 12], [12, 15]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#287B00",
                "text-halo-width": 1,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - lieu dit non habité 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","LIEU-DIT_NON_HABITE"],
                        ["in","txt_typo",
                            "TYPO_B_5",
                            "TYPO_B_4"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme - bois 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","BOIS"],
                        ["in","txt_typo",
                            "TYPO_F_5",
                            "TYPO_F_4"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 19,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - bois 0",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["all",
                        ["==","symbo","BOIS"],
                        ["in","txt_typo",
                            "TYPO_F_3",
                            "TYPO_F_2"
                        ]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 22,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - ocs ponc 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["==","txt_typo","OCS_FORET_3"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 12], [12, 15]]},
                "text-allow-overlap": false,
                "text-padding": 1,
				"text-anchor": "center",
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
            "id": "toponyme - oro lineaire 3",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_lin",
            "filter": ["in","txt_typo",
                                    "ORO_ILE_3",
                                    "ORO_RELIEF_3",
                                    "ORO_RELIEF_3_T",
                                    "ORO_RELIEF_4",
                                    "ORO_RELIEF_4_T",
                                    "ORO_CAP_2",
                                    "ORO_CAP_3",
                                    "ORO_SOMMET_2",
                                    "ORO_COL_2",
                                    "ORO_GORGE_1",
									"ORO_GORGE-1"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 12,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#863831",
                "text-halo-width": 1.5,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - oro ponc 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
            "filter": ["in","txt_typo",
                                    "ORO_ILE_3",
                                    "ORO_RELIEF_3",
                                    "ORO_RELIEF_3_T",
                                    "ORO_RELIEF_4",
                                    "ORO_RELIEF_4_T",
                                    "ORO_CAP_2",
                                    "ORO_CAP_3",
                                    "ORO_SOMMET_2",
                                    "ORO_COL_2",
                                    "ORO_GORGE_1",
									"ORO_GORGE-1",
                                    "TYPO_G_6",
                                    "TYPO_G_7"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 12], [16, 17]]},
                "text-allow-overlap": true,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 1.5
			}
		},
		{
            "id": "toponyme - hydro lineaire 3",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
            "filter": ["in","txt_typo",
                                    "HYD_LIN_3",
                                    "HYD_LIN_4",
                                    "HYD_LIN_5",
                                    "TYPO_D_LIN_3",
                                    "TYPO_D_LIN_4",
                                    "HYD_SURF_3",
                                    "HYD_SURF_3_T",
                                    "HYD_SURF_4",
                                    "HYD_SURF_4_T",
                                    "HYD_SURF_5",
                                    "HYD_SURF_5_T",
									"TYPO_D_5",
                                    "TYPO_D_7"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[14, 12], [18, 19]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 1.5,
                "text-halo-color": "rgba(255, 255, 255, 0.7)"
            }
        },
		{
            "id": "toponyme - hydro lineaire 4",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
			"minzoom":14,
            "filter": ["in","txt_typo",
                                    "TYPO_D_6",
                                    "TYPO_D_8",
                                    "TYPO_D_9",
                                    "TYPO_D_10"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[14, 10], [18, 16]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 1.5,
                "text-halo-color": "rgba(255, 255, 255, 0.7)"
            }
        },
		{
			"id": "toponyme - hydro ponc 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
            "filter": ["in","txt_typo",
                                    "HYD_SURF_3",
                                    "TYPO_D_5",
                                    "TYPO_D_6",
                                    "TYPO_D_7"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[9, 13], [10, 15], [15, 15], [17, 18]]},
                "text-allow-overlap": true,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme bati ponc zai zoom 16",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "maxzoom":16,
            "filter": ["==","txt_typo","zai"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati ponc zai zoom 17 a 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":16,
            "filter": ["==","txt_typo","zai"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati ponc zai_15 zoom 15",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "maxzoom":15,
            "filter": ["==","txt_typo","zai_15"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati ponc zai_15 zoom 16 a 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
            "filter": ["==","txt_typo","zai_15"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000"
			}
		},
		{
			"id": "toponyme bati ponc zai zoom 16 vert",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":15,
			"maxzoom":16,
            "filter": ["==","txt_typo","zai_vert"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{designation}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme bati ponc zai zoom 17 a 19 vert",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":16,
            "filter": ["==","txt_typo","zai_vert"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme bati ponc zai zoom 17 a 19 beige",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":16,
            "filter": ["==","txt_typo","zai_beige"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#686042",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme bati ponc monuments zoom 15 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":14,
            "filter": ["all",
						["==","txt_typo","divers_bati"],
						["==","symbo","MONUMENT"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme bati ponc monuments ge zoom 18 à 19",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_bati_ponc",
            "minzoom":17,
            "filter": ["all",
						["==","txt_typo","divers_bati_ge"],
						["==","symbo","MONUMENT"]
			],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 1
			}
		},
		{
			"id": "toponyme localite importance 4",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 7,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "TYPO_A_4",
                                    "BAT_COMMUNE_4",
                                    "BAT_COMMUNE_4_T"
             ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.21,
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.10],
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA9",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
            "maxzoom": 18,
            "filter": ["==","txt_typo","TYPO_A_9"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 14]]},
                "text-allow-overlap": true,
                "text-max-width": 20,
				"text-anchor": "bottom-right",
                "text-padding": 1,
                "text-font": ["Source Sans Pro"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA8 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_8"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 11], [17, 14]]},
                "text-allow-overlap": true,
                "text-max-width": 6,
				"text-anchor": "top-right",
                "text-padding": 5,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - limite militaire ponc 1 et 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_limite_ponc",
            "filter": ["in","txt_typo",
                                    "LIM_MILI_1",
                                    "LIM_MILI_2"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": false,
                "text-padding": 5,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0D2000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - limite parc marin",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_limite_ponc",
			"minzoom": 8,
            "filter": ["in","txt_typo",
                                    "PARC_MARIN_1",
                                    "PARC_MARIN_2"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": false,
                "text-padding": 10,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - limite parc ponc 1 et 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_limite_ponc",
			"minzoom":8,
            "filter": ["in","txt_typo",
                                    "LIM_PARC_1",
                                    "LIM_PARC_2",
                                    "PARC_1",
									"PARC_2"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": false,
                "text-padding": 10,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - ocs lineaire 2",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_ocs_lin",
            "filter": ["==","txt_typo","OCS_FORET_2"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 15], [12, 18]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#287B00",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - ocs ponc 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["==","txt_typo","OCS_FORET_2"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 15], [12, 18]]},
                "text-allow-overlap": false,
                "text-padding": 1,
				"text-anchor": "center",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - oro lineaire 2",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_lin",
            "filter": ["in","txt_typo",
                                    "ORO_ILE_2",
                                    "ORO_RELIEF_2",
                                    "ORO_RELIEF_2_T",
                                    "ORO_CAP_1",
                                    "ORO_SOMMET_1"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 15,
                "text-anchor": "center",
                "text-keep-upright": true,
				"text-padding": 10,
                "text-max-angle": 45,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#863831",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - oro ponc 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
			"minzoom":9,
            "filter": ["in","txt_typo",
                                    "ORO_ILE_2",
                                    "ORO_RELIEF_2",
                                    "ORO_RELIEF_2_T",
                                    "ORO_CAP_1",
                                    "ORO_COL_1",
                                    "TYPO_G_5",
                                    "ORO_SOMMET_1"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[9, 13], [10, 15], [13, 15], [16, 19]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - oro ponc 2B",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
			"minzoom":8,
            "filter": ["==","txt_typo","TYPO_G_4"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[13, 15], [16, 19]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - hydro lineaire 2",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
            "filter": ["in","txt_typo",
                                    "HYD_LIN_2",
                                    "TYPO_D_LIN_2",
                                    "HYD_SURF_2",
                                    "HYD_SURF_2_T",
                                    "TYPO_D_4"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[14, 15], [18, 21]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - hydro ponc 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
			"minzoom": 5,
            "filter": ["in","txt_typo",
                                    "moyen",
                                    "HYD_SURF_2",
                                    "TYPO_D_2"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[5, 12], [6, 18], [10, 17], [18, 21]]},
                "text-allow-overlap": false,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - hydro ponc 2B",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
            "filter": ["in","txt_typo",
                                    "TYPO_D_3",
                                    "TYPO_D_4"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[9, 15], [10, 17], [18, 21]]},
                "text-allow-overlap": false,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "#FFFFFF",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite importance 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 5,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "commune 3",
									"TYPO_A_3",
                                    "BAT_COMMUNE_3",
                                    "BAT_COMMUNE_3_T"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.21,
                "text-field": "{texte}",
                "text-size": {"stops": [[5, 10], [6, 15]]},
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.10],
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA7 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_7"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 10], [17, 14]]},
                "text-allow-overlap": true,
				"text-anchor": "top",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA5etA6 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["in","txt_typo","TYPO_A_5","TYPO_A_6"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 10], [17, 14]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - oro lineaire 1",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_oro_lin",
            "filter": ["in","txt_typo",
                                    "ORO_ILE_1",
                                    "ORO_RELIEF_1",
                                    "ORO_RELIEF_1_T"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 20,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-padding": 5,
                "text-max-angle": 45,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#863831",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - oro ponc monde",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
            "minzoom": 5,
            "filter": ["in","txt_typo",
                                    "Basin",
                                    "Depression",
                                    "Desert",
                                    "Geoarea",
                                    "Gorge",
                                    "Isthmus",
                                    "Lake",
                                    "Lowland",
                                    "Pen/cape",
                                    "Plain",
                                    "Plateau",
                                    "Range/mtn",
                                    "Tundra",
                                    "Valley",
                                    "Island",
                                    "Island group"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 11,
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Italic"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA4 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_4"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 17,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 3
			}
		},
		{
            "id": "toponyme - ocs lineaire 1",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_ocs_lin",
            "filter": ["==","txt_typo","OCS_FORET_1"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 18], [12, 22]]},
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-padding": 1,
                "text-max-angle": 45,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#287B00",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - ocs ponc 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_ocs_ponc",
            "filter": ["==","txt_typo","OCS_FORET_1"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[10, 18], [12, 22]]},
                "text-allow-overlap": true,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#287B00",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - oro ponc 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
			"minzoom":8,
            "filter": ["in","txt_typo",
                                    "ORO_ILE_1",
                                    "ORO_RELIEF_1",
                                    "ORO_RELIEF_1_T",
                                    "TYPO_G_1"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 21,
                "text-allow-overlap": true,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme - oro ponc 1B",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_oro_ponc",
			"minzoom":8,
            "filter": ["in","txt_typo",
                                    "TYPO_G_2",
                                    "TYPO_G_3"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
				"text-size": {"stops": [[12, 15], [13, 21]]},
                "text-allow-overlap": false,
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#863831",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
            "id": "toponyme - hydro lineaire glacier",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
            "filter": ["in","txt_typo",
                                    "ORO_GLACIER_1",
                                    "ORO_GLACIER_2"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 15,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-font": ["Source Sans Pro Italic"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
            "id": "toponyme - hydro lineaire 1",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
            "filter": ["in","txt_typo",
                                    "HYD_LIN_1",
									"HYD-LIN-1",
                                    "TYPO_D_LIN_1",
                                    "HYD_SURF_1",
                                    "HYD_SURF_1_T",
                                    "TYPO_D_1",
                                    "TYPO_D_2",
									"TYPO_D_3_T",
									"TYPO_D_4_T"
            ],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 18,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 2,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
            "id": "toponyme - hydro lineaire ocean",
            "type": "symbol",
            "source": "plan_ign",
            "source-layer": "toponyme_hydro_lin",
            "filter": ["==","txt_typo","OCEAN_MER"],
            "layout": {
                "symbol-placement": "line",
                "text-field": "{texte}",
                "text-size": 30,
                "text-anchor": "center",
                "text-keep-upright": true,
                "text-max-angle": 45,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
            },
            "paint": {
                "text-color": "#0080FF",
                "text-halo-width": 4,
                "text-halo-color": "rgba(255, 255, 255, 0.5)"
            }
        },
		{
			"id": "toponyme - hydro ponc 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
			"minzoom": 4,
            "filter": ["in","txt_typo",
                                    "mer",
                                    "grand",
                                    "HYD_SURF_1",
                                    "TYPO_D_1"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[4, 16], [6, 30], [10, 25]]},
                "text-allow-overlap": true,
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme localite importance 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 4,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "commune 2",
									"TYPO_A_2",
                                    "BAT_COMMUNE_2",
									"BAT_COMMUNE-2",
                                    "BAT_COMMUNE_2_T"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.25,
                "text-field": "{texte}",
                "text-size": {"stops": [[4, 10], [6, 17]]},
                "text-allow-overlap": true,
				"text-anchor": "bottom-left",
				"text-offset": [0.30, 0.2],
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": {"stops": [[1, ["Source Sans Pro Regular"]], [7, ["Source Sans Pro Bold"]], [10, ["Source Sans Pro Regular"]]]}
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 3
			}
		},
		{
			"id": "toponyme localite n0 typoA3 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_3"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 19,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 3
			}
		},
		{
			"id": "toponyme localite n0 typoA2 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_2"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 21,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme localite n0 typoA8 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_8"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 12], [17, 15]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
				"text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA7 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_7"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 13], [17, 16]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
				"text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA5etA6 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 18,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["in","txt_typo","TYPO_A_5","TYPO_A_6"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[15, 15], [17, 18]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
				"text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 2
			}
		},
		{
			"id": "toponyme localite n0 typoA1 non commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["!=","symbo","COMMUNE_FUSIONNEE"],
						["!=","symbo","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_1"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 23,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme localite n0 typoA4 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_4"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 17,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 3
			}
		},
		{
			"id": "toponyme localite n0 typoA3 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_3"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 19,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 3
			}
		},
		{
			"id": "toponyme localite n0 typoA2 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_2"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 21,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme localite importance 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 3,
			"maxzoom": 13,
            "filter": ["in","txt_typo",
                                    "commune 1",
									"TYPO_A_1",
                                    "BAT_COMMUNE_1",
                                    "BAT_COMMUNE_1_T"
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
				"icon-image": "Localite",
				"icon-size": 0.3,
                "text-field": "{texte}",
                "text-size": {"stops": [[3, 10], [6, 20]]},
                "text-allow-overlap": false,
				"text-anchor": "bottom-left",
				"text-offset": [0.25, -0.10],
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": {"stops": [[1, ["Source Sans Pro Regular"]], [7, ["Source Sans Pro Bold"]], [10, ["Source Sans Pro Regular"]]]}
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme localite n0 typoA1 commune",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 13,
            "maxzoom": 16,
            "filter": ["all",
						["in","symbo","COMMUNE_FUSIONNEE","COMMUNE_CHEF_LIEU"],
						["==","txt_typo","TYPO_A_1"]
            ],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": 23,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#000000",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
		{
			"id": "toponyme - hydro ponc ocean",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_hydro_ponc",
			"minzoom": 1,
            "filter": ["==","txt_typo","ocean"],
			"layout": {
				"visibility": "visible",
                "symbol-placement": "point",
                "text-field": "{texte}",
                "text-size": {"stops": [[1, 16], [6, 30]]},
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 10,
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#0080FF",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
    	{
			"id": "toponyme pays 3",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 4,
			"maxzoom": 5,
            "filter": ["==","txt_typo","pays 3"],
			"layout": {
				"visibility": "visible",
                "text-field": "{texte}",
                "text-size": 9,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#787878",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
    	{
			"id": "toponyme pays 2",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 2,
			"maxzoom": 5,
            "filter": ["==","txt_typo","pays 2"],
			"layout": {
				"visibility": "visible",
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 2,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#787878",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
        {
			"id": "toponyme pays 1",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"minzoom": 2,
			"maxzoom": 5,
            "filter": ["==","txt_typo","pays 1"],
			"layout": {
				"visibility": "visible",
                "text-field": "{texte}",
                "text-size": 13,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 2,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Regular"]
			},
			"paint": {
                "text-color": "#787878",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		},
        {
			"id": "toponyme continent",
			"type": "symbol",
			"source": "plan_ign",
			"source-layer": "toponyme_localite_ponc",
			"maxzoom": 3,
            "filter": ["==","txt_typo","continent"],
			"layout": {
				"visibility": "visible",
                "text-field": "{texte}",
                "text-size": 15,
                "text-allow-overlap": true,
				"text-anchor": "center",
                "text-padding": 1,
                "text-transform": "uppercase",
                "text-font": ["Source Sans Pro Bold"]
			},
			"paint": {
                "text-color": "#787878",
                "text-halo-color": "rgba(255, 255, 255, 0.5)",
                "text-halo-width": 4
			}
		}
	]
};
